/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.integration.adsmedia.provider;

import com.bxm.acl.facade.model.UserRo;
import com.bxm.adsmanager.integration.acl.AclUserIntegration;
import com.bxm.adsmanager.integration.adsmedia.provider.service.ProviderFinanceFacadeService;
import com.bxm.adsmanager.integration.utils.FacadePageInfoUtil;
import com.bxm.adsmedia.facade.model.provider.FirstProviderAuditDto;
import com.bxm.adsmedia.facade.model.provider.ProviderFinanceListRO;
import com.bxm.adsmedia.facade.model.provider.ProviderStatusListRO;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProviderFinanceFacadeIntegration {
    private static final Logger log = LoggerFactory.getLogger(ProviderFinanceFacadeIntegration.class);
    @Autowired
    private ProviderFinanceFacadeService providerFinanceFacadeService;
    @Autowired
    private AclUserIntegration aclUserIntegration;

    public PageInfo<ProviderFinanceListRO> getAuditPage(String keywords, String mjCode, String bdCode, long providerId, Byte status, Integer areaType, Integer pageNum, Integer pageSize) {
        try {
            ResultModel<PageInfo<ProviderFinanceListRO>> resultModel = this.providerFinanceFacadeService.getAuditPage(keywords, mjCode, bdCode, providerId, status, areaType, pageNum, pageSize);
            if (resultModel.isSuccessed()) {
                return (PageInfo)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u67e5\u8be2\u5f00\u53d1\u8005\u8d22\u52a1\u7ba1\u7406\u5217\u8868\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5f00\u53d1\u8005\u8d22\u52a1\u7ba1\u7406\u5217\u8868\u5f02\u5e38", (Throwable)e);
        }
        return FacadePageInfoUtil.noneDataPage();
    }

    public PageInfo<ProviderStatusListRO> getAuditStatusPage(String providerName, String email, Byte financeStatus, Byte mediaStatus, Byte appEntranceStatus, String mjCode, String bdCode, Boolean isOrderByDateDesc, String code, Integer areaType, Integer pageNum, Integer pageSize) {
        try {
            ResultModel<PageInfo<ProviderStatusListRO>> resultModel = this.providerFinanceFacadeService.getAuditStatusPage(providerName, email, financeStatus, mediaStatus, appEntranceStatus, mjCode, bdCode, isOrderByDateDesc, code, areaType, pageNum, pageSize);
            if (resultModel.isSuccessed()) {
                PageInfo pageInfo = (PageInfo)resultModel.getReturnValue();
                for (ProviderStatusListRO providerStatusListRO : pageInfo.getList()) {
                    if (!StringUtils.isNotBlank((String)providerStatusListRO.getMjCode())) continue;
                    UserRo userRo = this.aclUserIntegration.queryUserByUsername(providerStatusListRO.getMjCode());
                    providerStatusListRO.setMjName(userRo.getName());
                }
                return pageInfo;
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u67e5\u8be2\u5f00\u53d1\u8005\u8d22\u52a1\u7ba1\u7406\u5217\u8868\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5f00\u53d1\u8005\u8d22\u52a1\u7ba1\u7406\u5217\u8868\u5f02\u5e38", (Throwable)e);
        }
        return FacadePageInfoUtil.noneDataPage();
    }

    public Boolean audit(boolean isRiskController, Long providerId, Boolean auditPass, String refuseReason, String reviewRefuseIds, String modifier) {
        try {
            ResultModel<Boolean> resultModel = this.providerFinanceFacadeService.audit(providerId, auditPass, refuseReason, reviewRefuseIds, modifier, isRiskController);
            if (resultModel.isSuccessed()) {
                return (Boolean)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u5ba1\u6838\u5f00\u53d1\u8005\u8d22\u52a1\u4fe1\u606f\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u5ba1\u6838\u5f00\u53d1\u8005\u8d22\u52a1\u4fe1\u606f\u5931\u8d25\u5f02\u5e38", (Throwable)e);
        }
        return false;
    }

    public FirstProviderAuditDto firstAudit(Long providerId, Boolean auditPass, String modifier, boolean isRiskController) {
        try {
            ResultModel<FirstProviderAuditDto> resultModel = this.providerFinanceFacadeService.firstAudit(providerId, auditPass, modifier, isRiskController);
            if (resultModel.isSuccessed()) {
                return (FirstProviderAuditDto)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u5ba1\u6838\u5f00\u53d1\u8005\u4fe1\u606f\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u5ba1\u6838\u5f00\u53d1\u8005\u4fe1\u606f\u5931\u8d25\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }
}

