/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.integration.adsprod.service;

import com.bxm.adsprod.facade.commons.CachePushableEntity;
import com.bxm.adsprod.facade.commons.CachePushableService;
import com.bxm.adsprod.facade.ticket.TicketService;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.StringHelper;
import java.math.BigInteger;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.stereotype.Component;

@EnableFeignClients(value={"com.bxm.adsprod.facade"})
@Component
public class ProdPusherIntegration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProdPusherIntegration.class);
    @Autowired
    private CachePushableService cachePushableService1;
    @Autowired
    private TicketService ticketService;

    public String pushToProd(String serviceName, Map<String, Object> parameters, byte[] data) throws Exception {
        LOGGER.info("\u63a8\u9001\u6570\u636e\u5230\u524d\u7aef serviceName=[" + serviceName + "] parameters=[" + JsonHelper.convert(parameters) + "], data=[" + StringHelper.convert((byte[])data) + "]");
        return this.cachePushableService1.push(new CachePushableEntity(serviceName, parameters, data));
    }

    public Boolean syncUpdateTicketStatus(BigInteger ticketId, byte status, int reason, boolean syncAdsmanager) throws Exception {
        LOGGER.info("syncUpdateTicketStatus , ticket id is " + ticketId);
        return this.ticketService.updateTicketStatus(ticketId, status, reason, syncAdsmanager);
    }
}

