/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.integration.advertiser.model;

import java.io.Serializable;

public class BasePageVo
implements Serializable {
    public static final int DEF_COUNT = 20;
    private static final long serialVersionUID = 4535880046092809745L;
    protected int totalCount = 0;
    protected int pageSize = 20;
    protected int pageNo = 1;
    protected int startIndex = 0;

    public static int checkPageNo(Integer pageNo) {
        return pageNo == null || pageNo < 1 ? 1 : pageNo;
    }

    public BasePageVo() {
    }

    public BasePageVo(int pageNo, int pageSize, int totalCount) {
        this.setTotalCount(totalCount);
        this.setPageSize(pageSize);
        this.setPageNo(pageNo);
        this.adjustPageNo();
    }

    public void adjustPageNo() {
        if (this.pageNo == 1) {
            return;
        }
        int totalPage = this.getTotalPage();
        if (this.pageNo > totalPage) {
            this.pageNo = totalPage;
        }
        this.startIndex = this.pageSize * (this.pageNo - 1);
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getTotalPage() {
        int totalPage = this.totalCount / this.pageSize;
        if (totalPage == 0 || this.totalCount % this.pageSize != 0) {
            ++totalPage;
        }
        return totalPage;
    }

    public boolean isFirstPage() {
        return this.pageNo <= 1;
    }

    public boolean isLastPage() {
        return this.pageNo >= this.getTotalPage();
    }

    public int getNextPage() {
        if (this.isLastPage()) {
            return this.pageNo;
        }
        return this.pageNo + 1;
    }

    public int getPretPage() {
        if (this.isFirstPage()) {
            return this.pageNo;
        }
        return this.pageNo - 1;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount < 0 ? 0 : totalCount;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize == null || pageSize < 1 ? 20 : pageSize;
        this.startIndex = this.pageSize * (this.pageNo - 1);
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo == null || pageNo < 1 ? 1 : pageNo;
        this.startIndex = this.pageSize * (this.pageNo - 1);
    }
}

