/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.integration.datapark.service;

import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.ocpc.OcpcOffers;
import com.bxm.datapark.facade.ocpc.OcpcOffersCondition;
import com.bxm.datapark.facade.ocpc.OcpcOffersService;
import com.bxm.datapark.facade.ocpc.OcpcStageCpaSearchDto;
import com.bxm.datapark.facade.ocpc.OcpcStageCpaVo;
import com.bxm.datapark.facade.ocpc.OcpcStatistics;
import com.bxm.datapark.facade.ocpc.OcpcStatisticsCondition;
import com.bxm.datapark.facade.ocpc.OcpcStatisticsService;
import com.bxm.datapark.web.FacadeOcpcDataServive;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DataparkOcpcIntegration {
    @Autowired
    private OcpcStatisticsService ocpcStatisticsService;
    @Autowired
    private OcpcOffersService ocpcOffersService;
    @Autowired
    private FacadeOcpcDataServive facadeOcpcDataServive;
    private static final Logger LOGGER = LoggerFactory.getLogger(DataparkOcpcIntegration.class);

    public Page<OcpcStatistics> find(OcpcStatisticsCondition condition) {
        return this.facadeOcpcDataServive.find(condition);
    }

    public Page<OcpcOffers> find(OcpcOffersCondition condition) {
        return this.ocpcOffersService.find(condition);
    }

    public List<OcpcStageCpaVo> getOcpcSecondStageAvgCpa(OcpcStageCpaSearchDto search) {
        try {
            return this.facadeOcpcDataServive.getOcpcSecondStageAvgCpa(search);
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42datapark getOcpcSecondStageAvgCpa\u51fa\u9519", (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    public Map<Long, Double> getOcpcSecondStageAvgCpaMap(OcpcStageCpaSearchDto search) {
        List<OcpcStageCpaVo> ocpcSecondStageAvgCpa = this.getOcpcSecondStageAvgCpa(search);
        if (CollectionUtils.isEmpty(ocpcSecondStageAvgCpa)) {
            return Collections.EMPTY_MAP;
        }
        try {
            return ocpcSecondStageAvgCpa.stream().collect(Collectors.toMap(OcpcStageCpaVo::getTicketId, OcpcStageCpaVo::getAvgCpa));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Collections.EMPTY_MAP;
        }
    }
}

