/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.timer.kuaishou;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.model.constant.RedisKeys;
import com.bxm.adsmanager.model.vo.kuaishou.KuaishouAuthResponse;
import com.bxm.adsmanager.model.vo.kuaishou.KuaishouTokenVo;
import com.bxm.util.DateUtil;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class KuaishouJob {
    private static final Logger log = LoggerFactory.getLogger(KuaishouJob.class);
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired
    private JedisFetcher fetcher;
    @Autowired
    @Qualifier(value="rtbJedisUpdater")
    private JedisUpdater rtbJedisUpdater;
    private static final String refreshUrl = "https://ad.e.kuaishou.com/rest/openapi/oauth2/authorize/refresh_token";

    public void execute() {
        Map<String, KuaishouTokenVo> map = this.fetcher.hfetchall(RedisKeys.hashKuaishouToken(), KuaishouTokenVo.class);
        if (MapUtils.isEmpty(map)) {
            return;
        }
        for (String key : map.keySet()) {
            KuaishouTokenVo kuaishouTokenVo = map.get(key);
            if (Objects.isNull(kuaishouTokenVo)) continue;
            List<Long> advertiserIds = kuaishouTokenVo.getAdvertiserIds();
            String appKey = kuaishouTokenVo.getAppKey();
            String secret = kuaishouTokenVo.getSecret();
            String refreshToken = kuaishouTokenVo.getRefreshToken();
            try {
                HashMap<String, String> refreshParams = Maps.newHashMap();
                refreshParams.put("app_id", key);
                refreshParams.put("secret", secret);
                refreshParams.put("refresh_token", refreshToken);
                String refreshResult = OkHttpUtils.postRequestBody(refreshUrl, refreshParams, new HashMap<String, String>());
                log.info("kuaishou refresh Response: {}", (Object)refreshResult);
                KuaishouAuthResponse kuaishouAuthResponse = JsonHelper.convert(refreshResult, KuaishouAuthResponse.class);
                if (kuaishouAuthResponse.getCode() != 0) {
                    return;
                }
                KuaishouAuthResponse.Data data = kuaishouAuthResponse.getData();
                Long exDate = System.currentTimeMillis() + Long.valueOf(data.getAccess_token_expires_in().intValue()) * 1000L;
                Long refreshExDate = System.currentTimeMillis() + Long.valueOf(data.getRefresh_token_expires_in().intValue()) * 1000L;
                String exDateFormat = DateUtil.dateTo14String(new Date(exDate));
                kuaishouTokenVo.setTokenExpireTime(exDateFormat);
                kuaishouTokenVo.setToken(data.getAccess_token());
                kuaishouTokenVo.setRefreshToken(data.getRefresh_token());
                kuaishouTokenVo.setRefreshExpireTime(DateUtil.dateTo14String(new Date(refreshExDate)));
                this.updater.hupdate(RedisKeys.hashKuaishouToken(), key, JsonHelper.convert(kuaishouTokenVo));
                HashMap<String, String> multiUpdateMap = new HashMap<String, String>();
                for (Long advertiser_id : advertiserIds) {
                    HashMap<String, String> valueMap = new HashMap<String, String>();
                    valueMap.put("accessToken", data.getAccess_token());
                    valueMap.put("expire", exDateFormat);
                    multiUpdateMap.put(Objects.toString(advertiser_id), JSONObject.toJSONString(valueMap));
                }
                this.rtbJedisUpdater.hmupdate(RedisKeys.hashRtbKuaishouAccessToken(appKey), multiUpdateMap);
            }
            catch (Exception e) {
                log.error("kuaishou job occur error :" + e.getMessage(), e);
            }
            log.info("kuaishou job execute is finished!");
        }
    }

    public static void main(String[] args) {
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString("https://developers.e.kuaishou.com/tools/authorize?app_id=165899974&scope=%5B%22ad_query%22%2C%22ad_manage%22%2C%22report_service%22%2C%22account_service%22%2C%22public_dmp_service%22%2C%22public_agent_service%22%2C%22public_account_service%22%5D&redirect_uri=https://www.baidu.com/&state=abcd&oauth_type=advertiser");
        String redirect_url = uriComponentsBuilder.replaceQueryParam("redirect_uri", "https://mgr.bianxianmao.com:18501/kuaishou/callback?appKey%3D757e39a645e9482e965a87cc28ee3b27%26appId%3D165899974").replaceQueryParam("state", "abcd").replaceQueryParam("oauth_type", "advertiser").build().toString();
        System.out.println(redirect_url);
    }
}

