/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.timer.media;

import com.bxm.adsmanager.dal.mapper.media.MediaTestMapper;
import com.bxm.adsmanager.integration.adsprod.service.ProdPullerIntegration;
import com.bxm.adsmanager.model.dao.media.AdMediaTest;
import com.bxm.adsmanager.model.dto.mediamanager.PositionWeightDto;
import com.bxm.adsmanager.service.mediamanager.PositionTicketWeightService;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.util.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MediaPositonTestJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaPositonTestJob.class);
    private static final short IS_USE = 1;
    @Autowired
    private MediaTestMapper mediaTestMapper;
    @Autowired
    private ProdPullerIntegration pullerIntegration;
    @Autowired
    private PositionTicketWeightService positionTicketWeightService;

    public void updateWeight() {
        LOGGER.info("\u5f00\u59cb\u6267\u884c\u5b9a\u65f6\u5668");
        List<AdMediaTest> adMediaTestList = this.mediaTestMapper.findAdMediaTestByIsUse();
        List<Object> tickets = new ArrayList();
        if (CollectionUtils.isNotEmpty(adMediaTestList)) {
            Map<String, Ticket> ocpcMap = this.pullerIntegration.fetchTicketAll();
            for (AdMediaTest adMediaTest : adMediaTestList) {
                Boolean b = true;
                if (MediaPositonTestJob.after(adMediaTest.getStartTime(), new Date()) || adMediaTest.getState() == 3) continue;
                Map<String, Long> mapCount = this.pullerIntegration.fetchPositionTestClickPvCount(adMediaTest.getPositionId());
                if (mapCount != null && !mapCount.isEmpty()) {
                    tickets = MediaPositonTestJob.getTicketIdList(adMediaTest.getTicketId().split(","));
                    for (String string : mapCount.keySet()) {
                        if (ocpcMap.get(string).getCloseThreshold() == null) continue;
                        if (mapCount.get(string) == null || mapCount.get(string) != null && mapCount.get(string) < (long)ocpcMap.get(string).getCloseThreshold().intValue()) {
                            this.updatePositionWeight(1000.0, adMediaTest.getPositionId(), string);
                            tickets.remove(string);
                            b = false;
                            continue;
                        }
                        this.updatePositionWeight(100.0, adMediaTest.getPositionId(), string);
                        tickets.remove(string);
                    }
                    if (CollectionUtils.isNotEmpty(tickets)) {
                        b = false;
                        for (String string : tickets) {
                            this.updatePositionWeight(1000.0, adMediaTest.getPositionId(), string);
                        }
                    }
                } else {
                    b = false;
                    this.updatePositionWeight(1000.0, adMediaTest.getPositionId(), adMediaTest.getTicketId());
                }
                if (b.booleanValue()) {
                    AdMediaTest at = new AdMediaTest();
                    at.setId(adMediaTest.getId());
                    at.setIsUseByWeight((short)1);
                    this.mediaTestMapper.update(at);
                    LOGGER.info("\u6743\u91cd\u4fee\u6539\u5b8c\u6210");
                }
                tickets.clear();
            }
        }
    }

    public void updatePositionWeight(double interventionFactor, String positionId, String ticketId) {
        PositionWeightDto record = new PositionWeightDto();
        record.setInterventionFactor(interventionFactor);
        record.setPositionId(positionId);
        record.setTicketIdChar(ticketId);
        this.positionTicketWeightService.updatePositionWeight(record);
    }

    public static List<String> getTicketIdList(String[] str) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < str.length; ++i) {
            if (!StringUtil.isNotBlank(str[i])) continue;
            list.add(str[i]);
        }
        return list;
    }

    public static boolean after(Date date1, Date date2) {
        long date1Long = date1.getTime();
        long date2Long = date2.getTime();
        return MediaPositonTestJob.after(date1Long, date2Long);
    }

    public static boolean after(long data1, long data2) {
        return data1 - data2 > 0L;
    }
}

