/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.timer.qualify;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.dal.mapper.advertiser.ext.TblAdQualifyMapperExt;
import com.bxm.adsmanager.integration.message.MessagerServiceIntegration;
import com.bxm.adsmanager.model.dao.advertiser.TblAdQualify;
import com.bxm.adsmanager.model.ro.QualifyContentRo;
import com.bxm.adsmanager.service.advertiser.AdvertiserQualifyService;
import com.bxm.messager.facade.dto.MessageInfoDTO;
import com.bxm.util.DateUtil;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.utils.DateHelper;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class QualifyCHeckJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(QualifyCHeckJob.class);
    @Qualifier(value="jedisUpdater")
    @Autowired
    private JedisUpdater updater;
    @Qualifier(value="jedisFetcher")
    @Autowired
    private JedisFetcher fetcher;
    @Autowired
    TblAdQualifyMapperExt tblAdQualifyMapperExt;
    @Autowired
    MessagerServiceIntegration messagerServiceIntegration;
    @Autowired
    AdvertiserQualifyService advertiserQualifyService;
    public static Integer LIMIT_DAYS = 3;
    public static Integer EXPIRE_STATUS_YES = 1;
    public static Integer EXPIRE_STATUS_NO = 2;
    public static Integer EXPIRE_STATUS_SOON = 3;
    public static String EXPIRE__YES = "EXPIRE__YES";
    public static String EXPIRE__SOON = "EXPIRE__SOON";

    public void checkQualify() {
        List<TblAdQualify> qualifyList = this.tblAdQualifyMapperExt.qualifyList();
        if (CollectionUtils.isEmpty(qualifyList)) {
            return;
        }
        for (TblAdQualify tblAdQualify : qualifyList) {
            List<QualifyContentRo> qualifyContentRo;
            String qualifyContentJsonStr = tblAdQualify.getQualifyContent();
            if (Objects.isNull(qualifyContentJsonStr) || CollectionUtils.isEmpty(qualifyContentRo = JSON.parseArray(qualifyContentJsonStr, QualifyContentRo.class))) continue;
            boolean expireStatusYesFlag = false;
            boolean expireStatusNoFlag = false;
            boolean expireStatusSoonFlag = false;
            for (QualifyContentRo contentRo : qualifyContentRo) {
                if (contentRo.isLongTime()) {
                    expireStatusNoFlag = true;
                    continue;
                }
                if (Objects.isNull(contentRo.getExpireTime()) || StringUtils.isBlank(contentRo.getExpireTime())) continue;
                int diffDays = DateUtil.countDiffDateDays(new Date(), DateHelper.parse(contentRo.getExpireTime(), "yyyy-MM-dd"));
                if (diffDays >= 0 && diffDays <= LIMIT_DAYS) {
                    this.sendMessage(contentRo, tblAdQualify, EXPIRE__SOON);
                    expireStatusSoonFlag = true;
                }
                if (diffDays < 0) {
                    this.sendMessage(contentRo, tblAdQualify, EXPIRE__YES);
                    expireStatusYesFlag = true;
                }
                if (diffDays <= LIMIT_DAYS) continue;
                expireStatusNoFlag = true;
            }
            this.updateExpireStatusOperate(tblAdQualify, expireStatusYesFlag, expireStatusNoFlag, expireStatusSoonFlag);
        }
    }

    private void updateExpireStatusOperate(TblAdQualify tblAdQualify, boolean expireStatusYesFlag, boolean expireStatusNoFlag, boolean expireStatusSoonFlag) {
        if (expireStatusYesFlag) {
            TblAdQualify record = new TblAdQualify();
            record.setId(tblAdQualify.getId());
            record.setAuditStatus(3);
            record.setRefuseReason("\u8d44\u8d28\u5230\u671f");
            record.setRefuseRemark("\u8d44\u8d28\u5230\u671f");
            record.setExpireStatus(EXPIRE_STATUS_YES);
            try {
                this.advertiserQualifyService.updateAdQualifyById(record);
            }
            catch (Exception e) {
                LOGGER.error("\u8d44\u8d28\u5230\u671f\u53d8\u66f4\u9519\u8bef", e);
            }
        }
        if (expireStatusNoFlag) {
            this.updateExpireStatusForDb(tblAdQualify, EXPIRE_STATUS_NO);
        }
        if (expireStatusSoonFlag) {
            this.updateExpireStatusForDb(tblAdQualify, EXPIRE_STATUS_SOON);
        }
    }

    private void updateExpireStatusForDb(TblAdQualify tblAdQualify, Integer status) {
        TblAdQualify record = new TblAdQualify();
        record.setId(tblAdQualify.getId());
        record.setExpireStatus(status);
        try {
            this.advertiserQualifyService.updateAdQualifyById(record);
        }
        catch (Exception e) {
            LOGGER.error("\u8d44\u8d28\u8fc7\u671f\u72b6\u6001\u53d8\u66f4\u9519\u8bef", e);
        }
    }

    private void sendMessage(QualifyContentRo contentRo, TblAdQualify tblAdQualify, String expireFlag) {
        String expireSoonFlag;
        boolean sendResult;
        String expireYesFlag;
        String content = "\u5230\u671f";
        if (EXPIRE__YES.equals(expireFlag) && (Objects.isNull(expireYesFlag = this.fetcher.hfetch(() -> StringUtils.join((Object[])new String[]{"QUALIFY", "STATUS", tblAdQualify.getAdvertiserId().toString()}, ":"), contentRo.getLabel() + EXPIRE__YES, String.class)) || StringUtils.isBlank(expireYesFlag)) && (sendResult = this.sendMessageDo(contentRo, tblAdQualify, content = "\u5df2\u5230\u671f"))) {
            this.updater.hupdate(() -> StringUtils.join((Object[])new String[]{"QUALIFY", "STATUS", tblAdQualify.getAdvertiserId().toString()}, ":"), contentRo.getLabel() + EXPIRE__YES, "ok");
        }
        if (EXPIRE__SOON.equals(expireFlag) && (Objects.isNull(expireSoonFlag = this.fetcher.hfetch(() -> StringUtils.join((Object[])new String[]{"QUALIFY", "STATUS", tblAdQualify.getAdvertiserId().toString()}, ":"), contentRo.getLabel() + EXPIRE__SOON, String.class)) || StringUtils.isBlank(expireSoonFlag)) && (sendResult = this.sendMessageDo(contentRo, tblAdQualify, content = "\u5373\u5c06\u5230\u671f"))) {
            this.updater.hupdate(() -> StringUtils.join((Object[])new String[]{"QUALIFY", "STATUS", tblAdQualify.getAdvertiserId().toString()}, ":"), contentRo.getLabel() + EXPIRE__SOON, "ok");
        }
    }

    private boolean sendMessageDo(QualifyContentRo contentRo, TblAdQualify tblAdQualify, String content) {
        MessageInfoDTO messageInfoDTO = MessageInfoDTO.builder().title("\u8d44\u8d28\u8fc7\u671f\u901a\u77e5!").pushGoalUserType(1).pushGoalUserContent(tblAdQualify.getAdvertiserId().toString()).channel(1).pushTopicType(2).pushStatus(1).pushContent("\u5c0a\u656c\u7684\u5ba2\u6237\uff0c\u60a8\u63d0\u4f9b\u7684\u300a" + contentRo.getLabel() + "\u300b" + content + "\uff0c\u8bf7\u5c3d\u5feb\u8865\u5145\u65b0\u7684\u8d44\u8d28\uff0c\u4ee5\u514d\u5f71\u54cd\u540e\u7eed\u5e7f\u544a\u6295\u653e\uff0c\u8c22\u8c22\u5408\u4f5c\uff01").createUser("wangpengfei").build();
        return this.messagerServiceIntegration.pushMessage(messageInfoDTO);
    }

    public static void main(String[] args) {
        String time = "2022-02-24";
        int diffDays = DateUtil.countDiffDateDays(new Date(), DateHelper.parse(time, "yyyy-MM-dd"));
        System.out.println(diffDays);
    }
}

