/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.timer.ticket;

import com.bxm.adsmanager.dal.mapper.opentime.TicketOpeningTimeMapper;
import com.bxm.adsmanager.model.dao.opentime.TicketOpeningTime;
import com.bxm.adsmanager.model.dao.report.TicketLogTime;
import com.bxm.adsmanager.service.adkeeper.AdRulesService;
import com.bxm.adsmanager.utils.DateFormatUtil;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketService;
import com.bxm.log.facade.dao.LogModel;
import com.bxm.log.facade.dao.Page;
import com.bxm.log.facade.dto.LogModelDto;
import com.bxm.log.facade.service.LogsService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class AdTicketOpenTimeJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdTicketOpenTimeJob.class);
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    private LogsService logsService;
    @Resource
    private TicketService ticketService;
    @Autowired
    private AdRulesService adRulesService;
    @Autowired
    private TicketOpeningTimeMapper ticketOpeningTimeMapper;
    private DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Pattern pattern = Pattern.compile("\"times\"\\s*:\\s*\"(\\d{1,2}-\\d{1,2}-\\d+(\\s*,\\s*\\d{1,2}-\\d{1,2}-\\d+)*)\"");

    public void ticketOpenTime() throws Exception {
        LOGGER.info("\u8bb0\u5f55\u793c\u5238\u7684\u5f00\u542f\u65f6\u95f4\u7684job\uff0c\u5f00\u59cb\u6267\u884c");
        List<Ticket> allTickets = this.ticketService.getAllTickets();
        LocalDate localDate = LocalDate.now().minusDays(1L);
        String datetime = this.dateTimeFormatter.format(localDate);
        for (Ticket ticket : allTickets) {
            List<TicketLogTime> openTimeList = this.getTicketLogTimes(datetime, ticket.getId().longValue());
            for (TicketLogTime ticketLogTime : openTimeList) {
                TicketOpeningTime ticketOpeningTime = new TicketOpeningTime();
                try {
                    ticketOpeningTime.setStartTime(this.dateFormat.parse(datetime + " " + ticketLogTime.getStartTime() + ":00:00"));
                    if (24 == ticketLogTime.getEndTime()) {
                        ticketOpeningTime.setEndTime(this.dateFormat.parse(datetime + " 23:59:59"));
                    } else {
                        ticketOpeningTime.setEndTime(this.dateFormat.parse(datetime + " " + ticketLogTime.getEndTime() + ":00:00"));
                    }
                }
                catch (ParseException e) {
                    LOGGER.error("\u8bb0\u5f55\u793c\u5238\u7684\u5f00\u542f\u65f6\u95f4\u7684job\u51fa\u9519", e);
                }
                ticketOpeningTime.setTicketId(ticket.getId().longValue());
                this.ticketOpeningTimeMapper.insert(ticketOpeningTime);
            }
        }
        LOGGER.info("\u8bb0\u5f55\u793c\u5238\u7684\u5f00\u542f\u65f6\u95f4\u7684job\uff0c\u6267\u884c\u6210\u529f");
    }

    private List<TicketLogTime> getTicketLogTimes(String datetime, Long ticketId) {
        ArrayList<TicketLogTime> ticketLogTimeResultList = Lists.newArrayList();
        TicketLogTime ticketLogTimeDefault = new TicketLogTime(0, 24, 24);
        String timeRule = this.adRulesService.findByTicketId(1, 5, ticketId);
        if (StringUtils.isNotEmpty(timeRule)) {
            StringBuilder sb = new StringBuilder();
            String[] rules = timeRule.split(",");
            for (int i = 0; i < rules.length; ++i) {
                String rule = rules[i];
                String[] str = rule.split("-");
                if (str.length != 3) continue;
                TicketLogTime ticketLogTime = new TicketLogTime(Integer.valueOf(str[0]), Integer.valueOf(str[1]), 0);
                ticketLogTimeResultList.add(ticketLogTime);
            }
        }
        if (CollectionUtils.isEmpty(ticketLogTimeResultList)) {
            ticketLogTimeResultList.add(ticketLogTimeDefault);
        }
        long dateTimeStamp = DateFormatUtil.getMillisecondByDate(datetime);
        long dateTimePlusOneDayStamp = DateFormatUtil.getMillisecondByPlusDate(datetime, 1L);
        long dateTimeMinusOneMonthStamp = DateFormatUtil.getMillisecondByMinusDate(datetime, 30L);
        long pageSize = this.getPageTotal(dateTimeStamp, dateTimePlusOneDayStamp, ticketId);
        List<LogModel> logModelList = this.getDateTimeLog(1, pageSize, dateTimeStamp, dateTimePlusOneDayStamp, ticketId);
        List<List<TicketLogTime>> ticketLogTimeList = this.getTicketLogTime(logModelList);
        if (CollectionUtils.isEmpty(ticketLogTimeList)) {
            return this.dealTicketLogTime(ticketLogTimeResultList);
        }
        long beforeMonthPageSize = this.getPageTotal(dateTimeMinusOneMonthStamp, dateTimeStamp, ticketId);
        List<LogModel> beforeMonthLogModelList = this.getDateTimeLog(1, beforeMonthPageSize, dateTimeMinusOneMonthStamp, dateTimeStamp, ticketId);
        Collections.reverse(beforeMonthLogModelList);
        List<List<TicketLogTime>> ticketBeforeMonthLogTimeList = this.getLastTicketLogTime(beforeMonthLogModelList);
        if (CollectionUtils.isEmpty(ticketBeforeMonthLogTimeList)) {
            return ticketLogTimeResultList;
        }
        ticketLogTimeList.addAll(0, ticketBeforeMonthLogTimeList);
        ArrayList<TicketLogTime> pvTimeList = Lists.newArrayList();
        for (int i = 0; i < ticketLogTimeList.size(); ++i) {
            if (i == 0) continue;
            List<TicketLogTime> logs = ticketLogTimeList.get(i);
            List<TicketLogTime> beforeDayLogs = ticketLogTimeList.get(i - 1);
            for (TicketLogTime ticketLogTime : logs) {
                int modifyHour = ticketLogTime.getModofyTime();
                for (TicketLogTime beforeDayTicketLogTime : beforeDayLogs) {
                    TicketLogTime time;
                    int beforeDayStartHour = beforeDayTicketLogTime.getStartTime();
                    int beforeDayEndHour = beforeDayTicketLogTime.getEndTime();
                    if (modifyHour < beforeDayStartHour) continue;
                    if (beforeDayStartHour <= modifyHour && beforeDayEndHour >= modifyHour) {
                        time = new TicketLogTime(beforeDayStartHour, modifyHour, modifyHour);
                        pvTimeList.add(time);
                        continue;
                    }
                    time = new TicketLogTime(beforeDayStartHour, beforeDayEndHour, modifyHour);
                    pvTimeList.add(time);
                }
                int startTime = ticketLogTime.getStartTime();
                int endTime = ticketLogTime.getEndTime();
                if (modifyHour < startTime) {
                    TicketLogTime time = new TicketLogTime(startTime, endTime, modifyHour);
                    pvTimeList.add(time);
                    continue;
                }
                if (startTime > modifyHour || modifyHour > endTime) continue;
                TicketLogTime time = new TicketLogTime(modifyHour, endTime, modifyHour);
                pvTimeList.add(time);
            }
        }
        return this.dealTicketLogTime(pvTimeList);
    }

    private List<TicketLogTime> dealTicketLogTime(List<TicketLogTime> ticketLogTimes) {
        HashSet<Integer> hourSet = new HashSet<Integer>();
        for (TicketLogTime ticketLogTime : ticketLogTimes) {
            int startTime = ticketLogTime.getStartTime();
            int endTime = ticketLogTime.getEndTime();
            hourSet.add(startTime);
            for (int hour = startTime++; hour <= endTime; ++hour) {
                hourSet.add(hour);
            }
        }
        Object[] objHour = hourSet.toArray();
        Integer[] intHour = new Integer[objHour.length];
        for (int k = 0; k < objHour.length; ++k) {
            int hour = (Integer)objHour[k];
            intHour[k] = hour;
        }
        for (int i = 0; i < intHour.length; ++i) {
            int tem = i;
            for (int j = i; j < intHour.length; ++j) {
                if (intHour[j] >= intHour[tem]) continue;
                tem = j;
            }
            int temp1 = intHour[i];
            intHour[i] = intHour[tem];
            intHour[tem] = temp1;
        }
        ArrayList<TicketLogTime> pvTimeResultList = Lists.newArrayList();
        int start = -1;
        for (int i = 0; i < intHour.length; ++i) {
            if (start == -1) {
                start = intHour[i];
            }
            if (i < intHour.length - 1 && intHour[i] + 1 == intHour[i + 1]) continue;
            int end = intHour[i];
            TicketLogTime ticketLogTime = new TicketLogTime(start, end, end);
            pvTimeResultList.add(ticketLogTime);
            start = -1;
        }
        return pvTimeResultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getPageTotal(long dateTimeStamp, long dateTimePlusOneDayStamp, Object ticketId) {
        LogModelDto dto = new LogModelDto();
        try {
            dto.setPageNum(1);
            dto.setPageSize(1);
            dto.setStartDateTime(dateTimeStamp);
            dto.setEndDateTime(dateTimePlusOneDayStamp);
            dto.setAdticketId(String.valueOf(ticketId));
            dto.setCollectionName("logs_adsmanager");
            Page<LogModel> logModelPage = this.logsService.find(dto);
            long l = logModelPage.getTotal();
            return l;
        }
        catch (Exception e) {
            LOGGER.error("\u7edf\u8ba1\u793c\u5238\u6628\u65e5\u53d1\u5238\u65f6\u95f4\u603b\u6570\u51fa\u9519\u4e86\uff01dto={},e={}", JsonHelper.convert(dto), ExceptionUtils.getFullStackTrace(e), e);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LogModel> getDateTimeLog(int pageNum, long pageSize, long dateTimeStamp, long dateTimePlusOneDayStamp, Object ticketId) {
        List<LogModel> logModelList;
        LogModelDto dto;
        block5: {
            dto = new LogModelDto();
            dto.setPageNum(pageNum);
            dto.setPageSize((int)pageSize);
            dto.setStartDateTime(dateTimeStamp);
            dto.setEndDateTime(dateTimePlusOneDayStamp);
            dto.setAdticketId(String.valueOf(ticketId));
            dto.setCollectionName("logs_adsmanager");
            Page<LogModel> logModelPage = this.logsService.find(dto);
            logModelList = logModelPage.getList();
            if (!CollectionUtils.isEmpty(logModelList)) break block5;
            ArrayList<LogModel> arrayList = Lists.newArrayList();
            return arrayList;
        }
        try {
            List<LogModel> list = logModelList;
            return list;
        }
        catch (Exception e) {
            LOGGER.error("\u7edf\u8ba1\u793c\u5238\u6628\u65e5\u53d1\u5238\u65f6\u95f4\u5217\u8868\u51fa\u9519\u4e86\uff01dto={},e={}", JsonHelper.convert(dto), ExceptionUtils.getFullStackTrace(e), e);
        }
        return Lists.newArrayList();
    }

    private List<List<TicketLogTime>> getTicketLogTime(List<LogModel> logModelList) {
        ArrayList<List<TicketLogTime>> list = Lists.newArrayList();
        for (LogModel logModel : logModelList) {
            ArrayList<TicketLogTime> ticketLogTimeList = Lists.newArrayList();
            String content = logModel.getContent();
            Date dateTime = logModel.getDateTime();
            Matcher matcher = this.pattern.matcher(content);
            while (matcher.find()) {
                String str = matcher.group(1);
                String[] size = str.split(",");
                int modifyTime = DateFormatUtil.getDateHour(dateTime);
                for (String s : size) {
                    String[] times = s.split("-");
                    int startTime = Integer.valueOf(times[0]);
                    int endTime = Integer.valueOf(times[1]);
                    TicketLogTime ticketLogTime = new TicketLogTime(startTime, endTime, modifyTime);
                    ticketLogTimeList.add(ticketLogTime);
                }
                list.add(ticketLogTimeList);
            }
        }
        return list;
    }

    private List<List<TicketLogTime>> getLastTicketLogTime(List<LogModel> beforeMonthLogModelList) {
        ArrayList<List<TicketLogTime>> list = Lists.newArrayList();
        for (LogModel logModel : beforeMonthLogModelList) {
            ArrayList<TicketLogTime> ticketLogTimeList = Lists.newArrayList();
            String content = logModel.getContent();
            Date dateTime = logModel.getDateTime();
            Matcher matcher = this.pattern.matcher(content);
            while (matcher.find()) {
                String str = matcher.group(1);
                String[] size = str.split(",");
                int modifyTime = DateFormatUtil.getDateHour(dateTime);
                for (String s : size) {
                    String[] times = s.split("-");
                    int startTime = Integer.valueOf(times[0]);
                    int endTime = Integer.valueOf(times[1]);
                    TicketLogTime ticketLogTime = new TicketLogTime(startTime, endTime, modifyTime);
                    ticketLogTimeList.add(ticketLogTime);
                }
                list.add(ticketLogTimeList);
            }
            if (!CollectionUtils.isNotEmpty(list)) continue;
            break;
        }
        return list;
    }
}

