/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.timer.youdao;

import com.bxm.adsmanager.integration.adsprod.service.ProdPullerIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssets;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsService;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.utils.DoubleUtil;
import com.bxm.util.DateUtil;
import com.bxm.util.DingtalkMsgUtil;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class YDTimerJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(YDTimerJob.class);
    private static final short IS_USE = 1;
    @Value(value="${yd.ticketIds}")
    private String ticketIds;
    @Autowired
    private AdTicketService adTicketService;
    @Autowired
    private AdTicketAssetsService adTicketAssetsService;
    @Autowired
    private ProdPullerIntegration pullerIntegration;
    public static final String url = "https://oapi.dingtalk.com/robot/send?access_token=c26b02268d084a2af29e27e31ccfb708b4fef65c94396ab3c547595c4b02423e";

    public void execute() {
        if (StringUtils.isEmpty(this.ticketIds)) {
            return;
        }
        List<AdTicket> openTicketList = this.adTicketService.findByIds(this.ticketIds);
        if (CollectionUtils.isEmpty(openTicketList)) {
            return;
        }
        String date = DateUtil.dateTo8String1(new Date());
        int totalCount = 0;
        int closeAssetsViewcount = 0;
        for (AdTicket adTicket : openTicketList) {
            List<AdAssets> assets;
            if (adTicket.getStatus() != 1 || CollectionUtils.isEmpty(assets = this.adTicketAssetsService.findAllAssetsById(adTicket.getId()))) continue;
            for (AdAssets adAssets : assets) {
                if (adAssets.getStatus() == 1) {
                    totalCount += this.pullerIntegration.fetchAssetAllViewPvCount(adAssets.getId().toString(), date).intValue();
                    continue;
                }
                closeAssetsViewcount = this.pullerIntegration.fetchAssetAllViewPvCount(adAssets.getId().toString(), date);
                totalCount += closeAssetsViewcount;
            }
            Double value = DoubleUtil.formatDouble(String.valueOf(closeAssetsViewcount), String.valueOf(totalCount));
            if (value < 85.0 && value > 0.0) {
                try {
                    adTicket.setStatus((short)3);
                    this.adTicketService.updateStatus(adTicket);
                    DingtalkMsgUtil.sendMsg(url, "\u5238ID: " + adTicket.getId() + " \u8be5\u5238\u7684\u7d20\u6750\u66dd\u5149\u5360\u6bd4\u5df2\u4f4e\u4e8e85%,\u73b0\u5728\u66dd\u5149\u5360\u6bd4\u662f" + value + "%,\u5df2\u5173\u95ed\u8be5\u5238,\u8bf7\u53ca\u65f6\u67e5\u770b", false, null);
                }
                catch (Exception e) {
                    DingtalkMsgUtil.sendMsg(url, "\u5238ID: " + adTicket.getId() + " \u8be5\u5238\u7684\u7d20\u6750\u66dd\u5149\u5360\u6bd4\u5df2\u4f4e\u4e8e90%,\u5173\u95ed\u5238\u5931\u8d25,\u73b0\u5728\u66dd\u5149\u5360\u6bd4\u662f" + value + "%\u8bf7\u624b\u52a8\u5173\u95ed", false, null);
                }
            }
            if (value >= 90.0 && value <= 95.0) {
                DingtalkMsgUtil.sendMsg(url, "\u5238ID: " + adTicket.getId() + " \u8be5\u5238\u7684\u7d20\u6750\u66dd\u5149\u5360\u6bd4\u5df2\u4f4e\u4e8e95%,\u73b0\u5728\u66dd\u5149\u5360\u6bd4\u662f" + value + "%\u8bf7\u53ca\u65f6\u67e5\u770b", false, null);
            }
            closeAssetsViewcount = 0;
            totalCount = 0;
        }
    }
}

