/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils.file;

import com.bxm.warcar.utils.file.DataTracker;
import com.bxm.warcar.utils.file.FileComparator;
import com.bxm.warcar.utils.file.FingerprintTracker;
import com.bxm.warcar.utils.file.LicenseTracker;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemFileComparator
implements FileComparator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemFileComparator.class);
    private final File fingerprint;
    private final File data;
    private final File license;
    private final FingerprintTracker fingerprintTracker;
    private final DataTracker dataTracker;
    private final LicenseTracker licenseTracker;

    public SystemFileComparator(File fingerprint, File data, FingerprintTracker fingerprintTracker, DataTracker dataTracker) {
        this(fingerprint, data, null, fingerprintTracker, dataTracker, null);
    }

    SystemFileComparator(File fingerprint, File data, File license, FingerprintTracker fingerprintTracker, DataTracker dataTracker, LicenseTracker licenseTracker) {
        Preconditions.checkNotNull((Object)fingerprintTracker);
        Preconditions.checkNotNull((Object)dataTracker);
        String tmpdir = System.getProperty("user.home") + File.separator + ".warcar" + File.separator;
        File directory = new File(tmpdir);
        if (!directory.exists()) {
            boolean mkdirs = directory.mkdirs();
            if (!mkdirs) {
                throw new RuntimeException(tmpdir + " cannot run command: mkdirs!");
            }
        } else if (!directory.isDirectory()) {
            throw new RuntimeException(tmpdir + " is not directory!");
        }
        if (null == fingerprint) {
            fingerprint = new File(tmpdir + fingerprintTracker.getCacheFileName());
        }
        if (null == data) {
            data = new File(tmpdir + dataTracker.getCacheFileName());
        }
        if (null == license && Objects.nonNull(licenseTracker)) {
            license = new File(tmpdir + licenseTracker.getCacheFileName());
        }
        this.checkAndCreateFile(fingerprint);
        this.checkAndCreateFile(data);
        if (Objects.nonNull(license)) {
            this.checkAndCreateFile(license);
        }
        this.fingerprint = fingerprint;
        this.data = data;
        this.license = license;
        this.fingerprintTracker = fingerprintTracker;
        this.dataTracker = dataTracker;
        this.licenseTracker = licenseTracker;
    }

    @Override
    public boolean compare() throws IOException {
        Preconditions.checkNotNull((Object)this.fingerprintTracker);
        String remoteFingerprint = this.fingerprintTracker.getFingerprint();
        if (StringUtils.isBlank((String)remoteFingerprint)) {
            throw new RuntimeException("fingerprint cannot be blank!");
        }
        String localFingerprint = this.readLocalFingerprint();
        if (StringUtils.equals((String)remoteFingerprint, (String)localFingerprint)) {
            return true;
        }
        Preconditions.checkNotNull((Object)this.dataTracker);
        byte[] data = this.dataTracker.getContent();
        this.writeDataFile(data);
        this.writeLocalFingerprint(remoteFingerprint);
        if (Objects.nonNull(this.licenseTracker)) {
            byte[] licenseTrackerData = this.licenseTracker.getContent();
            this.writeLicenseFile(licenseTrackerData);
        }
        return false;
    }

    @Override
    public File getData() {
        return this.data;
    }

    @Override
    public File getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public File getLicense() {
        return this.license;
    }

    private void checkAndCreateFile(File file) {
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    throw new RuntimeException("Cannot create file: " + file);
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Created file: {}", (Object)file);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("createNewFile: ", e);
            }
        }
        if (!file.isFile()) {
            throw new RuntimeException("File must be not directory: " + file);
        }
    }

    private void writeLocalFingerprint(String fingerprintStr) throws IOException {
        FileUtils.writeStringToFile((File)this.fingerprint, (String)fingerprintStr, (String)"utf-8");
    }

    private String readLocalFingerprint() {
        try {
            return FileUtils.readFileToString((File)this.fingerprint, (String)"utf-8");
        }
        catch (IOException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("read: ", (Throwable)e);
            }
            return null;
        }
    }

    private void writeDataFile(byte[] data) throws IOException {
        FileUtils.writeByteArrayToFile((File)this.data, (byte[])data);
    }

    private void writeLicenseFile(byte[] data) throws IOException {
        FileUtils.writeByteArrayToFile((File)this.license, (byte[])data);
    }

    public static void main(String[] args) {
        System.out.println(System.getProperty("user.home"));
    }
}

