/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.model.enums;

import org.apache.commons.lang3.StringUtils;

public enum LandUserAgeRangeEnum {
    youngsters(0, "<18"),
    youth(1, "18-22"),
    midlife(2, "22-50"),
    old(3, ">50");

    private Integer ageRange;
    private String ageDesc;

    private LandUserAgeRangeEnum(Integer ageRange, String ageDesc) {
        this.ageRange = ageRange;
        this.ageDesc = ageDesc;
    }

    public Integer getAgeRange() {
        return this.ageRange;
    }

    public String getAgeDesc() {
        return this.ageDesc;
    }

    public static String getDesc(Integer ageRange) {
        if (null == ageRange) {
            return "";
        }
        for (LandUserAgeRangeEnum ageRangeEnum : LandUserAgeRangeEnum.values()) {
            if (!ageRangeEnum.getAgeRange().equals(ageRange)) continue;
            return ageRangeEnum.getAgeDesc();
        }
        return "";
    }

    public static Integer getRange(String desc) {
        if (StringUtils.isBlank((CharSequence)desc)) {
            return null;
        }
        for (LandUserAgeRangeEnum ageRangeEnum : LandUserAgeRangeEnum.values()) {
            if (!ageRangeEnum.getAgeDesc().equals(desc)) continue;
            return ageRangeEnum.getAgeRange();
        }
        return null;
    }

    public static Integer getRange(Integer age) {
        if (null == age) {
            return null;
        }
        if (age < 18) {
            return youngsters.getAgeRange();
        }
        if (age < 22) {
            return youth.getAgeRange();
        }
        if (age < 50) {
            return midlife.getAgeRange();
        }
        return old.getAgeRange();
    }
}

