/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.commons.time;

import com.google.common.base.MoreObjects;
import java.util.concurrent.TimeUnit;

public class Time {
    private TimeUnit unit;
    private long duration;

    private Time(long duration, TimeUnit unit) {
        this.duration = duration;
        this.unit = unit;
    }

    public static Time current() {
        return Time.milliSeconds(System.currentTimeMillis());
    }

    public static Time milliSeconds(long milliSecs) {
        return new Time(milliSecs, TimeUnit.MILLISECONDS);
    }

    public static Time seconds(long secs) {
        return new Time(secs, TimeUnit.SECONDS);
    }

    public static Time minutes(long mins) {
        return new Time(mins, TimeUnit.MINUTES);
    }

    public static Time hours(long hours) {
        return new Time(hours, TimeUnit.HOURS);
    }

    public static Time days(long days) {
        return new Time(days, TimeUnit.DAYS);
    }

    public Time until(Time targetTime) {
        return Time.milliSeconds(targetTime.toMillis() - this.toMillis());
    }

    public long toMillis() {
        return this.getUnit().toMillis(this.getDuration());
    }

    public long toSeconds() {
        return this.getUnit().toSeconds(this.getDuration());
    }

    public long toMinutes() {
        return this.getUnit().toMinutes(this.getDuration());
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public long getDuration() {
        return this.duration;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("duration", this.duration).add("unit", (Object)this.unit).toString();
    }
}

