/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.util;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.bxm.util.CommonValidate;
import com.bxm.util.StringUtil;

public class AliYunSmsUtil {
    private static final String REGION_ID = "cn-hangzhou";
    private static final String PRODUCT = "Dysmsapi";
    private static final String DOMAIN = "dysmsapi.aliyuncs.com";
    private static final String PARAM_STRING = "{\"code\":\"msgContent\"}";

    public static boolean sendValidateCodeMsg(String accessKeyId, String accessKeySecret, String signName, String phone, String msgContent, String msgTemplateCode) {
        CommonValidate.me.checkParam(accessKeyId);
        CommonValidate.me.checkParam(accessKeySecret);
        CommonValidate.me.checkParam(signName);
        CommonValidate.me.checkParam(phone);
        CommonValidate.me.checkParam(msgContent);
        CommonValidate.me.checkParam(msgTemplateCode);
        boolean isSendSuccess = false;
        try {
            System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
            System.setProperty("sun.net.client.defaultReadTimeout", "10000");
            DefaultProfile profile = DefaultProfile.getProfile((String)REGION_ID, (String)accessKeyId, (String)accessKeySecret);
            DefaultProfile.addEndpoint((String)REGION_ID, (String)REGION_ID, (String)PRODUCT, (String)DOMAIN);
            DefaultAcsClient acsClient = new DefaultAcsClient((IClientProfile)profile);
            SendSmsRequest request = new SendSmsRequest();
            request.setMethod(MethodType.POST);
            request.setPhoneNumbers(phone);
            request.setSignName(signName);
            request.setTemplateCode(msgTemplateCode);
            request.setTemplateParam(PARAM_STRING.replace("msgContent", msgContent));
            SendSmsResponse sendSmsResponse = (SendSmsResponse)acsClient.getAcsResponse((AcsRequest)request);
            if (sendSmsResponse.getCode() != null && sendSmsResponse.getCode().equals("OK")) {
                isSendSuccess = true;
            }
        }
        catch (ServerException e) {
            e.printStackTrace();
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        return isSendSuccess;
    }

    public static boolean sendMsg(String accessKeyId, String accessKeySecret, String signName, String phone, String msgContent, String msgTemplateCode) {
        CommonValidate.me.checkParam(accessKeyId);
        CommonValidate.me.checkParam(accessKeySecret);
        CommonValidate.me.checkParam(signName);
        CommonValidate.me.checkParam(phone);
        CommonValidate.me.checkParam(msgTemplateCode);
        boolean isSendSuccess = false;
        try {
            SendSmsResponse sendSmsResponse;
            System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
            System.setProperty("sun.net.client.defaultReadTimeout", "10000");
            DefaultProfile profile = DefaultProfile.getProfile((String)REGION_ID, (String)accessKeyId, (String)accessKeySecret);
            DefaultProfile.addEndpoint((String)REGION_ID, (String)REGION_ID, (String)PRODUCT, (String)DOMAIN);
            DefaultAcsClient acsClient = new DefaultAcsClient((IClientProfile)profile);
            SendSmsRequest request = new SendSmsRequest();
            request.setMethod(MethodType.POST);
            request.setPhoneNumbers(phone);
            request.setSignName(signName);
            request.setTemplateCode(msgTemplateCode);
            if (StringUtil.isNotBlank((CharSequence)msgContent)) {
                request.setTemplateParam(msgContent);
            }
            if ((sendSmsResponse = (SendSmsResponse)acsClient.getAcsResponse((AcsRequest)request)).getCode() != null && sendSmsResponse.getCode().equals("OK")) {
                isSendSuccess = true;
            }
        }
        catch (ServerException e) {
            e.printStackTrace();
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        return isSendSuccess;
    }
}

