/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.util;

import com.bxm.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CatchImageUtil {
    private static final String IMGURL_REG = "<img.*src=(.*?)[^>]*?>";
    private static final String IMGSRC_REG = "http:\"?(.*?)(\"|>|\\s+)";

    public static List<String> getImageTag(String htmlStr) {
        Matcher matcher = Pattern.compile(IMGURL_REG).matcher(htmlStr);
        ArrayList<String> listImgUrl = new ArrayList<String>();
        while (matcher.find()) {
            listImgUrl.add(matcher.group());
        }
        return listImgUrl;
    }

    public static String getFristImageTag(String htmlStr) {
        Matcher matcher = Pattern.compile(IMGURL_REG).matcher(htmlStr);
        String imgUrl = "";
        while (matcher.find()) {
            imgUrl = matcher.group();
        }
        return imgUrl;
    }

    public static String getImageSrc(String imageTag) {
        String listImgSrc = "";
        Matcher matcher = Pattern.compile(IMGSRC_REG).matcher(imageTag);
        if (matcher.find()) {
            listImgSrc = matcher.group().substring(0, matcher.group().length() - 1);
        }
        return listImgSrc;
    }

    public static List<String> getImageSrc(List<String> listImageTag) {
        ArrayList<String> listImgSrc = new ArrayList<String>();
        for (String image : listImageTag) {
            Matcher matcher = Pattern.compile(IMGSRC_REG).matcher(image);
            while (matcher.find()) {
                listImgSrc.add(matcher.group().substring(0, matcher.group().length() - 1));
            }
        }
        return listImgSrc;
    }

    public static void downloadImgList(List<String> listImgUrl, String savePath) {
        try {
            if (listImgUrl != null && StringUtil.isNotBlank((CharSequence)savePath)) {
                savePath.replace("\\", "/");
                File targetDir = new File(savePath);
                if (!targetDir.exists()) {
                    targetDir.mkdirs();
                }
                for (String url : listImgUrl) {
                    String imageName = url.substring(url.lastIndexOf("/") + 1, url.length());
                    URL uri = new URL(url);
                    InputStream in = uri.openStream();
                    String filePath = String.valueOf(savePath) + "/" + imageName;
                    filePath.replace("\\", "/");
                    File file = new File(filePath);
                    file.createNewFile();
                    FileOutputStream fo = new FileOutputStream(file);
                    byte[] buf = new byte[1024];
                    int length = 0;
                    while ((length = in.read(buf, 0, buf.length)) != -1) {
                        fo.write(buf, 0, length);
                    }
                    in.close();
                    fo.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void downloadOneImg(String imgUrl, String savePath) {
        try {
            if (imgUrl != null && StringUtil.isNotBlank((CharSequence)savePath)) {
                String imageName = imgUrl.substring(imgUrl.lastIndexOf("/") + 1, imgUrl.length());
                URL uri = new URL(imgUrl);
                InputStream in = uri.openStream();
                savePath.replace("\\", "/");
                File targetDir = new File(savePath);
                if (!targetDir.exists()) {
                    targetDir.mkdirs();
                }
                String filePath = String.valueOf(savePath) + "/" + imageName;
                filePath.replace("\\", "/");
                File file = new File(filePath);
                file.createNewFile();
                FileOutputStream fo = new FileOutputStream(file);
                byte[] buf = new byte[1024];
                int length = 0;
                while ((length = in.read(buf, 0, buf.length)) != -1) {
                    fo.write(buf, 0, length);
                }
                in.close();
                fo.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

