/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ListUtil {
    public static <T> List<List<T>> splitList(List<T> resList, int count) {
        if (resList == null || count < 1) {
            return null;
        }
        ArrayList<List<T>> ret = new ArrayList<List<T>>();
        int size = resList.size();
        if (size <= count) {
            ret.add(resList);
        } else {
            int pre = size / count;
            int last = size % count;
            int i = 0;
            while (i < pre) {
                ArrayList<T> itemList = new ArrayList<T>();
                int j = 0;
                while (j < count) {
                    itemList.add(resList.get(i * count + j));
                    ++j;
                }
                ret.add(itemList);
                ++i;
            }
            if (last > 0) {
                ArrayList<T> itemList = new ArrayList<T>();
                int i2 = 0;
                while (i2 < last) {
                    itemList.add(resList.get(pre * count + i2));
                    ++i2;
                }
                ret.add(itemList);
            }
        }
        return ret;
    }

    public static List<Object> getTotalPage(List<Object> listObj, int pageIndex, int pageNum) {
        if (listObj == null) {
            return null;
        }
        List<Object> pageList = new ArrayList<Object>();
        int listSize = listObj.size();
        int totalPage = 0;
        totalPage = listSize % pageNum > 0 ? listSize / pageNum + 1 : listSize / pageNum;
        if (listSize > 0 && pageIndex <= totalPage) {
            if (pageIndex == 1) {
                pageList = listSize <= pageNum ? listObj.subList(0, listSize) : listObj.subList(0, pageNum);
            } else {
                int fromIndex = (pageIndex - 1) * pageNum;
                int toIndex = pageIndex * pageNum;
                toIndex = (listSize - toIndex) % pageNum >= 0 ? pageIndex * pageNum : (pageIndex - 1) * pageNum + listSize % pageNum;
                if (listSize >= toIndex) {
                    pageList = listObj.subList(fromIndex, toIndex);
                }
            }
        }
        return pageList;
    }

    public static Object[] listToArray(List<Object> params) {
        Object[] objs = new Object[]{};
        if (params != null && params.size() > 0) {
            objs = new Object[params.size()];
            int index = 0;
            Iterator<Object> iterator = params.iterator();
            while (iterator.hasNext()) {
                Object object;
                objs[index] = object = iterator.next();
                ++index;
            }
        }
        return objs;
    }
}

