/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.util;

import com.bxm.util.StringUtil;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class PinyinUtil {
    public static String getPinYin(String sourceStr, String connectStr, boolean isFirstToUppper) {
        if (StringUtil.isBlank((CharSequence)sourceStr)) {
            return sourceStr;
        }
        char[] tempChar = null;
        tempChar = sourceStr.toCharArray();
        String[] newStrs = new String[tempChar.length];
        HanyuPinyinOutputFormat pinyinFormat = new HanyuPinyinOutputFormat();
        pinyinFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        pinyinFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        pinyinFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
        String pinyinStr = "";
        int t0 = tempChar.length;
        try {
            int i = 0;
            while (i < t0) {
                if (Character.toString(tempChar[i]).matches("[\\u4E00-\\u9FA5]+")) {
                    newStrs = PinyinHelper.toHanyuPinyinStringArray((char)tempChar[i], (HanyuPinyinOutputFormat)pinyinFormat);
                    if (isFirstToUppper) {
                        String temp = newStrs[0].substring(0, 1).toUpperCase();
                        newStrs[0] = String.valueOf(temp) + newStrs[0].substring(1);
                    }
                    if (StringUtil.isNotBlank((CharSequence)connectStr) && i + 1 != t0) {
                        newStrs[0] = String.valueOf(newStrs[0]) + connectStr;
                    }
                    pinyinStr = String.valueOf(pinyinStr) + newStrs[0];
                } else {
                    pinyinStr = String.valueOf(pinyinStr) + Character.toString(tempChar[i]);
                }
                ++i;
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            e.printStackTrace();
        }
        return pinyinStr;
    }

    public static String getPinYinHeadChar(String sourceStr, String connectStr, boolean isToUpper) {
        if (StringUtil.isBlank((CharSequence)sourceStr)) {
            return sourceStr;
        }
        String pinyinStr = "";
        int j = 0;
        while (j < sourceStr.length()) {
            char word = sourceStr.charAt(j);
            String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray((char)word);
            pinyinStr = pinyinArray != null ? String.valueOf(pinyinStr) + pinyinArray[0].charAt(0) : String.valueOf(pinyinStr) + word;
            if (StringUtil.isNotBlank((CharSequence)connectStr) && j + 1 != sourceStr.length()) {
                pinyinStr = String.valueOf(pinyinStr) + connectStr;
            }
            ++j;
        }
        if (isToUpper) {
            pinyinStr = pinyinStr.toUpperCase();
        }
        return pinyinStr;
    }
}

