/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Pattern;

public final class ValidateUtils {
    public static final String PATTERN_EMAIL = "^(\\w)+(\\.\\w+)*@(\\w)+((\\.\\w+)+)$";
    public static final String PATTERN_MOBILE = "^(0|86|17951)?(13[0-9]|15[012356789]|17[0678]|18[0-9]|14[57])[0-9]{8}$";
    public static final String PATTERN_TELEPHONE = "^([0-9]{3,4}-)?[0-9]{7,8}$";
    public static final String PATTERN_PHONE = "^((0\\d{2,3}-{0,1}\\d{7,8})|(\\d{7,8})|(1[35784]\\d{9}))$";
    public static final String PATTERN_NUM = "^[-]{0,1}[0-9]*$";
    public static final String PATTERN_POSTNUM = "^[0-9]{6}$";
    private static final String[] CITYCODE = new String[]{"11", "12", "13", "14", "15", "21", "22", "23", "31", "32", "33", "34", "35", "36", "37", "41", "42", "43", "44", "45", "46", "50", "51", "52", "53", "54", "61", "62", "63", "64", "65", "71", "81", "82", "91"};
    private static final int[] POWER = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};

    public static class Builder {
        private String value;
        private boolean required;
        private boolean num;
        private String pattern;
        private Integer min;
        private Integer max;

        public Builder() {
            this(null);
        }

        public Builder(String value) {
            this.value = value;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder required(boolean required) {
            this.required = required;
            return this;
        }

        public Builder num(boolean num) {
            this.num = num;
            return this;
        }

        public Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder min(Integer min) {
            this.min = min;
            return this;
        }

        public Builder max(Integer max) {
            this.max = max;
            return this;
        }

        public Builder minAndMax(Integer min, Integer max) {
            this.min = min;
            this.max = max;
            return this;
        }

        public boolean isMail() {
            return this.pattern(ValidateUtils.PATTERN_EMAIL).validate();
        }

        public boolean isTelephone() {
            return this.pattern(ValidateUtils.PATTERN_TELEPHONE).validate();
        }

        public boolean isMobile() {
            return this.pattern(ValidateUtils.PATTERN_MOBILE).validate();
        }

        public boolean isPhone() {
            return this.pattern(ValidateUtils.PATTERN_PHONE).validate();
        }

        public boolean isPostNum() {
            return this.pattern(ValidateUtils.PATTERN_POSTNUM).validate();
        }

        public boolean isNum() {
            return this.num(true).validate();
        }

        public boolean isMail(boolean required) {
            return this.required(required).pattern(ValidateUtils.PATTERN_EMAIL).validate();
        }

        public boolean isTelephone(boolean required) {
            return this.required(required).pattern(ValidateUtils.PATTERN_TELEPHONE).validate();
        }

        public boolean isMobile(boolean required) {
            return this.required(required).pattern(ValidateUtils.PATTERN_MOBILE).validate();
        }

        public boolean isNum(boolean required) {
            return this.required(required).num(true).validate();
        }

        public boolean isPhone(boolean required) {
            return this.required(required).pattern(ValidateUtils.PATTERN_PHONE).validate();
        }

        public boolean isPostNum(boolean required) {
            return this.required(required).pattern(ValidateUtils.PATTERN_POSTNUM).validate();
        }

        public boolean validate() {
            if (this.value == null || "".equals(this.value)) {
                if (this.required) {
                    return false;
                }
            } else {
                Pattern p2;
                if (this.num) {
                    Pattern p1 = Pattern.compile(ValidateUtils.PATTERN_NUM);
                    if (!p1.matcher(this.value).matches()) {
                        return false;
                    }
                    if (this.min != null && Integer.valueOf(this.value) < this.min) {
                        return false;
                    }
                    if (this.max != null && Integer.valueOf(this.value) > this.max) {
                        return false;
                    }
                } else {
                    if (this.min != null && this.value.length() < this.min) {
                        return false;
                    }
                    if (this.max != null && this.value.length() > this.max) {
                        return false;
                    }
                }
                if (this.pattern != null && !(p2 = Pattern.compile(this.pattern)).matcher(this.value).matches()) {
                    return false;
                }
            }
            return true;
        }

        public boolean isIDCard() {
            if (this.value == null || "".equals(this.value)) {
                return !this.required;
            }
            if (this.value.length() == 15) {
                return this.validate15IDCard();
            }
            return this.validate18Idcard();
        }

        public boolean isIDCard(boolean required) {
            return this.required(true).isIDCard();
        }

        public boolean validate18Idcard() {
            if (this.value.length() != 18) {
                return false;
            }
            String idcard17 = this.value.substring(0, 17);
            if (!Builder.isDigital(idcard17)) {
                return false;
            }
            String provinceid = this.value.substring(0, 2);
            if (!this.checkProvinceid(provinceid)) {
                return false;
            }
            String birthday = this.value.substring(6, 14);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            try {
                Date birthDate = sdf.parse(birthday);
                String tmpDate = sdf.format(birthDate);
                if (!tmpDate.equals(birthday)) {
                    return false;
                }
            }
            catch (ParseException e1) {
                return false;
            }
            String idcard18Code = this.value.substring(17, 18);
            char[] c = idcard17.toCharArray();
            int[] bit = Builder.converCharToInt(c);
            int sum17 = 0;
            sum17 = Builder.getPowerSum(bit);
            String checkCode = Builder.getCheckCodeBySum(sum17);
            if (checkCode == null) {
                return false;
            }
            return idcard18Code.equalsIgnoreCase(checkCode);
        }

        public boolean validate15IDCard() {
            if (this.value.length() != 15) {
                return false;
            }
            if (!Builder.isDigital(this.value)) {
                return false;
            }
            String provinceid = this.value.substring(0, 2);
            if (!this.checkProvinceid(provinceid)) {
                return false;
            }
            String birthday = this.value.substring(6, 12);
            SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd");
            try {
                Date birthDate = sdf.parse(birthday);
                String tmpDate = sdf.format(birthDate);
                return tmpDate.equals(birthday);
            }
            catch (ParseException e1) {
                return false;
            }
        }

        public String convertIdcarBy15bit() {
            if (this.value == null) {
                return null;
            }
            if (this.value.length() != 15) {
                return null;
            }
            if (!Builder.isDigital(this.value)) {
                return null;
            }
            String provinceid = this.value.substring(0, 2);
            if (!this.checkProvinceid(provinceid)) {
                return null;
            }
            String birthday = this.value.substring(6, 12);
            SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd");
            Date birthdate = null;
            try {
                birthdate = sdf.parse(birthday);
                String tmpDate = sdf.format(birthdate);
                if (!tmpDate.equals(birthday)) {
                    return null;
                }
            }
            catch (ParseException e1) {
                return null;
            }
            Calendar cday = Calendar.getInstance();
            cday.setTime(birthdate);
            String year = String.valueOf(cday.get(1));
            String idcard17 = String.valueOf(this.value.substring(0, 6)) + year + this.value.substring(8);
            char[] c = idcard17.toCharArray();
            String checkCode = "";
            int[] bit = Builder.converCharToInt(c);
            int sum17 = 0;
            sum17 = Builder.getPowerSum(bit);
            checkCode = Builder.getCheckCodeBySum(sum17);
            if (checkCode == null) {
                return null;
            }
            idcard17 = String.valueOf(idcard17) + checkCode;
            return idcard17;
        }

        private boolean checkProvinceid(String provinceid) {
            String[] stringArray = CITYCODE;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                if (id.equals(provinceid)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private static boolean isDigital(String str) {
            return str.matches("^[0-9]*$");
        }

        private static int getPowerSum(int[] bit) {
            int sum = 0;
            if (POWER.length != bit.length) {
                return sum;
            }
            int i = 0;
            while (i < bit.length) {
                int j = 0;
                while (j < POWER.length) {
                    if (i == j) {
                        sum += bit[i] * POWER[j];
                    }
                    ++j;
                }
                ++i;
            }
            return sum;
        }

        private static String getCheckCodeBySum(int sum17) {
            String checkCode = null;
            switch (sum17 % 11) {
                case 10: {
                    checkCode = "2";
                    break;
                }
                case 9: {
                    checkCode = "3";
                    break;
                }
                case 8: {
                    checkCode = "4";
                    break;
                }
                case 7: {
                    checkCode = "5";
                    break;
                }
                case 6: {
                    checkCode = "6";
                    break;
                }
                case 5: {
                    checkCode = "7";
                    break;
                }
                case 4: {
                    checkCode = "8";
                    break;
                }
                case 3: {
                    checkCode = "9";
                    break;
                }
                case 2: {
                    checkCode = "x";
                    break;
                }
                case 1: {
                    checkCode = "0";
                    break;
                }
                case 0: {
                    checkCode = "1";
                }
            }
            return checkCode;
        }

        private static int[] converCharToInt(char[] c) throws NumberFormatException {
            int[] a = new int[c.length];
            int k = 0;
            char[] cArray = c;
            int n = c.length;
            int n2 = 0;
            while (n2 < n) {
                char temp = cArray[n2];
                a[k++] = Integer.parseInt(String.valueOf(temp));
                ++n2;
            }
            return a;
        }
    }
}

