/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.mq.redis;

import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Listener;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.SingleMessageListener;
import com.bxm.warcar.mq.redis.RedisConsumer;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.LifeCycle;
import com.bxm.warcar.utils.NamedThreadFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPubSub;

public class JedisSubscriber
extends LifeCycle
implements Consumer {
    private final ThreadPoolExecutor subscriber = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("JedisSubscriber"));
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisConsumer.class);
    private final JedisPool jedisPool;
    private final SingleMessageListener messageListener;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);

    public JedisSubscriber(JedisPool jedisPool, SingleMessageListener messageListener) {
        this.jedisPool = jedisPool;
        this.messageListener = messageListener;
    }

    @Override
    protected void doInit() {
        String topic = this.messageListener.getTopic();
        if (this.shutdown.get()) {
            return;
        }
        this.subscriber.execute(() -> {
            if (null == this.jedisPool || this.jedisPool.isClosed()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return;
            }
            Jedis jedis = this.jedisPool.getResource();
            try {
                jedis.subscribe(new JedisPubSub(){

                    public void onMessage(String channel, String message) {
                        if (null != message) {
                            Message message1 = JsonHelper.convert(message, Message.class);
                            JedisSubscriber.this.messageListener.consume(message1, message1);
                        }
                    }
                }, new String[]{topic});
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
            finally {
                if (null != jedis) {
                    jedis.close();
                }
            }
        });
    }

    @Override
    protected void doDestroy() {
        if (this.jedisPool != null) {
            this.jedisPool.destroy();
        }
    }

    @Override
    public void suspend() {
    }

    @Override
    public void shutdown() {
        this.doDestroy();
    }

    @Override
    public void start() {
        this.doInit();
    }

    @Override
    public boolean isStarted() {
        return false;
    }

    @Override
    public Listener getMessageListener() {
        return this.messageListener;
    }
}

