/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.configures;

import com.bxm.adsmanager.configures.GatewayRedisConfiguration;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;

@Configuration
@EnableConfigurationProperties(value={GatewayRedisConfiguration.class})
public class GatewayRedisBeanConfiguration {
    private final GatewayRedisConfiguration gatewayRedisConfiguration;

    public GatewayRedisBeanConfiguration(GatewayRedisConfiguration gatewayRedisConfiguration) {
        this.gatewayRedisConfiguration = gatewayRedisConfiguration;
    }

    @Bean
    public JedisPool jedisPoolForGateway() {
        return new JedisPool((GenericObjectPoolConfig)this.gatewayRedisConfiguration, this.gatewayRedisConfiguration.getHost(), this.gatewayRedisConfiguration.getPort(), this.gatewayRedisConfiguration.getTimeout(), this.gatewayRedisConfiguration.getPassword(), this.gatewayRedisConfiguration.getDatabase());
    }

    @Bean
    public JedisFetcher jedisFetcherForGateway() {
        return new JedisFetcher(this.jedisPoolForGateway());
    }

    @Bean
    public JedisUpdater jedisUpdaterForGateway() {
        return new JedisUpdater(this.jedisPoolForGateway());
    }
}

