/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.listener;

import com.bxm.adsmanager.dal.mapper.overseas.OverseasOfflineAdvertMapper;
import com.bxm.adsmanager.model.dao.overseas.OverseasOfflineAdvert;
import com.bxm.adsmanager.model.dto.overseas.OverseasOfflineAdSyncDto;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class OverseasOfflineAdSyncListener {
    private static final Logger log = LoggerFactory.getLogger(OverseasOfflineAdSyncListener.class);
    @Autowired
    private OverseasOfflineAdvertMapper mapper;
    private final Map<Integer, OverseasOfflineAdSyncDto> map = new HashMap<Integer, OverseasOfflineAdSyncDto>(16);
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(100), (ThreadFactory)new NamedThreadFactory("OverseasOfflineAdSync"));

    @Scheduled(initialDelay=0L, fixedDelay=300000L)
    public synchronized void schedule() {
        for (Map.Entry<Integer, OverseasOfflineAdSyncDto> next : this.map.entrySet()) {
            OverseasOfflineAdSyncDto value = next.getValue();
            if (!this.judgeDataComplete(value)) continue;
            this.executor.execute(() -> this.doDataSync(value.getData()));
            this.map.put(next.getKey(), OverseasOfflineAdSyncDto.builder().batchId(value.getBatchId()).build());
        }
    }

    private boolean judgeDataComplete(OverseasOfflineAdSyncDto data) {
        if (Boolean.FALSE.equals(data.getPart())) {
            return true;
        }
        if (data.getTotal() != null && data.getTotal() <= data.getData().size()) {
            return true;
        }
        return data.getExpireTime() != null && System.currentTimeMillis() > data.getExpireTime();
    }

    @EventListener
    public synchronized void sync(OverseasOfflineAdSyncDto newData) {
        if (newData == null || CollectionUtils.isEmpty((Collection)newData.getData()) || newData.getPart() == null) {
            return;
        }
        if (Boolean.FALSE.equals(newData.getPart())) {
            this.executor.execute(() -> this.doDataSync(newData.getData()));
            return;
        }
        if (newData.getBatchId() == null || newData.getTime() == null) {
            return;
        }
        newData.setExpireTime(Long.valueOf(System.currentTimeMillis() + newData.getTime()));
        Integer offerSource = ((OverseasOfflineAdvert)newData.getData().get(0)).getOfferSource();
        OverseasOfflineAdSyncDto existData = this.map.get(offerSource);
        if (existData == null) {
            this.map.put(offerSource, newData);
            return;
        }
        if (newData.getBatchId() > existData.getBatchId()) {
            this.map.put(offerSource, newData);
        } else if (newData.getBatchId().equals(existData.getBatchId()) && CollectionUtils.isNotEmpty((Collection)existData.getData())) {
            existData.getData().addAll(newData.getData());
        }
    }

    private void doDataSync(List<OverseasOfflineAdvert> adverts) {
        this.dataFilter(adverts);
        if (CollectionUtils.isEmpty(adverts)) {
            return;
        }
        Integer offerSource = adverts.get(0).getOfferSource();
        ArrayList insert = Lists.newArrayList();
        ArrayList update = Lists.newArrayList();
        Map<String, Long> collect = this.mapper.selectBySelective(OverseasOfflineAdvert.builder().offerSource(offerSource).build()).stream().collect(Collectors.toMap(OverseasOfflineAdvert::getOfferId, OverseasOfflineAdvert::getId));
        for (OverseasOfflineAdvert tmp : adverts) {
            if (collect.containsKey(tmp.getOfferId())) {
                tmp.setId(collect.get(tmp.getOfferId()));
                collect.remove(tmp.getOfferId());
                update.add(tmp);
                continue;
            }
            insert.add(tmp);
        }
        for (OverseasOfflineAdvert tmp : update) {
            this.mapper.updateByPrimaryKey(tmp);
        }
        for (OverseasOfflineAdvert tmp : insert) {
            this.mapper.insertSelective(tmp);
        }
        if (collect.size() > 0) {
            this.mapper.deleteByIds(collect.values());
        }
    }

    private void dataFilter(List<OverseasOfflineAdvert> adverts) {
        HashSet<String> ids = new HashSet<String>();
        Iterator<OverseasOfflineAdvert> iterator = adverts.iterator();
        while (iterator.hasNext()) {
            OverseasOfflineAdvert next = iterator.next();
            if (ids.contains(next.getOfferId())) {
                iterator.remove();
                continue;
            }
            ids.add(next.getOfferId());
        }
    }
}

