/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.openlog;

import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdAssetsTemplateAssetsMapperExt;
import com.bxm.adsmanager.model.constant.RedisKeys;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTemplateAssets;
import com.bxm.adsmanager.model.enums.PanguAdxEnum;
import com.bxm.adsmanager.service.prod.ProdService;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Pangu;
import com.bxm.openlog.sdk.listener.LogSubscriber;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.mq.ConsumeStatus;
import com.bxm.warcar.utils.DateHelper;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
public class CreativeStatusRejectingLogSubscriber
implements LogSubscriber {
    private static final Logger log = LoggerFactory.getLogger(CreativeStatusRejectingLogSubscriber.class);
    private static final String QTT_FAIL_REASON_PARAM = "failreason";
    private static final String QTT_FAIL_REASON_CREATIVE_UNREVIEW = "\u5ba1\u6838\u8fc7\u6ee4";
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    private final LoadingCache<String, String> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, String>(){

        public String load(String key) throws Exception {
            return key;
        }
    });
    @Resource
    private AdAssetsTemplateAssetsMapperExt adAssetsTemplateAssetsMapperExt;
    @Resource
    private ProdService prodService;

    public String getId() {
        return "CSRLS";
    }

    public Production getProduction() {
        return Production.PANGU;
    }

    public String[] getMts() {
        return new String[]{Pangu.Mt.Bidded.original()};
    }

    public ConsumeStatus consume(KeyValueMap keyValueMap) {
        String adxId = (String)keyValueMap.getFirst((Object)"adxid");
        String creativeId = (String)keyValueMap.getFirst((Object)"createid");
        String failReason = (String)keyValueMap.getFirst((Object)QTT_FAIL_REASON_PARAM);
        String adPlanId = (String)keyValueMap.getFirst((Object)"adid");
        if (log.isDebugEnabled()) {
            log.debug("{}", (Object)keyValueMap);
        }
        if (this.isQttCreativeUnReview(adxId, adPlanId, creativeId, failReason)) {
            this.cache.put((Object)creativeId, (Object)adPlanId);
        }
        return ConsumeStatus.CONSUME_SUCCESS;
    }

    @Scheduled(fixedDelay=10000L)
    public void handleCreativeAdxStatus() {
        if (log.isDebugEnabled()) {
            log.debug("start handleCreativeAdxStatus");
        }
        ConcurrentMap map = this.cache.asMap();
        HashSet ticketIds = new HashSet();
        for (Map.Entry entry : map.entrySet()) {
            if (log.isDebugEnabled()) {
                log.debug("handle cid = {}", entry.getKey());
            }
            AdAssetsTemplateAssets record = new AdAssetsTemplateAssets();
            record.setId(Long.valueOf((String)entry.getKey()));
            record.setAdxAuditStatus(Short.valueOf((short)3));
            this.adAssetsTemplateAssetsMapperExt.updateByPrimaryKeySelective(record);
            ticketIds.add(entry.getValue());
            this.cache.invalidate(entry.getKey());
        }
        if (CollectionUtils.isNotEmpty(ticketIds)) {
            try {
                for (String id : ticketIds) {
                    this.prodService.pushAdTicketToProdPre(Long.valueOf(id));
                }
            }
            catch (Exception e) {
                log.error("pushAdTicketToProdPre err", (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("end handleCreativeAdxStatus");
        }
    }

    private boolean isQttCreativeUnReview(String adxId, String adPlanId, String creativeId, String failReason) {
        if (StringUtils.isEmpty((CharSequence)adxId)) {
            return false;
        }
        if (Integer.valueOf(adxId).intValue() != PanguAdxEnum.QTT.getAdxType()) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)creativeId)) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)failReason)) {
            return false;
        }
        if (failReason.equals(QTT_FAIL_REASON_CREATIVE_UNREVIEW)) {
            return true;
        }
        if (StringUtils.isNotEmpty((CharSequence)adPlanId) || adPlanId.equals("27522")) {
            this.updater.hupdate(RedisKeys.getPanguQttBidded(), adPlanId + "-" + creativeId, (Object)failReason, (int)DateHelper.getRemainSecondsOfToday());
        }
        return false;
    }
}

