/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.scheduler;

import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.integration.advertiser.model.Advertiser;
import com.bxm.adsmanager.integration.advertiser.service.AdvertiserFeignService;
import com.bxm.adsmanager.model.enums.ProdServiceNameEnum;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.bxm.warcar.zk.ZkClientHolder;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;

public class AdvertiserSynchronizingPushable
implements ApplicationListener<ApplicationReadyEvent>,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(AdvertiserSynchronizingPushable.class);
    private final ScheduledThreadPoolExecutor threadPool = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("pos-sync"));
    private final AdvertiserFeignService advertiserFeignService;
    private final ProdPusherIntegration prodPusher;
    private final Fetcher fetcher;
    private final Updater updater;
    private final LeaderLatch leaderLatch;

    public AdvertiserSynchronizingPushable(AdvertiserFeignService advertiserFeignService, ProdPusherIntegration prodPusher, Fetcher fetcher, Updater updater, ZkClientHolder zkClientHolder) {
        this.advertiserFeignService = advertiserFeignService;
        this.prodPusher = prodPusher;
        this.fetcher = fetcher;
        this.updater = updater;
        this.leaderLatch = new LeaderLatch(zkClientHolder.get(), "/adsmanager/advertiser_sync_execution_leader");
    }

    public void destroy() {
        try {
            this.leaderLatch.close();
        }
        catch (Exception e) {
            log.error("shutdown: ", (Throwable)e);
        }
        this.threadPool.shutdownNow();
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.leaderLatch.addListener(new LeaderLatchListener(){

            public void isLeader() {
                AdvertiserSynchronizingPushable.this.startSyncData();
            }

            public void notLeader() {
            }
        });
        try {
            this.leaderLatch.start();
        }
        catch (Exception e) {
            log.error("start: ", (Throwable)e);
            System.exit(-1);
        }
    }

    private void startSyncData() {
        this.threadPool.scheduleWithFixedDelay(() -> {
            try {
                if (log.isInfoEnabled()) {
                    log.info("Starting sync advertiser.");
                }
                long start = System.currentTimeMillis();
                int pageNum = 1;
                int pageSize = 10;
                long pages = 0L;
                String orderParam = "updated";
                String orderType = "asc";
                String updated = this.getLastSyncTime();
                do {
                    List list;
                    long oneStart = System.currentTimeMillis();
                    ResultModel pageList = this.advertiserFeignService.getList(Integer.valueOf(pageNum), Integer.valueOf(pageSize), orderParam, orderType, null, null, null, null, null, null, null, null, null, null, null, updated);
                    if (!pageList.isSuccessed()) continue;
                    PageInfo pageInfo = (PageInfo)pageList.getReturnValue();
                    if (Objects.isNull(pageInfo) || CollectionUtils.isEmpty((Collection)(list = pageInfo.getList()))) break;
                    pages = pageInfo.getPages();
                    String now = null;
                    for (Advertiser advertiser : list) {
                        if (log.isInfoEnabled()) {
                            log.info("Post advertiser data: {}", (Object)JsonHelper.convert((Object)advertiser));
                        }
                        byte[] data = JsonHelper.convert2bytes((Object)advertiser);
                        this.prodPusher.pushToProd(ProdServiceNameEnum.ADVERTISER.getServiceName(), new HashMap(), data);
                        Date updatedDate = advertiser.getUpdated();
                        if (!Objects.nonNull(updatedDate)) continue;
                        now = DateHelper.format((Date)updatedDate, (String)"yyyy-MM-dd HH:mm:ss");
                    }
                    if (log.isInfoEnabled()) {
                        BigDecimal cost = BigDecimal.valueOf(System.currentTimeMillis() - start).divide(BigDecimal.valueOf(1000L), 2, 4);
                        BigDecimal oneCost = BigDecimal.valueOf(System.currentTimeMillis() - oneStart).divide(BigDecimal.valueOf(1000L), 2, 4);
                        int size = list.size();
                        log.info("Synchronizing advertiser: {}/{} (page) | Offset {} | pageSize {} | cost {} sec | Total cost {} sec", new Object[]{pageNum, pages, now, size, oneCost, cost});
                    }
                    ++pageNum;
                    if (!StringUtils.isNotBlank(now)) continue;
                    this.setLastSyncTime(now);
                } while ((long)pageNum <= pages);
            }
            catch (Exception e) {
                log.error("schedule: ", (Throwable)e);
            }
        }, 0L, 5L, TimeUnit.MINUTES);
    }

    private void setLastSyncTime(String now) {
        this.updater.update(AdvertiserSynchronizingPushable.stringLastSyncTime(), (Object)now);
    }

    private String getLastSyncTime() {
        return (String)this.fetcher.fetch(AdvertiserSynchronizingPushable.stringLastSyncTime(), String.class);
    }

    private static KeyGenerator stringLastSyncTime() {
        return () -> KeyBuilder.build((Object[])new Object[]{"advertiser", "sync", "last", "time"});
    }
}

