/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adflowpackage.impl;

import com.bxm.adsmanager.dal.mapper.adflowpackage.AdFlowPackageMapper;
import com.bxm.adsmanager.dal.mapper.adflowpackage.AdTicketFlowPackageMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdRulesMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.common.DictionariesMapper;
import com.bxm.adsmanager.integration.adsprod.service.ProdPositonGroupIntegration;
import com.bxm.adsmanager.model.dao.AdTicketPopup.ProvideAppDto;
import com.bxm.adsmanager.model.dao.adflowpackage.AdFlowPackage;
import com.bxm.adsmanager.model.dao.adflowpackage.AdTicketFlowPackageConf;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdFlowPackageDto;
import com.bxm.adsmanager.model.dto.AdFlowPackageSearchDto;
import com.bxm.adsmanager.model.enums.RuleTargetEnum;
import com.bxm.adsmanager.model.enums.RuleTypeEnum;
import com.bxm.adsmanager.model.vo.AdFlowPackageVo;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.service.adflowpackage.AdFlowPackageService;
import com.bxm.adsmanager.service.adkeeper.AdRulesService;
import com.bxm.adsmanager.service.adkeeper.impl.AdPositionServiceImpl;
import com.bxm.adsmanager.service.advertiser.TblStationUserWeightService;
import com.bxm.adsmanager.service.prod.ProdService;
import com.bxm.adsmanager.utils.DingtalkMsgUtil;
import com.bxm.adsmanager.utils.UserRoleCodeUtil;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.bxm.warcar.validate.ValidateException;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdFlowPackageServiceImpl
implements AdFlowPackageService,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdFlowPackageServiceImpl.class);
    private static final String ON = "1";
    private static final String OFF = "0";
    @Autowired
    private AdFlowPackageMapper adFlowPackageMapper;
    @Autowired
    private AdTicketFlowPackageMapper adTicketFlowPackageMapper;
    @Autowired
    private AdPositionServiceImpl adPositionServiceImpl;
    @Autowired
    private AdRulesService adRulesServiceImpl;
    @Autowired
    private ProdService prodService;
    @Autowired
    private ProdPositonGroupIntegration prodPositonGroupIntegration;
    @Autowired
    private AdRulesMapper adRulesMapper;
    @Autowired
    private AdTicketMapper adTicketMapper;
    @Autowired
    private DictionariesMapper dictionariesMapper;
    @Autowired
    private TblStationUserWeightService tblStationUserWeightService;
    private static final ThreadPoolExecutor PUSH_POOL = new ThreadPoolExecutor(4, 4, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("ticket-data-push"));

    public void destroy() throws Exception {
        PUSH_POOL.shutdown();
        if (!PUSH_POOL.awaitTermination(2L, TimeUnit.MINUTES)) {
            LOGGER.error("await termination fail!");
        } else {
            LOGGER.info("Shutdown OK!");
        }
    }

    @Override
    public void add(AdFlowPackageDto adTicketPopupDto, String userName) throws Exception {
        AdFlowPackage adFlowPackage = new AdFlowPackage();
        adFlowPackage.setCount(adTicketPopupDto.getCount());
        adFlowPackage.setCreateTime(new Date());
        adFlowPackage.setCreateUser(userName);
        adFlowPackage.setPackageName(adTicketPopupDto.getPackageName());
        adFlowPackage.setIsShare(adTicketPopupDto.getIsShare());
        if (StringUtils.isNotBlank((CharSequence)adTicketPopupDto.getPositionId()) && !adTicketPopupDto.getPositionId().endsWith(",")) {
            adTicketPopupDto.setPositionId(adTicketPopupDto.getPositionId() + ",");
        }
        adFlowPackage.setPositionId(adTicketPopupDto.getPositionId());
        adFlowPackage.setState(adTicketPopupDto.getState());
        adFlowPackage.setRemark(adTicketPopupDto.getRemark());
        this.adFlowPackageMapper.insert(adFlowPackage);
    }

    @Override
    public Pagination findAll(AdFlowPackageSearchDto adFlowPackageSearchDto, User user) throws Exception {
        PageInfo adFlowPackagePageInfo;
        List adFlowPackages;
        Pagination pagination = new Pagination();
        String mediaOrPosition = adFlowPackageSearchDto.getMediaOrPosition();
        HashMap map = Maps.newHashMap();
        map.put("createUser", adFlowPackageSearchDto.getCreateUser());
        map.put("flowPackageName", adFlowPackageSearchDto.getFlowPackageName());
        map.put("state", adFlowPackageSearchDto.getState());
        map.put("type", adFlowPackageSearchDto.getType());
        map.put("isShare", adFlowPackageSearchDto.getIsShare());
        if (StringUtils.isNotBlank((CharSequence)mediaOrPosition)) {
            if (mediaOrPosition.contains("-")) {
                map.put("mediaOrPosition", mediaOrPosition + ",");
            } else {
                map.put("mediaOrPosition", mediaOrPosition + "-");
            }
        }
        if (StringUtils.isEmpty((CharSequence)adFlowPackageSearchDto.getType()) && (StringUtils.isNotEmpty((CharSequence)UserRoleCodeUtil.isAe(user)) || StringUtils.isNotEmpty((CharSequence)UserRoleCodeUtil.isSale(user)))) {
            map.put("isShare", 1);
            if (StringUtils.isEmpty((CharSequence)adFlowPackageSearchDto.getCreateUser())) {
                map.put("createUser", user.getUsername());
                if (StringUtils.isNotEmpty((CharSequence)adFlowPackageSearchDto.getState())) {
                    map.remove("createUser");
                }
                if (StringUtils.isNotEmpty((CharSequence)adFlowPackageSearchDto.getFlowPackageName())) {
                    map.remove("createUser");
                }
            }
            if (StringUtils.isEmpty((CharSequence)adFlowPackageSearchDto.getFlowPackageName()) && StringUtils.isEmpty((CharSequence)adFlowPackageSearchDto.getState()) && StringUtils.isEmpty((CharSequence)adFlowPackageSearchDto.getCreateUser())) {
                map.remove("isShare");
                map.put("isShareAcl", 1);
            }
            if (StringUtils.isNotEmpty((CharSequence)adFlowPackageSearchDto.getCreateUser())) {
                map.remove("isShare");
                map.remove("isShareAcl");
                if (!adFlowPackageSearchDto.getCreateUser().equals(user.getUsername())) {
                    map.put("isShare", 1);
                }
            }
        }
        if (CollectionUtils.isEmpty((Collection)(adFlowPackages = (adFlowPackagePageInfo = PageHelper.startPage((int)adFlowPackageSearchDto.getPageNum(), (int)adFlowPackageSearchDto.getPageSize()).doSelectPageInfo(() -> this.adFlowPackageMapper.getListByMap(map))).getList()))) {
            pagination.setList(Collections.emptyList());
            return pagination;
        }
        ArrayList voList = Lists.newArrayListWithCapacity((int)adFlowPackages.size());
        List userList = this.dictionariesMapper.find();
        if (CollectionUtils.isNotEmpty((Collection)userList)) {
            Map userMap = userList.stream().collect(HashMap::new, (k, v) -> k.put(v.getTypecode(), v.getTypename()), HashMap::putAll);
            for (AdFlowPackage adFlowPackage : adFlowPackagePageInfo.getList()) {
                AdFlowPackageVo adFlowPackageVo = new AdFlowPackageVo();
                String code = adFlowPackage.getCreateUser();
                adFlowPackage.setCreateUser((String)userMap.get(code));
                BeanUtils.copyProperties((Object)adFlowPackage, (Object)adFlowPackageVo);
                adFlowPackageVo.setUserName(code);
                voList.add(adFlowPackageVo);
            }
        }
        pagination.setList((List)voList);
        pagination.setPageSize(adFlowPackageSearchDto.getPageSize());
        pagination.setPageNo(adFlowPackageSearchDto.getPageNum());
        pagination.setTotalCount((int)adFlowPackagePageInfo.getTotal());
        return pagination;
    }

    @Override
    public AdFlowPackageVo findById(String flowPackageId, String ticketId, String type) throws Exception {
        if (StringUtil.isBlank((CharSequence)flowPackageId)) {
            throw new Exception("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AdFlowPackage adFlowPackage = this.adFlowPackageMapper.findById(flowPackageId);
        AdFlowPackageVo vo = new AdFlowPackageVo();
        BeanUtils.copyProperties((Object)adFlowPackage, (Object)vo);
        if (StringUtils.isNotBlank((CharSequence)ticketId) && StringUtils.isNumeric((CharSequence)ticketId)) {
            long consume = this.prodPositonGroupIntegration.getBudgetOfToday(BigInteger.valueOf(Long.parseLong(ticketId)), flowPackageId);
            if (StringUtil.equals((String)"cpc", (String)type)) {
                vo.setConsume(Double.parseDouble(consume + "") / 1000.0 + "");
            } else {
                vo.setConsume(consume + "");
            }
        }
        return vo;
    }

    @Override
    public Pagination findAdPositionByFlowPackageId(AdFlowPackageSearchDto adFlowPackageSearchDto) throws Exception {
        if (StringUtil.isBlank((CharSequence)(adFlowPackageSearchDto.getId() + ""))) {
            throw new Exception("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AdFlowPackage AdFlowPackage2 = this.adFlowPackageMapper.findById(adFlowPackageSearchDto.getId() + "");
        String positonIds = AdFlowPackage2.getPositionId();
        String[] positonId = positonIds.split(",");
        Integer pageStart = adFlowPackageSearchDto.getPageStart();
        Integer pageSize = adFlowPackageSearchDto.getPageSize();
        StringBuilder sb = new StringBuilder("");
        for (int i = pageStart.intValue(); i < pageStart + pageSize && i < positonId.length; ++i) {
            sb.append(positonId[i]).append(",");
        }
        List<ProvideAppDto> prolist = this.adPositionServiceImpl.findAllByPositionId(sb.toString());
        Pagination pagination = new Pagination();
        pagination.setList(prolist);
        pagination.setPageSize(adFlowPackageSearchDto.getPageSize());
        pagination.setPageNo(adFlowPackageSearchDto.getPageNum());
        pagination.setTotalCount(positonId.length);
        return pagination;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=120)
    public void update(AdFlowPackageDto adFlowPackageDto, String userName) throws Exception {
        if (StringUtil.isBlank((CharSequence)(adFlowPackageDto.getId() + ""))) {
            throw new ValidateException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AdFlowPackage oldAdFlowPackage = this.adFlowPackageMapper.findById(adFlowPackageDto.getId().toString());
        if (null == oldAdFlowPackage) {
            throw new ValidateException("\u6b64\u6d41\u91cf\u5305\u4e0d\u5b58\u5728");
        }
        if (oldAdFlowPackage.getIsShare().equals(OFF) && !oldAdFlowPackage.getCreateUser().equals(userName)) {
            throw new ValidateException("\u6ca1\u6709\u4fee\u6539\u8be5\u6d41\u91cf\u5305\u6743\u9650");
        }
        if (StringUtils.isNotBlank((CharSequence)adFlowPackageDto.getPositionId()) && !adFlowPackageDto.getPositionId().endsWith(",")) {
            adFlowPackageDto.setPositionId(adFlowPackageDto.getPositionId() + ",");
        }
        String[] oldAdFlowPackages = oldAdFlowPackage.getPositionId().split(",");
        String newPositionId = adFlowPackageDto.getPositionId();
        String[] newPositionIds = newPositionId.split(",");
        if (oldAdFlowPackages.length > 200 && (double)newPositionIds.length / (double)oldAdFlowPackages.length < 0.5) {
            throw new ValidateException("\u4fee\u6539\u7684\u6d41\u91cf\u5305\u6bd4\u539f\u6765\u7684\u6570\u91cf\u5c11\u4e00\u534a\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("flowPackageId", adFlowPackageDto.getId() + "");
        List adTicketFlowPackageConfList = this.adTicketFlowPackageMapper.getListByparam(map);
        adFlowPackageDto.setModifyUser(userName);
        adFlowPackageDto.setModifyTime(new Date());
        this.adFlowPackageMapper.update(adFlowPackageDto);
        this.refreshWeightCacheWhenFlowPackageUpdate(oldAdFlowPackages, newPositionIds, adFlowPackageDto.getId().longValue(), userName);
        HashSet adIds = Sets.newHashSet();
        String ticketPositionId = "";
        for (AdTicketFlowPackageConf adTicketFlowPackageConf : adTicketFlowPackageConfList) {
            if (adTicketFlowPackageConf.getType() == 2) continue;
            StringBuilder sb = new StringBuilder();
            HashMap<String, String> mapticketPositionId = new HashMap<String, String>();
            Long ticketId = adTicketFlowPackageConf.getTicketId();
            ticketPositionId = this.adRulesServiceImpl.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.GUANGGAOWEI.getValue(), ticketId);
            if (StringUtils.isNotBlank((CharSequence)ticketPositionId)) {
                String[] positionIds;
                String blackWhite = ticketPositionId.substring(0, 1);
                sb.append(blackWhite).append("-");
                String allticketPositionId = ticketPositionId.substring(2, ticketPositionId.length());
                for (String positionId : positionIds = allticketPositionId.split(",")) {
                    mapticketPositionId.put(positionId, positionId);
                }
            }
            for (String oldAdFlowPackage1 : oldAdFlowPackages) {
                mapticketPositionId.remove(oldAdFlowPackage1);
            }
            for (String newPositionId1 : newPositionIds) {
                mapticketPositionId.put(newPositionId1, newPositionId1);
            }
            for (String v : mapticketPositionId.values()) {
                sb.append(v).append(",");
            }
            AdTicket adTicket = new AdTicket();
            adTicket.setId(ticketId);
            adTicket.setModifyUser(userName);
            adTicket.setModifyTime(new Date());
            this.adTicketMapper.updateByPrimaryKeySelective(adTicket);
            this.adRulesMapper.deleteByAdTicketAndType(Integer.valueOf(RuleTypeEnum.GUANGGAOWEI.getValue()), ticketId);
            this.adRulesServiceImpl.add(sb.toString(), ticketId, RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.GUANGGAOWEI.getValue());
            adIds.add(ticketId);
        }
        adIds.forEach(id -> PUSH_POOL.execute(() -> {
            try {
                this.prodService.pushAdTicketToProdPre((Long)id);
            }
            catch (Exception e) {
                LOGGER.error(id + " - push fail!", (Throwable)e);
            }
        }));
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public void updateStatus(AdFlowPackageDto adFlowPackageDto, String userName) throws Exception {
        if (StringUtil.isBlank((CharSequence)(adFlowPackageDto.getId() + ""))) {
            throw new Exception("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        adFlowPackageDto.setModifyUser(userName);
        adFlowPackageDto.setModifyTime(new Date());
        this.adFlowPackageMapper.update(adFlowPackageDto);
    }

    @Override
    public List<String> findAllPackageName() throws Exception {
        return this.adFlowPackageMapper.findAllPackageName();
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public void delete(String id, String userName) throws Exception {
        if (StringUtil.isBlank((CharSequence)id)) {
            throw new Exception("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AdFlowPackage oldAdFlowPackage = this.adFlowPackageMapper.findById(id);
        if (oldAdFlowPackage.getIsShare().equals(OFF) && !oldAdFlowPackage.getCreateUser().equals(userName)) {
            throw new Exception("\u6ca1\u6709\u4fee\u6539\u8be5\u6d41\u91cf\u5305\u6743\u9650");
        }
        Integer count = this.adTicketFlowPackageMapper.getCountByparam(id);
        if (count > 0) {
            throw new Exception("\u8be5\u6d41\u91cf\u5305\u5df2\u7ecf\u5173\u8054\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        Long adFlowPackageId = Long.valueOf(id);
        String positionIdsStr = oldAdFlowPackage.getPositionId();
        this.adFlowPackageMapper.delete(adFlowPackageId);
        try {
            HashSet currentPositionIdSet = Sets.newHashSet((Iterable)Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)positionIdsStr));
            this.tblStationUserWeightService.refreshWeightCacheWhenFlowPackageDelete(adFlowPackageId, currentPositionIdSet, userName);
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u6d41\u91cf\u5305\uff0c\u8c03\u7528\u7ad9\u5185\u80e1\u8ba1\u5212\u5237\u65b0\u5e7f\u544a\u4f4d\u7f13\u5b58\u5931\u8d25\uff01", (Throwable)e);
            DingtalkMsgUtil.sendMsg("https://oapi.dingtalk.com/robot/send?access_token=ef60c4cae6387ad2106d070803d6ca3ecb44de5ffec02b167f730c55ea6bbff3", "\u7f16\u8f91\u6d41\u91cf\u5305\uff0c\u8c03\u7528\u7ad9\u5185\u80e1\u8ba1\u5212\u5237\u65b0\u5e7f\u544a\u4f4d\u7f13\u5b58\u5931\u8d25\uff01", false, Collections.emptyList());
        }
    }

    @Override
    public String findPositionIdsById(String ids) throws Exception {
        if (StringUtil.isBlank((CharSequence)ids)) {
            throw new Exception("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] idsString = ids.split(",");
        ArrayList<String> list = new ArrayList<String>();
        for (String id : idsString) {
            list.add(id);
        }
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        map.put("list", list);
        List afplist = this.adFlowPackageMapper.findPositionIdsById(map);
        StringBuffer sb = new StringBuffer("");
        for (AdFlowPackage adFlowPackage : afplist) {
            sb.append(adFlowPackage.getPositionId() + ",");
        }
        return sb.toString().substring(0, sb.toString().length() - 1);
    }

    @Override
    public Set<String> findPositionIdsByPackageIds(String ids) throws Exception {
        String[] idsString = ids.split(",");
        ArrayList<String> list = new ArrayList<String>();
        for (String id : idsString) {
            list.add(id);
        }
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        map.put("list", list);
        List afplist = this.adFlowPackageMapper.findPositionIdsById(map);
        HashSet<String> set = new HashSet<String>();
        for (AdFlowPackage adFlowPackage : afplist) {
            if (!StringUtils.isNotBlank((CharSequence)adFlowPackage.getPositionId())) continue;
            for (String position : adFlowPackage.getPositionId().split(",")) {
                set.add(position);
            }
        }
        return set;
    }

    private void refreshWeightCacheWhenFlowPackageUpdate(String[] currentPositionIds, String[] newPositionIds, Long adFlowPackageId, String operationUserName) {
        try {
            HashSet currentPositionIdSet = Sets.newHashSet((Object[])currentPositionIds);
            HashSet newPositionIdSet = Sets.newHashSet((Object[])newPositionIds);
            HashSet removePositionIdSet = Sets.newHashSet();
            for (String s : currentPositionIdSet) {
                if (newPositionIdSet.contains(s)) continue;
                removePositionIdSet.add(s);
            }
            HashSet addPositionIdSet = Sets.newHashSet();
            for (String s : newPositionIdSet) {
                if (currentPositionIdSet.contains(s)) continue;
                addPositionIdSet.add(s);
            }
            this.tblStationUserWeightService.refreshWeightCacheWhenFlowPackageUpdate(adFlowPackageId, removePositionIdSet, addPositionIdSet, operationUserName);
        }
        catch (Exception e) {
            LOGGER.error("\u7f16\u8f91\u6d41\u91cf\u5305\uff0c\u8c03\u7528\u7ad9\u5185\u80e1\u8ba1\u5212\u5237\u65b0\u5e7f\u544a\u4f4d\u7f13\u5b58\u5931\u8d25\uff01", (Throwable)e);
            DingtalkMsgUtil.sendMsg("https://oapi.dingtalk.com/robot/send?access_token=ef60c4cae6387ad2106d070803d6ca3ecb44de5ffec02b167f730c55ea6bbff3", "\u7f16\u8f91\u6d41\u91cf\u5305\uff0c\u8c03\u7528\u7ad9\u5185\u80e1\u8ba1\u5212\u5237\u65b0\u5e7f\u544a\u4f4d\u7f13\u5b58\u5931\u8d25\uff01", false, Collections.emptyList());
        }
    }

    @Override
    public Date getMaxModifyTimeByIds(List<Long> packageIds) {
        return this.adFlowPackageMapper.getMaxModifyTimeByIds(packageIds);
    }
}

