/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adkeeper.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdAppIdPackageMapperExt;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdAppIdPackage;
import com.bxm.adsmanager.model.dto.AdAppIdPackageDTO;
import com.bxm.adsmanager.model.dto.AdAppIdPackageSearchDTO;
import com.bxm.adsmanager.model.enums.ProdServiceNameEnum;
import com.bxm.adsmanager.model.vo.AdAppIdPackageListVO;
import com.bxm.adsmanager.service.adkeeper.AdAppIdPackageService;
import com.bxm.adsmanager.service.prod.ProdService;
import com.bxm.adsprod.facade.ticket.AppIdPackage;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdAppIdPackageServiceImpl
implements AdAppIdPackageService {
    private static final Logger log = LoggerFactory.getLogger(AdAppIdPackageServiceImpl.class);
    @Autowired
    private AdAppIdPackageMapperExt adAppIdPackageMapperExt;
    @Autowired
    private ProdService prodService;
    @Autowired
    private ProdPusherIntegration prodPusherIntegration;

    @Override
    public PageInfo<AdAppIdPackageListVO> findPage(AdAppIdPackageSearchDTO searchDTO) {
        PageHelper.startPage((int)searchDTO.getPageNum(), (int)searchDTO.getPageSize());
        return new PageInfo(this.adAppIdPackageMapperExt.findList(searchDTO));
    }

    @Override
    public void add(AdAppIdPackageDTO dto) {
        AdAppIdPackage adAppIdPackage = new AdAppIdPackage();
        BeanUtils.copyProperties((Object)dto, (Object)adAppIdPackage);
        adAppIdPackage.setId(null);
        this.adAppIdPackageMapperExt.insertSelective(adAppIdPackage);
        try {
            this.pushAppIdPackage(adAppIdPackage);
        }
        catch (Exception e) {
            log.error("adsprod exception!", (Throwable)e);
        }
    }

    public void pushAppIdPackage(AdAppIdPackage entity) throws Exception {
        if (entity != null) {
            AppIdPackage data = new AppIdPackage();
            BeanUtils.copyProperties((Object)entity, (Object)data);
            this.prodPusherIntegration.pushToProd(ProdServiceNameEnum.APP_ID_PACKAGE.getServiceName(), null, JSONArray.toJSONBytes((Object)data, (SerializerFeature[])new SerializerFeature[0]));
        }
    }

    @Override
    public void update(AdAppIdPackageDTO dto) {
        AdAppIdPackage appIdPackage = this.adAppIdPackageMapperExt.selectByPrimaryKey(dto.getId());
        if (appIdPackage == null) {
            throw new BusinessException("\u6570\u636e\u672a\u627e\u5230");
        }
        appIdPackage.setName(dto.getName());
        appIdPackage.setAppIds(dto.getAppIds());
        this.adAppIdPackageMapperExt.updateByPrimaryKeySelective(appIdPackage);
        try {
            this.pushAppIdPackage(appIdPackage);
        }
        catch (Exception e) {
            log.error("adsprod exception!", (Throwable)e);
        }
    }
}

