/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adkeeper.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdAssetsTemplateContentMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdAssetsTemplateAssetsMapperExt;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdAssetsTemplateMapperExt;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTemplate;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTemplateContent;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTemplateContentExample;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTemplateExample;
import com.bxm.adsmanager.model.dto.AdAssetsTemplateAssetsTicketAssetsNumDTO;
import com.bxm.adsmanager.model.dto.AdAssetsTemplateDTO;
import com.bxm.adsmanager.model.dto.AdAssetsTemplateSearchDTO;
import com.bxm.adsmanager.model.enums.ProdServiceNameEnum;
import com.bxm.adsmanager.model.enums.RuleTargetEnum;
import com.bxm.adsmanager.model.enums.RuleTypeEnum;
import com.bxm.adsmanager.model.vo.AdAssetsTemplateTicketListVO;
import com.bxm.adsmanager.model.vo.AdAssetsTemplateVO;
import com.bxm.adsmanager.service.adkeeper.AdAssetsTemplateService;
import com.bxm.adsmanager.service.adkeeper.AdRulesService;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAssetsTemplateIdAndNumVo;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceParamDTO;
import com.bxm.adsprod.facade.ticket.AssetsTemplate;
import com.bxm.adsprod.facade.ticket.AssetsTemplateContent;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdAssetsTemplateServiceImpl
implements AdAssetsTemplateService {
    private static final Logger log = LoggerFactory.getLogger(AdAssetsTemplateServiceImpl.class);
    @Autowired
    private AdAssetsTemplateMapperExt adAssetsTemplateMapperExt;
    @Autowired
    private AdAssetsTemplateContentMapper adAssetsTemplateContentMapper;
    @Autowired
    private AdAssetsTemplateAssetsMapperExt adAssetsTemplateAssetsMapperExt;
    @Autowired
    private ProdPusherIntegration prodPusherIntegration;
    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;
    @Autowired
    private AdRulesService adRulesService;

    @Override
    public PageInfo<AdAssetsTemplate> findPage(AdAssetsTemplateSearchDTO searchDTO) {
        PageHelper.startPage((int)searchDTO.getPageNum(), (int)searchDTO.getPageSize());
        return new PageInfo(this.adAssetsTemplateMapperExt.findList(searchDTO));
    }

    @Override
    public List<AdAssetsTemplateTicketListVO> findAllByTicketPositionAssociations(Long ticketId) {
        List<String> assetsTemplateIdList;
        List templateAssetsNum;
        String result = this.adRulesService.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.GUANGGAOWEI.getValue(), ticketId);
        if (StringUtils.isBlank((CharSequence)result) || !result.startsWith("1")) {
            return Collections.emptyList();
        }
        String positionIdsStr = result.substring(2);
        ArrayList positionIdList = Lists.newArrayList((Iterable)Splitter.on((String)",").splitToList((CharSequence)positionIdsStr));
        QueryAppEntranceParamDTO queryAppEntranceParamDTO = new QueryAppEntranceParamDTO();
        queryAppEntranceParamDTO.setPositionIds((List)positionIdList);
        List appEntranceAdROList = this.newAppEntranceFacadeIntegration.getAllList(queryAppEntranceParamDTO);
        if (CollectionUtils.isEmpty((Collection)appEntranceAdROList)) {
            return Collections.emptyList();
        }
        String assetsTemplateIds = appEntranceAdROList.stream().filter(p -> StringUtils.isNotBlank((CharSequence)p.getAssetsTemplateId())).map(AppEntranceAdRO::getAssetsTemplateId).collect(Collectors.joining(","));
        if (StringUtils.isBlank((CharSequence)assetsTemplateIds)) {
            return Collections.emptyList();
        }
        AdAssetsTemplateSearchDTO searchDTO = new AdAssetsTemplateSearchDTO();
        searchDTO.setAssetsTemplateIds(assetsTemplateIds);
        List adAssetsTemplateTicketList = this.adAssetsTemplateMapperExt.findListByTemplateIds(searchDTO);
        if (CollectionUtils.isNotEmpty((Collection)adAssetsTemplateTicketList) && CollectionUtils.isNotEmpty((Collection)(templateAssetsNum = this.adAssetsTemplateAssetsMapperExt.findTemplateAssetsNum(ticketId, assetsTemplateIdList = Arrays.asList(assetsTemplateIds.split(",")))))) {
            HashMap<Long, Long> templateAssetsNumMap = new HashMap<Long, Long>(templateAssetsNum.size());
            for (AdAssetsTemplateAssetsTicketAssetsNumDTO dto : templateAssetsNum) {
                if (dto.getTemplateId() == null) continue;
                templateAssetsNumMap.put(dto.getTemplateId(), dto.getAssetsNum());
            }
            for (AdAssetsTemplateTicketListVO vo : adAssetsTemplateTicketList) {
                vo.setAssetsNum(templateAssetsNumMap.getOrDefault(vo.getId(), 0L));
            }
        }
        return adAssetsTemplateTicketList;
    }

    @Override
    public List<AppEntranceAdRO> findAssociationsPositionList(Long id) {
        QueryAppEntranceParamDTO paramDTO = new QueryAppEntranceParamDTO();
        paramDTO.setAssetsTemplateId(id);
        paramDTO.setPageNum(Integer.valueOf(1));
        paramDTO.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        PageInfo page = this.newAppEntranceFacadeIntegration.getPage(paramDTO);
        List list = page.getList();
        return list;
    }

    @Override
    public AdAssetsTemplateVO get(Long id) {
        AdAssetsTemplate adAssetsTemplate = this.adAssetsTemplateMapperExt.selectByPrimaryKey(id);
        if (adAssetsTemplate == null) {
            throw new BusinessException("\u6a21\u7248\u4e0d\u5b58\u5728\uff01");
        }
        AdAssetsTemplateVO adAssetsTemplateVo = new AdAssetsTemplateVO();
        BeanUtils.copyProperties((Object)adAssetsTemplate, (Object)adAssetsTemplateVo);
        AdAssetsTemplateContentExample example = new AdAssetsTemplateContentExample();
        example.createCriteria().andTemplateIdEqualTo(id);
        List adAssetsTemplates = this.adAssetsTemplateContentMapper.selectByExample(example);
        adAssetsTemplateVo.setAdAssetsTemplateContents(adAssetsTemplates);
        return adAssetsTemplateVo;
    }

    @Override
    public Long add(AdAssetsTemplateDTO dto) {
        AdAssetsTemplateExample example = new AdAssetsTemplateExample();
        example.createCriteria().andNameEqualTo(dto.getName());
        List adAssetsTemplates = this.adAssetsTemplateMapperExt.selectByExample(example);
        if (CollectionUtils.isNotEmpty((Collection)adAssetsTemplates)) {
            throw new BusinessException("\u8be5\u6a21\u7248\u5df2\u5b58\u5728\uff01");
        }
        AdAssetsTemplate adAssetsTemplate = new AdAssetsTemplate();
        BeanUtils.copyProperties((Object)dto, (Object)adAssetsTemplate);
        adAssetsTemplate.setCreateTime(new Date());
        adAssetsTemplate.setStatus(Short.valueOf((short)1));
        this.adAssetsTemplateMapperExt.insertSelective(adAssetsTemplate);
        for (AdAssetsTemplateContent adAssetsTemplateContent : dto.getAdAssetsTemplateContents()) {
            adAssetsTemplateContent.setTemplateId(adAssetsTemplate.getId());
            this.adAssetsTemplateContentMapper.insert(adAssetsTemplateContent);
        }
        try {
            this.pushAssetsTemplate(adAssetsTemplate.getId());
        }
        catch (Exception e) {
            log.error("adsprod exception!", (Throwable)e);
        }
        return adAssetsTemplate.getId();
    }

    public void pushAssetsTemplate(Long id) throws Exception {
        AdAssetsTemplateVO adAssetsTemplateVo = this.get(id);
        if (adAssetsTemplateVo != null) {
            AssetsTemplate data = new AssetsTemplate();
            ArrayList<AssetsTemplateContent> assetsTemplateContents = new ArrayList<AssetsTemplateContent>();
            BeanUtils.copyProperties((Object)adAssetsTemplateVo, (Object)data);
            for (AdAssetsTemplateContent adAssetsTemplateContent : adAssetsTemplateVo.getAdAssetsTemplateContents()) {
                AssetsTemplateContent content = new AssetsTemplateContent();
                BeanUtils.copyProperties((Object)adAssetsTemplateContent, (Object)content);
                assetsTemplateContents.add(content);
            }
            data.setAdAssetsTemplateContents(assetsTemplateContents);
            this.prodPusherIntegration.pushToProd(ProdServiceNameEnum.ASSETS_TEMPLATE.getServiceName(), null, JSONArray.toJSONBytes((Object)data, (SerializerFeature[])new SerializerFeature[0]));
        }
    }

    @Override
    public void updateStatus(Long id, Short status, String username) throws Exception {
        AdAssetsTemplate adAssets = this.adAssetsTemplateMapperExt.selectByPrimaryKey(id);
        if (adAssets == null) {
            throw new BusinessException("\u6570\u636e\u672a\u627e\u5230");
        }
        if (adAssets.getStatus().equals(status)) {
            return;
        }
        if (adAssets.getStatus() == 1 && status == 0 && adAssets.getAssociationsNum() > 0) {
            throw new BusinessException("\u8be5\u7d20\u6750\u6a21\u677f\u5df2\u6709\u5e7f\u544a\u4f4d\u5173\u8054\uff0c\u8bf7\u5148\u53d6\u6d88\u5e7f\u544a\u4f4d\u5173\u8054\u3002");
        }
        AdAssetsTemplate adAssetsUpdate = new AdAssetsTemplate();
        adAssetsUpdate.setId(id);
        adAssetsUpdate.setStatus(Short.valueOf(status));
        adAssetsUpdate.setModifyUser(username);
        adAssetsUpdate.setModifyTime(new Date());
        this.adAssetsTemplateMapperExt.updateByPrimaryKeySelective(adAssetsUpdate);
        try {
            this.pushAssetsTemplate(adAssetsUpdate.getId());
        }
        catch (Exception e) {
            log.error("adsprod exception!", (Throwable)e);
        }
    }

    @Override
    public void updateAssetsTemplateAssociationsPositionNum() {
        String idsStr;
        List positionNumByTemplateId;
        AdAssetsTemplateSearchDTO adAssetsTemplateSearchDto = new AdAssetsTemplateSearchDTO();
        adAssetsTemplateSearchDto.setStatus(Short.valueOf((short)1));
        adAssetsTemplateSearchDto.setPageNum(Integer.valueOf(1));
        adAssetsTemplateSearchDto.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        PageInfo<AdAssetsTemplate> pageInfo = this.findPage(adAssetsTemplateSearchDto);
        Set assetsTemplateIdSet = pageInfo.getList().stream().map(AdAssetsTemplate::getId).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(assetsTemplateIdSet) && CollectionUtils.isNotEmpty((Collection)(positionNumByTemplateId = this.newAppEntranceFacadeIntegration.getPositionNumByTemplateId(idsStr = Joiner.on((String)",").skipNulls().join(assetsTemplateIdSet))))) {
            for (AppEntranceAssetsTemplateIdAndNumVo idAndNumVo : positionNumByTemplateId) {
                AdAssetsTemplate example = new AdAssetsTemplate();
                example.setId(idAndNumVo.getAssetsTemplateId());
                example.setAssociationsNum(Integer.valueOf(idAndNumVo.getNum().intValue()));
                this.adAssetsTemplateMapperExt.updateByPrimaryKeySelective(example);
            }
        }
    }

    @Override
    public void delete(Long id) throws Exception {
        AdAssetsTemplate adAssets = this.adAssetsTemplateMapperExt.selectByPrimaryKey(id);
        if (adAssets == null) {
            throw new BusinessException("\u6570\u636e\u672a\u627e\u5230");
        }
        if (adAssets.getStatus() != 0) {
            throw new BusinessException("\u7d20\u6750\u6a21\u7248\u4e3a\u5173\u95ed\u7684\u60c5\u51b5\u4e0b\u624d\u5141\u8bb8\u5c06\u6a21\u7248\u5220\u9664");
        }
        this.adAssetsTemplateMapperExt.deleteByPrimaryKey(id);
    }
}

