/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adkeeper.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.configures.AdticketCostConfiguration;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketCostLogMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketTagConfMapper;
import com.bxm.adsmanager.dal.mapper.cost.AdTicketCostMapper;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssets;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketCostLog;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketTagConfDO;
import com.bxm.adsmanager.model.dao.cost.AdTicketCost;
import com.bxm.adsmanager.model.dao.tbltag.TblAdPostionTag;
import com.bxm.adsmanager.model.dto.AdTicketSearchDto;
import com.bxm.adsmanager.model.dto.TicketCosWarnDto;
import com.bxm.adsmanager.model.dto.TicketCostWarnName;
import com.bxm.adsmanager.model.dto.TicketCostWarnTag;
import com.bxm.adsmanager.model.vo.AdTicketCostLogVo;
import com.bxm.adsmanager.model.vo.PaginationTemp;
import com.bxm.adsmanager.model.vo.TicketInfoVo;
import com.bxm.adsmanager.redis.RedisClient;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsService;
import com.bxm.adsmanager.service.adkeeper.AdTicketCostService;
import com.bxm.adsmanager.service.adkeeper.AdTicketTagConfService;
import com.bxm.adsmanager.service.adkeeper.impl.AdTicketServiceImpl;
import com.bxm.adsmanager.service.outside.AdticketOutsideService;
import com.bxm.adsmanager.service.tbltag.TblAdTagService;
import com.bxm.adsmanager.utils.DingtalkMsgUtil;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.utils.KeyBuilder;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AdTicketCostServiceImpl
implements AdTicketCostService {
    private static final Logger log = LoggerFactory.getLogger(AdTicketCostServiceImpl.class);
    private static final int TWO = 2;
    private static final String STR_TWO = "2-";
    private static final String DIRECTURL = "https://i.iwanbei.cn/activities?appKey=%s&appEntrance=%s&business=money&supportPc=1";
    @Autowired
    JedisUpdater jedisUpdater;
    @Autowired
    JedisFetcher jedisFetcher;
    @Autowired
    RedisClient redisClient;
    @Value(value="${ticket.cost.warn.dingding.token}")
    private String token;
    @Autowired
    private AdTicketServiceImpl adTicketService;
    @Autowired
    private AdTicketTagConfService adTicketTagConfService;
    @Autowired
    AdTicketAssetsService adTicketAssetsService;
    @Autowired
    private AdTicketCostLogMapper adTicketCostLogMapper;
    @Autowired
    private AdTicketMapper adTicketMapper;
    @Autowired
    AdTicketTagConfMapper adTicketTagConfMapper;
    @Autowired
    private AdticketOutsideService adticketOutsideService;
    @Autowired
    private TblAdTagService tblAdTagService;
    @Autowired
    private AdticketCostConfiguration adticketCostConfiguration;
    @Autowired
    private AdTicketCostMapper adTicketCostMapper;

    @Override
    public PaginationTemp<AdTicketCostLogVo> findAll(AdTicketSearchDto condition, String costIds) throws Exception {
        String code;
        List list;
        ArrayList<Long> longList;
        PaginationTemp result = new PaginationTemp();
        result.setPageSize(condition.getPageSize());
        result.setPageNo(condition.getPageNum());
        result.setList(new ArrayList());
        if (condition == null) {
            return result;
        }
        String ae = condition.getAe();
        condition.setAe(null);
        List<AdvertiserDto> advertiserDtoList = this.adTicketService.getAllAdvertiser(condition);
        if (advertiserDtoList != null && advertiserDtoList.size() > 0) {
            longList = new ArrayList<Long>(advertiserDtoList.size());
            for (AdvertiserDto ad : advertiserDtoList) {
                longList.add(ad.getId().longValue());
            }
        } else {
            return result;
        }
        condition.setList(longList);
        condition.setAe(ae);
        if (StringUtils.isNotBlank((CharSequence)condition.getTagCodes())) {
            List<Long> ticketIds = this.adTicketTagConfService.findTicketIdsByCode(condition.getTagCodes() + "");
            if (CollectionUtils.isEmpty(ticketIds)) {
                return result;
            }
            list = condition.getTicketIds();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                ticketIds.retainAll(list);
            }
            if (CollectionUtils.isEmpty(ticketIds)) {
                ticketIds.add(-1L);
            }
            condition.setTicketIds(ticketIds);
        }
        if (StringUtil.isNotBlank((CharSequence)(code = condition.getStatusCode()))) {
            if (code.contains(STR_TWO)) {
                condition.setPauseReason(Integer.valueOf(Integer.parseInt(code.substring(2))));
            } else {
                condition.setStatus(Short.valueOf(code));
            }
        }
        list = Lists.newArrayList();
        if (!"[]".equals(costIds) && StringUtils.isNotBlank((CharSequence)costIds)) {
            list = JSON.parseArray((String)costIds, Long.class);
        }
        Integer total = this.adTicketCostLogMapper.totalcount(condition, list);
        List adTicketCostLogs = this.adTicketCostLogMapper.findAll(condition, list);
        if (CollectionUtils.isEmpty((Collection)adTicketCostLogs)) {
            return result;
        }
        Map<String, String> dictionariesMap = this.adTicketService.getDictionaries("adstatus");
        ArrayList ids = Lists.newArrayList();
        for (AdTicketCostLogVo adTicketCostLogVo : adTicketCostLogs) {
            ids.add(adTicketCostLogVo.getTicketId());
        }
        List tagConfDOList = this.adTicketTagConfMapper.findTicketBelongCodeName((List)ids, Integer.valueOf(2));
        Map<Object, Object> map = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)tagConfDOList)) {
            map = tagConfDOList.stream().collect(Collectors.toMap(AdTicketTagConfDO::getTicketId, AdTicketTagConfDO::getFullNameStr));
        }
        for (AdTicketCostLogVo adTicketCostLogVo : adTicketCostLogs) {
            if (adTicketCostLogVo.getPauseReason() != null && adTicketCostLogVo.getStatus() == 2) {
                adTicketCostLogVo.setTicketStatus(dictionariesMap.get(STR_TWO + adTicketCostLogVo.getPauseReason()));
            } else {
                adTicketCostLogVo.setTicketStatus(dictionariesMap.get(adTicketCostLogVo.getStatus() + ""));
            }
            adTicketCostLogVo.setOutsideUrl(adTicketCostLogVo.getOutsideUrl());
            String tag = (String)map.get(adTicketCostLogVo.getTicketId());
            String newTag = null;
            if (StringUtils.isNotBlank((CharSequence)tag)) {
                newTag = tag.replace('.', '/');
            }
            adTicketCostLogVo.setTag(newTag);
            String cosWarn = adTicketCostLogVo.getCosWarn();
            Double cost = adTicketCostLogVo.getCost();
            if (StringUtils.isNotBlank((CharSequence)cosWarn)) {
                Double cosWarnNew = Double.valueOf(cosWarn) / 1000.0;
                adTicketCostLogVo.setCosWarn(cosWarnNew + "");
            }
            if (cost != null) {
                Double costNeww = cost / 1000.0;
                adTicketCostLogVo.setCost(costNeww);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            adTicketCostLogVo.setTime(sdf.format(adTicketCostLogVo.getCreateTime()));
        }
        result.setPageSize(condition.getPageSize());
        result.setPageNo(condition.getPageNum());
        result.setList(adTicketCostLogs);
        result.setTotalCount(total.intValue());
        return result;
    }

    @Override
    public Boolean remove(Long id) {
        AdTicketCostLog adTicketCostLog = new AdTicketCostLog();
        adTicketCostLog.setDeleteTime(new Date());
        adTicketCostLog.setId(id);
        return 1 == this.adTicketCostLogMapper.updateByPrimaryKeySelective(adTicketCostLog);
    }

    @Override
    public void saveOrUpdate(TicketCosWarnDto ticketCosWarnDto) throws Exception {
        if (null == ticketCosWarnDto || StringUtils.isBlank((CharSequence)ticketCosWarnDto.getCosWarn()) || StringUtils.isBlank((CharSequence)ticketCosWarnDto.getTicketCosWarnIdAndTicketIds()) || "[]".equals(ticketCosWarnDto.getJson()) || StringUtils.isBlank((CharSequence)ticketCosWarnDto.getJson())) {
            throw new Exception("\u4e0d\u80fd\u4f20\u7a7a");
        }
        List<String> ticketCosWarnIdAndTicketIds = Arrays.asList(ticketCosWarnDto.getTicketCosWarnIdAndTicketIds().split(","));
        Double cosWarn = Double.valueOf(ticketCosWarnDto.getCosWarn()) * 1000.0;
        ArrayList<AdTicketCost> adTicketCostList = new ArrayList<AdTicketCost>();
        Boolean flag = true;
        ArrayList<Long> ticketIdsList = new ArrayList<Long>();
        for (String ticketCosWarnIdAndTicketId : ticketCosWarnIdAndTicketIds) {
            String[] ticketIdAndId = ticketCosWarnIdAndTicketId.split("-");
            AdTicketCost adTicketCost = new AdTicketCost();
            adTicketCost.setCosWarn(cosWarn.intValue() + "");
            adTicketCost.setJson(ticketCosWarnDto.getJson());
            adTicketCost.setUrl(ticketCosWarnDto.getUrl());
            adTicketCost.setTicketId(Long.valueOf(ticketIdAndId[0]));
            if (ticketIdAndId.length == 2) {
                adTicketCost.setId(Long.valueOf(ticketIdAndId[1]));
                adTicketCost.setUpdateTime(new Date());
                flag = false;
            } else {
                adTicketCost.setCreateTime(new Date());
            }
            ticketIdsList.add(Long.valueOf(ticketIdAndId[0]));
            adTicketCostList.add(adTicketCost);
        }
        if (flag.booleanValue()) {
            this.adTicketCostMapper.batchInsert(adTicketCostList);
        } else {
            this.adTicketCostMapper.batchUpdate(adTicketCostList);
        }
        List allAdTicketCostList = this.adTicketCostMapper.selectByParams(ticketIdsList, null);
        Map<Long, List<AdTicketCost>> map = this.getMap(allAdTicketCostList);
        for (Long ticketId : map.keySet()) {
            this.jedisUpdater.hupdate(this.getTicketCost(), ticketId.toString(), map.get(ticketId));
        }
    }

    private Map<Long, List<AdTicketCost>> getMap(List<AdTicketCost> allAdTicketCostList) {
        HashMap<Long, List<AdTicketCost>> map = new HashMap<Long, List<AdTicketCost>>();
        for (AdTicketCost adTicketCost : allAdTicketCostList) {
            ArrayList<AdTicketCost> list = (ArrayList<AdTicketCost>)map.get(adTicketCost.getTicketId());
            if (CollectionUtils.isEmpty((Collection)list)) {
                list = new ArrayList<AdTicketCost>();
                list.add(adTicketCost);
            } else {
                list.add(adTicketCost);
            }
            map.put(adTicketCost.getTicketId(), list);
        }
        return map;
    }

    @Override
    public Boolean delete(String id) {
        AdTicketCost adTicketCost = this.adTicketCostMapper.selectByPrimaryKey(Long.valueOf(id));
        this.adTicketCostMapper.deleteByPrimaryKey(Long.valueOf(id));
        List<Long> ticketIdsList = Arrays.asList(adTicketCost.getTicketId());
        List allAdTicketCostList = this.adTicketCostMapper.selectByParams(ticketIdsList, null);
        if (CollectionUtils.isEmpty((Collection)allAdTicketCostList)) {
            this.jedisUpdater.hremove(this.getTicketCost(), new String[]{adTicketCost.getTicketId().toString()});
        }
        Map<Long, List<AdTicketCost>> map = this.getMap(allAdTicketCostList);
        for (Long ticketId : map.keySet()) {
            this.jedisUpdater.hupdate(this.getTicketCost(), ticketId.toString(), map.get(ticketId));
        }
        return true;
    }

    @Override
    public void deleteByIds(List<Long> ids) {
        List deleteList = this.adTicketCostMapper.selectByParams(null, ids);
        if (CollectionUtils.isEmpty((Collection)deleteList)) {
            return;
        }
        this.adTicketCostMapper.deleteByIds(ids);
        ArrayList<Long> ticketIdsList = new ArrayList<Long>();
        for (AdTicketCost adTicketCost : deleteList) {
            ticketIdsList.add(adTicketCost.getTicketId());
        }
        List allAdTicketCostList = this.adTicketCostMapper.selectByParams(ticketIdsList, null);
        Map<Long, List<AdTicketCost>> map = this.getMap(allAdTicketCostList);
        for (Long ticketId : map.keySet()) {
            this.jedisUpdater.hupdate(this.getTicketCost(), ticketId.toString(), map.get(ticketId));
        }
        for (Long ticketId : ticketIdsList) {
            if (map.get(ticketId) != null) continue;
            this.jedisUpdater.hremove(this.getTicketCost(), new String[]{ticketId.toString()});
        }
    }

    @Override
    public PaginationTemp<TicketInfoVo> findTicket(AdTicketSearchDto condition, Integer mark, String json) {
        PaginationTemp result = new PaginationTemp();
        if (mark == null) {
            return result;
        }
        if (null != condition.getTagCode()) {
            List<Long> ticketIds = this.adTicketTagConfService.findTicketIds(condition.getTagCode());
            if (CollectionUtils.isNotEmpty(ticketIds)) {
                condition.setTicketIds(ticketIds);
            } else {
                return result;
            }
        }
        condition.setIsDeal("1");
        String code = condition.getStatusCode();
        if (StringUtil.isNotBlank((CharSequence)code)) {
            if (code.contains(STR_TWO)) {
                condition.setPauseReason(Integer.valueOf(Integer.parseInt(code.substring(2))));
            } else {
                condition.setStatus(Short.valueOf(code));
            }
        }
        if (mark == 1) {
            condition.setStatusList(null);
            if (CollectionUtils.isEmpty(this.getTickets())) {
                return result;
            }
            List list1 = condition.getTicketIds();
            List<Long> list2 = this.getTickets();
            ArrayList<Long> list3 = new ArrayList<Long>();
            if (CollectionUtils.isNotEmpty((Collection)list1)) {
                for (Long id : list1) {
                    if (!list2.contains(id)) continue;
                    list3.add(id);
                }
                if (CollectionUtils.isEmpty(list3)) {
                    return result;
                }
                condition.setTicketIds(list3);
            } else {
                condition.setTicketIds(list2);
            }
        } else if (mark == 3) {
            if (StringUtils.isNotBlank((CharSequence)json) && !"[]".equals(json)) {
                List jsonList = JSON.parseArray((String)json, Long.class);
                condition.setTicketIds(jsonList);
            }
        } else if (mark == 2) {
            condition.setSettleType(Short.valueOf((short)1));
        }
        List list = this.adTicketMapper.findAll(condition);
        Integer total = this.adTicketMapper.totalcount(condition);
        ArrayList ticketInfoVos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            Map<String, String> dictionariesMap = this.adTicketService.getDictionaries("adstatus");
            ArrayList ids = Lists.newArrayList();
            for (AdTicket adTicket : list) {
                ids.add(adTicket.getId());
            }
            Map<Long, String> map = this.getMapTag(ids);
            for (AdTicket ad : list) {
                TicketInfoVo ticketInfoVo = new TicketInfoVo();
                BeanUtils.copyProperties((Object)ad, (Object)ticketInfoVo);
                if (ad.getPauseReason() != null && ad.getStatus() == 2) {
                    ticketInfoVo.setStatus(dictionariesMap.get(STR_TWO + ad.getPauseReason()));
                } else {
                    ticketInfoVo.setStatus(dictionariesMap.get(ad.getStatus() + ""));
                }
                if (mark == 1) {
                    String cosWarn = (String)this.jedisFetcher.hfetch(() -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "COSWARN"}), ticketInfoVo.getId() + "", String.class);
                    if (StringUtils.isNotBlank((CharSequence)cosWarn)) {
                        Double cosWarnNew = Double.valueOf(cosWarn) / 1000.0;
                        cosWarn = cosWarnNew + "";
                    }
                    int cosWarnNew = Double.valueOf(cosWarn).intValue();
                    ticketInfoVo.setCosWarn(cosWarnNew + "");
                    String TicketCostWarnNames = (String)this.jedisFetcher.hfetch(() -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "COSWARNNAME"}), ticketInfoVo.getId() + "", String.class);
                    List oldList = JSON.parseArray((String)TicketCostWarnNames, TicketCostWarnName.class);
                    ticketInfoVo.setList(oldList);
                    StringBuffer string = new StringBuffer();
                    if (CollectionUtils.isNotEmpty((Collection)oldList)) {
                        for (TicketCostWarnName ticketCostWarnName : oldList) {
                            if (string.length() > 0) {
                                string.append(",");
                            }
                            if (StringUtils.isBlank((CharSequence)ticketCostWarnName.getNeedCost())) {
                                ticketCostWarnName.setNeedCost("0");
                            }
                            string.append(ticketCostWarnName.getName() + ticketCostWarnName.getNeedCost() + "\u5143");
                        }
                    }
                    ticketInfoVo.setNeed(string.toString());
                }
                String tag = map.get(ad.getId());
                String newTag = null;
                if (StringUtils.isNotBlank((CharSequence)tag)) {
                    newTag = tag.replace('.', '/');
                }
                ticketInfoVo.setTag(newTag);
                ticketInfoVos.add(ticketInfoVo);
            }
        }
        result.setList((List)ticketInfoVos);
        result.setTotalCount(total.intValue());
        return result;
    }

    public Map<Long, String> getMapTag(List<Long> ids) {
        List tagConfDOList = this.adTicketTagConfMapper.findTicketBelongCodeName(ids, Integer.valueOf(2));
        HashedMap map = new HashedMap();
        if (CollectionUtils.isNotEmpty((Collection)tagConfDOList)) {
            for (AdTicketTagConfDO adTicketTagConfDO : tagConfDOList) {
                map.put(adTicketTagConfDO.getTicketId(), adTicketTagConfDO.getFullNameStr());
            }
        }
        return map;
    }

    @Override
    public PageInfo<TicketInfoVo> findTicketConsumeRemindList(AdTicketSearchDto condition) {
        List ticketInfoVoList;
        String code;
        PageHelper.startPage((int)condition.getPageNum(), (int)condition.getPageSize());
        if (null != condition.getTagCode()) {
            List<Long> ticketIds = this.adTicketTagConfService.findTicketIds(condition.getTagCode());
            if (CollectionUtils.isNotEmpty(ticketIds)) {
                condition.setTicketIds(ticketIds);
            } else {
                return new PageInfo();
            }
        }
        if (StringUtil.isNotBlank((CharSequence)(code = condition.getStatusCode()))) {
            if (code.contains(STR_TWO)) {
                condition.setPauseReason(Integer.valueOf(Integer.parseInt(code.substring(2))));
            } else {
                condition.setStatus(Short.valueOf(code));
            }
        }
        if (CollectionUtils.isEmpty((Collection)(ticketInfoVoList = this.adTicketCostMapper.selectTicketListByParams(condition)))) {
            return new PageInfo();
        }
        Map<String, String> dictionariesMap = this.adTicketService.getDictionaries("adstatus");
        ArrayList ids = Lists.newArrayList();
        for (TicketInfoVo ticketInfoVo : ticketInfoVoList) {
            ids.add(ticketInfoVo.getTicketId());
        }
        Map<Long, String> map = this.getMapTag(ids);
        for (TicketInfoVo ticketInfoVo : ticketInfoVoList) {
            if (ticketInfoVo.getPauseReason() != null && ticketInfoVo.getTicketStatus() == 2) {
                ticketInfoVo.setStatus(dictionariesMap.get(STR_TWO + ticketInfoVo.getPauseReason()));
            } else {
                ticketInfoVo.setStatus(dictionariesMap.get(ticketInfoVo.getTicketStatus() + ""));
            }
            List ticketCostWarnNameList = JSON.parseArray((String)ticketInfoVo.getJson(), TicketCostWarnName.class);
            ticketInfoVo.setList(ticketCostWarnNameList);
            StringBuffer string = new StringBuffer();
            if (CollectionUtils.isNotEmpty((Collection)ticketCostWarnNameList)) {
                for (TicketCostWarnName ticketCostWarnName : ticketCostWarnNameList) {
                    if (string.length() > 0) {
                        string.append(",");
                    }
                    if (StringUtils.isBlank((CharSequence)ticketCostWarnName.getNeedCost())) {
                        ticketCostWarnName.setNeedCost("0");
                    }
                    string.append(ticketCostWarnName.getName() + ticketCostWarnName.getNeedCost() + "\u5143");
                }
            }
            ticketInfoVo.setNeed(string.toString());
            String tag = map.get(ticketInfoVo.getTicketId());
            String newTag = null;
            if (StringUtils.isNotBlank((CharSequence)tag)) {
                newTag = tag.replace('.', '/');
            }
            ticketInfoVo.setTag(newTag);
        }
        return new PageInfo(ticketInfoVoList);
    }

    @Override
    public Boolean insert(AdTicketCostLog adTicketCostLog) {
        if (adTicketCostLog.getTicketId() == null) {
            return false;
        }
        String result = (String)this.jedisFetcher.hfetch(this.getTicketCost(), adTicketCostLog.getTicketId() + "", String.class);
        if (StringUtils.isBlank((CharSequence)result)) {
            return false;
        }
        List adTicketCostList = JSON.parseArray((String)result, AdTicketCost.class);
        if (CollectionUtils.isEmpty((Collection)adTicketCostList)) {
            return false;
        }
        AdTicketCost finalAdTicketCost = new AdTicketCost();
        for (AdTicketCost adTicketCost : adTicketCostList) {
            if (adTicketCost.getId().intValue() != adTicketCostLog.getId().intValue()) continue;
            finalAdTicketCost = adTicketCost;
        }
        adTicketCostLog.setId(null);
        List<AdAssets> assetList = this.adTicketAssetsService.findAllAssetsByIdAndStatus(adTicketCostLog.getTicketId(), (short)1);
        StringBuffer buf = new StringBuffer();
        for (AdAssets adAssets : assetList) {
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(adAssets.getId());
        }
        adTicketCostLog.setAssetIds(buf.toString());
        adTicketCostLog.setCreateTime(new Date());
        adTicketCostLog.setCosWarn(finalAdTicketCost.getCosWarn());
        AdTicket adTicket = this.adTicketMapper.selectByPrimaryKey(adTicketCostLog.getTicketId());
        if (adTicket.getPauseReason() == null) {
            adTicketCostLog.setTicketStatus(adTicket.getStatus() + "");
        }
        if (adTicket.getPauseReason() != null && adTicket.getStatus() != 2) {
            adTicketCostLog.setTicketStatus(adTicket.getStatus() + "-" + adTicket.getPauseReason());
        }
        adTicketCostLog.setOutsideUrl(finalAdTicketCost.getUrl());
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String createTime = sdf.format(date);
        adTicketCostLog.setPutId("" + adTicketCostLog.getTicketId() + assetList.get(0).getId() + createTime);
        List oldList = JSON.parseArray((String)finalAdTicketCost.getJson(), TicketCostWarnName.class);
        Double a = Double.valueOf(finalAdTicketCost.getCosWarn()) / 1000.0;
        if (CollectionUtils.isNotEmpty((Collection)oldList)) {
            StringBuffer stringBuffer = new StringBuffer();
            for (TicketCostWarnName ticketCostWarnName : oldList) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                Double b = Double.valueOf(ticketCostWarnName.getNeedCost());
                BigDecimal bd = new BigDecimal(a / b).setScale(0, 4);
                stringBuffer.append(ticketCostWarnName.getName() + Integer.parseInt(bd.toString()) + "\u4e2a");
            }
            adTicketCostLog.setNeed(stringBuffer.toString());
        }
        this.adTicketCostLogMapper.insert(adTicketCostLog);
        try {
            ArrayList list = Lists.newArrayList();
            AdTicketCostLogVo adTicketCostLogVo = new AdTicketCostLogVo();
            BeanUtils.copyProperties((Object)adTicketCostLog, (Object)adTicketCostLogVo);
            list.add(adTicketCostLogVo);
            this.sendDing(list);
        }
        catch (Exception e) {
            log.error("\u5238\u6d88\u8017\u63d0\u9192\u9489\u9489\u63a8\u9001\u5931\u8d25>>>>ticketId = {},id = {}", (Object)adTicketCostLog.getTicketId(), (Object)adTicketCostLog.getId());
        }
        return true;
    }

    @Override
    public TicketInfoVo editShow(String ticketIds) {
        TicketInfoVo ticketInfoVo = new TicketInfoVo();
        ResultModel resultModel = new ResultModel();
        List list = JSON.parseArray((String)ticketIds, Long.class);
        if (list.size() == 1) {
            String cosWarn = (String)this.jedisFetcher.hfetch(() -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "COSWARN"}), list.get(0) + "", String.class);
            String TicketCostWarnNames = (String)this.jedisFetcher.hfetch(() -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "COSWARNNAME"}), list.get(0) + "", String.class);
            List oldList = JSON.parseArray((String)TicketCostWarnNames, TicketCostWarnName.class);
            if (CollectionUtils.isNotEmpty((Collection)oldList)) {
                for (TicketCostWarnName ticketCostWarnName : oldList) {
                    if (!StringUtils.isBlank((CharSequence)ticketCostWarnName.getNeedCost())) continue;
                    ticketCostWarnName.setNeedCost("0");
                }
            }
            ticketInfoVo.setList(oldList);
            Double cosWarnNew = Double.valueOf(cosWarn) / 1000.0;
            ticketInfoVo.setCosWarn(cosWarnNew.intValue() + "");
            resultModel.setReturnValue((Object)ticketInfoVo);
        } else {
            HashMap map = Maps.newHashMap();
            for (Long ticketId : list) {
                String TicketCostWarnNames = (String)this.jedisFetcher.hfetch(() -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "COSWARNNAME"}), ticketId + "", String.class);
                List oldList = JSON.parseArray((String)TicketCostWarnNames, TicketCostWarnName.class);
                if (!CollectionUtils.isNotEmpty((Collection)oldList)) continue;
                for (TicketCostWarnName ticketCostWarnName : oldList) {
                    map.put(ticketCostWarnName.getName(), ticketCostWarnName);
                }
            }
            ArrayList nameList = Lists.newArrayList();
            for (String name : map.keySet()) {
                TicketCostWarnName ticketCostWarnName = new TicketCostWarnName();
                ticketCostWarnName.setName(name);
                nameList.add(ticketCostWarnName);
            }
            ticketInfoVo.setList((List)nameList);
        }
        return ticketInfoVo;
    }

    @Override
    public ResultModel addCostWarnByTag(String tagCodes, String cosWarn, String json, String url) {
        ResultModel resultModel = new ResultModel();
        List ticketIds = this.adTicketTagConfMapper.findTicketIdsByCodeWarn(tagCodes);
        ArrayList idList = Lists.newArrayList();
        List nameList = Lists.newArrayList();
        List deleteIds = (List)this.jedisFetcher.fetch(() -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "DELETECOSWARNS"}), List.class);
        for (Object ticketId : ticketIds) {
            idList.add(ticketId);
            Double cosWarn1 = Double.valueOf(cosWarn) * 1000.0;
            this.jedisUpdater.hupdate(() -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "COSWARN"}), ticketId + "", (Object)cosWarn1);
            nameList = JSON.parseArray((String)json, TicketCostWarnName.class);
            this.jedisUpdater.hupdate(() -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "COSWARNNAME"}), ticketId + "", (Object)nameList);
            if (CollectionUtils.isNotEmpty((Collection)deleteIds) && deleteIds.contains(ticketId + "")) {
                deleteIds.remove(ticketId + "");
            }
            if (!StringUtils.isNotBlank((CharSequence)url)) continue;
            this.jedisUpdater.hupdate(() -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "COSTWARN", "OUTSIDEURL"}), ((Long)ticketId).toString(), (Object)url);
        }
        if (CollectionUtils.isNotEmpty((Collection)deleteIds)) {
            this.jedisUpdater.update(() -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "DELETECOSWARNS"}), (Object)deleteIds);
        }
        ArrayList<String> ids = (ArrayList<String>)this.jedisFetcher.fetch(() -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "COSWARNS"}), List.class);
        if (CollectionUtils.isNotEmpty((Collection)ticketIds)) {
            if (CollectionUtils.isEmpty((Collection)ids)) {
                ids = new ArrayList<String>();
            }
            for (Long id : ticketIds) {
                ids.add(id + "");
            }
            HashSet set = new HashSet(ids);
            ids.clear();
            ids.addAll(set);
            this.jedisUpdater.update(() -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "COSWARNS"}), ids);
        } else {
            this.jedisUpdater.update(() -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "COSWARNS"}), (Object)idList);
        }
        List<TblAdPostionTag> tags = this.tblAdTagService.findByFullpath(tagCodes);
        for (TblAdPostionTag tblAdPostionTag : tags) {
            this.jedisUpdater.hupdate(() -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "COSWARNSTAG"}), tblAdPostionTag.getCode() + "", (Object)new TicketCostWarnTag(cosWarn, nameList));
        }
        return resultModel;
    }

    @Override
    public List<AdTicketCostLogVo> findToDing(Map<String, Object> map) {
        return this.adTicketCostLogMapper.findToDing(map);
    }

    @Override
    public void syns() throws Exception {
        AdTicketSearchDto adTicketSearchDto = new AdTicketSearchDto();
        adTicketSearchDto.setPageNum(Integer.valueOf(1));
        adTicketSearchDto.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        PaginationTemp<TicketInfoVo> paginationTemp = this.findTicket(adTicketSearchDto, 1, null);
        List ticketInfoVoList = paginationTemp.getList();
        for (TicketInfoVo ticketInfoVo : ticketInfoVoList) {
            TicketCosWarnDto ticketCosWarnDto = new TicketCosWarnDto();
            ticketCosWarnDto.setCosWarn(ticketInfoVo.getCosWarn());
            ticketCosWarnDto.setJson(JSON.toJSONString((Object)ticketInfoVo.getList()));
            String url = (String)this.jedisFetcher.hfetch(() -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "COSTWARN", "OUTSIDEURL"}), ticketInfoVo.getId().toString(), String.class);
            ticketCosWarnDto.setUrl(url);
            ticketCosWarnDto.setTicketCosWarnIdAndTicketIds(ticketInfoVo.getId().toString());
            this.saveOrUpdate(ticketCosWarnDto);
        }
    }

    private List<Long> getTickets() {
        List ids = (List)this.jedisFetcher.fetch(() -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "COSWARNS"}), List.class);
        if (CollectionUtils.isNotEmpty((Collection)ids)) {
            ArrayList list = Lists.newArrayList();
            for (String id : ids) {
                list.add(Long.valueOf(id));
            }
            return list;
        }
        return new ArrayList<Long>();
    }

    private void sendDing(List<AdTicketCostLogVo> list) {
        String content = this.getContent(list);
        if (StringUtils.isNotBlank((CharSequence)content)) {
            ArrayList phones = new ArrayList();
            String url = "https://oapi.dingtalk.com/robot/send?access_token=" + this.token;
            DingtalkMsgUtil.sendMsg(url, content, false, Collections.emptyList());
        }
    }

    public String getContent(List<AdTicketCostLogVo> list) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        SimpleDateFormat sdf1 = new SimpleDateFormat("MMddHHmm");
        Date time = new Date();
        String endTime = sdf.format(time.getTime() + 3600000L);
        String content = "";
        for (AdTicketCostLogVo adTicketCostLogVo : list) {
            content = content + "\n " + sdf1.format(time.getTime()) + "--" + adTicketCostLogVo.getTicketId() + "86 " + adTicketCostLogVo.getNeed() + " \n " + adTicketCostLogVo.getOutsideUrl() + "\n";
        }
        return content.replace("\u5145\u503c", "CZ").replace("\u6ce8\u518c", "ZC").replace("\u590d\u5145", "FC").replace("\u6df1\u804a", "SL").replace("\u5143", "\u77f3").replace("\u91d1\u989d", "\u6570\u989d");
    }

    private String getOutSideUrl(Long assetId, String positionId) {
        try {
            if (StringUtils.isNotBlank((CharSequence)this.adticketCostConfiguration.getUrl())) {
                return this.adticketCostConfiguration.getUrl() + assetId;
            }
            if (StringUtils.isBlank((CharSequence)positionId)) {
                return "url null";
            }
            String[] positionIds = positionId.split("-");
            if (positionIds.length < 1) {
                return "url null";
            }
            return String.format(DIRECTURL, positionIds[0], positionIds[1]);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "url error";
        }
    }

    public static void main(String[] args) {
        Date time = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        String url = "https://oapi.dingtalk.com/robot/send?access_token=19b625e5f5c7ae05361963daebf2c9bfb98518f45f4d057969d4d589148f4f96";
        String content = "\u4e2a\u6570";
        content.replace("\u5145\u503c", "CZ").replace("\u6ce8\u518c", "ZC").replace("\u590d\u5145", "FC").replace("\u6df1\u804a", "SL").replace("\u5143", "\u77f3").replace("\u91d1\u989d", "\u6570\u989d");
        DingtalkMsgUtil.sendMsg(url, content, false, Collections.emptyList());
    }

    public KeyGenerator getTicketCost() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "NEWCOSWARN"});
    }

    public KeyGenerator getTicketCostConsume(Long ticketId, String date) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "NEWCOST", "CONSUME", date, ticketId});
    }
}

