/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adkeeper.impl;

import com.alibaba.fastjson.JSONArray;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketPersonsGradeConfMapper;
import com.bxm.adsmanager.integration.getui.model.RuleForm;
import com.bxm.adsmanager.integration.getui.service.GeTuiIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketPersonsGradeConf;
import com.bxm.adsmanager.service.adkeeper.AdTicketPersonsGradeConfService;
import com.bxm.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class AdTicketPersonsGradeConfServiceImpl
implements AdTicketPersonsGradeConfService {
    @Autowired
    private AdTicketPersonsGradeConfMapper adTicketPersonsGradeConfMapper;
    @Autowired
    private GeTuiIntegration geTuiIntegration;

    @Override
    public Integer add(AdTicketPersonsGradeConf ref) {
        if (ref == null) {
            return null;
        }
        Integer result = this.adTicketPersonsGradeConfMapper.insert(ref);
        this.geTuiIntegration.deleteRule(ref.getTicketId());
        return result;
    }

    @Override
    public Integer addBatch(String confs, Long ticketId) {
        if (StringUtil.isBlank((CharSequence)confs) || null == ticketId) {
            return null;
        }
        List list = JSONArray.parseArray((String)confs, AdTicketPersonsGradeConf.class);
        if (list.isEmpty()) {
            return null;
        }
        for (AdTicketPersonsGradeConf conf : list) {
            conf.setTicketId(ticketId);
        }
        return this.adTicketPersonsGradeConfMapper.insertBatch(list);
    }

    @Async
    public void pushToGeTui(List<AdTicketPersonsGradeConf> refs, Long ticketId) {
        ArrayList<RuleForm> list = new ArrayList<RuleForm>();
        for (AdTicketPersonsGradeConf ref : refs) {
            RuleForm ruleForm = new RuleForm();
            ruleForm.setIsveto(ref.getIsVeto());
            ruleForm.setFraction(ref.getScore());
            ruleForm.setLabelid(ref.getLabelId());
            list.add(ruleForm);
        }
        this.geTuiIntegration.uploadRule(list, ticketId);
    }

    @Override
    public Integer delete(Long ticketId) {
        return this.adTicketPersonsGradeConfMapper.deleteByTicketId(ticketId);
    }

    @Override
    public List<AdTicketPersonsGradeConf> findByTicketId(Long ticketId) {
        return this.adTicketPersonsGradeConfMapper.findByTicketId(ticketId);
    }
}

