/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adkeeper.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketRightsMapper;
import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketRights;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketRightsExample;
import com.bxm.adsmanager.model.dto.AdTicketRightsDto;
import com.bxm.adsmanager.model.enums.ProdServiceNameEnum;
import com.bxm.adsmanager.service.adkeeper.AdTicketRightsService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdTicketRightsServiceImpl
implements AdTicketRightsService {
    @Autowired
    private AdTicketRightsMapper adTicketRightsMapper;
    @Autowired
    private ProdPusherIntegration prodPusher;

    @Override
    @Transactional
    public Long add(AdTicketRightsDto adTicketRightsDto) throws Exception {
        AdTicketRights adTicketRights = new AdTicketRights();
        BeanUtils.copyProperties((Object)adTicketRightsDto, (Object)adTicketRights);
        adTicketRights.setId(null);
        int result = this.adTicketRightsMapper.insert(adTicketRights);
        if (result > 0) {
            this.prodPusher.pushToProd(ProdServiceNameEnum.RIGHTS.getServiceName(), null, JSONArray.toJSONBytes((Object)adTicketRights, (SerializerFeature[])new SerializerFeature[0]));
            return adTicketRights.getId();
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer update(AdTicketRightsDto adTicketRightsDto) throws Exception {
        AdTicketRights adTicketRights = new AdTicketRights();
        BeanUtils.copyProperties((Object)adTicketRightsDto, (Object)adTicketRights);
        adTicketRights.setId(Long.valueOf(adTicketRightsDto.getId().longValue()));
        int result = this.adTicketRightsMapper.updateByPrimaryKeySelective(adTicketRights);
        this.prodPusher.pushToProd(ProdServiceNameEnum.RIGHTS.getServiceName(), null, JSONArray.toJSONBytes((Object)adTicketRights, (SerializerFeature[])new SerializerFeature[0]));
        return result;
    }

    @Override
    public PageInfo<AdTicketRights> findAll(AdTicketRightsDto searchDto) throws Exception {
        PageHelper.startPage((int)searchDto.getPageNum(), (int)searchDto.getPageSize());
        PageInfo pageInfo = new PageInfo(this.getList(searchDto));
        return pageInfo;
    }

    @Override
    public List<AdTicketRights> getList(AdTicketRightsDto searchDto) throws Exception {
        AdTicketRightsExample example = new AdTicketRightsExample();
        if (StringUtils.isNotBlank((CharSequence)searchDto.getName())) {
            example.createCriteria().andNameLike("%" + searchDto.getName() + "%");
        }
        example.setOrderByClause("id desc");
        return this.adTicketRightsMapper.selectByExample(example);
    }
}

