/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adkeeper.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bxm.adsmanager.dal.mapper.adflowpackage.AdFlowPackageMapper;
import com.bxm.adsmanager.dal.mapper.adflowpackage.AdTicketFlowPackageMapper;
import com.bxm.adsmanager.dal.mapper.adflowpackage.AdTicketFlowPackageOfferRelationMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdAssetsMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdLandingPagePlanMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdRulesMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketTagConfMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketUrlTestMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketWeightManualConfMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdAssetsAdxMapperExt;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdAssetsInspireVideoMapperExt;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdAssetsTemplateAssetsMapperExt;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdTicketAdxMapperExt;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdTicketAppExtendMapperExt;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdTicketGetuiTagRefMapperExt;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdTicketMapperExt;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdTicketPositionTimesLimitMapperExt;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdTicketWeightManualConfMapperExt;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.TblAdTicketModifyMapperExt;
import com.bxm.adsmanager.dal.mapper.advertiser.ext.TblAdQualifyMapperExt;
import com.bxm.adsmanager.dal.mapper.audit.AdAuditRecordMapper;
import com.bxm.adsmanager.dal.mapper.audit.IndustryAuditMapper;
import com.bxm.adsmanager.dal.mapper.common.DictionariesMapper;
import com.bxm.adsmanager.dal.mapper.explore.TicketExploreMapper;
import com.bxm.adsmanager.dal.mapper.tbltag.ext.TblAdPostionTagMapperExt;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.facade.model.adx.AdxMeituanReviewDto;
import com.bxm.adsmanager.integration.acl.AclUserIntegration;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.integration.adsprod.service.ProdPullerIntegration;
import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserMainInfoVo;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.integration.adx.MeituanReviewIntegration;
import com.bxm.adsmanager.integration.config.MeituanReviewConfig;
import com.bxm.adsmanager.integration.datapark.model.TicketCountCommon;
import com.bxm.adsmanager.integration.datapark.service.DataparkOcpcIntegration;
import com.bxm.adsmanager.integration.datapark.service.DataparkTicketPullerIntegration;
import com.bxm.adsmanager.integration.logs.LogsIntegration;
import com.bxm.adsmanager.integration.screenshot.ScreenShotIntegration;
import com.bxm.adsmanager.model.constant.CommonConstant;
import com.bxm.adsmanager.model.constant.RedisKeys;
import com.bxm.adsmanager.model.dao.adflowpackage.AdFlowPackage;
import com.bxm.adsmanager.model.dao.adflowpackage.AdTicketFlowPackageConf;
import com.bxm.adsmanager.model.dao.adflowpackage.AdTicketFlowPackageOfferRelation;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssets;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsAdx;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsAdxExample;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsCoupons;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsInspireVideo;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTemplateAssets;
import com.bxm.adsmanager.model.dao.adkeeper.AdRules;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketAdx;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketAdxExample;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketAppExtend;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketAppExtendExample;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketCouponsCode;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketCouponsInfo;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketGetuiTagRef;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketOcpcConf;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketOnoff;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketPersonsGradeConf;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketPriceConf;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketUrlTest;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketWeightManualConf;
import com.bxm.adsmanager.model.dao.adkeeper.TblAdTicketModify;
import com.bxm.adsmanager.model.dao.advertiser.TblAdQualify;
import com.bxm.adsmanager.model.dao.audit.AdAuditRecord;
import com.bxm.adsmanager.model.dao.common.Dictionaries;
import com.bxm.adsmanager.model.dao.explore.TicketExplore;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdAbnormalTicketConsumeSearchDTO;
import com.bxm.adsmanager.model.dto.AdAssetsTemplateAssetsAdxAuditStatusDTO;
import com.bxm.adsmanager.model.dto.AdFlowPackageNewDto;
import com.bxm.adsmanager.model.dto.AdTicketCheckDto;
import com.bxm.adsmanager.model.dto.AdTicketCheckInfokDto;
import com.bxm.adsmanager.model.dto.AdTicketCouponsCodeStatusNumDto;
import com.bxm.adsmanager.model.dto.AdTicketDto;
import com.bxm.adsmanager.model.dto.AdTicketFlowPackageAddBatchDto;
import com.bxm.adsmanager.model.dto.AdTicketFlowPackageOfferConfDto;
import com.bxm.adsmanager.model.dto.AdTicketPositionAddBatchDto;
import com.bxm.adsmanager.model.dto.AdTicketSearchDto;
import com.bxm.adsmanager.model.dto.AdvertiserCheckDto;
import com.bxm.adsmanager.model.dto.TicketCostWarnTag;
import com.bxm.adsmanager.model.enums.RuleTargetEnum;
import com.bxm.adsmanager.model.enums.RuleTypeEnum;
import com.bxm.adsmanager.model.vo.AdAbnormalTicketConsumeVo;
import com.bxm.adsmanager.model.vo.AdAdxTicketPackageVo;
import com.bxm.adsmanager.model.vo.AdFlowPackageNewVo;
import com.bxm.adsmanager.model.vo.AdTicketAllVo;
import com.bxm.adsmanager.model.vo.AdTicketAppEntranceVo;
import com.bxm.adsmanager.model.vo.AdTicketCopyVo;
import com.bxm.adsmanager.model.vo.AdTicketFlowPackageOfferConfVo;
import com.bxm.adsmanager.model.vo.AdTicketPositionTimesLimitConfigVo;
import com.bxm.adsmanager.model.vo.AdTicketVo;
import com.bxm.adsmanager.model.vo.AdTicketWeightVo;
import com.bxm.adsmanager.model.vo.LandingPagePlanVo;
import com.bxm.adsmanager.model.vo.PaginationTemp;
import com.bxm.adsmanager.redis.RedisClient;
import com.bxm.adsmanager.redis.RedisNewClient;
import com.bxm.adsmanager.service.adflowpackage.AdFlowPackageService;
import com.bxm.adsmanager.service.adflowpackage.AdTicketFlowNewService;
import com.bxm.adsmanager.service.adflowpackage.AdTicketFlowPackageOfferConfService;
import com.bxm.adsmanager.service.adkeeper.AdRulesService;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsCouponsService;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsRefService;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsService;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsTemplateAssetsService;
import com.bxm.adsmanager.service.adkeeper.AdTicketCouponsCodeService;
import com.bxm.adsmanager.service.adkeeper.AdTicketCouponsInfoService;
import com.bxm.adsmanager.service.adkeeper.AdTicketGetuiTagRefService;
import com.bxm.adsmanager.service.adkeeper.AdTicketOcpcService;
import com.bxm.adsmanager.service.adkeeper.AdTicketOnoffService;
import com.bxm.adsmanager.service.adkeeper.AdTicketOsConfSerive;
import com.bxm.adsmanager.service.adkeeper.AdTicketPersonsGradeConfService;
import com.bxm.adsmanager.service.adkeeper.AdTicketPositionTimesLimitConfigService;
import com.bxm.adsmanager.service.adkeeper.AdTicketPriceConfService;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.service.adkeeper.AdTicketTagConfService;
import com.bxm.adsmanager.service.adkeeper.TikcetCurrentClickAveragePriceService;
import com.bxm.adsmanager.service.adticketgroup.TicketGroupService;
import com.bxm.adsmanager.service.advertiser.TblStationUserWeightService;
import com.bxm.adsmanager.service.audit.impl.AdAuditServiceImpl;
import com.bxm.adsmanager.service.common.DictionariesService;
import com.bxm.adsmanager.service.prod.ProdService;
import com.bxm.adsmanager.utils.DateUtils;
import com.bxm.adsmanager.utils.DingtalkMsgUtil;
import com.bxm.adsmanager.utils.DoubleUtil;
import com.bxm.adsmanager.utils.ListOrderUtils;
import com.bxm.adsmanager.utils.ListUtil;
import com.bxm.adsmanager.utils.UserRoleCodeUtil;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppAdPositionDTO;
import com.bxm.adsprod.facade.rules.Rule;
import com.bxm.adsprod.facade.ticket.ChasePriceConfig;
import com.bxm.adsprod.facade.ticket.IllegalTicketException;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketCache;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.commons.currency.Money;
import com.bxm.datapark.facade.ocpc.OcpcStageCpaSearchDto;
import com.bxm.log.facade.dao.LogModel;
import com.bxm.util.DateUtil;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ValidateException;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.bxm.warcar.utils.TypeHelper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdTicketServiceImpl
implements AdTicketService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdTicketServiceImpl.class);
    private static final ThreadPoolExecutor PUSH_TICKET_POOL = new ThreadPoolExecutor(4, 4, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("Push Ticket Pool"));
    private static final String STR_ZERO = "0";
    private static final int ZERO = 0;
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final String STR_TWO = "2-";
    private static final String ADTICKET_ID = "AD:ADTICKET:ID";
    private static final int DB = 13;
    private static final String IS_CHECK = "AD:IS_CHECK";
    @Autowired
    private AdTicketMapper adTicketMapper;
    @Autowired
    private AdAssetsMapper adAssetsMapper;
    @Autowired
    private AdTicketTagConfService adTicketTagConfService;
    @Autowired
    private AdRulesService adRulesService;
    @Autowired
    private AdTicketOsConfSerive adTicketOsConfSerive;
    @Autowired
    private AdTicketAssetsRefService adTicketAssetsRefService;
    @Autowired
    private AdTicketOnoffService adTicketOnoffService;
    @Autowired
    private AdTicketOcpcService adTicketOcpcService;
    @Autowired
    private AdTicketPersonsGradeConfService adTicketPersonsGradeConfService;
    @Autowired
    private AdTicketWeightManualConfMapper adTicketWeightManualConfMapper;
    @Autowired
    private DictionariesMapper dictionariesMapper;
    @Autowired
    private AdRulesMapper adRulesMapper;
    @Autowired
    private ProdPullerIntegration prodPuller;
    @Autowired
    private ProdService prodService;
    @Autowired
    private AdShopIntegration adShopIntegration;
    @Autowired
    private AdTicketPriceConfService adTicketPriceConfService;
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private AdTicketMapperExt adTicketMapperExt;
    @Autowired
    private DictionariesService dictionariesService;
    @Autowired
    private AdTicketWeightManualConfMapperExt adTicketWeightManualConfMapperExt;
    @Autowired
    private ProdPusherIntegration prodPusherIntegration;
    @Autowired
    private DataparkTicketPullerIntegration dataparkTicketPullerIntegration;
    @Autowired
    private AdTicketFlowPackageMapper adTicketFlowPackageMapper;
    @Autowired
    private AdFlowPackageMapper adFlowPackageMapper;
    @Resource
    TicketExploreMapper ticketExploreMapper;
    @Autowired
    private AdTicketFlowPackageOfferRelationMapper adTicketFlowPackageOfferRelationMapper;
    @Autowired
    private TicketGroupService ticketGroupService;
    @Autowired
    private AdTicketFlowNewService adTicketFlowNewService;
    @Autowired
    private AdTicketAssetsService adTicketAssetsService;
    @Autowired
    private TblAdQualifyMapperExt tblAdQualifyMapperExt;
    @Autowired
    private TblAdTicketModifyMapperExt tblAdTicketModifyMapperExt;
    @Autowired
    private AdTicketUrlTestMapper adTicketUrlTestMapper;
    @Autowired
    private AdTicketTagConfMapper adTicketTagConfMapper;
    @Autowired
    private AdFlowPackageService adFlowPackageService;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    private RedisNewClient redisNewClient;
    @Resource
    private AclUserIntegration aclUserIntegration;
    @Autowired
    private TblStationUserWeightService tblStationUserWeightService;
    @Autowired
    private AdTicketCouponsInfoService adTicketCouponsInfoService;
    @Autowired
    private AdTicketCouponsCodeService adTicketCouponsCodeService;
    @Autowired
    private AdTicketAssetsCouponsService adTicketAssetsCouponsService;
    @Autowired
    private AdTicketFlowPackageOfferConfService adTicketFlowPackageOfferConfService;
    @Autowired
    private AdTicketAdxMapperExt adTicketAdxMapperExt;
    @Autowired
    private AdAssetsAdxMapperExt adAssetsAdxMapperExt;
    @Autowired
    private AdAssetsInspireVideoMapperExt adAssetsInspireVideoMapperExt;
    @Autowired
    private AdAssetsTemplateAssetsMapperExt adAssetsTemplateAssetsMapperExt;
    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;
    @Autowired
    private TblAdPostionTagMapperExt tblAdPostionTagMapperExt;
    @Autowired
    private IndustryAuditMapper industryAuditMapper;
    @Autowired
    private ScreenShotIntegration screenShotIntegration;
    @Autowired
    private TikcetCurrentClickAveragePriceService tikcetCurrentClickAveragePriceService;
    @Autowired
    private AdAuditRecordMapper adAuditRecordMapper;
    @Autowired
    private MeituanReviewIntegration meituanReviewIntegration;
    @Autowired
    private MeituanReviewConfig meituanReviewConfig;
    @Autowired
    private AdTicketAppExtendMapperExt adTicketAppExtendMapperExt;
    @Autowired
    private AdTicketGetuiTagRefMapperExt adTicketGetuiTagRefMapperExt;
    @Autowired
    private AdTicketGetuiTagRefService adTicketGetuiTagRefService;
    @Autowired
    private AdTicketPositionTimesLimitConfigService adTicketPositionTimesLimitConfigService;
    @Autowired
    private AdTicketAssetsTemplateAssetsService adTicketAssetsTemplateAssetsService;
    @Autowired
    private LogsIntegration logsIntegration;
    @Autowired
    private AdLandingPagePlanMapper adLandingPagePlanMapper;
    @Autowired
    private DataparkOcpcIntegration dataparkOcpcIntegration;
    @Autowired
    private AdTicketPositionTimesLimitMapperExt adTicketPositionTimesLimitMapperExt;
    private static final ExecutorService THREAD_POOL = new ThreadPoolExecutor(5, 5, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("screen-shot-loadingpage"));
    private static final ThreadPoolExecutor SAVE_LOG_POOL = new ThreadPoolExecutor(2, 2, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("Save Log Pool"));

    @PreDestroy
    public void destroy() {
        THREAD_POOL.shutdown();
        try {
            if (!THREAD_POOL.awaitTermination(30L, TimeUnit.SECONDS)) {
                LOGGER.error("termination has timeout");
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("destroy:", (Throwable)e);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public Long add(AdTicketDto adTicketDto, String userName) throws Exception {
        this.checkCPCAndOCPCPrice(adTicketDto);
        AdTicket adTicket = new AdTicket();
        BeanUtils.copyProperties((Object)adTicketDto, (Object)adTicket);
        adTicket.setCreateUser(userName);
        if (!adTicketDto.getIsGroup().booleanValue()) {
            adTicket.setGroupId(null);
        }
        this.setTicketPrice(adTicketDto, adTicket);
        if (1 == adTicket.getStatus() || 2 == adTicket.getStatus()) {
            String tiems = null;
            if (null != adTicketDto.getControlDto()) {
                tiems = adTicketDto.getControlDto().getTimes();
                if (1 == adTicket.getSettleType() || 4 == adTicket.getSettleType() || 5 == adTicket.getSettleType()) {
                    tiems = this.transformLiTimes(tiems);
                }
            }
            adTicket = this.checkStatus(adTicket, adTicket, tiems, new Object[0]);
        }
        adTicket.setId(Long.valueOf(this.getId()));
        if (AdTicket.AdTicketType.isAdx((Short)adTicketDto.getType())) {
            String newUrl = null;
            newUrl = adTicket.getUrl().contains("?") ? adTicket.getUrl().replace("?", "?xid=" + adTicket.getId() + "&") : adTicket.getUrl() + "?" + "xid" + "=" + adTicket.getId();
            adTicket.setUrl(newUrl);
        }
        this.adTicketMapper.insertSelective(adTicket);
        if (AdTicket.AdTicketType.isNotAdx((Short)adTicketDto.getType()) && StringUtil.isNotEmpty((CharSequence)adTicketDto.getFlowPackageArrayConfs())) {
            List confs = JSON.parseArray((String)adTicketDto.getFlowPackageArrayConfs(), AdTicketFlowPackageOfferConfDto.class);
            boolean is_new_ticket = Boolean.TRUE;
            Long flowPackageOfferConfId = this.adTicketFlowPackageOfferConfService.save(confs, adTicket.getId(), is_new_ticket, userName);
            if (flowPackageOfferConfId != null) {
                adTicket.setFlowPackageOfferConfId(flowPackageOfferConfId);
                this.adTicketMapper.updateFlowPackageOfferConfId(adTicket.getId(), flowPackageOfferConfId);
            }
        }
        this.saveref(CommonConstant.Opera.Platform.ADSMANAGER, CommonConstant.Opera.Method.ADD, adTicketDto, adTicket.getId(), adTicket.getPrice(), userName, null);
        this.addCostWarn(adTicketDto, adTicket.getId());
        AdTicketDto.ControlDto controlDto = adTicketDto.getControlDto();
        String noiemi = null;
        String imeinomatching = null;
        if (controlDto != null && StringUtil.isNotBlank((CharSequence)adTicketDto.getPersonsGradeConf())) {
            noiemi = controlDto.getNoimei();
            imeinomatching = controlDto.getImeinomatching();
        }
        AdTicketPriceConf conf = new AdTicketPriceConf();
        conf.setTicketId(adTicket.getId());
        conf.setBeforePrice(adTicket.getPrice());
        conf.setAfterPrice(adTicket.getPrice());
        conf.setFloatPercent(Double.valueOf(100.0));
        Map<String, Rule> ruleMap = this.getRuleMap(adTicketDto, BigInteger.valueOf(adTicket.getId()));
        adTicketDto.setId(Integer.valueOf(adTicket.getId().intValue()));
        try {
            if (StringUtils.isNotBlank((CharSequence)adTicketDto.getTags())) {
                int tagCode = Integer.valueOf(adTicketDto.getTags().substring(adTicketDto.getTags().lastIndexOf(",") + 1, adTicketDto.getTags().length()));
                this.tblStationUserWeightService.refreshWeightCacheWhenTicketUpdate(adTicket.getId(), tagCode, tagCode, true);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u65b0\u589e\u5238\uff0c\u8c03\u7528\u7ad9\u5185\u6237\u8ba1\u5212\u5237\u65b0\u5e7f\u544a\u4f4d\u7f13\u5b58\u5931\u8d25\uff01", (Throwable)e);
            DingtalkMsgUtil.sendMsg("https://oapi.dingtalk.com/robot/send?access_token=ef60c4cae6387ad2106d070803d6ca3ecb44de5ffec02b167f730c55ea6bbff3", "\u65b0\u589e\u5238\uff0c\u8c03\u7528\u7ad9\u5185\u6237\u8ba1\u5212\u5237\u65b0\u5e7f\u544a\u4f4d\u7f13\u5b58\u5931\u8d25\uff01", false, Collections.emptyList());
        }
        if (AdTicket.AdTicketType.isNotAdx((Short)adTicketDto.getType())) {
            AdTicket finalAdTicket = adTicket;
            THREAD_POOL.submit(() -> {
                try {
                    String screenshotUrl = this.screenShotIntegration.screenshot(finalAdTicket.getId(), finalAdTicket.getUrl());
                    if (StringUtils.isNotBlank((CharSequence)screenshotUrl)) {
                        this.updater.hupdate(AdAuditServiceImpl.loadingPageScreenShotUrl(), finalAdTicket.getId().toString(), (Object)screenshotUrl);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("\u65b0\u589e\u5238\u65f6\u843d\u5730\u9875\u622a\u56fe\u5931\u8d25", (Throwable)e);
                }
            });
        }
        this.prodService.pushAdTicketToProd(adTicketDto.getOss(), adTicketDto.getTags(), noiemi, imeinomatching, adTicket, adTicketDto.getAssetsids(), adTicketDto.getWeight(), conf, ruleMap);
        if (adTicketDto.getIsGroup().booleanValue() && adTicketDto.getGroupId() != null) {
            this.ticketGroupService.pushTicketGroup(adTicketDto.getGroupId());
        }
        return adTicket.getId();
    }

    public void saveAdTicketOnoff(String value, Long ticketId, Integer type) {
        AdTicketOnoff adTicketOnoff = new AdTicketOnoff();
        adTicketOnoff.setTicketId(ticketId);
        if (STR_ZERO.equals(value)) {
            adTicketOnoff.setOnoff(Short.valueOf(value));
        } else {
            adTicketOnoff.setOnoff(Short.valueOf("1"));
            adTicketOnoff.setValue(value);
        }
        adTicketOnoff.setType(type);
        this.adTicketOnoffService.add(adTicketOnoff);
    }

    private void checkCPCAndOCPCPrice(AdTicketDto adTicketDto) {
        String chasePriceConfig;
        if (2 != adTicketDto.getSettleType() && 4 != adTicketDto.getSettleType()) {
            if (99999.0 < adTicketDto.getPrice()) {
                throw new RuntimeException("\u6700\u9ad8\u652f\u6301\u51fa\u4ef710.00\u5143");
            }
            if (0.001 > adTicketDto.getPrice()) {
                throw new RuntimeException("\u51fa\u4ef7\u5fc5\u987b\u5927\u4e8e0.001\u5143");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(chasePriceConfig = adTicketDto.getChasePriceConfig()))) {
            List chasePriceConfigs = JSONObject.parseArray((String)chasePriceConfig, ChasePriceConfig.class);
            for (ChasePriceConfig priceConfig : chasePriceConfigs) {
                if (Objects.isNull(priceConfig.getBalance())) {
                    throw new RuntimeException("\u8ffd\u4ef7CPC\u4f59\u989d\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!Objects.isNull(priceConfig.getPrice()) && !(priceConfig.getPrice() < 0.0)) continue;
                throw new RuntimeException("\u8ffd\u4ef7CPC\u51fa\u4ef7\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0\u5143");
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=60)
    public Long update(CommonConstant.Opera.Platform platform, AdTicketDto adTicketDto, String userName) throws Exception {
        this.checkCPCAndOCPCPrice(adTicketDto);
        AdTicket t = this.adTicketMapper.selectByPrimaryKey(Long.valueOf(adTicketDto.getId().longValue()));
        if (t == null) {
            throw new ValidateException("\u6839\u636eid\u6ca1\u6709\u67e5\u627e\u5230\u5e7f\u544a\u5238");
        }
        if (!ObjectUtils.equals((Object)t.getType(), (Object)adTicketDto.getType())) {
            throw new ValidateException("\u5238\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u67e5\u770b\u524d\u7aef\u662f\u5426\u6709Bug\uff01");
        }
        String tagCode = this.adTicketTagConfService.findCode(adTicketDto.getId().longValue(), 2);
        Long oldgroupId = t.getGroupId();
        this.adTicketTagConfService.delete(adTicketDto.getId().longValue());
        this.adTicketOnoffService.delete(adTicketDto.getId().longValue());
        this.adRulesService.delete(adTicketDto.getId().longValue());
        this.adTicketPersonsGradeConfService.delete(adTicketDto.getId().longValue());
        this.adTicketOsConfSerive.delete(adTicketDto.getId().longValue());
        this.adTicketWeightManualConfMapper.deleteByTicketId(Long.valueOf(adTicketDto.getId().longValue()));
        this.adTicketFlowPackageMapper.deleteByTicketId(Long.valueOf(adTicketDto.getId().longValue()));
        this.adTicketGetuiTagRefMapperExt.deleteByTicketId(Long.valueOf(adTicketDto.getId().longValue()));
        AdTicket adTicket = new AdTicket();
        BeanUtils.copyProperties((Object)adTicketDto, (Object)adTicket);
        adTicket.setModifyUser(userName);
        adTicket.setId(Long.valueOf(adTicketDto.getId().longValue()));
        this.setTicketPrice(adTicketDto, adTicket);
        ArrayList<Long> packageIds = new ArrayList();
        ArrayList<AdFlowPackageNewDto> packages = new ArrayList();
        if (StringUtil.isNotEmpty((CharSequence)adTicketDto.getFlowPackageIdArray())) {
            packageIds = JSON.parseArray((String)adTicketDto.getFlowPackageIdArray(), Long.class);
        }
        if (StringUtil.isNotEmpty((CharSequence)adTicketDto.getFlowPackageArray())) {
            packages = JSON.parseArray((String)adTicketDto.getFlowPackageArray(), AdFlowPackageNewDto.class);
        }
        this.adTicketFlowNewService.dealPackage(packageIds, adTicketDto.getId().longValue(), packages, userName);
        if (adTicketDto.getStatus() == null) {
            adTicketDto.setStatus(t.getStatus());
        }
        if (adTicketDto.getStatus() != -2 && (1 == t.getStatus() || 2 == t.getStatus())) {
            String tiems = null;
            if (null != adTicketDto.getControlDto()) {
                tiems = adTicketDto.getControlDto().getTimes();
                if (1 == adTicket.getSettleType() || 4 == adTicket.getSettleType() || 5 == adTicket.getSettleType()) {
                    tiems = this.transformLiTimes(tiems);
                }
            }
            adTicket = this.checkStatus(adTicket, adTicket, tiems, adTicketDto);
        }
        if (StringUtils.isBlank((CharSequence)adTicketDto.getPersonsGradeConf()) || "[]".equals(adTicketDto.getPersonsGradeConf())) {
            adTicket.setUserGradePassScore(Integer.valueOf(-1));
        }
        if (!adTicketDto.getIsGroup().booleanValue()) {
            adTicket.setGroupId(null);
        }
        if (AdTicket.AdTicketType.isAdx((Short)adTicketDto.getType()) && !adTicket.getUrl().contains("xid")) {
            String newUrl = null;
            newUrl = adTicket.getUrl().contains("?") ? adTicket.getUrl().replace("?", "?xid=" + adTicket.getId() + "&") : adTicket.getUrl() + "?" + "xid" + "=" + adTicket.getId();
            adTicket.setUrl(newUrl);
        }
        if (AdTicket.AdTicketType.isNotAdx((Short)adTicketDto.getType())) {
            Long flowPackageOfferConfId = null;
            if (StringUtil.isNotEmpty((CharSequence)adTicketDto.getFlowPackageArrayConfs())) {
                List confs = JSON.parseArray((String)adTicketDto.getFlowPackageArrayConfs(), AdTicketFlowPackageOfferConfDto.class);
                boolean is_new_ticket = Boolean.FALSE;
                flowPackageOfferConfId = this.adTicketFlowPackageOfferConfService.save(confs, adTicket.getId(), is_new_ticket, userName);
            }
            adTicket.setFlowPackageOfferConfId(flowPackageOfferConfId);
        }
        this.adTicketMapper.updateByPrimaryKeySelective(adTicket);
        this.adTicketMapper.updateGroupIdAndRightsId(adTicket.getId(), adTicket.getGroupId(), adTicket.getRightsId(), adTicket.getTicketActivityMatchTag());
        this.saveref(platform, CommonConstant.Opera.Method.EDIT, adTicketDto, adTicketDto.getId().longValue(), adTicket.getPrice(), userName, t);
        if (StringUtils.isNotBlank((CharSequence)tagCode)) {
            this.updateCostWarn(adTicketDto, tagCode);
        }
        if (StringUtils.isNotBlank((CharSequence)tagCode)) {
            try {
                int newTagCode = Integer.valueOf(adTicketDto.getTags().substring(adTicketDto.getTags().lastIndexOf(",") + 1, adTicketDto.getTags().length()));
                this.tblStationUserWeightService.refreshWeightCacheWhenTicketUpdate(adTicket.getId(), Integer.valueOf(tagCode), newTagCode, false);
            }
            catch (Exception e) {
                LOGGER.error("\u7f16\u8f91\u5238\uff0c\u8c03\u7528\u7ad9\u5185\u6237\u8ba1\u5212\u5237\u65b0\u5e7f\u544a\u4f4d\u7f13\u5b58\u5931\u8d25\uff01", (Throwable)e);
                DingtalkMsgUtil.sendMsg("https://oapi.dingtalk.com/robot/send?access_token=ef60c4cae6387ad2106d070803d6ca3ecb44de5ffec02b167f730c55ea6bbff3", "\u7f16\u8f91\u5238\uff0c\u8c03\u7528\u7ad9\u5185\u6237\u8ba1\u5212\u5237\u65b0\u5e7f\u544a\u4f4d\u7f13\u5b58\u5931\u8d25\uff01", false, Collections.emptyList());
            }
        }
        this.prodService.pushAdTicketToProdPre(adTicketDto.getId().longValue());
        Long groupId = adTicketDto.getGroupId();
        if (adTicketDto.getIsGroup().booleanValue() && groupId != null && !groupId.equals(oldgroupId)) {
            this.ticketGroupService.pushTicketGroup(groupId);
        }
        if (oldgroupId != null && !oldgroupId.equals(groupId)) {
            this.ticketGroupService.pushTicketGroup(oldgroupId);
        }
        return adTicketDto.getId().longValue();
    }

    private void setTicketPrice(AdTicketDto adTicketDto, AdTicket adTicket) {
        Money money = Money.ofYuan((double)adTicketDto.getPrice());
        adTicket.setPrice(Integer.valueOf(Long.valueOf(money.getLi()).intValue()));
        if (1 == adTicketDto.getSettleType() || 4 == adTicketDto.getSettleType() || 5 == adTicketDto.getSettleType()) {
            Money money1 = Money.ofYuan((double)adTicketDto.getBudgetDaily());
            adTicket.setBudgetDaily(Long.valueOf(money1.getLi()));
        } else {
            adTicket.setBudgetDaily(Long.valueOf(adTicketDto.getBudgetDaily().longValue()));
        }
    }

    private void saveref(CommonConstant.Opera.Platform platform, CommonConstant.Opera.Method method, AdTicketDto adTicketDto, Long ticketId, Integer price, String userName, AdTicket oldTicketInfo) {
        String ruleValue;
        AdTicketDto.OcpcConfDto ocpcConf;
        AdTicket.AdTicketType adTicketType;
        if (adTicketDto.getPrice() != null) {
            AdTicketPriceConf adTicketPriceConf = new AdTicketPriceConf();
            adTicketPriceConf.setCreateUser(userName);
            adTicketPriceConf.setModifyUser(userName);
            adTicketPriceConf.setTicketId(ticketId);
            adTicketPriceConf.setAfterPrice(price);
            this.adTicketPriceConfService.update(adTicketPriceConf);
        }
        AdTicketDto.ControlDto controlDto = adTicketDto.getControlDto();
        if (StringUtil.isNotBlank((CharSequence)adTicketDto.getTags())) {
            this.adTicketTagConfService.addBatch(adTicketDto.getTags(), ticketId);
        }
        if (StringUtil.isNotBlank((CharSequence)adTicketDto.getCitys())) {
            this.adRulesService.add(adTicketDto.getCitys(), ticketId, RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.DIYUXIANZHI.getValue());
        } else if (StringUtil.isNotBlank((CharSequence)adTicketDto.getIpLibrary())) {
            this.adRulesService.add(adTicketDto.getIpLibrary(), ticketId, RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.IPLIB.getValue());
        }
        if (StringUtil.isNotBlank((CharSequence)adTicketDto.getOss())) {
            this.adTicketOsConfSerive.addBatch(adTicketDto.getOss(), ticketId);
        }
        if ((AdTicket.AdTicketType.TYPE_NORMALS == (adTicketType = AdTicket.AdTicketType.getByType((Short)adTicketDto.getType())) || AdTicket.AdTicketType.TYPE_STANDBYS == adTicketType || AdTicket.AdTicketType.TYPE_ENCOURAGE == adTicketType || AdTicket.AdTicketType.TYPE_DSP == adTicketType || AdTicket.AdTicketType.TYPE_RTA == adTicketType || AdTicket.AdTicketType.TYPE_PUSH == adTicketType) && StringUtil.isNotBlank((CharSequence)adTicketDto.getAssetsids())) {
            this.adTicketAssetsRefService.addBatch(adTicketDto.getAssetsids(), ticketId);
        }
        if (AdTicket.AdTicketType.TYPE_COUPON == adTicketType && adTicketDto.getCouponsInfoDto() != null && adTicketDto.getCouponsInfoDto().getUseType() != null) {
            if (StringUtil.isNotBlank((CharSequence)adTicketDto.getAssetscouponsids())) {
                this.adTicketAssetsCouponsService.updateTicketIdByAssetsCouponsIds(ticketId, adTicketDto.getAssetscouponsids());
            }
            AdTicketCouponsInfo adTicketCouponsInfo = this.adTicketCouponsInfoService.findByTicketId(ticketId);
            Date currentTime = new Date();
            boolean useTypeChange = false;
            if (adTicketCouponsInfo == null || adTicketCouponsInfo.getId() == null) {
                adTicketCouponsInfo = new AdTicketCouponsInfo();
                BeanUtils.copyProperties((Object)adTicketDto.getCouponsInfoDto(), (Object)adTicketCouponsInfo);
                adTicketCouponsInfo.setTicketId(ticketId);
                adTicketCouponsInfo.setCreateTime(currentTime);
                adTicketCouponsInfo.setCreateUser(userName);
                this.adTicketCouponsInfoService.add(adTicketCouponsInfo);
            } else {
                useTypeChange = !adTicketDto.getCouponsInfoDto().getUseType().equals(adTicketCouponsInfo.getUseType());
                BeanUtils.copyProperties((Object)adTicketDto.getCouponsInfoDto(), (Object)adTicketCouponsInfo);
                adTicketCouponsInfo.setModifyTime(currentTime);
                adTicketCouponsInfo.setModifyUser(userName);
                this.adTicketCouponsInfoService.update(adTicketCouponsInfo);
            }
            String codeKeyName = adTicketDto.getCouponsInfoDto().getCodeKeyName();
            if (StringUtils.isNotBlank((CharSequence)codeKeyName) && (AdTicketCouponsInfo.AdCouponsUseType.USETYPE_SINGLE.getType() == adTicketDto.getCouponsInfoDto().getUseType().shortValue() || AdTicketCouponsInfo.AdCouponsUseType.USETYPE_MULTIPLE.getType() == adTicketDto.getCouponsInfoDto().getUseType().shortValue())) {
                Set<String> codeSet = this.redisNewClient.smembers(RedisKeys.getKeyGeneratorByTempAssetsCouponsCode((String)codeKeyName).generateKey(), RedisKeys.getKeyGeneratorByTempAssetsCouponsCodeDBIndex());
                KeyGenerator codeKeyGenerator = TicketKeyGenerator.Coupon.getCouponInfo((BigInteger)new BigInteger(String.valueOf(ticketId)), (Short)AdTicketCouponsCode.AdCouponsStatus.STATUS_UNUSED.getStatus());
                if (useTypeChange) {
                    this.adTicketCouponsCodeService.deleteByTicketId(ticketId);
                    this.redisNewClient.delKey(codeKeyGenerator.generateKey(), RedisKeys.getKeyGeneratorByTempAssetsCouponsCodeDBIndex());
                }
                this.adTicketCouponsCodeService.addBatch(codeSet, ticketId, AdTicketCouponsCode.AdCouponsStatus.STATUS_UNUSED.getStatus(), currentTime, userName);
                this.redisNewClient.sadd(codeKeyGenerator.generateKey(), codeSet, (Integer)RedisKeys.getKeyGeneratorByTempAssetsCouponsCodeDBIndex());
            }
        }
        if ((AdTicket.AdTicketType.TYPE_ADX_DIRECT == adTicketType || AdTicket.AdTicketType.TYPE_ADX_INTERACT == adTicketType) && adTicketDto.getAdxConfDto() != null) {
            Money money1;
            Money money;
            if (AdTicket.AdTicketType.TYPE_ADX_INTERACT == adTicketType) {
                adTicketDto.getAdxConfDto().setAdxPrice(adTicketDto.getPrice());
                adTicketDto.getAdxConfDto().setAdxBudgetDaily(adTicketDto.getBudgetDaily());
            }
            AdTicketAdxExample example = new AdTicketAdxExample();
            example.createCriteria().andAdTicketIdEqualTo(ticketId);
            List adTicketAdxes = this.adTicketAdxMapperExt.selectByExample(example);
            AdTicketAdx adTicketAdx = null;
            if (CollectionUtils.isNotEmpty((Collection)adTicketAdxes)) {
                adTicketAdx = (AdTicketAdx)adTicketAdxes.get(0);
                BeanUtils.copyProperties((Object)adTicketDto.getAdxConfDto(), (Object)adTicketAdx);
                adTicketAdx.setAdTicketId(ticketId);
                money = Money.ofYuan((double)adTicketDto.getAdxConfDto().getAdxPrice());
                adTicketAdx.setAdxPrice(Integer.valueOf(Long.valueOf(money.getLi()).intValue()));
                money1 = Money.ofYuan((double)adTicketDto.getAdxConfDto().getAdxBudgetDaily());
                adTicketAdx.setAdxBudgetDaily(Integer.valueOf(Long.valueOf(money1.getLi()).intValue()));
                this.adTicketAdxMapperExt.updateByPrimaryKey(adTicketAdx);
            } else {
                adTicketAdx = new AdTicketAdx();
                BeanUtils.copyProperties((Object)adTicketDto.getAdxConfDto(), (Object)adTicketAdx);
                adTicketAdx.setAdTicketId(ticketId);
                money = Money.ofYuan((double)adTicketDto.getAdxConfDto().getAdxPrice());
                adTicketAdx.setAdxPrice(Integer.valueOf(Long.valueOf(money.getLi()).intValue()));
                money1 = Money.ofYuan((double)adTicketDto.getAdxConfDto().getAdxBudgetDaily());
                adTicketAdx.setAdxBudgetDaily(Integer.valueOf(Long.valueOf(money1.getLi()).intValue()));
                this.adTicketAdxMapperExt.insert(adTicketAdx);
            }
            String assetsAdxArray = adTicketDto.getAdxConfDto().getAssetsAdxArray();
            if (StringUtils.isNotBlank((CharSequence)assetsAdxArray)) {
                List assetsAdxes = JSON.parseArray((String)assetsAdxArray, AdAssetsAdx.class);
                Short meituanReviewStatus = AdAssetsAdx.MEITUAN_REVIEW_WAIT;
                try {
                    if (this.isAdxMeituanReview(adTicketDto.getIsMeituanReview(), controlDto.getBanners()).booleanValue()) {
                        this.updater.hupdate(RedisKeys.getMeituanTicketRedisKey(), ticketId.toString(), (Object)(adTicketDto.getPrimaryIndustryId() + "," + adTicketDto.getSecondaryIndustryId()));
                        AdxMeituanReviewDto dto = new AdxMeituanReviewDto();
                        AdvertiserMainInfoVo advertiserMainInfo = this.adShopIntegration.getAdvertiserMainInfo(Integer.valueOf(adTicketDto.getAdvertiser().intValue()));
                        if (null != advertiserMainInfo) {
                            dto.setAdvertiserName(advertiserMainInfo.getCompany());
                            dto.setAdvertiserLicenseUrl(advertiserMainInfo.getBusinessLicenseImg());
                            dto.setDspAdvertiserId(adTicketDto.getAdvertiser());
                        }
                        adTicketDto.getPrimaryIndustryId();
                        adTicketDto.getSecondaryIndustryId();
                        AdAssetsAdx adAssetsAdx = (AdAssetsAdx)assetsAdxes.get(0);
                        dto.setImageUrl(adAssetsAdx.getCreativePicture());
                        dto.setLandingPage(adTicketDto.getUrl());
                        dto.setPrimaryIndustryId(adTicketDto.getPrimaryIndustryId());
                        dto.setSecondaryIndustryId(adTicketDto.getSecondaryIndustryId());
                        dto.setDspCreativeId(adAssetsAdx.getId().toString());
                        Boolean result = this.meituanReviewIntegration.sendReviewData(dto);
                        LOGGER.info("\u3010\u7f8e\u56e2\u9001\u5ba1\u5b8c\u6210\u3011 result\uff1a{}", (Object)result);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("\u7f8e\u56e2\u9001\u5ba1\u5f02\u5e38", (Throwable)e);
                    meituanReviewStatus = null;
                }
                for (AdAssetsAdx assetsAdx : assetsAdxes) {
                    assetsAdx.setAdTicketId(ticketId);
                    assetsAdx.setAdTicketAdxId(adTicketAdx.getId());
                    assetsAdx.setStatus(Short.valueOf(AdAssetsAdx.AdAssetsAdxStatus.STATUS_AUDIT_PASS.getStatus()));
                    if (this.isAdxMeituanReview(adTicketDto.getIsMeituanReview(), controlDto.getBanners()).booleanValue()) {
                        assetsAdx.setMeituanReviewStatus(meituanReviewStatus);
                        continue;
                    }
                    assetsAdx.setMeituanReviewStatus(assetsAdx.getMeituanReviewStatus());
                }
                List updateObjs = assetsAdxes.stream().filter(p -> p.getId() != null).collect(Collectors.toList());
                List addObjs = assetsAdxes.stream().filter(p -> p.getId() == null).collect(Collectors.toList());
                AdAssetsAdxExample adAssetsAdxExample = new AdAssetsAdxExample();
                adAssetsAdxExample.createCriteria().andAdTicketIdEqualTo(ticketId);
                List adAssetsAdxList = this.adAssetsAdxMapperExt.selectByExample(adAssetsAdxExample);
                if (CollectionUtils.isNotEmpty((Collection)adAssetsAdxList)) {
                    List oldIds = adAssetsAdxList.stream().map(AdAssetsAdx::getId).collect(Collectors.toList());
                    List needUpdateIds = updateObjs.stream().map(AdAssetsAdx::getId).collect(Collectors.toList());
                    oldIds.removeAll(needUpdateIds);
                    if (oldIds.size() > 0) {
                        this.adAssetsAdxMapperExt.deleteBatch(oldIds);
                    }
                }
                if (CollectionUtils.isNotEmpty(addObjs)) {
                    int n = this.adAssetsAdxMapperExt.insertBatch(addObjs);
                }
                if (CollectionUtils.isNotEmpty(updateObjs)) {
                    for (AdAssetsAdx updateVideo : updateObjs) {
                        int n = this.adAssetsAdxMapperExt.updateByPrimaryKey(updateVideo);
                    }
                }
            }
        }
        if (StringUtil.isNotBlank((CharSequence)adTicketDto.getPersonsGradeConf())) {
            this.adTicketPersonsGradeConfService.addBatch(adTicketDto.getPersonsGradeConf(), ticketId);
        }
        if (adTicketDto.getWeight() != null) {
            AdTicketWeightManualConf conf = new AdTicketWeightManualConf();
            conf.setCreateUser(userName);
            conf.setTicketId(ticketId);
            conf.setInterventionFactor(adTicketDto.getWeight());
            this.adTicketWeightManualConfMapper.insert(conf);
        }
        if (CommonConstant.Opera.Method.isEdit((CommonConstant.Opera.Method)method)) {
            this.processSettleTypeModify(adTicketDto, ticketId, userName, oldTicketInfo);
        }
        if (null != (ocpcConf = adTicketDto.getOcpcConf())) {
            if (null == ocpcConf.getTicketId()) {
                ocpcConf.setTicketId(ticketId);
            }
            this.adTicketOcpcService.update(ocpcConf.to());
        } else {
            this.adTicketOcpcService.deleteByTicketId(ticketId);
        }
        if (controlDto == null) {
            return;
        }
        if (StringUtil.isNotBlank((CharSequence)controlDto.getTimes())) {
            ruleValue = controlDto.getTimes();
            if (1 == adTicketDto.getSettleType() || 4 == adTicketDto.getSettleType() || 5 == adTicketDto.getSettleType()) {
                ruleValue = this.transformLiTimes(ruleValue);
            }
            this.adRulesService.add(ruleValue, ticketId, RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.SHIJIANDUAN.getValue());
        }
        if (StringUtil.isNotBlank((CharSequence)controlDto.getTimeBidding())) {
            ruleValue = controlDto.getTimeBidding();
            ruleValue = this.transformLiTimes(ruleValue);
            this.adRulesService.add(ruleValue, ticketId, RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.TIME_BIDDING.getValue());
        }
        if (StringUtil.isNotBlank((CharSequence)controlDto.getBanners())) {
            this.adRulesService.add(controlDto.getBanners(), ticketId, RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.GUANGGAOWEI.getValue());
        }
        if (StringUtil.isNotBlank((CharSequence)controlDto.getPersonsGrade())) {
            this.saveGetuiTagRef(controlDto, ticketId);
        }
        if (StringUtil.isNotBlank((CharSequence)controlDto.getFrequencys())) {
            this.adRulesService.add(controlDto.getFrequencys(), ticketId, RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.PINCI.getValue());
        }
        if (StringUtil.isNotBlank((CharSequence)controlDto.getNoimei())) {
            this.saveAdTicketOnoff(controlDto.getNoimei(), ticketId, 1);
        }
        if (StringUtil.isNotBlank((CharSequence)controlDto.getImeinomatching())) {
            this.saveAdTicketOnoff(controlDto.getImeinomatching(), ticketId, 2);
        }
        if (StringUtil.isNotBlank((CharSequence)controlDto.getCrowdPackage())) {
            this.adRulesService.add(controlDto.getCrowdPackage(), ticketId, RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.THIRD_PARTY_CROWD_PACKAGE.getValue());
        }
        if (StringUtil.isNotBlank((CharSequence)controlDto.getTicketPackage())) {
            this.adRulesService.add(controlDto.getTicketPackage(), ticketId, RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.TICKET_PACKAGE.getValue());
        }
        if (StringUtil.isNotBlank((CharSequence)controlDto.getAdxAppIdRule())) {
            this.adRulesService.add(controlDto.getAdxAppIdRule(), ticketId, RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.ADX_APP_ID.getValue());
        }
        if (StringUtil.isNotBlank((CharSequence)controlDto.getIsp())) {
            this.adRulesService.add(controlDto.getIsp(), ticketId, RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.ISP.getValue());
        }
        if (StringUtil.isNotBlank((CharSequence)controlDto.getNetworkType())) {
            this.adRulesService.add(controlDto.getNetworkType(), ticketId, RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.NETWORK_TYPE.getValue());
        }
        if (StringUtil.isNotBlank((CharSequence)controlDto.getAdQuality())) {
            this.adRulesService.add(controlDto.getAdQuality(), ticketId, RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.AD_QUALITY.getValue());
        }
        if (StringUtil.isNotBlank((CharSequence)controlDto.getActivityOrientation())) {
            this.adRulesService.add(controlDto.getActivityOrientation(), ticketId, RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.ACTIVITY_ORIENTATION.getValue());
        }
        if (StringUtil.isNotBlank((CharSequence)controlDto.getNewAndOldUsers())) {
            this.adRulesService.add(controlDto.getNewAndOldUsers(), ticketId, RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.NEW_AND_OLD_USERS.getValue());
        }
        if (StringUtil.isNotBlank((CharSequence)controlDto.getGetuiSex())) {
            this.adRulesService.add(controlDto.getGetuiSex(), ticketId, RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.GETUI_SEX.getValue());
        }
        if (StringUtil.isNotBlank((CharSequence)controlDto.getBesGender())) {
            this.adRulesService.add(controlDto.getBesGender(), ticketId, RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.BES_GENDER.getValue());
        }
        if (StringUtil.isNotBlank((CharSequence)controlDto.getBesAge())) {
            this.adRulesService.add(controlDto.getBesAge(), ticketId, RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.BES_AGE.getValue());
        }
        if (StringUtil.isNotBlank((CharSequence)controlDto.getPhoneBrand())) {
            this.adRulesService.add(controlDto.getPhoneBrand(), ticketId, RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.PHONE_BRAND.getValue());
        }
        if (StringUtil.isNotBlank((CharSequence)controlDto.getAdxAPPEntranceRule())) {
            this.adRulesService.add(controlDto.getAdxAPPEntranceRule(), ticketId, RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.ADX_ENTRANCE.getValue());
        }
        if (StringUtil.isNotBlank((CharSequence)controlDto.getAppIdPackage())) {
            this.adRulesService.add(controlDto.getAppIdPackage(), ticketId, RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.APP_ID_PACKAGE.getValue());
        }
        if (StringUtil.isNotBlank((CharSequence)controlDto.getAdxTagIdRule())) {
            this.adRulesService.add(controlDto.getAdxTagIdRule(), ticketId, RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.ADX_TAG_ID.getValue());
        }
        if (StringUtil.isNotBlank((CharSequence)controlDto.getCountry())) {
            this.adRulesService.add(controlDto.getCountry(), ticketId, RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.COUNTRY.getValue());
        }
        if (StringUtil.isNotBlank((CharSequence)controlDto.getBaiduLookLikeRule())) {
            this.adRulesService.add(controlDto.getBaiduLookLikeRule(), ticketId, RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.BAIDU_LOOK_LIKE.getValue());
        }
        ArrayList<Long> packageIds = new ArrayList();
        ArrayList<AdFlowPackageNewDto> packages = new ArrayList();
        if (StringUtil.isNotEmpty((CharSequence)adTicketDto.getFlowPackageIdArray())) {
            packageIds = JSON.parseArray((String)adTicketDto.getFlowPackageIdArray(), Long.class);
        }
        if (StringUtil.isNotEmpty((CharSequence)adTicketDto.getFlowPackageArray())) {
            packages = JSON.parseArray((String)adTicketDto.getFlowPackageArray(), AdFlowPackageNewDto.class);
        }
        this.adTicketFlowNewService.dealPackage(packageIds, ticketId, packages, userName);
        List adTicketPositionTimesLimitConfigVos = Collections.emptyList();
        if (StringUtil.isNotEmpty((CharSequence)adTicketDto.getPositionTimesLimitConfig())) {
            adTicketPositionTimesLimitConfigVos = JSON.parseArray((String)adTicketDto.getPositionTimesLimitConfig(), AdTicketPositionTimesLimitConfigVo.class);
        }
        this.adTicketPositionTimesLimitConfigService.save(platform, method, adTicketPositionTimesLimitConfigVos, ticketId, userName);
        if (AdTicket.AdTicketType.isNotAdx((Short)adTicketType.getType()) && null != adTicketDto.getTicketAppExtendDto()) {
            AdTicketAppExtendExample example = new AdTicketAppExtendExample();
            example.createCriteria().andTicketIdEqualTo(ticketId);
            List adTicketAppExtends = this.adTicketAppExtendMapperExt.selectByExample(example);
            AdTicketAppExtend adTicketAppExtend = null;
            if (CollectionUtils.isNotEmpty((Collection)adTicketAppExtends)) {
                adTicketAppExtend = (AdTicketAppExtend)adTicketAppExtends.get(0);
                this.setTicketAppExtendInfo(adTicketDto, ticketId, adTicketType, adTicketAppExtend);
                this.adTicketAppExtendMapperExt.updateByPrimaryKey(adTicketAppExtend);
            } else {
                adTicketAppExtend = new AdTicketAppExtend();
                this.setTicketAppExtendInfo(adTicketDto, ticketId, adTicketType, adTicketAppExtend);
                this.adTicketAppExtendMapperExt.insert(adTicketAppExtend);
            }
        }
        this.saveDirectChasePrice(ticketId, adTicketDto, userName);
    }

    private void setTicketAppExtendInfo(AdTicketDto adTicketDto, Long ticketId, AdTicket.AdTicketType adTicketType, AdTicketAppExtend adTicketAppExtend) {
        AdTicketDto.TicketAppExtendDto ticketAppExtendDto = adTicketDto.getTicketAppExtendDto();
        BeanUtils.copyProperties((Object)ticketAppExtendDto, (Object)adTicketAppExtend);
        adTicketAppExtend.setTicketId(ticketId);
        adTicketAppExtend.setAppPackageRule(adTicketDto.getControlDto().getAppPackageRule());
        if (AdTicket.AdTicketType.TYPE_ACTIVITY == adTicketType || AdTicket.AdTicketType.TYPE_DIRECT == adTicketType) {
            Money adxPriceMoney = Money.ofYuan((double)ticketAppExtendDto.getAdxPrice());
            adTicketAppExtend.setAdxPrice(Integer.valueOf(Long.valueOf(adxPriceMoney.getLi()).intValue()));
            Money adxBudgetDailyMoney = Money.ofYuan((double)ticketAppExtendDto.getAdxBudgetDaily());
            adTicketAppExtend.setAdxBudgetDaily(Integer.valueOf(Long.valueOf(adxBudgetDailyMoney.getLi()).intValue()));
            Double adxTargetCpa = ticketAppExtendDto.getAdxTargetCpa();
            if (Objects.nonNull(adxTargetCpa)) {
                Money adxTargetCpaMoney = Money.ofYuan((double)adxTargetCpa);
                adTicketAppExtend.setAdxTargetCpa(Integer.valueOf(Long.valueOf(adxTargetCpaMoney.getLi()).intValue()));
            } else {
                adTicketAppExtend.setAdxTargetCpa(null);
            }
            adTicketAppExtend.setAdxPriceType(ticketAppExtendDto.getAdxPriceType());
            adTicketAppExtend.setDeviceOrientation((String)StringUtils.defaultIfBlank((CharSequence)adTicketAppExtend.getDeviceOrientation(), (CharSequence)"1"));
            Double tbWaresDetailRate = ticketAppExtendDto.getTbWaresDetailRate();
            if (Objects.nonNull(tbWaresDetailRate)) {
                int tbWaresDetailRateInt = BigDecimal.valueOf(tbWaresDetailRate).movePointRight(2).setScale(0, RoundingMode.HALF_UP).intValue();
                adTicketAppExtend.setTbWaresDetailRate(Integer.valueOf(tbWaresDetailRateInt));
            } else {
                adTicketAppExtend.setTbWaresDetailRate(null);
            }
            Double tbFirstCallAndWaresDetailRate = ticketAppExtendDto.getTbFirstCallAndWaresDetailRate();
            if (Objects.nonNull(tbFirstCallAndWaresDetailRate)) {
                int tbFirstCallAndWaresDetailRateInt = BigDecimal.valueOf(tbFirstCallAndWaresDetailRate).movePointRight(2).setScale(0, RoundingMode.HALF_UP).intValue();
                adTicketAppExtend.setTbFirstCallAndWaresDetailRate(Integer.valueOf(tbFirstCallAndWaresDetailRateInt));
            } else {
                adTicketAppExtend.setTbFirstCallAndWaresDetailRate(null);
            }
            Double roiCoefficient = ticketAppExtendDto.getRoiCoefficient();
            if (Objects.nonNull(roiCoefficient)) {
                int roiCoefficientInt = BigDecimal.valueOf(roiCoefficient).movePointRight(2).setScale(0, RoundingMode.HALF_UP).intValue();
                adTicketAppExtend.setRoiCoefficient(Integer.valueOf(roiCoefficientInt));
            } else {
                adTicketAppExtend.setRoiCoefficient(null);
            }
            Double adxAppRvCover = ticketAppExtendDto.getAdxAppRvCover();
            if (Objects.nonNull(adxAppRvCover)) {
                int adxAppRvCoverInt = BigDecimal.valueOf(adxAppRvCover).movePointRight(1).setScale(0, RoundingMode.HALF_UP).intValue();
                adTicketAppExtend.setAdxAppRvCover(Integer.valueOf(adxAppRvCoverInt));
            } else {
                adTicketAppExtend.setAdxAppRvCover(null);
            }
        }
    }

    private void saveGetuiTagRef(AdTicketDto.ControlDto controlDto, Long ticketId) {
        String[] split;
        ArrayList<AdTicketGetuiTagRef> adTicketGetuiTagRefs = new ArrayList<AdTicketGetuiTagRef>();
        for (String tagGroupConf : split = controlDto.getPersonsGrade().split(",")) {
            String[] tagGroupConfArray;
            String tagGroupCode;
            if (!StringUtils.isNotBlank((CharSequence)tagGroupConf) || !StringUtils.isNotBlank((CharSequence)(tagGroupCode = (tagGroupConfArray = tagGroupConf.split("-"))[0]))) continue;
            AdTicketGetuiTagRef adTicketGetuiTagRef = new AdTicketGetuiTagRef();
            adTicketGetuiTagRef.setTicketId(ticketId);
            adTicketGetuiTagRef.setTagGroupCode(tagGroupCode);
            String tagGroupValue = tagGroupConf.replace(tagGroupCode + "-", "").replace("-", ",");
            adTicketGetuiTagRef.setTagGroupValue(tagGroupValue);
            adTicketGetuiTagRefs.add(adTicketGetuiTagRef);
        }
        if (CollectionUtils.isNotEmpty(adTicketGetuiTagRefs)) {
            this.adTicketGetuiTagRefMapperExt.insertBatch(adTicketGetuiTagRefs);
        }
    }

    public Map<String, Rule> getRuleMap(AdTicketDto adTicketDto, BigInteger ticketId) {
        Rule rule;
        String ruleValue;
        Rule rule2;
        AdTicketDto.ControlDto controlDto;
        Rule rule3;
        HashMap<String, Rule> ruleMap = new HashMap<String, Rule>();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{adTicketDto.getCitys()})) {
            rule3 = new Rule();
            rule3.setRuleType(Integer.valueOf(RuleTypeEnum.DIYUXIANZHI.getValue()));
            rule3.setRuleValue(adTicketDto.getCitys());
            rule3.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule3.setTargetId(ticketId);
            ruleMap.put("region", rule3);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{adTicketDto.getIpLibrary()})) {
            rule3 = new Rule();
            rule3.setRuleType(Integer.valueOf(RuleTypeEnum.IPLIB.getValue()));
            rule3.setRuleValue(adTicketDto.getIpLibrary());
            rule3.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule3.setTargetId(ticketId);
            ruleMap.put("ipLib", rule3);
        }
        if ((controlDto = adTicketDto.getControlDto()) == null) {
            return ruleMap;
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{controlDto.getTimes()})) {
            rule2 = new Rule();
            ruleValue = controlDto.getTimes();
            if (1 == adTicketDto.getSettleType() || 4 == adTicketDto.getSettleType() || 5 == adTicketDto.getSettleType()) {
                ruleValue = this.transformLiTimes(ruleValue);
            }
            rule2.setRuleType(Integer.valueOf(RuleTypeEnum.SHIJIANDUAN.getValue()));
            rule2.setRuleValue(ruleValue);
            rule2.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule2.setTargetId(ticketId);
            ruleMap.put("timeline", rule2);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{controlDto.getTimeBidding()})) {
            rule2 = new Rule();
            ruleValue = controlDto.getTimeBidding();
            ruleValue = this.transformLiTimes(ruleValue);
            rule2.setRuleType(Integer.valueOf(RuleTypeEnum.TIME_BIDDING.getValue()));
            rule2.setRuleValue(ruleValue);
            rule2.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule2.setTargetId(ticketId);
            ruleMap.put("timeBidding", rule2);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{controlDto.getBanners()})) {
            rule2 = new Rule();
            rule2.setRuleType(Integer.valueOf(RuleTypeEnum.GUANGGAOWEI.getValue()));
            rule2.setRuleValue(controlDto.getBanners());
            rule2.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule2.setTargetId(ticketId);
            ruleMap.put("position", rule2);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{controlDto.getFrequencys()})) {
            rule2 = new Rule();
            rule2.setRuleType(Integer.valueOf(RuleTypeEnum.PINCI.getValue()));
            rule2.setRuleValue(controlDto.getFrequencys());
            rule2.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule2.setTargetId(ticketId);
            ruleMap.put("times", rule2);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{controlDto.getCrowdPackage()})) {
            rule2 = new Rule();
            rule2.setRuleType(Integer.valueOf(RuleTypeEnum.THIRD_PARTY_CROWD_PACKAGE.getValue()));
            rule2.setRuleValue(controlDto.getCrowdPackage());
            rule2.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule2.setTargetId(ticketId);
            ruleMap.put("crowdPackage", rule2);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{controlDto.getTicketPackage()})) {
            rule2 = new Rule();
            rule2.setRuleType(Integer.valueOf(RuleTypeEnum.TICKET_PACKAGE.getValue()));
            rule2.setRuleValue(controlDto.getTicketPackage());
            rule2.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule2.setTargetId(ticketId);
            ruleMap.put("ticketPackage", rule2);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{controlDto.getIsp()})) {
            rule2 = new Rule();
            rule2.setRuleType(Integer.valueOf(RuleTypeEnum.ISP.getValue()));
            rule2.setRuleValue(controlDto.getIsp());
            rule2.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule2.setTargetId(ticketId);
            ruleMap.put("isp", rule2);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{controlDto.getNetworkType()})) {
            rule2 = new Rule();
            rule2.setRuleType(Integer.valueOf(RuleTypeEnum.NETWORK_TYPE.getValue()));
            rule2.setRuleValue(controlDto.getNetworkType());
            rule2.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule2.setTargetId(ticketId);
            ruleMap.put("networkType", rule2);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{controlDto.getAdQuality()})) {
            rule2 = new Rule();
            rule2.setRuleType(Integer.valueOf(RuleTypeEnum.AD_QUALITY.getValue()));
            rule2.setRuleValue(controlDto.getAdQuality());
            rule2.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule2.setTargetId(ticketId);
            ruleMap.put("adQuality", rule2);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{controlDto.getActivityOrientation()})) {
            rule2 = new Rule();
            rule2.setRuleType(Integer.valueOf(RuleTypeEnum.ACTIVITY_ORIENTATION.getValue()));
            rule2.setRuleValue(controlDto.getActivityOrientation());
            rule2.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule2.setTargetId(ticketId);
            ruleMap.put("activityOrientation", rule2);
        }
        List packages = new ArrayList();
        if (StringUtil.isNotEmpty((CharSequence)adTicketDto.getFlowPackageArray())) {
            packages = JSON.parseArray((String)adTicketDto.getFlowPackageArray(), AdFlowPackageNewDto.class);
        }
        if (CollectionUtils.isNotEmpty(packages)) {
            StringBuffer sb = new StringBuffer();
            Rule rule4 = new Rule();
            rule4.setRuleType(Integer.valueOf(RuleTypeEnum.FLOWPACKAGE.getValue()));
            for (AdFlowPackageNewDto packageNewDto : packages) {
                String price;
                String quota = packageNewDto.getQuota();
                if (!"infinity".equalsIgnoreCase(quota) && StringUtil.isNotEmpty((CharSequence)quota)) {
                    if (1 == adTicketDto.getSettleType() || 4 == adTicketDto.getSettleType() || 5 == adTicketDto.getSettleType()) {
                        Money money = Money.ofYuan((double)Double.valueOf(quota));
                        quota = money.getLi() + "|";
                    }
                } else {
                    quota = "0|";
                }
                if (StringUtil.isNotEmpty((CharSequence)(price = packageNewDto.getPrice()))) {
                    Money money = Money.ofYuan((double)Double.valueOf(price));
                    price = money.getLi() + "|";
                }
                AdFlowPackage adFlow = this.adFlowPackageMapper.findById(packageNewDto.getFlowPackageId().toString());
                sb.append(packageNewDto.getFlowPackageId() + "|" + quota + price + adFlow.getPositionId().replaceAll(",", "^"));
                sb.append("|" + packageNewDto.getCpaPrice() + "|" + packageNewDto.getDeepCpaPrice());
                sb.append(",");
            }
            rule4.setRuleValue(sb.toString().substring(0, sb.toString().length() - 1));
            rule4.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule4.setTargetId(ticketId);
            ruleMap.put("positionGroup", rule4);
        }
        if (StringUtils.isNotBlank((CharSequence)controlDto.getAppPackageRule())) {
            rule = new Rule();
            rule.setRuleType(Integer.valueOf(RuleTypeEnum.APP_PACKAGE.getValue()));
            rule.setRuleValue(controlDto.getAppPackageRule());
            rule.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule.setTargetId(ticketId);
            ruleMap.put("appPackage", rule);
        }
        if (adTicketDto.getTicketAppExtendDto() != null && StringUtils.isNotBlank((CharSequence)adTicketDto.getTicketAppExtendDto().getMediaAppPackageRule())) {
            rule = new Rule();
            rule.setRuleType(Integer.valueOf(RuleTypeEnum.MEDIA_APP_PACKAGE.getValue()));
            rule.setRuleValue(adTicketDto.getTicketAppExtendDto().getMediaAppPackageRule());
            rule.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule.setTargetId(ticketId);
            ruleMap.put("mediaAppPackage", rule);
        }
        if (StringUtils.isNotBlank((CharSequence)controlDto.getAdxAppIdRule())) {
            rule = new Rule();
            rule.setRuleType(Integer.valueOf(RuleTypeEnum.ADX_APP_ID.getValue()));
            rule.setRuleValue(controlDto.getAdxAppIdRule());
            rule.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule.setTargetId(ticketId);
            ruleMap.put("adxAppId", rule);
        }
        if (StringUtils.isNotBlank((CharSequence)controlDto.getNewAndOldUsers())) {
            rule = new Rule();
            rule.setRuleType(Integer.valueOf(RuleTypeEnum.NEW_AND_OLD_USERS.getValue()));
            rule.setRuleValue(controlDto.getNewAndOldUsers());
            rule.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule.setTargetId(ticketId);
            ruleMap.put("newAndOldUsers", rule);
        }
        if (StringUtils.isNotBlank((CharSequence)controlDto.getGetuiSex())) {
            rule = new Rule();
            rule.setRuleType(Integer.valueOf(RuleTypeEnum.GETUI_SEX.getValue()));
            rule.setRuleValue(controlDto.getGetuiSex());
            rule.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule.setTargetId(ticketId);
            ruleMap.put("getuiSex", rule);
        }
        if (StringUtils.isNotBlank((CharSequence)controlDto.getBesGender())) {
            rule = new Rule();
            rule.setRuleType(Integer.valueOf(RuleTypeEnum.BES_GENDER.getValue()));
            rule.setRuleValue(controlDto.getBesGender());
            rule.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule.setTargetId(ticketId);
            ruleMap.put("besGender", rule);
        }
        if (StringUtils.isNotBlank((CharSequence)controlDto.getBesAge())) {
            rule = new Rule();
            rule.setRuleType(Integer.valueOf(RuleTypeEnum.BES_AGE.getValue()));
            rule.setRuleValue(controlDto.getBesAge());
            rule.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule.setTargetId(ticketId);
            ruleMap.put("besAge", rule);
        }
        if (StringUtils.isNotBlank((CharSequence)controlDto.getPhoneBrand())) {
            rule = new Rule();
            rule.setRuleType(Integer.valueOf(RuleTypeEnum.PHONE_BRAND.getValue()));
            rule.setRuleValue(controlDto.getPhoneBrand());
            rule.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule.setTargetId(ticketId);
            ruleMap.put("phoneBrand", rule);
        }
        if (StringUtils.isNotBlank((CharSequence)controlDto.getAdxAPPEntranceRule())) {
            rule = new Rule();
            rule.setRuleType(Integer.valueOf(RuleTypeEnum.ADX_ENTRANCE.getValue()));
            rule.setRuleValue(controlDto.getAdxAPPEntranceRule());
            rule.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule.setTargetId(ticketId);
            ruleMap.put("adxAPPEntrance", rule);
        }
        if (StringUtils.isNotBlank((CharSequence)controlDto.getAppIdPackage())) {
            rule = new Rule();
            rule.setRuleType(Integer.valueOf(RuleTypeEnum.APP_ID_PACKAGE.getValue()));
            rule.setRuleValue(controlDto.getAppIdPackage());
            rule.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule.setTargetId(ticketId);
            ruleMap.put("appIdPackage", rule);
        }
        if (StringUtils.isNotBlank((CharSequence)controlDto.getAdxTagIdRule())) {
            rule = new Rule();
            rule.setRuleType(Integer.valueOf(RuleTypeEnum.ADX_TAG_ID.getValue()));
            rule.setRuleValue(controlDto.getAdxTagIdRule());
            rule.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule.setTargetId(ticketId);
            ruleMap.put("adxTagIdRule", rule);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{controlDto.getCountry()})) {
            rule = new Rule();
            rule.setRuleType(Integer.valueOf(RuleTypeEnum.COUNTRY.getValue()));
            rule.setRuleValue(controlDto.getCountry());
            rule.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule.setTargetId(ticketId);
            ruleMap.put("country", rule);
        }
        if (StringUtils.isNotBlank((CharSequence)controlDto.getBaiduLookLikeRule())) {
            rule = new Rule();
            rule.setRuleType(Integer.valueOf(RuleTypeEnum.BAIDU_LOOK_LIKE.getValue()));
            rule.setRuleValue(controlDto.getBaiduLookLikeRule());
            rule.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule.setTargetId(ticketId);
            ruleMap.put("baiduLookLikeRule", rule);
        }
        return ruleMap;
    }

    @Override
    public AdTicketVo findById(Long id) throws Exception {
        AdTicketVo adTicketVo = new AdTicketVo();
        AdTicketVo.ControlVo controlVo = new AdTicketVo.ControlVo();
        AdTicket adTicket = this.adTicketMapper.selectByPrimaryKey(id);
        if (adTicket == null) {
            throw new ValidateException("\u6839\u636eid\u6ca1\u6709\u67e5\u627e\u5230\u5e7f\u544a\u5238");
        }
        BeanUtils.copyProperties((Object)adTicket, (Object)adTicketVo);
        adTicketVo.setId(Integer.valueOf(adTicket.getId().intValue()));
        if (null != adTicket.getAdvertiser()) {
            adTicketVo.setAdvertiserName(this.getAdvertiserName(adTicket.getAdvertiser().toString()));
        }
        adTicketVo.setPrice(Double.valueOf(adTicket.getPrice().doubleValue() / 1000.0));
        if (1 == adTicket.getSettleType() || 4 == adTicket.getSettleType() || 5 == adTicket.getSettleType()) {
            adTicketVo.setBudgetDaily(Double.valueOf(adTicket.getBudgetDaily().doubleValue() / 1000.0));
        } else {
            adTicketVo.setBudgetDaily(Double.valueOf(adTicket.getBudgetDaily().doubleValue()));
        }
        String adTags = this.adTicketTagConfService.findByTicketId(adTicket.getId());
        adTicketVo.setTags(adTags);
        String citys = this.adRulesService.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.DIYUXIANZHI.getValue(), adTicket.getId());
        String ipLibrary = this.adRulesService.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.IPLIB.getValue(), adTicket.getId());
        if (StringUtils.isNotBlank((CharSequence)citys)) {
            adTicketVo.setCitys(citys);
        } else {
            adTicketVo.setIpLibrary(ipLibrary);
        }
        String oss = this.adTicketOsConfSerive.findByTicketId(adTicket.getId());
        adTicketVo.setOss(oss);
        AdTicket.AdTicketType adTicketType = AdTicket.AdTicketType.getByType((Short)adTicketVo.getType());
        if (AdTicket.AdTicketType.TYPE_NORMALS == adTicketType || AdTicket.AdTicketType.TYPE_STANDBYS == adTicketType || AdTicket.AdTicketType.TYPE_ENCOURAGE == adTicketType || AdTicket.AdTicketType.TYPE_DSP == adTicketType || AdTicket.AdTicketType.TYPE_RTA == adTicketType || AdTicket.AdTicketType.TYPE_PUSH == adTicketType) {
            String assetsids = this.adTicketAssetsRefService.findByTicketId(adTicket.getId());
            adTicketVo.setAssetsids(assetsids);
        }
        List<AdTicketPersonsGradeConf> list = this.adTicketPersonsGradeConfService.findByTicketId(adTicket.getId());
        adTicketVo.setPersonsGradeConf(JSONArray.toJSONString(list, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        Double weight = this.adTicketWeightManualConfMapper.findByTicketId(adTicket.getId());
        adTicketVo.setWeight(weight);
        String times = this.adRulesService.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.SHIJIANDUAN.getValue(), adTicket.getId());
        if (1 == adTicket.getSettleType() || 4 == adTicket.getSettleType() || 5 == adTicket.getSettleType()) {
            times = this.transformYuanTimes(times);
        }
        controlVo.setTimes(times);
        String timeBidding = this.adRulesService.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.TIME_BIDDING.getValue(), adTicket.getId());
        timeBidding = this.transformYuanTimes(timeBidding);
        controlVo.setTimeBidding(timeBidding);
        String banners = this.adRulesService.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.GUANGGAOWEI.getValue(), adTicket.getId());
        controlVo.setBanners(banners);
        List<AdTicketGetuiTagRef> adTicketGetuiTagRefList = this.adTicketGetuiTagRefService.findAll(adTicket.getId());
        controlVo.setPersonsGrade(JSONArray.toJSONString(adTicketGetuiTagRefList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        String frequencys = this.adRulesService.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.PINCI.getValue(), adTicket.getId());
        controlVo.setFrequencys(frequencys);
        String noimei = this.adTicketOnoffService.findByTicketId(adTicket.getId(), 1);
        controlVo.setNoimei(noimei);
        String imeinomatching = this.adTicketOnoffService.findByTicketId(adTicket.getId(), 2);
        controlVo.setImeinomatching(imeinomatching);
        String crowdPackage = this.adRulesService.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.THIRD_PARTY_CROWD_PACKAGE.getValue(), adTicket.getId());
        controlVo.setCrowdPackage(crowdPackage);
        String ticketPackage = this.adRulesService.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.TICKET_PACKAGE.getValue(), adTicket.getId());
        controlVo.setTicketPackage(ticketPackage);
        String isp = this.adRulesService.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.ISP.getValue(), adTicket.getId());
        controlVo.setIsp(isp);
        String adxAppIdRule = this.adRulesService.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.ADX_APP_ID.getValue(), adTicket.getId());
        controlVo.setAdxAppIdRule(adxAppIdRule);
        String networkType = this.adRulesService.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.NETWORK_TYPE.getValue(), adTicket.getId());
        controlVo.setNetworkType(networkType);
        String adQuality = this.adRulesService.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.AD_QUALITY.getValue(), adTicket.getId());
        controlVo.setAdQuality(adQuality);
        String activityOrientation = this.adRulesService.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.ACTIVITY_ORIENTATION.getValue(), adTicket.getId());
        controlVo.setActivityOrientation(activityOrientation);
        String newAndOldUsers = this.adRulesService.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.NEW_AND_OLD_USERS.getValue(), adTicket.getId());
        controlVo.setNewAndOldUsers(newAndOldUsers);
        String getuiSex = this.adRulesService.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.GETUI_SEX.getValue(), adTicket.getId());
        controlVo.setGetuiSex(getuiSex);
        String besGender = this.adRulesService.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.BES_GENDER.getValue(), adTicket.getId());
        controlVo.setBesGender(besGender);
        String besAge = this.adRulesService.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.BES_AGE.getValue(), adTicket.getId());
        controlVo.setBesAge(besAge);
        String phoneBrand = this.adRulesService.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.PHONE_BRAND.getValue(), adTicket.getId());
        controlVo.setPhoneBrand(phoneBrand);
        String adxAPPEntranceRule = this.adRulesService.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.ADX_ENTRANCE.getValue(), adTicket.getId());
        controlVo.setAdxAPPEntranceRule(adxAPPEntranceRule);
        String appIdPackage = this.adRulesService.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.APP_ID_PACKAGE.getValue(), adTicket.getId());
        controlVo.setAppIdPackage(appIdPackage);
        String adxTagIdRule = this.adRulesService.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.ADX_TAG_ID.getValue(), adTicket.getId());
        controlVo.setAdxTagIdRule(adxTagIdRule);
        String country = this.adRulesService.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.COUNTRY.getValue(), adTicket.getId());
        controlVo.setCountry(country);
        String baiduLookLikeRule = this.adRulesService.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.BAIDU_LOOK_LIKE.getValue(), adTicket.getId());
        controlVo.setBaiduLookLikeRule(baiduLookLikeRule);
        adTicketVo.setControlVo(controlVo);
        AdTicketOcpcConf ocpcConf = this.adTicketOcpcService.selectByTicketId(adTicket.getId());
        adTicketVo.setOcpcConf(AdTicketVo.OcpcConfVo.of((AdTicketOcpcConf)ocpcConf));
        adTicketVo.setIsGroup(Boolean.valueOf(adTicketVo.getGroupId() != null));
        List<AdTicketFlowPackageOfferConfVo> flowPackageArrayConfs = this.adTicketFlowPackageOfferConfService.findFlowPackageConfs(adTicketVo.getId().longValue(), adTicketVo.getSettleType() == null ? "cpc" : adTicketVo.getSettleType().toString());
        adTicketVo.setFlowPackageArrayConfs(flowPackageArrayConfs);
        List<AdFlowPackageNewVo> packages = this.adTicketFlowNewService.findPackageByCondition(adTicketVo.getId().longValue(), adTicketVo.getSettleType() == null ? "cpc" : adTicketVo.getSettleType().toString());
        adTicketVo.setAdFlows(packages);
        List<AdTicketPositionTimesLimitConfigVo> adTicketPositionTimesLimitConfigVos = this.adTicketPositionTimesLimitConfigService.findByTicketId(adTicketVo.getId().longValue());
        adTicketVo.setPositionTimesLimitConfig(adTicketPositionTimesLimitConfigVos);
        this.fillDirectChasePrice(adTicketVo);
        String isPackage = "2";
        if (CollectionUtils.isNotEmpty(packages)) {
            isPackage = "1";
        }
        if (CollectionUtils.isNotEmpty(adTicketPositionTimesLimitConfigVos)) {
            isPackage = "3";
        }
        controlVo.setIsPackage(isPackage);
        adTicketVo.setControlVo(controlVo);
        if (AdTicket.AdTicketType.TYPE_COUPON == adTicketType) {
            List<AdAssetsCoupons> adAssetsCouponsList = this.adTicketAssetsCouponsService.findByTicketId(adTicket.getId());
            if (CollectionUtils.isNotEmpty(adAssetsCouponsList)) {
                StringBuffer adAssetsCouponsIds = new StringBuffer();
                for (int i = 0; i < adAssetsCouponsList.size(); ++i) {
                    if (i == adAssetsCouponsList.size() - 1) {
                        adAssetsCouponsIds.append(adAssetsCouponsList.get(i).getId());
                        continue;
                    }
                    adAssetsCouponsIds.append(adAssetsCouponsList.get(i).getId()).append(",");
                }
                adTicketVo.setAssetscouponsids(adAssetsCouponsIds.toString());
            }
            AdTicketCouponsInfo adTicketCouponsInfo = this.adTicketCouponsInfoService.findByTicketId(adTicket.getId());
            AdTicketVo.CouponsInfoVo couponsInfoVo = new AdTicketVo.CouponsInfoVo();
            BeanUtils.copyProperties((Object)adTicketCouponsInfo, (Object)couponsInfoVo);
            List<AdTicketCouponsCodeStatusNumDto> codeStatusNumDtoList = this.adTicketCouponsCodeService.findStatusNumByTicketId(adTicket.getId());
            couponsInfoVo.setCodeUnusedNum(Integer.valueOf(0));
            couponsInfoVo.setCodeReceivedNum(Integer.valueOf(0));
            couponsInfoVo.setCodeUsedNum(Integer.valueOf(0));
            if (CollectionUtils.isNotEmpty(codeStatusNumDtoList)) {
                for (AdTicketCouponsCodeStatusNumDto adTicketCouponsCodeStatusNumDto : codeStatusNumDtoList) {
                    if (adTicketCouponsCodeStatusNumDto.getStatus().equals(AdTicketCouponsCode.AdCouponsStatus.STATUS_UNUSED.getStatus())) {
                        couponsInfoVo.setCodeUnusedNum(adTicketCouponsCodeStatusNumDto.getNum());
                        continue;
                    }
                    if (adTicketCouponsCodeStatusNumDto.getStatus().equals(AdTicketCouponsCode.AdCouponsStatus.STATUS_RECEIVED.getStatus())) {
                        couponsInfoVo.setCodeReceivedNum(adTicketCouponsCodeStatusNumDto.getNum());
                        continue;
                    }
                    if (!adTicketCouponsCodeStatusNumDto.getStatus().equals(AdTicketCouponsCode.AdCouponsStatus.STATUS_USED.getStatus())) continue;
                    couponsInfoVo.setCodeUsedNum(adTicketCouponsCodeStatusNumDto.getNum());
                }
            }
            adTicketVo.setCouponsInfoVo(couponsInfoVo);
        }
        if (AdTicket.AdTicketType.TYPE_ADX_DIRECT == adTicketType || AdTicket.AdTicketType.TYPE_ADX_INTERACT == adTicketType) {
            AdTicketAdxExample adTicketAdxExample = new AdTicketAdxExample();
            adTicketAdxExample.createCriteria().andAdTicketIdEqualTo(adTicket.getId());
            List adTicketAdxes = this.adTicketAdxMapperExt.selectByExample(adTicketAdxExample);
            if (CollectionUtils.isNotEmpty((Collection)adTicketAdxes)) {
                AdTicketAdx adTicketAdx = (AdTicketAdx)adTicketAdxes.get(0);
                AdTicketVo.AdxConfVo adxConfVo = new AdTicketVo.AdxConfVo();
                BeanUtils.copyProperties((Object)adTicketAdx, (Object)adxConfVo);
                if (AdTicket.AdTicketType.TYPE_ADX_DIRECT == adTicketType) {
                    adxConfVo.setAdxPrice(Double.valueOf(adTicketAdx.getAdxPrice().doubleValue() / 1000.0));
                    adxConfVo.setAdxBudgetDaily(Double.valueOf(adTicketAdx.getAdxBudgetDaily().doubleValue() / 1000.0));
                    String tags = (String)this.fetcher.hfetch(RedisKeys.getMeituanTicketRedisKey(), adTicket.getId().toString(), String.class);
                    if (StringUtils.isNotBlank((CharSequence)tags) && StringUtils.contains((CharSequence)tags, (CharSequence)",")) {
                        String[] split = tags.split(",");
                        adxConfVo.setPrimaryIndustryId(split[0]);
                        adxConfVo.setSecondaryIndustryId(split[1]);
                    }
                }
                adTicketVo.setAdxConfVo(adxConfVo);
            }
            AdAssetsAdxExample adAssetsAdxExample = new AdAssetsAdxExample();
            adAssetsAdxExample.createCriteria().andAdTicketIdEqualTo(adTicket.getId());
            List adAssetsAdxList = this.adAssetsAdxMapperExt.selectByExample(adAssetsAdxExample);
            if (CollectionUtils.isNotEmpty((Collection)adAssetsAdxList)) {
                StringBuffer assetsadxids = new StringBuffer();
                for (int i = 0; i < adAssetsAdxList.size(); ++i) {
                    if (i == adAssetsAdxList.size() - 1) {
                        assetsadxids.append(((AdAssetsAdx)adAssetsAdxList.get(i)).getId());
                        continue;
                    }
                    assetsadxids.append(((AdAssetsAdx)adAssetsAdxList.get(i)).getId()).append(",");
                }
                adTicketVo.setAssetsadxids(assetsadxids.toString());
            }
        }
        AdTicketAppExtendExample adTicketAppExtendExample = new AdTicketAppExtendExample();
        adTicketAppExtendExample.createCriteria().andTicketIdEqualTo(adTicket.getId());
        List adTicketAppExtends = this.adTicketAppExtendMapperExt.selectByExample(adTicketAppExtendExample);
        if (CollectionUtils.isNotEmpty((Collection)adTicketAppExtends)) {
            AdTicketAppExtend adTicketAppExtend = (AdTicketAppExtend)adTicketAppExtends.get(0);
            AdTicketVo.TicketAppExtendVo ticketAppExtendVo = new AdTicketVo.TicketAppExtendVo();
            BeanUtils.copyProperties((Object)adTicketAppExtend, (Object)ticketAppExtendVo);
            if (adTicketAppExtend.getAdxPrice() != null) {
                ticketAppExtendVo.setAdxPrice(Double.valueOf(adTicketAppExtend.getAdxPrice().doubleValue() / 1000.0));
            }
            if (adTicketAppExtend.getAdxBudgetDaily() != null) {
                ticketAppExtendVo.setAdxBudgetDaily(Double.valueOf(adTicketAppExtend.getAdxBudgetDaily().doubleValue() / 1000.0));
            }
            if (adTicketAppExtend.getAdxTargetCpa() != null) {
                ticketAppExtendVo.setAdxTargetCpa(Double.valueOf(adTicketAppExtend.getAdxTargetCpa().doubleValue() / 1000.0));
            }
            ticketAppExtendVo.setAdxPriceType(adTicketAppExtend.getAdxPriceType());
            if (adTicketAppExtend.getTbWaresDetailRate() != null) {
                ticketAppExtendVo.setTbWaresDetailRate(Double.valueOf(adTicketAppExtend.getTbWaresDetailRate().doubleValue() / 100.0));
            }
            if (adTicketAppExtend.getTbFirstCallAndWaresDetailRate() != null) {
                ticketAppExtendVo.setTbFirstCallAndWaresDetailRate(Double.valueOf(adTicketAppExtend.getTbFirstCallAndWaresDetailRate().doubleValue() / 100.0));
            }
            if (adTicketAppExtend.getRoiCoefficient() != null) {
                ticketAppExtendVo.setRoiCoefficient(Double.valueOf(adTicketAppExtend.getRoiCoefficient().doubleValue() / 100.0));
            }
            if (adTicketAppExtend.getAdxAppRvCover() != null) {
                ticketAppExtendVo.setAdxAppRvCover(Double.valueOf(adTicketAppExtend.getAdxAppRvCover().doubleValue() / 10.0));
            }
            adTicketVo.setTicketAppExtendVo(ticketAppExtendVo);
        }
        return adTicketVo;
    }

    public String transformYuanTimes(String times) {
        if (StringUtil.isBlank((CharSequence)times)) {
            return times;
        }
        String ruleValue = "";
        String[] ruleValues = times.split(",");
        for (int i = 0; i < ruleValues.length; ++i) {
            String r = ruleValues[i];
            String pre = r.substring(0, r.lastIndexOf("-"));
            String end = r.substring(r.lastIndexOf("-") + 1);
            Money money = Money.ofLi((long)Long.parseLong(end));
            ruleValue = i == ruleValues.length - 1 ? ruleValue + pre + "-" + money.getYuan() : ruleValue + pre + "-" + money.getYuan() + ",";
        }
        return ruleValue;
    }

    public String transformLiTimes(String times) {
        if (StringUtil.isBlank((CharSequence)times)) {
            return times;
        }
        String[] ruleValues = times.split(",");
        String ruleValue = "";
        for (int i = 0; i < ruleValues.length; ++i) {
            String rule = ruleValues[i];
            String pre = rule.substring(0, rule.lastIndexOf("-"));
            String end = rule.substring(rule.lastIndexOf("-") + 1);
            Money money = Money.ofYuan((double)Double.valueOf(end));
            ruleValue = i == ruleValues.length - 1 ? ruleValue + pre + "-" + money.getLi() : ruleValue + pre + "-" + money.getLi() + ",";
        }
        return ruleValue;
    }

    @Override
    public Integer delete(Long id, String userName) throws Exception {
        String string;
        AdTicket adTicket = new AdTicket();
        adTicket.setId(id);
        adTicket.setStatus(Short.valueOf((short)99));
        adTicket.setModifyUser(userName);
        int result = this.adTicketMapper.updateByPrimaryKeySelective(adTicket);
        String code = this.adTicketTagConfMapper.findTicketTag(id);
        if (StringUtils.isNotEmpty((CharSequence)code) && StringUtils.isNotEmpty((CharSequence)(string = this.redisNewClient.hGet("AD:TICKET:COSWARNSTAG", code, 0))) && !string.equals("[]")) {
            this.redisNewClient.hdel("AD:TICKET:COSWARN", id + "", 0);
            this.redisNewClient.hdel("AD:TICKET:COSWARNNAME", id + "", 0);
            String coswarns = this.redisNewClient.getRedis("AD:TICKET:COSWARNS");
            if (StringUtils.isNotEmpty((CharSequence)coswarns) && !coswarns.equals("[]")) {
                List list = JSON.parseArray((String)coswarns, String.class);
                list.remove(id + "");
                String ids = JSON.toJSONString((Object)list);
                this.redisNewClient.set("AD:TICKET:COSWARNS", ids);
            }
        }
        this.prodService.pushAdTicketToProdPre(adTicket.getId());
        return result;
    }

    @Override
    public PaginationTemp<AdTicketAllVo> findAll(AdTicketSearchDto condition, User user) throws Exception {
        String banners;
        Object adxAuditStatusMap;
        Map stageTickets;
        String orderParam;
        ArrayList<Long> longList;
        PaginationTemp pagination = new PaginationTemp();
        if (condition == null) {
            condition = new AdTicketSearchDto();
        }
        if (StringUtils.isNotBlank((CharSequence)UserRoleCodeUtil.isAe(user))) {
            if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{condition.getAe()}) && !user.getUsername().equals(condition.getAe())) {
                return pagination;
            }
            condition.setAe(user.getUsername());
        }
        if (StringUtils.isNotBlank((CharSequence)UserRoleCodeUtil.isSale(user))) {
            if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{condition.getSale()}) && !user.getUsername().equals(condition.getSale())) {
                return pagination;
            }
            condition.setSale(user.getUsername());
        }
        String ae = condition.getAe();
        condition.setAe(null);
        List<AdvertiserDto> advertiserDtoList = this.getAllAdvertiser(condition);
        HashMap<Long, String> advertiserMap = new HashMap<Long, String>();
        if (advertiserDtoList != null && advertiserDtoList.size() > 0) {
            longList = new ArrayList<Long>(advertiserDtoList.size());
            for (AdvertiserDto ad : advertiserDtoList) {
                longList.add(ad.getId().longValue());
                advertiserMap.put(ad.getId().longValue(), ad.getCompany());
            }
        } else {
            return pagination;
        }
        condition.setList(longList);
        String code = condition.getStatusCode();
        if (StringUtil.isNotBlank((CharSequence)code)) {
            if (code.contains(STR_TWO)) {
                condition.setPauseReason(Integer.valueOf(Integer.parseInt(code.substring(2))));
            } else {
                condition.setStatus(Short.valueOf(code));
            }
        }
        if ("budgetDaily".equals(orderParam = condition.getOrderParam())) {
            condition.setOrderParam("budget_daily");
        } else if ("validEndDate".equals(orderParam)) {
            condition.setOrderParam("valid_end_date");
        }
        if (null != condition.getTagCode()) {
            List<Long> ticketIds = this.adTicketTagConfService.findTicketIds(condition.getTagCode());
            if (CollectionUtils.isNotEmpty(ticketIds)) {
                List list = condition.getTicketIds();
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    ticketIds.retainAll(list);
                }
                if (CollectionUtils.isEmpty(ticketIds)) {
                    ticketIds.add(-1L);
                }
                condition.setTicketIds(ticketIds);
            } else {
                return pagination;
            }
        }
        if (null == (stageTickets = this.fetcher.hfetchall(RedisKeys.getOcpcSecendStageTicket(), String.class))) {
            stageTickets = Maps.newHashMap();
        }
        this.dealSettleTypeSearch(condition, stageTickets);
        condition.setAe(ae);
        if (StringUtils.isNotBlank((CharSequence)condition.getKeywords())) {
            String tempStr = condition.getKeywords().replaceAll("\\\uff0c", ",");
            List<String> keywordsList = Arrays.asList(tempStr.split(","));
            if (keywordsList.size() > 1) {
                condition.setKeywords(null);
                condition.setKeywordsList(keywordsList);
            } else {
                condition.setKeywordsList(null);
            }
        }
        Integer totalcount = this.adTicketMapper.totalcount(condition);
        List list = this.adTicketMapper.findAll(condition);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return pagination;
        }
        Map<String, String> dictionariesMap = this.getDictionaries("adstatus");
        List<AdTicketOcpcConf> ocpcConfList = this.adTicketOcpcService.selectByTicketIdList(list);
        HashMap<String, String> mapAdTicketOcpcConf = new HashMap<String, String>();
        HashMap<String, Integer> mapExpectCpa = new HashMap<String, Integer>();
        for (AdTicketOcpcConf adTicketOcpcConf : ocpcConfList) {
            mapAdTicketOcpcConf.put(adTicketOcpcConf.getTicketId() + "", adTicketOcpcConf.getIsSupportOcpc() + "");
            mapExpectCpa.put(adTicketOcpcConf.getTicketId() + "", adTicketOcpcConf.getCpaExpectPrice());
        }
        List urlTests = this.adTicketUrlTestMapper.findAll();
        Map urlTestMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)urlTests)) {
            urlTestMap = urlTests.stream().collect(HashMap::new, (k, v) -> k.put(v.getTicketId(), v.getUrlTestResult()), HashMap::putAll);
        }
        List<AdTicketAllVo> adTicketAllVoList = new ArrayList<AdTicketAllVo>(list.size());
        ArrayList<Long> ticketIds = new ArrayList<Long>();
        ArrayList<Long> newAdxTypeTicketIds = new ArrayList<Long>();
        List landingPagePlanVos = this.adLandingPagePlanMapper.selectAll();
        Map<Long, Boolean> landingPagePlanMap = landingPagePlanVos.stream().filter(l -> l.getStatus().equals((short)1)).collect(Collectors.toMap(LandingPagePlanVo::getTicketId, l -> true, (a, b) -> a));
        Map<Long, Double> abnormalConsumeMap = this.getAbnormalConsumeMap(condition, list);
        Map<Long, Boolean> advertiserQualifyWarningMap = this.getAdvertiserQualifyWarningMap(list);
        for (AdTicket ad : list) {
            AdTicketAllVo vo = new AdTicketAllVo();
            BeanUtils.copyProperties((Object)ad, (Object)vo);
            Long ticketId = vo.getId();
            if (MapUtils.isNotEmpty((Map)urlTestMap)) {
                vo.setUrlTestResult((String)urlTestMap.get(ticketId));
            }
            vo.setPrice(Double.valueOf(ad.getPrice().doubleValue() / 1000.0));
            if (1 == ad.getSettleType() || 4 == ad.getSettleType() || 5 == ad.getSettleType()) {
                vo.setBudgetDaily(Double.valueOf(ad.getBudgetDaily().doubleValue() / 1000.0));
            } else {
                vo.setBudgetDaily(Double.valueOf(ad.getBudgetDaily().doubleValue()));
            }
            vo.setAdvertiserName((String)advertiserMap.get(ad.getAdvertiser()));
            Money money = Money.ofLi((long)this.prodPuller.getAdvertiserBalance(ad.getAdvertiser()));
            vo.setAdvertiserBalance(Double.valueOf(money.getYuan()));
            vo.setCrrentClickPrice(this.tikcetCurrentClickAveragePriceService.currentClickAveragePrice(ticketId));
            if (ad.getStatus() == 2 && ad.getPauseReason() != null) {
                vo.setPauseReason(dictionariesMap.get(STR_TWO + ad.getPauseReason()));
            } else {
                vo.setPauseReason(dictionariesMap.get(ad.getStatus() + ""));
            }
            boolean isActivityType = AdTicket.AdTicketType.TYPE_ACTIVITY.getType() == vo.getType().shortValue();
            boolean isDirectType = AdTicket.AdTicketType.TYPE_DIRECT.getType() == vo.getType().shortValue();
            Map<String, String> map = this.getCountPv(condition.getPvStartTime(), condition.getPvEndTime(), ticketId, isActivityType);
            vo.setOpenPv(Integer.valueOf(NumberUtils.toInt((String)map.get("openPv"))));
            vo.setClickPv(Integer.valueOf(NumberUtils.toInt((String)map.get("clickpv"))));
            vo.setClickRate(DoubleUtil.formatDouble(vo.getClickPv().toString(), vo.getOpenPv().toString()));
            this.fillConsume(vo, isActivityType, map, condition, abnormalConsumeMap);
            if (isActivityType || isDirectType) {
                vo.setEntranceOpenPv(vo.getOpenPv());
                vo.setEntranceClickPv(vo.getClickPv());
                vo.setEntranceClickRate(vo.getClickRate());
                if (isActivityType) {
                    vo.setOpenPv(Integer.valueOf(0));
                    vo.setClickPv(Integer.valueOf(0));
                    vo.setClickRate(Double.valueOf(0.0));
                }
                newAdxTypeTicketIds.add(ticketId);
            }
            vo.setValidClick("---");
            vo.setIsSupportOcpc(Integer.valueOf(StringUtil.isBlank((CharSequence)((CharSequence)mapAdTicketOcpcConf.get(ad.getId() + ""))) ? 0 : Integer.parseInt((String)mapAdTicketOcpcConf.get(ad.getId() + ""))));
            if (vo.isOcpc()) {
                vo.setOcpcStage(stageTickets.get(ad.getId().toString()) == null ? null : Integer.valueOf("2".equals(stageTickets.get(ad.getId().toString())) ? 2 : 1));
            }
            vo.setExistLandPlan(landingPagePlanMap.getOrDefault(ticketId, false));
            if (vo.isOnlyOcpc()) {
                vo.setCreateTime(DateUtil.increaseHour((Date)vo.getCreateTime(), (int)-14));
                TicketExplore ticketExplore = this.ticketExploreMapper.selectByPrimaryParams(vo.getId());
                if (Objects.isNull(ticketExplore)) {
                    vo.setExploreStatus("\u5173\u95ed");
                } else if (ticketExplore.getStatus() == 1) {
                    vo.setExploreStatus("\u5173\u95ed");
                } else {
                    LocalDate today = LocalDate.now();
                    if ((ticketExplore.getStartDate().isBefore(today) || ticketExplore.getStartDate().equals(today)) && (ticketExplore.getEndDate().isAfter(today) || ticketExplore.getEndDate().equals(today))) {
                        Long value = (Long)this.fetcher.hfetch(TicketKeyGenerator.ticketExploreBudget((String)ticketId.toString()), ticketId.toString(), Long.class);
                        if (!Objects.isNull(value) && value >= ticketExplore.getBudgetDaily()) {
                            vo.setExploreStatus("\u63a2\u7d22\u5df2\u5b8c\u6210");
                        } else {
                            vo.setExploreStatus("\u63a2\u7d22\u4e2d");
                        }
                    } else {
                        vo.setExploreStatus("\u5173\u95ed");
                    }
                }
            } else {
                vo.setExploreStatus("\u5173\u95ed");
            }
            vo.setQualifyWarningFlag(Integer.valueOf(advertiserQualifyWarningMap.getOrDefault(ad.getAdvertiser(), false) != false ? 0 : 1));
            adTicketAllVoList.add(vo);
            ticketIds.add(ticketId);
        }
        if ("budgetDaily".equals(orderParam)) {
            final String orderType = condition.getOrderType();
            Collections.sort(adTicketAllVoList, new Comparator<AdTicketAllVo>(){

                @Override
                public int compare(AdTicketAllVo a1, AdTicketAllVo a2) {
                    if (a1.getBudgetDaily() > a2.getBudgetDaily()) {
                        if ("asc".equals(orderType)) {
                            return 1;
                        }
                        return -1;
                    }
                    if (a1.getBudgetDaily().doubleValue() == a2.getBudgetDaily().doubleValue()) {
                        return 0;
                    }
                    if ("asc".equals(orderType)) {
                        return -1;
                    }
                    return 1;
                }
            });
        }
        adTicketAllVoList = this.getAdTicketAllVoList(condition.getPvStartTime(), condition.getPvEndTime(), ticketIds, adTicketAllVoList);
        OcpcStageCpaSearchDto ocpcStageCpaSearchDto = new OcpcStageCpaSearchDto();
        ocpcStageCpaSearchDto.setTicketIdList(ticketIds);
        ocpcStageCpaSearchDto.setStartTime(DateUtil.dateTo8String((Date)DateUtil.increaseDate((Date)DateUtil.convertStr2Date((String)condition.getPvEndTime()), (int)-6)));
        ocpcStageCpaSearchDto.setEndTime(condition.getPvEndTime());
        Map ocpcSecondStageAvgCpaMap = this.dataparkOcpcIntegration.getOcpcSecondStageAvgCpaMap(ocpcStageCpaSearchDto);
        List<Dictionaries> domainNames = this.dictionariesService.findAll("shopstype");
        Map<String, String> domainNameMap = null;
        if (CollectionUtils.isNotEmpty(domainNames)) {
            domainNameMap = new HashMap(domainNames.size());
            for (Dictionaries domainName : domainNames) {
                domainNameMap.put(domainName.getTypecode(), domainName.getTypename());
            }
        } else {
            domainNameMap = Collections.emptyMap();
        }
        Map<Long, String> tagNameMap = this.adTicketTagConfService.findClassifyTagName(ticketIds);
        for (AdTicketAllVo adTicketAllVo : adTicketAllVoList) {
            adTicketAllVo.setTagName(tagNameMap.get(adTicketAllVo.getId()));
            adTicketAllVo.setDomainName((String)domainNameMap.getOrDefault(adTicketAllVo.getDomainCode(), null));
            adTicketAllVo.setSecondStageWeekAvgCpa(ocpcSecondStageAvgCpaMap.getOrDefault(adTicketAllVo.getId(), 0.0));
            Integer expectCpaLi = (Integer)mapExpectCpa.get(adTicketAllVo.getId() + "");
            if (expectCpaLi == null) {
                adTicketAllVo.setCpaExpectPrice(Double.valueOf(0.0));
                continue;
            }
            adTicketAllVo.setCpaExpectPrice(Double.valueOf(Money.ofLi((long)expectCpaLi.intValue()).getYuan()));
        }
        Set<String> dailys = DateUtils.getDailyBetweenDate(DateUtil.convertStr2Date((String)condition.getPvStartTime()), DateUtil.convertStr2Date((String)condition.getPvEndTime()));
        DecimalFormat df = new DecimalFormat("######0");
        AdTicket.AdTicketType searchAdTicketType = AdTicket.AdTicketType.getByType((Short)condition.getType());
        ArrayList<String> positionIds = new ArrayList<String>(adTicketAllVoList.size());
        if (searchAdTicketType == null || AdTicket.AdTicketType.TYPE_ACTIVITY == searchAdTicketType || AdTicket.AdTicketType.TYPE_DIRECT == searchAdTicketType) {
            if (CollectionUtils.isNotEmpty(ticketIds)) {
                AdTicketAppExtendExample example = new AdTicketAppExtendExample();
                example.createCriteria().andTicketIdIn(ticketIds);
                List adTicketAppExtends = this.adTicketAppExtendMapperExt.selectByExample(example);
                if (CollectionUtils.isNotEmpty((Collection)adTicketAppExtends)) {
                    Object adxAuditStatusList;
                    Map<Long, AdTicketAppExtend> adTicketAppExtendMap = adTicketAppExtends.stream().collect(Collectors.toMap(a -> a.getTicketId(), a -> a));
                    adxAuditStatusMap = Maps.newHashMap();
                    if (CollectionUtils.isNotEmpty(newAdxTypeTicketIds) && CollectionUtils.isNotEmpty((Collection)(adxAuditStatusList = this.adAssetsTemplateAssetsMapperExt.findAdxAuditStatus(newAdxTypeTicketIds)))) {
                        adxAuditStatusMap = adxAuditStatusList.stream().collect(HashMap::new, (k, v) -> k.put(v.getTicketId(), v), HashMap::putAll);
                    }
                    for (AdTicketAllVo vo : adTicketAllVoList) {
                        AdTicketAppExtend adTicketAppExtend = adTicketAppExtendMap.get(vo.getId());
                        if (adTicketAppExtend == null || !AdTicket.AdTicketType.isNewAdx((Short)vo.getType())) continue;
                        if (adTicketAppExtend.getAdxPrice() != null) {
                            vo.setAdxPrice(Double.valueOf(adTicketAppExtend.getAdxPrice().doubleValue() / 1000.0));
                        }
                        if (adTicketAppExtend.getAdxBudgetDaily() != null) {
                            vo.setAdxBudgetDaily(Double.valueOf(adTicketAppExtend.getAdxBudgetDaily().doubleValue() / 1000.0));
                        }
                        if (adTicketAppExtend.getAdxTargetCpa() != null) {
                            vo.setAdxTargetCpa(Double.valueOf(adTicketAppExtend.getAdxTargetCpa().doubleValue() / 1000.0));
                        }
                        int adxCountConsumeForLi = this.getAdxCountConsumeByPangu(condition.getPvStartTime(), condition.getPvEndTime(), vo.getId());
                        Double consume = NumberUtils.toDouble((String)String.valueOf(adxCountConsumeForLi)) / 1000.0;
                        vo.setAdxConsume(consume);
                        vo.setAdxCost(vo.getAdxConsume());
                        if (vo.getAdxCost() != null) {
                            BigDecimal entranceOpenPvBigDecimal;
                            double divide;
                            BigDecimal entranceClickPvBigDecimal;
                            if (vo.getEntranceClickPv() != null && (entranceClickPvBigDecimal = new BigDecimal(vo.getEntranceClickPv())).compareTo(new BigDecimal(BigInteger.ZERO)) != 0) {
                                divide = new BigDecimal(vo.getAdxCost()).divide(entranceClickPvBigDecimal, 4, 4).doubleValue();
                                vo.setAdxCpcCost(Double.valueOf(divide));
                            }
                            if (vo.getEntranceOpenPv() != null && (entranceOpenPvBigDecimal = new BigDecimal(vo.getEntranceOpenPv())).compareTo(new BigDecimal(BigInteger.ZERO)) != 0) {
                                divide = new BigDecimal(vo.getAdxCost()).divide(entranceOpenPvBigDecimal, 4, 4).multiply(new BigDecimal(1000)).doubleValue();
                                vo.setAdxCpmCost(Double.valueOf(divide));
                            }
                        }
                        vo.setAdxPriceType(adTicketAppExtend.getAdxPriceType());
                        vo.setAdxId(adTicketAppExtend.getAdxId());
                        vo.setRiskControl(adTicketAppExtend.getRiskControl());
                        AdAssetsTemplateAssetsAdxAuditStatusDTO adAssetsTemplateAssetsAdxAuditStatusDTO = adxAuditStatusMap.getOrDefault(vo.getId(), new AdAssetsTemplateAssetsAdxAuditStatusDTO());
                        vo.setAdxAuditStatus(adAssetsTemplateAssetsAdxAuditStatusDTO.getAdxAuditStatus());
                        vo.setAdxAuditMessage(adAssetsTemplateAssetsAdxAuditStatusDTO.getOppoAuditMessage());
                        vo.setAdxAssetsFillRate(this.adTicketAssetsTemplateAssetsService.findAssetsFillRate(vo.getId()));
                    }
                }
            }
        } else if (AdTicket.AdTicketType.TYPE_ADX_DIRECT == searchAdTicketType) {
            Object adTicketAdxs;
            if (CollectionUtils.isNotEmpty(ticketIds) && CollectionUtils.isNotEmpty((Collection)(adTicketAdxs = this.adTicketAdxMapperExt.findByTicketId(ticketIds)))) {
                for (AdTicketAllVo ad : adTicketAllVoList) {
                    BigDecimal divide;
                    adxAuditStatusMap = adTicketAdxs.iterator();
                    while (adxAuditStatusMap.hasNext()) {
                        AdTicketAdx adTicketAdx = (AdTicketAdx)adxAuditStatusMap.next();
                        if (!ad.getId().equals(adTicketAdx.getAdTicketId())) continue;
                        ad.setAdxAe(adTicketAdx.getAdxAe());
                        ad.setAdxSettleType(adTicketAdx.getAdxSettleType());
                        ad.setAdxPrice(Double.valueOf(adTicketAdx.getAdxPrice().doubleValue() / 1000.0));
                        ad.setAdxBudgetDaily(Double.valueOf(adTicketAdx.getAdxBudgetDaily().doubleValue() / 1000.0));
                        break;
                    }
                    Map<String, String> map = this.getCountPv(condition.getPvStartTime(), condition.getPvEndTime(), ad.getId(), false);
                    int adxRequestCount = this.getAdxRequestCount(ad.getId().toString(), dailys);
                    int adxOfferPriceCount = this.getAdxOfferPriceCount(ad.getId().toString(), dailys);
                    ad.setRequestNum(Integer.valueOf(adxRequestCount));
                    ad.setOfferPriceNum(Integer.valueOf(adxOfferPriceCount));
                    if (adxRequestCount != 0) {
                        divide = new BigDecimal(adxOfferPriceCount * 100).divide(new BigDecimal(adxRequestCount), 2, 4);
                        ad.setOfferPriceRate(divide + "%");
                    } else {
                        ad.setOfferPriceRate("0.00%");
                    }
                    if (adxOfferPriceCount != 0) {
                        divide = new BigDecimal(ad.getOpenPv() * 100).divide(new BigDecimal(adxOfferPriceCount), 2, 4);
                        ad.setOpenPvOfferPriceRate(divide + "%");
                        continue;
                    }
                    ad.setOpenPvOfferPriceRate("0.00%");
                }
            }
            for (AdTicketAllVo vo : adTicketAllVoList) {
                int adxCountConsumeForLi = this.getAdxCountConsume(condition.getPvStartTime(), condition.getPvEndTime(), vo.getId());
                vo.setAdxConsume(Double.valueOf(NumberUtils.toDouble((String)String.valueOf(adxCountConsumeForLi)) / 1000.0));
                banners = this.adRulesService.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.GUANGGAOWEI.getValue(), vo.getId());
                if (!StringUtils.isNotBlank((CharSequence)banners)) continue;
                String positionId = banners.substring(2);
                vo.setPositionId(positionId);
                positionIds.add(positionId);
            }
        } else if (AdTicket.AdTicketType.TYPE_ADX_INTERACT == searchAdTicketType) {
            for (AdTicketAllVo vo : adTicketAllVoList) {
                int adxCountConsumeForLi = this.getAdxCountConsume(condition.getPvStartTime(), condition.getPvEndTime(), vo.getId());
                vo.setConsume(Double.valueOf(NumberUtils.toDouble((String)String.valueOf(adxCountConsumeForLi)) / 1000.0));
                banners = this.adRulesService.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.GUANGGAOWEI.getValue(), vo.getId());
                if (!StringUtils.isNotBlank((CharSequence)banners)) continue;
                String positionId = banners.substring(2);
                vo.setPositionId(positionId);
                positionIds.add(positionId);
            }
        }
        if (CollectionUtils.isNotEmpty(positionIds)) {
            QueryAppAdPositionDTO queryAppAdPositionDto = new QueryAppAdPositionDTO();
            queryAppAdPositionDto.setPositionIds(positionIds);
            List appEntranceAdROList = this.newAppEntranceFacadeIntegration.getPositionList(queryAppAdPositionDto);
            if (CollectionUtils.isNotEmpty((Collection)appEntranceAdROList)) {
                Map<String, AppEntranceAdRO> map = appEntranceAdROList.stream().collect(Collectors.toMap(AppEntranceAdRO::getPositionId, appEntranceAdRO -> appEntranceAdRO));
                for (AdTicketAllVo vo : adTicketAllVoList) {
                    AppEntranceAdRO ro = map.get(vo.getPositionId());
                    if (ro == null) continue;
                    vo.setPositionName(ro.getAppEntranceName());
                    vo.setPositionIdCodeName(String.format("%06d", ro.getCode()) + "-" + ro.getAppEntranceId());
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)condition.getSortName())) {
            ListOrderUtils.sortList(adTicketAllVoList, condition.getSortName(), condition.getSortType());
        }
        pagination.setPageSize(condition.getPageSize());
        pagination.setPageNo(condition.getPageNum());
        pagination.setList(adTicketAllVoList);
        pagination.setTotalCount(totalcount.intValue());
        return pagination;
    }

    @Override
    public PaginationTemp<AdAdxTicketPackageVo> findAdxTicketPackage(AdTicketSearchDto condition, User user) throws Exception {
        ArrayList<Long> longList;
        PaginationTemp pagination = new PaginationTemp();
        if (condition == null) {
            condition = new AdTicketSearchDto();
        }
        HashMap<Long, String> advertiserMap = new HashMap<Long, String>();
        if (StringUtils.isNotBlank((CharSequence)UserRoleCodeUtil.isAe(user))) {
            if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{condition.getAe()}) && !user.getUsername().equals(condition.getAe())) {
                return pagination;
            }
            condition.setAe(user.getUsername());
        }
        if (StringUtils.isNotBlank((CharSequence)UserRoleCodeUtil.isSale(user))) {
            if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{condition.getSale()}) && !user.getUsername().equals(condition.getSale())) {
                return pagination;
            }
            condition.setSale(user.getUsername());
        }
        String ae = condition.getAe();
        condition.setAe(null);
        List<AdvertiserDto> advertiserDtoList = this.getAllAdvertiser(condition);
        if (advertiserDtoList != null && advertiserDtoList.size() > 0) {
            longList = new ArrayList<Long>(advertiserDtoList.size());
            for (AdvertiserDto ad : advertiserDtoList) {
                longList.add(ad.getId().longValue());
                advertiserMap.put(ad.getId().longValue(), ad.getCompany());
            }
        } else {
            return pagination;
        }
        condition.setList(longList);
        String code = condition.getStatusCode();
        if (StringUtil.isNotBlank((CharSequence)code)) {
            if (code.contains(STR_TWO)) {
                condition.setPauseReason(Integer.valueOf(Integer.parseInt(code.substring(2))));
            } else {
                condition.setStatus(Short.valueOf(code));
            }
        }
        Map<String, String> dictionariesMap = this.getDictionaries("adstatus");
        if (null != condition.getTagCode()) {
            List<Long> ticketIds = this.adTicketTagConfService.findTicketIds(condition.getTagCode());
            if (CollectionUtils.isNotEmpty(ticketIds)) {
                condition.setTicketIds(ticketIds);
            } else {
                return pagination;
            }
        }
        Integer totalcount = this.adTicketMapper.totalcount(condition);
        List list = this.adTicketMapper.findAll(condition);
        List<AdAdxTicketPackageVo> adTicketAllVoList = new ArrayList<AdAdxTicketPackageVo>(list.size());
        ArrayList<Long> ticketIds = new ArrayList<Long>();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return pagination;
        }
        List<AdTicketOcpcConf> ocpcConfList = this.adTicketOcpcService.selectByTicketIdList(list);
        HashMap<String, String> mapAdTicketOcpcConf = new HashMap<String, String>();
        for (AdTicketOcpcConf adTicketOcpcConf : ocpcConfList) {
            mapAdTicketOcpcConf.put(adTicketOcpcConf.getTicketId() + "", adTicketOcpcConf.getIsSupportOcpc() + "");
        }
        List urlTests = this.adTicketUrlTestMapper.findAll();
        Map urlTestMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)urlTests)) {
            urlTestMap = urlTests.stream().collect(HashMap::new, (k, v) -> k.put(v.getTicketId(), v.getUrlTestResult()), HashMap::putAll);
        }
        for (AdTicket ad : list) {
            AdAdxTicketPackageVo vo = new AdAdxTicketPackageVo();
            BeanUtils.copyProperties((Object)ad, (Object)vo);
            if (MapUtils.isNotEmpty((Map)urlTestMap)) {
                vo.setUrlTestResult((String)urlTestMap.get(vo.getId()));
            }
            vo.setPrice(Double.valueOf(ad.getPrice().doubleValue() / 1000.0));
            if (1 == ad.getSettleType() || 4 == ad.getSettleType() || 5 == ad.getSettleType()) {
                vo.setBudgetDaily(Double.valueOf(ad.getBudgetDaily().doubleValue() / 1000.0));
            } else {
                vo.setBudgetDaily(Double.valueOf(ad.getBudgetDaily().doubleValue()));
            }
            vo.setAdvertiserName((String)advertiserMap.get(ad.getAdvertiser()));
            Money money = Money.ofLi((long)this.prodPuller.getAdvertiserBalance(ad.getAdvertiser()));
            vo.setAdvertiserBalance(Double.valueOf(money.getYuan()));
            if (ad.getStatus() == 2 && ad.getPauseReason() != null) {
                vo.setPauseReason(dictionariesMap.get(STR_TWO + ad.getPauseReason()));
            } else {
                vo.setPauseReason(dictionariesMap.get(ad.getStatus() + ""));
            }
            vo.setValidClick("---");
            vo.setIsSupportOcpc(Integer.valueOf(StringUtil.isBlank((CharSequence)((CharSequence)mapAdTicketOcpcConf.get(ad.getId() + ""))) ? 0 : Integer.parseInt((String)mapAdTicketOcpcConf.get(ad.getId() + ""))));
            adTicketAllVoList.add(vo);
            ticketIds.add(ad.getId());
        }
        adTicketAllVoList = this.getAdAdxTicketPackageVoList(condition.getPvStartTime(), condition.getPvEndTime(), ticketIds, adTicketAllVoList);
        List<Dictionaries> domainNames = this.dictionariesService.findAll("shopstype");
        Map<String, String> domainNameMap = null;
        if (CollectionUtils.isNotEmpty(domainNames)) {
            domainNameMap = new HashMap(domainNames.size());
            for (Dictionaries domainName : domainNames) {
                domainNameMap.put(domainName.getTypecode(), domainName.getTypename());
            }
        } else {
            domainNameMap = Collections.emptyMap();
        }
        Map<Long, String> tagNameMap = this.adTicketTagConfService.findClassifyTagName(ticketIds);
        for (AdAdxTicketPackageVo adTicketAllVo : adTicketAllVoList) {
            adTicketAllVo.setTagName(tagNameMap.get(adTicketAllVo.getId()));
            adTicketAllVo.setDomainName((String)domainNameMap.getOrDefault(adTicketAllVo.getDomainCode(), null));
        }
        pagination.setPageSize(condition.getPageSize());
        pagination.setPageNo(condition.getPageNum());
        pagination.setList(adTicketAllVoList);
        pagination.setTotalCount(totalcount.intValue());
        return pagination;
    }

    public List<AdAdxTicketPackageVo> getAdAdxTicketPackageVoList(String startTime, String endTime, List<Long> ticketIds, List<AdAdxTicketPackageVo> adAdxTicketPackageVoList) {
        try {
            if (StringUtil.isNotBlank((CharSequence)startTime)) {
                List ticketCountCommonList;
                String nowDate = DateUtil.dateTo8String((Date)new Date());
                if (StringUtil.endsWith((CharSequence)startTime, (CharSequence)endTime) && !nowDate.equalsIgnoreCase(startTime) && CollectionUtils.isNotEmpty((Collection)(ticketCountCommonList = this.dataparkTicketPullerIntegration.getTicketCount(startTime, null, JSON.toJSONString(ticketIds))))) {
                    HashMap<String, TicketCountCommon> ticketCountCommonMap = new HashMap<String, TicketCountCommon>();
                    for (TicketCountCommon ticketCountCommon : ticketCountCommonList) {
                        ticketCountCommonMap.put(ticketCountCommon.getCertificateid() + "", ticketCountCommon);
                    }
                    for (AdAdxTicketPackageVo adAdxTicketPackageVo : adAdxTicketPackageVoList) {
                        TicketCountCommon ticketCountCommon = (TicketCountCommon)ticketCountCommonMap.get(adAdxTicketPackageVo.getId() + "");
                        if (ticketCountCommon == null) continue;
                        adAdxTicketPackageVo.setValidClickRate(ticketCountCommon.getValidClickRate());
                        adAdxTicketPackageVo.setOpenPvAurp(ticketCountCommon.getOpenPvAurp());
                        adAdxTicketPackageVo.setClickAurp(ticketCountCommon.getClickAurp());
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return adAdxTicketPackageVoList;
    }

    public List<AdTicketAllVo> getAdTicketAllVoList(String startTime, String endTime, List<Long> ticketIds, List<AdTicketAllVo> adTicketAllVoList) {
        if (CollectionUtils.isEmpty(adTicketAllVoList)) {
            return adTicketAllVoList;
        }
        try {
            if (StringUtil.isNotBlank((CharSequence)startTime)) {
                List ticketCountCommonList;
                String nowDate = DateUtil.dateTo8String((Date)new Date());
                if (StringUtil.endsWith((CharSequence)startTime, (CharSequence)endTime)) {
                    for (AdTicketAllVo adTicketAllVo : adTicketAllVoList) {
                        boolean isActivityType;
                        String newStartTime = DateUtil.dateTo8String1((Date)DateUtil.StringToDate((String)startTime));
                        boolean bl = isActivityType = AdTicket.AdTicketType.TYPE_ACTIVITY.getType() == adTicketAllVo.getType().shortValue();
                        if (isActivityType) {
                            String activityKey = TicketKeyGenerator.Statistics.getPanGuValidClickOfDaily((String)newStartTime, (BigInteger)BigInteger.valueOf(adTicketAllVo.getId())).generateKey();
                            Integer ctivityValidClick = this.redisNewClient.pfCount(activityKey, 0);
                            adTicketAllVo.setValidClick(String.valueOf(ctivityValidClick));
                            continue;
                        }
                        String key = TicketKeyGenerator.Statistics.getValidClickOfDaily((String)newStartTime, (BigInteger)BigInteger.valueOf(adTicketAllVo.getId())).generateKey();
                        Integer validClick = this.redisNewClient.pfCount(key, 0);
                        adTicketAllVo.setValidClick(String.valueOf(validClick));
                    }
                }
                HashSet<Long> adxTicketIds = new HashSet<Long>();
                for (AdTicketAllVo adTicketAllVo : adTicketAllVoList) {
                    if (!AdTicket.AdTicketType.isAdx((Short)adTicketAllVo.getType())) continue;
                    adxTicketIds.add(adTicketAllVo.getId());
                }
                if (CollectionUtils.isNotEmpty(adxTicketIds) && CollectionUtils.isNotEmpty((Collection)(ticketCountCommonList = this.dataparkTicketPullerIntegration.getTicketAdxCount(startTime, null, JSON.toJSONString(adxTicketIds))))) {
                    HashMap<String, Integer> ticketCountCommonMap = new HashMap<String, Integer>();
                    for (TicketCountCommon ticketCountCommon : ticketCountCommonList) {
                        ticketCountCommonMap.put(ticketCountCommon.getCertificateid() + "", ticketCountCommon.getValidClick());
                    }
                    Iterator<Object> iterator = adTicketAllVoList.iterator();
                    while (iterator.hasNext()) {
                        AdTicketAllVo adTicketAllVo;
                        adTicketAllVo.setValidClick(ticketCountCommonMap.get((adTicketAllVo = (AdTicketAllVo)iterator.next()).getId() + "") + "" != null ? ticketCountCommonMap.get(adTicketAllVo.getId() + "") + "" : adTicketAllVo.getValidClick());
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return adTicketAllVoList;
    }

    public Map<String, String> getCountPv(String startDate, String endDate, Long ticketId, Boolean isActivityType) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        int openPv = 0;
        int clickpv = 0;
        Long consume = 0L;
        int activityConsume = 0;
        map.put("openPv", String.valueOf(openPv));
        map.put("clickpv", String.valueOf(clickpv));
        map.put("consume", String.valueOf(consume));
        map.put("activityConsume", String.valueOf(activityConsume));
        Date pvStartDate = new Date();
        Date pvEndDate = new Date();
        if (StringUtil.isBlank((CharSequence)startDate) && StringUtil.isBlank((CharSequence)endDate)) {
            return map;
        }
        pvStartDate = DateUtil.StringToDate((String)startDate);
        pvEndDate = DateUtil.StringToDate((String)endDate);
        if (null == ticketId || DateUtil.isAfter((Date)pvEndDate, (Date)pvStartDate)) {
            return map;
        }
        long num = DateUtil.countDiffDateDays2((Date)pvStartDate, (Date)pvEndDate) + 1L;
        for (long i = 0L; i < num; ++i) {
            openPv += this.prodPuller.fetchOpenPvCount(ticketId.toString(), DateUtil.dateTo8String1((Date)pvStartDate)).intValue();
            clickpv += this.prodPuller.fetchClikePvCount(ticketId.toString(), DateUtil.dateTo8String1((Date)pvStartDate)).intValue();
            consume = consume + this.prodPuller.fetchBudgetOfDailyCount(ticketId.toString(), DateUtil.dateTo8String1((Date)pvStartDate));
            if (isActivityType.booleanValue()) {
                activityConsume += this.prodPuller.fetchActivityCostOfDailyCount(ticketId.toString(), DateUtil.dateTo8String1((Date)pvStartDate)).intValue();
            }
            pvStartDate = DateUtil.increaseDate((Date)pvStartDate, (int)1);
        }
        map.put("openPv", String.valueOf(openPv));
        map.put("clickpv", String.valueOf(clickpv));
        map.put("consume", String.valueOf(consume));
        map.put("activityConsume", String.valueOf(activityConsume));
        return map;
    }

    @Override
    public int getAdxCountConsume(String startDate, String endDate, Long ticketId) {
        Date pvStartDate = new Date();
        Date pvEndDate = new Date();
        if (StringUtil.isBlank((CharSequence)startDate) && StringUtil.isBlank((CharSequence)endDate)) {
            return 0;
        }
        pvStartDate = DateUtil.StringToDate((String)startDate);
        pvEndDate = DateUtil.StringToDate((String)endDate);
        if (null == ticketId || DateUtil.isAfter((Date)pvEndDate, (Date)pvStartDate)) {
            return 0;
        }
        long num = DateUtil.countDiffDateDays2((Date)pvStartDate, (Date)pvEndDate) + 1L;
        int consume = 0;
        for (long i = 0L; i < num; ++i) {
            consume += this.prodPuller.fetchAdxBudgetOfDailyCount(ticketId.toString(), DateUtil.dateTo8String1((Date)pvStartDate)).intValue();
            pvStartDate = DateUtil.increaseDate((Date)pvStartDate, (int)1);
        }
        return consume;
    }

    private int getAdxCountConsumeByPangu(String startDate, String endDate, Long ticketId) {
        Date pvStartDate = new Date();
        Date pvEndDate = new Date();
        if (StringUtil.isBlank((CharSequence)startDate) && StringUtil.isBlank((CharSequence)endDate)) {
            return 0;
        }
        pvStartDate = DateUtil.StringToDate((String)startDate);
        pvEndDate = DateUtil.StringToDate((String)endDate);
        if (null == ticketId || DateUtil.isAfter((Date)pvEndDate, (Date)pvStartDate)) {
            return 0;
        }
        long num = DateUtil.countDiffDateDays2((Date)pvStartDate, (Date)pvEndDate) + 1L;
        int consume = 0;
        for (long i = 0L; i < num; ++i) {
            consume += this.prodPuller.fetchAdxBudgetOfDailyCountByPangu(ticketId.toString(), DateUtil.dateTo8String1((Date)pvStartDate)).intValue();
            pvStartDate = DateUtil.increaseDate((Date)pvStartDate, (int)1);
        }
        return consume;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Object updateStatus(AdTicket adTicket) throws Exception {
        Iterator iterator;
        AdTicket ad = this.adTicketMapper.selectByPrimaryKey(adTicket.getId());
        if (ad == null || 99 == ad.getStatus()) {
            throw new ValidateException("\u67e5\u627e\u4e0d\u5230\u5e7f\u544a\u5238\u6216\u8005\u8be5\u5e7f\u544a\u5238\u5df2\u7ecf\u5220\u9664");
        }
        Boolean isInspireVideo = ad.getType().equals((short)7) || ad.getType().equals((short)8);
        Boolean isActivityOrDirect = ad.getType().equals((short)12) || ad.getType().equals((short)13);
        boolean isAdx = AdTicket.AdTicketType.isAdx((Short)ad.getType());
        if (isInspireVideo.booleanValue()) {
            List adAssetsInspireVideoList = this.adAssetsInspireVideoMapperExt.findAllByTicketId(adTicket.getId());
            iterator = adAssetsInspireVideoList.iterator();
            while (iterator.hasNext()) {
                AdAssetsInspireVideo adAssetsInspireVideo = (AdAssetsInspireVideo)iterator.next();
                if (adAssetsInspireVideo.getStatus() != 0) continue;
                iterator.remove();
            }
            if (CollectionUtils.isEmpty((Collection)adAssetsInspireVideoList)) {
                throw new ValidateException("\u8bf7\u5148\u5f00\u542f\u7d20\u6750");
            }
        } else if (isActivityOrDirect.booleanValue()) {
            List adAssetsTemplateAssetsList = this.adAssetsTemplateAssetsMapperExt.findAllByTicketId(adTicket.getId());
            iterator = adAssetsTemplateAssetsList.iterator();
            while (iterator.hasNext()) {
                AdAssetsTemplateAssets adAssetsTemplateAssets = (AdAssetsTemplateAssets)iterator.next();
                if (adAssetsTemplateAssets.getStatus() != 0) continue;
                iterator.remove();
            }
            if (CollectionUtils.isEmpty((Collection)adAssetsTemplateAssetsList)) {
                throw new ValidateException("\u8bf7\u5148\u5f00\u542f\u7d20\u6750");
            }
        } else if (isAdx) {
            AdAssetsAdx adAssetsAdx;
            List adAssetsAdxes = this.adAssetsAdxMapperExt.findAllByTicketId(adTicket.getId());
            if (CollectionUtils.isNotEmpty((Collection)adAssetsAdxes) && (adAssetsAdx = (AdAssetsAdx)adAssetsAdxes.get(0)).getMeituanReviewStatus() != null && !adAssetsAdx.getMeituanReviewStatus().equals(AdAssetsAdx.MEITUAN_REVIEW_PASS) && adTicket.getStatus() != 3) {
                throw new ValidateException("\u7f8e\u56e2\u7d20\u6750\u5ba1\u6838\u672a\u901a\u8fc7");
            }
        } else {
            List adAssetsList = this.adAssetsMapper.findAllByTicketId(adTicket.getId());
            iterator = adAssetsList.iterator();
            while (iterator.hasNext()) {
                AdAssets adAssets = (AdAssets)iterator.next();
                if (adAssets.getStatus() != 0) continue;
                iterator.remove();
            }
            if (CollectionUtils.isEmpty((Collection)adAssetsList)) {
                throw new ValidateException("\u8bf7\u5148\u5f00\u542f\u7d20\u6750");
            }
        }
        if (-2 == ad.getStatus() && ad.getLastStatus() > 0) {
            adTicket.setModifyTime(new Date());
            adTicket.setLastStatus(adTicket.getStatus().shortValue());
            adTicket.setStatus(ad.getStatus());
            int result = this.adTicketMapper.updateByPrimaryKeySelective(adTicket);
            return result;
        }
        Short status = ad.getStatus();
        if (!(status == null || status != 1 && status != 3 || adTicket.getStatus() != 1 && adTicket.getStatus() != 3)) {
            adTicket.setLastStatus(status.shortValue());
        }
        if (1 == adTicket.getStatus()) {
            String tiems = this.adRulesService.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.SHIJIANDUAN.getValue(), ad.getId());
            adTicket = this.checkStatus(adTicket, ad, tiems, new Object[0]);
        }
        adTicket.setUserGradePassScore(ad.getUserGradePassScore());
        int result = this.adTicketMapper.updateByPrimaryKeySelective(adTicket);
        try {
            this.updateTicketStatus(adTicket);
        }
        catch (Exception e) {
            LOGGER.error("update adticket status fail ,try pushAdTicketToProdPre ", (Throwable)e);
            this.prodService.pushAdTicketToProdPre(adTicket.getId());
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean updateStatus(Long id) throws Exception {
        Boolean flag = true;
        AdTicket adTicket = this.adTicketMapper.selectByPrimaryKey(id);
        if (adTicket == null || 99 == adTicket.getStatus()) {
            throw new ValidateException("\u67e5\u627e\u4e0d\u5230\u5e7f\u544a\u5238\u6216\u8005\u8be5\u5e7f\u544a\u5238\u5df2\u7ecf\u5220\u9664");
        }
        if (adTicket.getStatus() < 0) {
            return flag;
        }
        adTicket.setLastStatus(adTicket.getStatus().shortValue());
        adTicket.setStatus(Short.valueOf((short)-2));
        adTicket.setModifyUser("\u76d1\u6d4b\u7ba1\u7406\u5458");
        int result = this.adTicketMapper.updateByPrimaryKeySelective(adTicket);
        if (result <= 0) {
            throw new ValidateException("\u66f4\u65b0\u5931\u8d25");
        }
        TblAdTicketModify tblAdTicketModify = new TblAdTicketModify();
        tblAdTicketModify.setCreateTime(new Date());
        tblAdTicketModify.setTicketId(adTicket.getId());
        tblAdTicketModify.setLog("\u76d1\u6d4b\u5230\u843d\u5730\u9875\u7be1\u6539");
        tblAdTicketModify.setCreateUser("\u76d1\u6d4b\u7ba1\u7406\u5458");
        this.tblAdTicketModifyMapperExt.insert(tblAdTicketModify);
        try {
            this.updateTicketStatus(adTicket);
        }
        catch (Exception e) {
            LOGGER.error("update adticket status fail ,try pushAdTicketToProdPre ", (Throwable)e);
            this.prodService.pushAdTicketToProdPre(adTicket.getId());
        }
        return flag;
    }

    @Override
    public String getAeCodeByTicketId(Long id) throws Exception {
        AdTicket adTicket = this.adTicketMapper.selectByPrimaryKey(id);
        if (adTicket == null) {
            return null;
        }
        return adTicket.getAe();
    }

    @Override
    public Integer facadeUpdateStatus(AdTicket adTicket) throws Exception {
        AdTicket ad = this.adTicketMapper.selectByPrimaryKey(adTicket.getId());
        if (ad == null || 99 == ad.getStatus()) {
            throw new ValidateException("\u67e5\u627e\u4e0d\u5230\u5e7f\u544a\u5238\u6216\u8005\u8be5\u5e7f\u544a\u5238\u5df2\u7ecf\u5220\u9664");
        }
        if (1 == adTicket.getStatus()) {
            String tiems = this.adRulesService.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.SHIJIANDUAN.getValue(), ad.getId());
            adTicket = this.checkStatus(adTicket, ad, tiems, new Object[0]);
        }
        int updateCount = this.adTicketMapper.updateByPrimaryKeySelective(adTicket);
        Long ticketId = adTicket.getId();
        PUSH_TICKET_POOL.execute(() -> {
            try {
                this.prodService.pushAdTicketToProdPre(ticketId);
                LOGGER.info("Push Queue Size {} ", (Object)PUSH_TICKET_POOL.getQueue().size());
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        });
        return updateCount;
    }

    @Override
    public Integer updateDailyBudget(Long id, Double dailyBudget) throws Exception {
        AdTicket ad = this.adTicketMapper.selectByPrimaryKey(id);
        if (ad == null || 99 == ad.getStatus()) {
            throw new ValidateException("\u67e5\u627e\u4e0d\u5230\u5e7f\u544a\u5238\u6216\u8005\u8be5\u5e7f\u544a\u5238\u5df2\u7ecf\u5220\u9664");
        }
        if (1 == ad.getSettleType() || 4 == ad.getSettleType() || 5 == ad.getSettleType()) {
            Money money1 = Money.ofYuan((double)dailyBudget);
            ad.setBudgetDaily(Long.valueOf(money1.getLi()));
        } else {
            ad.setBudgetDaily(Long.valueOf(dailyBudget.longValue()));
        }
        ad.setModifyUser("advertiser");
        if (3 != ad.getStatus()) {
            String tiems = this.adRulesService.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.SHIJIANDUAN.getValue(), ad.getId());
            ad = this.checkStatus(ad, ad, tiems, new Object[0]);
        }
        int result = this.adTicketMapper.updateByPrimaryKeySelective(ad);
        this.prodService.pushAdTicketToProdPre(id);
        return result;
    }

    @Override
    public Integer advertiserUpdateStatus(AdTicket adTicket) throws Exception {
        AdTicket ad = this.adTicketMapper.selectByPrimaryKey(adTicket.getId());
        if (ad == null || 99 == ad.getStatus()) {
            throw new ValidateException("\u67e5\u627e\u4e0d\u5230\u5e7f\u544a\u5238\u6216\u8005\u8be5\u5e7f\u544a\u5238\u5df2\u7ecf\u5220\u9664");
        }
        Short status = ad.getStatus();
        if (!(status == null || status != 3 && status != 1 || adTicket.getStatus() != 1 && adTicket.getStatus() != 3)) {
            adTicket.setLastStatus(status.shortValue());
        }
        if (1 == adTicket.getStatus()) {
            String tiems = this.adRulesService.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.SHIJIANDUAN.getValue(), ad.getId());
            adTicket = this.checkStatus(adTicket, ad, tiems, new Object[0]);
        }
        int result = this.adTicketMapper.updateByPrimaryKeySelective(adTicket);
        if (1 == adTicket.getStatus() || 3 == adTicket.getStatus()) {
            try {
                this.updateTicketStatus(adTicket);
            }
            catch (Exception e) {
                LOGGER.error("update adticket status fail ,try pushAdTicketToProdPre ", (Throwable)e);
                this.prodService.pushAdTicketToProdPre(adTicket.getId());
            }
        }
        return result;
    }

    public List<AdvertiserDto> getAllAdvertiser(AdTicketSearchDto condition) throws Exception {
        AdvertiserDto search = new AdvertiserDto();
        if (StringUtil.isNumeric((CharSequence)condition.getAdvertiseIdOrName())) {
            try {
                search.setId(Integer.valueOf(condition.getAdvertiseIdOrName()));
            }
            catch (NumberFormatException e) {
                search.setCompany(condition.getAdvertiseIdOrName());
            }
        } else {
            search.setCompany(condition.getAdvertiseIdOrName());
        }
        search.setAe(condition.getAe());
        search.setSale(condition.getSale());
        ArrayList list = new ArrayList();
        return this.adShopIntegration.getAdShopList(search);
    }

    public String getAdvertiserName(String ids) {
        try {
            List list = this.adShopIntegration.findAdShopMsgs(ids);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                return ((AdvertiserDto)list.get(0)).getCompany();
            }
            return ids;
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5e7f\u544a\u4e3b\u540d\u5b57\u51fa\u9519", (Throwable)e);
            return ids;
        }
    }

    public AdTicket checkStatus(AdTicket adTicket, AdTicket ad, String adRules, Object ... obj) {
        Number adxBudgetDaily;
        Long budget;
        List adTicketAdxes;
        AdTicketAdxExample adTicketAdxExample;
        AdTicketDto adTicketDto;
        Long budget2;
        Date date = new Date();
        adTicket.setStatus(Short.valueOf((short)1));
        adTicket.setPauseReason(null);
        if (DateUtil.compareOnlyDate((Date)date, (Date)ad.getValidStartDate()) < 0) {
            adTicket.setStatus(Short.valueOf((short)2));
            adTicket.setPauseReason(Integer.valueOf(3));
            LOGGER.info("getId={},getType={},getPauseReason={}", new Object[]{ad.getId(), ad.getType(), ad.getPauseReason()});
            return adTicket;
        }
        if (DateUtil.compareOnlyDate((Date)date, (Date)ad.getValidEndDate()) > 0) {
            adTicket.setStatus(Short.valueOf((short)2));
            adTicket.setPauseReason(Integer.valueOf(4));
            LOGGER.info("getId={},getType={},getPauseReason={}", new Object[]{ad.getId(), ad.getType(), ad.getPauseReason()});
            return adTicket;
        }
        if (null != ad.getId() && null != (budget2 = this.prodPuller.getBudgetOfToday(ad.getId())) && budget2 >= ad.getBudgetDaily()) {
            adTicket.setStatus(Short.valueOf((short)2));
            adTicket.setPauseReason(Integer.valueOf(1));
            LOGGER.info("\u65e5\u9884\u7b97\u4e0d\u8db3\uff1agetId={},getType={},getPauseReason={}", new Object[]{ad.getId(), ad.getType(), ad.getPauseReason()});
            return adTicket;
        }
        Long advertiserBalance = this.prodPuller.getAdvertiserBalance(ad.getAdvertiser());
        if (null != advertiserBalance && advertiserBalance < (long)ad.getPrice().intValue() && (1 == ad.getSettleType() || 4 == ad.getSettleType() || 5 == ad.getSettleType())) {
            adTicket.setStatus(Short.valueOf((short)2));
            adTicket.setPauseReason(Integer.valueOf(2));
            LOGGER.info("getId={},getType={},getPauseReason={}", new Object[]{ad.getId(), ad.getType(), ad.getPauseReason()});
            return adTicket;
        }
        AdTicket.AdTicketType adTicketType = AdTicket.AdTicketType.getByType((Short)ad.getType());
        if (AdTicket.AdTicketType.TYPE_ADX_DIRECT != adTicketType && AdTicket.AdTicketType.TYPE_ADX_INTERACT != adTicketType) {
            int currentHour = Calendar.getInstance().get(11);
            if (StringUtils.isNotBlank((CharSequence)adRules)) {
                for (String rule : Splitter.on((String)",").split((CharSequence)adRules)) {
                    boolean isNow;
                    String[] rules = StringUtils.split((String)rule, (char)'-');
                    if (null == rules || rules.length <= 2) continue;
                    int startHour = Integer.parseInt(rules[0]);
                    int endHour = Integer.parseInt(rules[1]);
                    long max = Integer.parseInt(rules[2]);
                    boolean bl = isNow = currentHour >= startHour && currentHour < endHour;
                    if (isNow) {
                        adTicket.setStatus(Short.valueOf((short)1));
                        adTicket.setPauseReason(null);
                        long budgetOfTimeline = this.prodPuller.getBudgetOfTimeline(BigInteger.valueOf(ad.getId()), startHour, endHour);
                        if (budgetOfTimeline >= max) {
                            adTicket.setStatus(Short.valueOf((short)2));
                            adTicket.setPauseReason(Integer.valueOf(5));
                            LOGGER.info("getId={},getType={},getPauseReason={}", new Object[]{ad.getId(), ad.getType(), ad.getPauseReason()});
                        }
                        return adTicket;
                    }
                    adTicket.setStatus(Short.valueOf((short)2));
                    adTicket.setPauseReason(Integer.valueOf(5));
                    LOGGER.info("getId={},getType={},getPauseReason={}", new Object[]{ad.getId(), ad.getType(), ad.getPauseReason()});
                }
            }
        }
        if (AdTicket.AdTicketType.TYPE_ADX_DIRECT == adTicketType || AdTicket.AdTicketType.TYPE_ADX_INTERACT == adTicketType) {
            String clickValue = this.redisClient.hGet(TicketKeyGenerator.Statistics.getClickOfDaily().generateKey(), adTicket.getId().toString(), 0);
            String viewValue = this.redisClient.hGet(TicketKeyGenerator.Statistics.getViewOfDaily().generateKey(), adTicket.getId().toString(), 0);
            if (obj != null && obj.length > 0) {
                adTicketDto = (AdTicketDto)obj[0];
                if (adTicketDto.getAdxConfDto().getClickMaximum() != null) {
                    if (StringUtil.isNotBlank((CharSequence)clickValue) && Integer.valueOf(clickValue) >= adTicketDto.getAdxConfDto().getClickMaximum()) {
                        adTicket.setStatus(Short.valueOf((short)2));
                        adTicket.setPauseReason(Integer.valueOf(99));
                        LOGGER.info("getId={},getType={},getPauseReason={}", new Object[]{ad.getId(), ad.getType(), ad.getPauseReason()});
                        return adTicket;
                    }
                } else if (adTicketDto.getAdxConfDto().getShowMaximum() != null && StringUtil.isNotBlank((CharSequence)viewValue) && Integer.valueOf(viewValue) >= adTicketDto.getAdxConfDto().getShowMaximum()) {
                    adTicket.setStatus(Short.valueOf((short)2));
                    adTicket.setPauseReason(Integer.valueOf(99));
                    LOGGER.info("getId={},getType={},getPauseReason={}", new Object[]{ad.getId(), ad.getType(), ad.getPauseReason()});
                    return adTicket;
                }
            } else {
                adTicketAdxExample = new AdTicketAdxExample();
                adTicketAdxExample.createCriteria().andAdTicketIdEqualTo(adTicket.getId());
                adTicketAdxes = this.adTicketAdxMapperExt.selectByExample(adTicketAdxExample);
                if (CollectionUtils.isNotEmpty((Collection)adTicketAdxes)) {
                    AdTicketAdx adTicketAdx = (AdTicketAdx)adTicketAdxes.get(0);
                    if (adTicketAdx.getClickMaximum() != null) {
                        if (StringUtil.isNotBlank((CharSequence)clickValue) && Integer.valueOf(clickValue) >= adTicketAdx.getClickMaximum()) {
                            adTicket.setStatus(Short.valueOf((short)2));
                            adTicket.setPauseReason(Integer.valueOf(99));
                            LOGGER.info("getId={},getType={},getPauseReason={}", new Object[]{ad.getId(), ad.getType(), ad.getPauseReason()});
                            return adTicket;
                        }
                    } else if (adTicketAdx.getShowMaximum() != null && StringUtil.isNotBlank((CharSequence)viewValue) && Integer.valueOf(viewValue) >= adTicketAdx.getShowMaximum()) {
                        adTicket.setStatus(Short.valueOf((short)2));
                        adTicket.setPauseReason(Integer.valueOf(99));
                        LOGGER.info("getId={},getType={},getPauseReason={}", new Object[]{ad.getId(), ad.getType(), ad.getPauseReason()});
                        return adTicket;
                    }
                }
            }
        }
        if (AdTicket.AdTicketType.TYPE_ADX_DIRECT == adTicketType && null != (budget = this.prodPuller.getAdxBudgetOfToday(ad.getId()))) {
            adxBudgetDaily = 0;
            if (obj != null && obj.length > 0) {
                adTicketDto = (AdTicketDto)obj[0];
                Money money = Money.ofYuan((double)adTicketDto.getAdxConfDto().getAdxBudgetDaily());
                adxBudgetDaily = Long.valueOf(money.getLi()).intValue();
            } else {
                adTicketAdxExample = new AdTicketAdxExample();
                adTicketAdxExample.createCriteria().andAdTicketIdEqualTo(ad.getId());
                adTicketAdxes = this.adTicketAdxMapperExt.selectByExample(adTicketAdxExample);
                if (CollectionUtils.isNotEmpty((Collection)adTicketAdxes)) {
                    adxBudgetDaily = ((AdTicketAdx)adTicketAdxes.get(0)).getAdxBudgetDaily();
                }
            }
            if (budget >= (long)((Integer)adxBudgetDaily).intValue()) {
                adTicket.setStatus(Short.valueOf((short)2));
                adTicket.setPauseReason(Integer.valueOf(1));
                LOGGER.info("ADX\u76f4\u6295\u5238\u65e5\u9884\u7b97\u4e0d\u8db3\uff1agetId={},getType={},getPauseReason={}", new Object[]{ad.getId(), ad.getType(), ad.getPauseReason()});
                return adTicket;
            }
        }
        if (AdTicket.AdTicketType.TYPE_ADX_INTERACT == adTicketType && null != (budget = this.prodPuller.getAdxBudgetOfToday(ad.getId()))) {
            adxBudgetDaily = ad.getBudgetDaily();
            if (budget >= (Long)adxBudgetDaily) {
                adTicket.setStatus(Short.valueOf((short)2));
                adTicket.setPauseReason(Integer.valueOf(1));
                LOGGER.info("ADX\u4e92\u52a8\u5238\u65e5\u9884\u7b97\u4e0d\u8db3\uff1agetId={},getType={},getPauseReason={}", new Object[]{ad.getId(), ad.getType(), ad.getPauseReason()});
                return adTicket;
            }
        }
        return adTicket;
    }

    public Map<String, String> getDictionaries(String typegroupid) {
        List list = this.dictionariesMapper.findAll(typegroupid);
        HashMap<String, String> map = new HashMap<String, String>(list.size());
        for (Dictionaries dictionaries : list) {
            map.put(dictionaries.getTypecode(), dictionaries.getTypename());
        }
        return map;
    }

    public long getId() {
        try {
            this.redisClient.incr(13, ADTICKET_ID);
            return Long.parseLong(this.redisClient.get(13, ADTICKET_ID));
        }
        catch (Exception e) {
            e.printStackTrace();
            return (long)(Math.random() * 9.0E7 + 1.0E7);
        }
    }

    @Override
    public List<AdTicket> findByIds(String ids) {
        if (StringUtil.isNotBlank((CharSequence)ids)) {
            ArrayList<Long> idList = new ArrayList<Long>();
            for (String id : ids.split(",")) {
                idList.add(Long.valueOf(id));
            }
            List list = this.adTicketMapper.findByids(idList);
            return list;
        }
        return null;
    }

    @Override
    public AdTicket find(Long id) {
        return this.adTicketMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<AdTicketCopyVo> getTicketByAdvertiser(Integer advertiserId, Integer ticketId, String ae) throws Exception {
        AdTicketSearchDto adTicketSearchDto = new AdTicketSearchDto();
        adTicketSearchDto.setAdvertiserId(advertiserId);
        adTicketSearchDto.setId(ticketId);
        adTicketSearchDto.setAe(ae);
        List tickets = this.adTicketMapperExt.findTicketByAdvertiser(adTicketSearchDto);
        ArrayList adTicketVoList = Lists.newArrayList();
        if (!CollectionUtils.isNotEmpty((Collection)tickets)) {
            return new ArrayList<AdTicketCopyVo>();
        }
        tickets.forEach(ticket -> {
            AdTicketCopyVo adTicketCopyVo = new AdTicketCopyVo();
            BeanUtils.copyProperties((Object)ticket, (Object)adTicketCopyVo);
            adTicketVoList.add(adTicketCopyVo);
        });
        List<AdTicketCopyVo> sortedList = adTicketVoList.stream().sorted(Comparator.comparing(AdTicketCopyVo::getStatus, (s1, s2) -> {
            if (s1.equals(s2)) {
                return 0;
            }
            if (s1 == 1) {
                return 1;
            }
            if (s2 == 1) {
                return -1;
            }
            return 1;
        }).reversed()).collect(Collectors.toList());
        return sortedList;
    }

    @Override
    public PageInfo<AdTicketWeightVo> queryTicketsByCondition(AdTicketSearchDto adTicketSearchDto) throws Exception {
        String code;
        if (StringUtil.isEmpty((CharSequence)adTicketSearchDto.getSortName())) {
            adTicketSearchDto.setSortName("interventionFactor");
        }
        if (StringUtil.isEmpty((CharSequence)adTicketSearchDto.getSortType())) {
            adTicketSearchDto.setSortType("desc");
        }
        PageInfo adTicketWeightVoPageInfo = new PageInfo();
        ArrayList advertiserIds = Lists.newArrayList();
        String ae = adTicketSearchDto.getAe();
        HashMap advertiserDtoMap = Maps.newHashMap();
        Map aeMaps = this.aclUserIntegration.queryUserByRoleCode("ae", Boolean.valueOf(false));
        if (StringUtils.isNotEmpty((CharSequence)ae) || adTicketSearchDto.getAdvertiserId() != null) {
            AdvertiserDto search = new AdvertiserDto();
            search.setId(adTicketSearchDto.getAdvertiserId());
            search.setAe(ae);
            this.getAdvertisers(advertiserIds, advertiserDtoMap, search);
            if (CollectionUtils.isEmpty((Collection)advertiserIds)) {
                return adTicketWeightVoPageInfo;
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)advertiserIds)) {
            adTicketSearchDto.setList((List)advertiserIds);
        }
        if (StringUtil.isNotBlank((CharSequence)(code = adTicketSearchDto.getStatusCode()))) {
            if (code.contains(STR_TWO)) {
                adTicketSearchDto.setPauseReason(Integer.valueOf(Integer.parseInt(code.substring(2))));
            } else {
                adTicketSearchDto.setStatus(Short.valueOf(code));
            }
        }
        PageHelper.startPage((int)adTicketSearchDto.getPageNum(), (int)adTicketSearchDto.getPageSize());
        List adTicketWeightVos = this.adTicketMapperExt.getTicketsByCondition(adTicketSearchDto);
        adTicketWeightVoPageInfo = new PageInfo(adTicketWeightVos);
        if (CollectionUtils.isNotEmpty((Collection)adTicketWeightVos)) {
            if (advertiserDtoMap.isEmpty()) {
                adTicketWeightVos.forEach(adTicketWeightVo -> advertiserIds.add(adTicketWeightVo.getAdvertiser()));
                this.dealAdvertiserInfo(adTicketSearchDto, advertiserIds, ae, advertiserDtoMap, aeMaps, adTicketWeightVos);
            } else {
                adTicketWeightVos.forEach(adTicketWeightVo -> {
                    if (!advertiserDtoMap.isEmpty()) {
                        String aeCode = advertiserDtoMap.getOrDefault(adTicketWeightVo.getAdvertiser().toString(), new AdvertiserDto()).getAe();
                        adTicketWeightVo.setAeCode(aeCode);
                        adTicketWeightVo.setAe((String)aeMaps.get(aeCode));
                        if (adTicketWeightVo.getAdvertiser() != null) {
                            adTicketWeightVo.setCompany(advertiserDtoMap.getOrDefault(adTicketWeightVo.getAdvertiser().toString(), new AdvertiserDto()).getCompany());
                        }
                    }
                });
            }
        }
        return adTicketWeightVoPageInfo;
    }

    private void getAdvertisers(List<Long> advertiserIds, Map<String, AdvertiserDto> advertiserDtoMap, AdvertiserDto search) throws Exception {
        List adShopList = this.adShopIntegration.getAdShopList(search);
        if (CollectionUtils.isNotEmpty((Collection)adShopList)) {
            adShopList.forEach(advertiserDto -> {
                Integer advertiserId = advertiserDto.getId();
                if (advertiserId != null) {
                    advertiserIds.add(advertiserDto.getId().longValue());
                    advertiserDtoMap.put(advertiserId.toString(), (AdvertiserDto)advertiserDto);
                }
            });
        }
    }

    private Map<Long, AdTicketWeightManualConf> queryAdTicketWeightManualConfByTickes(List<AdTicket> adTickets) {
        HashMap adTicketWeightManualConfMap = Maps.newHashMap();
        ArrayList ticketIds = Lists.newArrayList();
        if (!CollectionUtils.isNotEmpty(adTickets)) {
            return adTicketWeightManualConfMap;
        }
        adTickets.forEach(adTicket -> ticketIds.add(adTicket.getId()));
        List adTicketWeightManualConfs = this.adTicketWeightManualConfMapperExt.selectByTicketIds((List)ticketIds);
        if (!CollectionUtils.isNotEmpty((Collection)adTicketWeightManualConfs)) {
            return adTicketWeightManualConfMap;
        }
        adTicketWeightManualConfs.forEach(adTicketWeightManualConf -> adTicketWeightManualConfMap.put(adTicketWeightManualConf.getTicketId(), adTicketWeightManualConf));
        return adTicketWeightManualConfMap;
    }

    private void dealAdvertiserInfo(AdTicketSearchDto adTicketSearchDto, List<Long> advertiserIds, String ae, Map<String, AdvertiserDto> advertiserDtoMap, Map<String, String> aeMaps, List<AdTicketWeightVo> adTicketWeightVos) throws IOException {
        if (StringUtils.isEmpty((CharSequence)ae) && adTicketSearchDto.getAdvertiserId() == null && CollectionUtils.isNotEmpty(advertiserIds)) {
            StringBuffer adshops = new StringBuffer();
            advertiserIds.forEach(advertiserId -> adshops.append(advertiserId + ","));
            List list = this.adShopIntegration.findAdShopMsgs(adshops.toString());
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                list.forEach(advertiserDto -> {
                    if (advertiserDto.getId() != null) {
                        advertiserDtoMap.put(advertiserDto.getId().toString(), (AdvertiserDto)advertiserDto);
                    }
                });
            }
            adTicketWeightVos.forEach(adTicketWeightVo -> {
                String aeCode = advertiserDtoMap.getOrDefault(adTicketWeightVo.getAdvertiser().toString(), new AdvertiserDto()).getAe();
                adTicketWeightVo.setAeCode(aeCode);
                adTicketWeightVo.setAe((String)aeMaps.get(aeCode));
                if (adTicketWeightVo.getAdvertiser() != null) {
                    adTicketWeightVo.setCompany(advertiserDtoMap.getOrDefault(adTicketWeightVo.getAdvertiser().toString(), new AdvertiserDto()).getCompany());
                }
            });
        }
    }

    @Override
    public List<AdTicketWeightVo> queryAdvertiserByCondition(String ae, Integer advertiserId) throws Exception {
        AdvertiserDto search = new AdvertiserDto();
        search.setAe(ae);
        search.setId(advertiserId);
        List adShopList = this.adShopIntegration.getAdShopList(search);
        ArrayList adTicketWeightVos = Lists.newArrayList();
        Map aeMaps = this.aclUserIntegration.queryUserByRoleCode("ae", Boolean.valueOf(false));
        if (!CollectionUtils.isNotEmpty((Collection)adShopList)) {
            return new ArrayList<AdTicketWeightVo>();
        }
        adShopList.forEach(advertiserDto -> {
            AdTicketWeightVo adTicketWeightVo = new AdTicketWeightVo();
            BeanUtils.copyProperties((Object)advertiserDto, (Object)adTicketWeightVo);
            if (advertiserDto.getId() != null) {
                adTicketWeightVo.setAdvertiser(Long.valueOf(advertiserDto.getId().longValue()));
            }
            adTicketWeightVo.setAeCode(adTicketWeightVo.getAe());
            adTicketWeightVo.setAe((String)aeMaps.get(adTicketWeightVo.getAe()));
            adTicketWeightVos.add(adTicketWeightVo);
        });
        return adTicketWeightVos;
    }

    @Override
    public Boolean updateInterventionFactor(Integer ticketId, Double interventionFactor, String userName) throws Exception {
        HashMap paramMap = Maps.newHashMap();
        if (ticketId == null) {
            throw new ValidateException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        paramMap.put("ticketId", ticketId);
        if (interventionFactor == null) {
            throw new ValidateException("\u5e72\u9884\u7cfb\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        paramMap.put("interventionFactor", interventionFactor);
        if (StringUtils.isEmpty((CharSequence)userName)) {
            throw new ValidateException("\u4fee\u6539\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        paramMap.put("userName", userName);
        paramMap.put("modifyTime", new Date());
        if (this.adTicketWeightManualConfMapperExt.updateInterventionFactor((Map)paramMap) < 1) {
            throw new BusinessException("\u4fee\u6539\u672c\u5730\u5e93\u7684\u624b\u52a8\u5e72\u9884\u7cfb\u6570\u5931\u8d25");
        }
        Double value = org.apache.commons.lang3.math.NumberUtils.toDouble((String)interventionFactor.toString(), (double)100.0) / 100.0;
        this.redisNewClient.hset("AD:WEIGHT:GLOBAL_TICKET", ticketId.toString(), value.toString(), 0, null);
        return true;
    }

    @Override
    public List<AdTicketWeightVo> getAllAe() throws Exception {
        ArrayList adTicketWeightVos = Lists.newArrayList();
        Map aes = this.aclUserIntegration.queryUserByRoleCode("ae", Boolean.valueOf(false));
        if (aes.isEmpty()) {
            return new ArrayList<AdTicketWeightVo>();
        }
        for (String key : aes.keySet()) {
            AdTicketWeightVo adTicketWeightVo = new AdTicketWeightVo();
            adTicketWeightVo.setAeCode(key);
            adTicketWeightVo.setAe((String)aes.get(key));
            adTicketWeightVos.add(adTicketWeightVo);
        }
        return adTicketWeightVos;
    }

    @Override
    public List<AdTicket> queryTicketListByCondition(AdTicketSearchDto search) {
        return this.adTicketMapperExt.findTicketListByCondition(search);
    }

    @Override
    public Boolean isCheck(String isCheck) {
        try {
            this.redisClient.set(13, IS_CHECK, isCheck);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("\u5168\u5c40\u5238\u5ba1\u6838\u64cd\u4f5c\u5931\u8d25" + e.getMessage(), (Throwable)e);
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String getIsCheck() {
        try {
            return this.redisClient.get(13, IS_CHECK);
        }
        catch (Exception e) {
            LOGGER.error("\u5168\u5c40\u5238\u5ba1\u6838\u5b57\u6bb5\u503c\u83b7\u53d6\u5931\u8d25" + e.getMessage(), (Throwable)e);
            e.printStackTrace();
            return Math.random() * 9.0E7 + 1.0E7 + "";
        }
    }

    @Override
    public Map<String, Object> getList(String keyWord, String sale, String ae, Integer pageNum, Integer pageSize) throws Exception {
        List<Object> pageList = Lists.newArrayList();
        AdTicketSearchDto search = new AdTicketSearchDto();
        if (keyWord != "" && !StringUtil.isEmpty((CharSequence)keyWord)) {
            search.setAdvertiseIdOrName(keyWord);
        }
        if (sale != "" && !StringUtil.isEmpty((CharSequence)sale)) {
            search.setSale(sale);
        }
        if (ae != "" && !StringUtil.isEmpty((CharSequence)ae)) {
            search.setAe(ae);
        }
        List<AdvertiserDto> advertiserDtoList = this.getAllAdvertiser(search);
        HashMap resultMap = Maps.newHashMap();
        resultMap.put("totalNum", 0);
        resultMap.put("pageList", pageList);
        if (CollectionUtils.isEmpty(advertiserDtoList)) {
            return resultMap;
        }
        Map<Integer, AdvertiserDto> map = advertiserDtoList.stream().collect(Collectors.toMap(AdvertiserDto::getId, advertiserDto -> advertiserDto));
        ArrayList advtiserIds = Lists.newArrayList();
        advertiserDtoList.forEach(advertiserDto -> advtiserIds.add(advertiserDto.getId()));
        List list = this.adTicketMapperExt.findStatusNum((List)advtiserIds);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return resultMap;
        }
        list.forEach(advertiserCheckDto -> {
            advertiserCheckDto.setCompany(((AdvertiserDto)map.get(advertiserCheckDto.getAdvertiser())).getCompany());
            advertiserCheckDto.setSale(((AdvertiserDto)map.get(advertiserCheckDto.getAdvertiser())).getSale());
            advertiserCheckDto.setAe(((AdvertiserDto)map.get(advertiserCheckDto.getAdvertiser())).getAe());
            advertiserCheckDto.setCreated(((AdvertiserDto)map.get(advertiserCheckDto.getAdvertiser())).getCreated());
        });
        Collections.sort(list, new Comparator<AdvertiserCheckDto>(){

            @Override
            public int compare(AdvertiserCheckDto o1, AdvertiserCheckDto o2) {
                if (o1.getCheckingNum().equals(o2.getCheckingNum()) && o1.getCreated().after(o2.getCreated())) {
                    return -1;
                }
                if (o1.getCheckingNum().equals(o2.getCheckingNum()) && o1.getCreated().before(o2.getCreated())) {
                    return 1;
                }
                return 0;
            }
        });
        pageList = ListUtil.getTotalPage(list, list.size(), pageNum, pageSize);
        resultMap.put("totalNum", list.size());
        resultMap.put("pageList", pageList);
        return resultMap;
    }

    @Override
    public Map<String, Object> getCheckList(Integer advertiserId, Integer status, String keyWord, Integer pageNum, Integer pageSize) throws Exception {
        List advertiserList = this.adShopIntegration.findAdShopMsgs(advertiserId + "");
        Map<Integer, String> map = advertiserList.stream().collect(Collectors.toMap(AdvertiserDto::getId, AdvertiserDto::getCompany));
        ArrayList ids = Lists.newArrayList();
        advertiserList.forEach(advertiserDto -> ids.add(advertiserDto.getId()));
        List list = this.adTicketMapperExt.findCheckTicket((List)ids, status, keyWord);
        list.forEach(adTicketCheckDto -> {
            adTicketCheckDto.setAdvertiser(adTicketCheckDto.getAdvertiser());
            adTicketCheckDto.setAdvertiserShow("(" + adTicketCheckDto.getAdvertiser() + ")" + (StringUtil.isEmpty((CharSequence)((CharSequence)map.get(Integer.parseInt(adTicketCheckDto.getAdvertiser())))) ? "\u540d\u79f0\u67e5\u4e0d\u5230" : (String)map.get(Integer.parseInt(adTicketCheckDto.getAdvertiser()))));
            List<Long> assetsLists = null;
            try {
                Long min;
                AdAssets record;
                assetsLists = this.queryModifyAssetsIdByTicketId(adTicketCheckDto.getId());
                if (!CollectionUtils.isEmpty(assetsLists) && (record = this.adAssetsMapper.selectByPrimaryKey(min = Collections.min(assetsLists))) != null) {
                    adTicketCheckDto.setAssetsImg(record.getImage());
                }
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            adTicketCheckDto.setModifyTime(adTicketCheckDto.getModifyTime() == null ? adTicketCheckDto.getCreateTime() : adTicketCheckDto.getModifyTime());
        });
        Integer totalNum = list.size();
        List pageList = ListUtil.getTotalPage(list, list.size(), pageNum, pageSize);
        HashMap resultMap = Maps.newHashMap();
        resultMap.put("totalNum", totalNum);
        resultMap.put("pageList", pageList);
        return resultMap;
    }

    @Override
    public PageInfo<AdTicketCheckDto> getWaitCheckList(String advertiser, String keyWord, String sale, String ae, String createUser, Integer pageNum, Integer pageSize) throws Exception {
        long count = this.adTicketMapperExt.findTicketByStatus((short)-2);
        List list = Lists.newArrayList();
        if (count > 0L) {
            AdTicketSearchDto search = new AdTicketSearchDto();
            String queryFlag = STR_ZERO;
            if (StringUtils.isNotBlank((CharSequence)advertiser)) {
                queryFlag = "1";
                search.setAdvertiseIdOrName(advertiser);
            }
            if (StringUtils.isNotBlank((CharSequence)sale)) {
                queryFlag = "1";
                search.setSale(sale);
            }
            if (StringUtils.isNotBlank((CharSequence)ae)) {
                queryFlag = "1";
                search.setAe(ae);
            }
            String aeNew = ae;
            search.setAe(null);
            List<AdvertiserDto> advertiserDtoList = this.getAllAdvertiser(search);
            Map<Integer, Object> advertiserMap = null;
            if (!CollectionUtils.isEmpty(advertiserDtoList)) {
                advertiserMap = advertiserDtoList.stream().collect(Collectors.toMap(AdvertiserDto::getId, AdvertiserDto::getCompany));
            }
            ArrayList ids = new ArrayList();
            if (!CollectionUtils.isEmpty(advertiserDtoList)) {
                advertiserDtoList.forEach(advertiserDto -> ids.add(advertiserDto.getId()));
            } else {
                advertiserMap = new HashMap<Integer, Object>();
            }
            PageHelper.startPage((int)pageNum, (int)pageSize);
            list = this.adTicketMapperExt.findWaitCheckTicket(ids, Integer.valueOf(String.valueOf(-2)), keyWord, createUser, queryFlag, aeNew);
            String reCheckIds = this.redisNewClient.getRedis("AD:TICKET:REUPDATETICKET");
            List reCheckList = Lists.newArrayList();
            if (StringUtils.isNotEmpty((CharSequence)reCheckIds) && !reCheckIds.equals("[]")) {
                reCheckList = JSON.parseArray((String)reCheckIds, Long.class);
            }
            if (!CollectionUtils.isEmpty((Collection)list)) {
                for (AdTicketCheckDto record : list) {
                    List<Long> assetsLists = null;
                    try {
                        assetsLists = this.queryModifyAssetsIdByTicketId(record.getId());
                        if (CollectionUtils.isNotEmpty(assetsLists)) {
                            Long min = Collections.min(assetsLists);
                            AdAssets assets = this.adAssetsMapper.selectByPrimaryKey(min);
                            if (record != null) {
                                record.setAssetsImg(assets.getImage());
                            }
                        }
                    }
                    catch (Exception e) {
                        try {
                            throw e;
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)record.getAdvertiser())) {
                        Object object = advertiserMap.get(Integer.parseInt(record.getAdvertiser()));
                        if (object != null) {
                            record.setAdvertiserShow("(" + record.getAdvertiser() + ")" + String.valueOf(object));
                        } else {
                            record.setAdvertiserShow("\u540d\u79f0\u67e5\u4e0d\u5230");
                        }
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)reCheckList) || !reCheckList.contains(record.getId())) continue;
                    record.setIsReCheck(Short.valueOf((short)1));
                }
            }
        }
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean updateQualify(List<TblAdQualify> list, String deleteIds, Integer advertiserId) throws Exception {
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        for (TblAdQualify tblAdQualify : list) {
            if (tblAdQualify.getId() == null) {
                tblAdQualify.setAdvertiserId(Long.valueOf(advertiserId.longValue()));
                tblAdQualify.setAuditStatus(Integer.valueOf(1));
                this.tblAdQualifyMapperExt.insertSelective(tblAdQualify);
                continue;
            }
            tblAdQualify.setAdvertiserId(Long.valueOf(advertiserId.longValue()));
            tblAdQualify.setAuditStatus(Integer.valueOf(1));
            this.tblAdQualifyMapperExt.updateByPrimaryKeySelective(tblAdQualify);
        }
        if (!"[]".equals(deleteIds)) {
            List deleteList = JSON.parseArray((String)deleteIds, String.class);
            this.tblAdQualifyMapperExt.deleteQualify(deleteList, new Date());
        }
        return true;
    }

    @Override
    public List<TblAdQualify> findQualifyList(Integer advertiserId) {
        return this.tblAdQualifyMapperExt.findQualifyList(advertiserId);
    }

    @Override
    public AdTicketCheckInfokDto getTicketInfo(Long ticketId) {
        AdTicketCheckInfokDto adTicketCheckInfokDto = new AdTicketCheckInfokDto();
        AdTicket adTicket = this.adTicketMapper.selectByPrimaryKey(ticketId);
        adTicketCheckInfokDto.setTicketName(adTicket.getName());
        adTicketCheckInfokDto.setUrl(adTicket.getUrl());
        String adTags = this.adTicketTagConfService.findByTicketId(adTicket.getId());
        adTicketCheckInfokDto.setTags(adTags);
        String assetsids = this.adTicketAssetsRefService.findByTicketId(adTicket.getId());
        adTicketCheckInfokDto.setAssets(assetsids);
        adTicketCheckInfokDto.setDomainCode(adTicket.getDomainCode());
        adTicketCheckInfokDto.setRefuseReason(adTicket.getRefuseReason());
        return adTicketCheckInfokDto;
    }

    @Override
    public AdTicketCheckInfokDto getTicketInfoAndAssetsModify(Long ticketId) throws Exception {
        AdTicketCheckInfokDto adTicketCheckInfokDto = new AdTicketCheckInfokDto();
        AdTicket adTicket = this.adTicketMapper.selectByPrimaryKey(ticketId);
        adTicketCheckInfokDto.setTicketName(adTicket.getName());
        adTicketCheckInfokDto.setTicketType(adTicket.getType());
        adTicketCheckInfokDto.setUrl(adTicket.getUrl());
        String adTags = this.adTicketTagConfService.findByTicketId(adTicket.getId());
        adTicketCheckInfokDto.setTags(adTags);
        List<Long> assetsIdList = this.queryModifyAssetsIdByTicketId(ticketId);
        if (!CollectionUtils.isEmpty(assetsIdList)) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < assetsIdList.size(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(assetsIdList.get(i));
            }
            adTicketCheckInfokDto.setAssets(sb.toString());
        }
        adTicketCheckInfokDto.setDomainCode(adTicket.getDomainCode());
        adTicketCheckInfokDto.setRefuseReason(adTicket.getRefuseReason());
        return adTicketCheckInfokDto;
    }

    @Override
    public List<Long> queryModifyAssetsIdByTicketId(Long ticketId) throws Exception {
        AdTicket adTicket = this.adTicketMapper.selectByPrimaryKey(ticketId);
        Short lastStatus = null;
        ArrayList<Long> modifyAssetsIds = new ArrayList<Long>();
        if (adTicket != null) {
            TblAdTicketModify ticketLog;
            lastStatus = adTicket.getLastStatus();
            if (lastStatus != null && lastStatus == 0) {
                AdTicket.AdTicketType adTicketType = AdTicket.AdTicketType.getByType((Short)adTicket.getType());
                if (AdTicket.AdTicketType.TYPE_NORMALS == adTicketType || AdTicket.AdTicketType.TYPE_STANDBYS == adTicketType || AdTicket.AdTicketType.TYPE_ENCOURAGE == adTicketType || AdTicket.AdTicketType.TYPE_RTA == adTicketType || AdTicket.AdTicketType.TYPE_DSP == adTicketType || AdTicket.AdTicketType.TYPE_PUSH == adTicketType) {
                    List assestsList = this.adAssetsMapper.findAllByTicketId(ticketId);
                    if (CollectionUtils.isNotEmpty((Collection)assestsList)) {
                        for (AdAssets adAssets : assestsList) {
                            modifyAssetsIds.add(adAssets.getId());
                        }
                    }
                } else if (AdTicket.AdTicketType.TYPE_COUPON == adTicketType) {
                    List<AdAssetsCoupons> adAssetsCouponsList = this.adTicketAssetsCouponsService.findByTicketId(ticketId);
                    if (CollectionUtils.isNotEmpty(adAssetsCouponsList)) {
                        for (AdAssetsCoupons adAssetsCoupons : adAssetsCouponsList) {
                            modifyAssetsIds.add(adAssetsCoupons.getId());
                        }
                    }
                } else if (AdTicket.AdTicketType.TYPE_ADX_DIRECT == adTicketType || AdTicket.AdTicketType.TYPE_ADX_INTERACT == adTicketType) {
                    AdAssetsAdxExample adAssetsAdxExample = new AdAssetsAdxExample();
                    adAssetsAdxExample.createCriteria().andAdTicketIdEqualTo(adTicket.getId());
                    List adAssetsAdxList = this.adAssetsAdxMapperExt.selectByExample(adAssetsAdxExample);
                    if (CollectionUtils.isNotEmpty((Collection)adAssetsAdxList)) {
                        for (AdAssetsAdx record : adAssetsAdxList) {
                            modifyAssetsIds.add(record.getId());
                        }
                    }
                }
            }
            if (lastStatus != null && lastStatus != 0 && (ticketLog = this.getTicketLog(ticketId)) != null && StringUtils.isNotBlank((CharSequence)ticketLog.getLog())) {
                String log = ticketLog.getLog();
                String regex = "\\d*";
                Pattern pattern = Pattern.compile(regex);
                Matcher m = pattern.matcher(log);
                while (m.find()) {
                    if (!StringUtils.isNotBlank((CharSequence)m.group())) continue;
                    modifyAssetsIds.add(Long.valueOf(m.group()));
                }
            }
        }
        if (!CollectionUtils.isEmpty(modifyAssetsIds)) {
            modifyAssetsIds = new ArrayList<Long>(new LinkedHashSet<Long>(modifyAssetsIds));
        }
        return modifyAssetsIds;
    }

    @Override
    public List<AdTicketVo> findBykeywords(AdTicketSearchDto condition) {
        List list = this.adTicketMapper.findAll(condition);
        ArrayList<AdTicketVo> adTicketvoList = new ArrayList<AdTicketVo>();
        if (list != null && list.size() > 0) {
            for (AdTicket at : list) {
                AdTicketVo atv = new AdTicketVo();
                atv.setId(Integer.valueOf(Integer.parseInt(at.getId() + "")));
                atv.setName(at.getName());
                adTicketvoList.add(atv);
            }
        }
        return adTicketvoList;
    }

    @Override
    @Transactional
    public Boolean checkTicketAssets(AdTicketDto adTicketDto, AdTicket adTicket, User user) {
        Object idsStr;
        List<AdAssets> allAssetsList;
        AdTicket.AdTicketType adTicketType;
        ArrayList<Long> allAssetIdList = new ArrayList<Long>();
        String log = adTicketDto.getLog();
        Boolean flag = false;
        Long tempId = 0L;
        if (StringUtils.isNotBlank((CharSequence)adTicketDto.getUrl()) && !adTicket.getUrl().equals(adTicketDto.getUrl())) {
            flag = true;
            if (StringUtil.isEmpty((CharSequence)log) || "-".equals(log) || "1".equals(log)) {
                String logNew = "\u843d\u5730\u9875\u5730\u5740\u53d8\u66f4;";
                TblAdTicketModify tblAdTicketModify = new TblAdTicketModify();
                tblAdTicketModify.setTicketId(Long.valueOf(adTicketDto.getId().longValue()));
                tblAdTicketModify.setLog(logNew);
                tblAdTicketModify.setCreateTime(new Date());
                tblAdTicketModify.setCreateUser("AE");
                if (user == null) {
                    tblAdTicketModify.setCreateUser("\u5e7f\u544a\u4e3b");
                }
                this.tblAdTicketModifyMapperExt.insertSelective(tblAdTicketModify);
                tempId = tblAdTicketModify.getId();
            } else {
                String logId = log.split("-")[0];
                Long id = Integer.parseInt(logId);
                String logNew = log + "\u843d\u5730\u9875\u5730\u5740\u53d8\u66f4;";
                TblAdTicketModify tblAdTicketModify = new TblAdTicketModify();
                tblAdTicketModify.setCreateTime(new Date());
                tblAdTicketModify.setLog(logNew);
                tblAdTicketModify.setId(id);
                this.tblAdTicketModifyMapperExt.updateByPrimaryKeySelective(tblAdTicketModify);
                tempId = id;
            }
        }
        if (AdTicket.AdTicketType.TYPE_NORMALS == (adTicketType = AdTicket.AdTicketType.getByType((Short)adTicketDto.getType())) || AdTicket.AdTicketType.TYPE_STANDBYS == adTicketType || AdTicket.AdTicketType.TYPE_ENCOURAGE == adTicketType || AdTicket.AdTicketType.TYPE_DSP == adTicketType || AdTicket.AdTicketType.TYPE_RTA == adTicketType || AdTicket.AdTicketType.TYPE_PUSH == adTicketType) {
            allAssetsList = this.adTicketAssetsService.findAllAssetsById(adTicketDto.getId().longValue());
            if (CollectionUtils.isNotEmpty(allAssetsList) && StringUtils.isNotBlank((CharSequence)adTicketDto.getAssetsids())) {
                for (AdAssets adAssets : allAssetsList) {
                    allAssetIdList.add(adAssets.getId());
                }
                idsStr = adTicketDto.getAssetsids().split(",");
                flag = this.updateAdTicketModifyInfo(adTicketDto, user, allAssetIdList, log, flag, tempId, (String[])idsStr);
            }
        } else if (AdTicket.AdTicketType.TYPE_COUPON == adTicketType) {
            allAssetsList = this.adTicketAssetsCouponsService.findByTicketId(adTicketDto.getId().longValue());
            if (CollectionUtils.isNotEmpty(allAssetsList) && StringUtils.isNotBlank((CharSequence)adTicketDto.getAssetscouponsids())) {
                for (AdAssetsCoupons adAssetsCoupons : allAssetsList) {
                    allAssetIdList.add(adAssetsCoupons.getId());
                }
                idsStr = adTicketDto.getAssetscouponsids().split(",");
                flag = this.updateAdTicketModifyInfo(adTicketDto, user, allAssetIdList, log, flag, tempId, (String[])idsStr);
            }
        } else if (AdTicket.AdTicketType.TYPE_ADX_DIRECT == adTicketType || AdTicket.AdTicketType.TYPE_ADX_INTERACT == adTicketType) {
            AdAssetsAdxExample adAssetsAdxExample = new AdAssetsAdxExample();
            adAssetsAdxExample.createCriteria().andAdTicketIdEqualTo(adTicket.getId());
            List adAssetsAdxList = this.adAssetsAdxMapperExt.selectByExample(adAssetsAdxExample);
            if (CollectionUtils.isNotEmpty((Collection)adAssetsAdxList) && StringUtils.isNotBlank((CharSequence)adTicketDto.getAssetsadxids())) {
                for (AdAssetsAdx recocd : adAssetsAdxList) {
                    allAssetIdList.add(recocd.getId());
                }
                String[] stringArray = adTicketDto.getAssetsadxids().split(",");
                flag = this.updateAdTicketModifyInfo(adTicketDto, user, allAssetIdList, log, flag, tempId, stringArray);
            }
        }
        return flag;
    }

    private Boolean updateAdTicketModifyInfo(AdTicketDto adTicketDto, User user, List<Long> allAssetIdList, String log, Boolean flag, Long tempId, String[] idsStr) {
        ArrayList<Long> longList = new ArrayList<Long>(idsStr.length);
        for (String id : idsStr) {
            longList.add(Long.valueOf(id));
        }
        if (!allAssetIdList.containsAll(longList)) {
            flag = true;
            String ids = this.getDifferentId(allAssetIdList, longList);
            if (StringUtil.isEmpty((CharSequence)log) || "-".equals(log) || "1".equals(log)) {
                if (0L == tempId) {
                    String logNew = "\u65b0\u589e\u7d20\u6750ID:" + ids;
                    TblAdTicketModify tblAdTicketModify = new TblAdTicketModify();
                    tblAdTicketModify.setTicketId(Long.valueOf(adTicketDto.getId().longValue()));
                    tblAdTicketModify.setLog(logNew);
                    tblAdTicketModify.setCreateTime(new Date());
                    tblAdTicketModify.setCreateUser("AE");
                    if (user == null) {
                        tblAdTicketModify.setCreateUser("\u5e7f\u544a\u4e3b");
                    }
                    this.tblAdTicketModifyMapperExt.insertSelective(tblAdTicketModify);
                } else {
                    TblAdTicketModify tblAdTicketModify = this.tblAdTicketModifyMapperExt.selectByPrimaryKey(tempId);
                    tblAdTicketModify.getLog();
                    String logNew = tblAdTicketModify.getLog() + "\u65b0\u589e\u7d20\u6750ID:" + ids;
                    tblAdTicketModify.setLog(logNew);
                    this.tblAdTicketModifyMapperExt.updateByPrimaryKeySelective(tblAdTicketModify);
                }
            } else if (0L == tempId) {
                String logId = log.split("-")[0];
                Long id = Integer.parseInt(logId);
                TblAdTicketModify tblAdTicketModify = this.tblAdTicketModifyMapperExt.selectByPrimaryKey(id);
                String assetsLog = tblAdTicketModify.getLog();
                String logNew = assetsLog + "\u65b0\u589e\u7d20\u6750ID:" + ids;
                tblAdTicketModify.setLog(logNew);
                tblAdTicketModify.setCreateTime(new Date());
                this.tblAdTicketModifyMapperExt.updateByPrimaryKeySelective(tblAdTicketModify);
            } else {
                TblAdTicketModify tblAdTicketModify = this.tblAdTicketModifyMapperExt.selectByPrimaryKey(tempId);
                String assetsLog = tblAdTicketModify.getLog();
                String logNew = assetsLog + "\u65b0\u589e\u7d20\u6750ID:" + ids;
                tblAdTicketModify.setLog(logNew);
                tblAdTicketModify.setCreateTime(new Date());
                this.tblAdTicketModifyMapperExt.updateByPrimaryKeySelective(tblAdTicketModify);
            }
        }
        if (allAssetIdList.size() != longList.size() && allAssetIdList.containsAll(longList)) {
            flag = true;
        }
        return flag;
    }

    @Override
    public TblAdTicketModify getTicketLog(Long ticketId) {
        return this.tblAdTicketModifyMapperExt.getTicketLog(ticketId);
    }

    @Override
    public List<TblAdTicketModify> getTicketLogListByTicketId(Long ticketId) {
        return this.tblAdTicketModifyMapperExt.getTicketLogListByTicketId(ticketId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean ticketCheck(Long ticketId, Integer status, String refuseReason, String tags, String domainCode, String auditUser) throws Exception {
        AdTicket adTicket = this.adTicketMapper.selectByPrimaryKey(ticketId);
        if (null == adTicket) {
            return Boolean.FALSE;
        }
        HashMap map = Maps.newHashMap();
        if (status == 0) {
            map.put("ticketId", ticketId);
            map.put("status", (short)-3);
            map.put("refuseReason", refuseReason);
            int n = this.adTicketMapperExt.updateStatus((Map)map);
        } else {
            if (adTicket.getLastStatus() <= 0) {
                String modifyUser = null;
                modifyUser = adTicket.getModifyUser();
                if (StringUtils.isBlank((CharSequence)modifyUser)) {
                    modifyUser = adTicket.getCreateUser();
                }
                map.put("status", (short)3);
                if (modifyUser.contains("advertiser") || modifyUser.contains(AdTicket.CPC_ADVERTISER)) {
                    map.put("status", (short)-1);
                }
                map.put("ticketId", ticketId);
                map.put("domainCode", domainCode);
                map.put("refuseReason", "");
                this.adTicketMapperExt.updateStatus((Map)map);
            } else {
                map.put("ticketId", ticketId);
                map.put("status", adTicket.getLastStatus());
                if (2 == adTicket.getLastStatus()) {
                    String tiems = null;
                    AdTicket ticketCheck = this.checkStatus(adTicket, adTicket, tiems, new Object[0]);
                    map.put("status", ticketCheck.getStatus());
                    map.put("pauseReason", ticketCheck.getPauseReason());
                }
                map.put("domainCode", domainCode);
                map.put("refuseReason", "");
                this.adTicketMapperExt.updateStatus((Map)map);
            }
            String ids = this.redisNewClient.getRedis("AD:TICKET:REUPDATETICKET");
            if (StringUtils.isNotEmpty((CharSequence)ids)) {
                String json;
                List list = JSON.parseArray((String)ids, String.class);
                if (list.contains(ticketId + "")) {
                    list.remove(ticketId + "");
                }
                if ((json = JSON.toJSONString((Object)list)).equals("[]")) {
                    this.redisNewClient.delKey("AD:TICKET:REUPDATETICKET", 0);
                } else {
                    this.redisNewClient.set("AD:TICKET:REUPDATETICKET", json);
                }
            }
        }
        String tagCode = this.adTicketTagConfService.findCode(ticketId, 2);
        this.adTicketTagConfService.delete(ticketId);
        if (StringUtil.isNotBlank((CharSequence)tags)) {
            this.adTicketTagConfService.addBatch(tags, ticketId);
        }
        AdTicketDto adTicketDto = new AdTicketDto();
        adTicketDto.setId(Integer.valueOf(ticketId.intValue()));
        adTicketDto.setTags(tags);
        if (StringUtils.isEmpty((CharSequence)tagCode)) {
            tagCode = "-99";
        }
        this.updateCostWarn(adTicketDto, tagCode);
        this.prodService.pushAdTicketToProdPre(ticketId);
        AdAuditRecord adAuditRecord = new AdAuditRecord();
        adAuditRecord.setTicketId(ticketId);
        adAuditRecord.setAuditType(AdAuditRecord.AUDITTYPE_TICKET);
        adAuditRecord.setSubmitTime(adTicket.getModifyTime());
        adAuditRecord.setTicketAuditStatus(status.equals(0) ? AdAuditRecord.AUDITSTAUS_REFUSE : AdAuditRecord.AUDITSTAUS_PASS);
        adAuditRecord.setTicketType(adTicket.getType());
        adAuditRecord.setTicketName(adTicket.getName());
        adAuditRecord.setAuditUser(auditUser);
        this.adAuditRecordMapper.insertSelective(adAuditRecord);
        return Boolean.TRUE;
    }

    @Override
    public PaginationTemp findUrlTestList(AdTicketSearchDto condition) throws Exception {
        ArrayList<Long> longList;
        PaginationTemp pagination = new PaginationTemp();
        String ae = condition.getAe();
        condition.setAe(null);
        List<AdvertiserDto> advertiserDtoList = this.getAllAdvertiser(condition);
        HashMap saleMap = Maps.newHashMap();
        if (advertiserDtoList != null && advertiserDtoList.size() > 0) {
            longList = new ArrayList<Long>(advertiserDtoList.size());
            for (AdvertiserDto ad : advertiserDtoList) {
                longList.add(ad.getId().longValue());
                saleMap.put(ad.getId(), ad.getSale());
            }
        } else {
            return pagination;
        }
        condition.setList(longList);
        condition.setAe(ae);
        Integer totalcount = this.adTicketMapper.urlTestCount(condition);
        List list = this.adTicketMapper.findUrlTestList(condition);
        if (totalcount == 0 || CollectionUtils.isEmpty((Collection)list)) {
            return pagination;
        }
        List userList = this.dictionariesMapper.find();
        Map userMap = userList.stream().collect(HashMap::new, (k, v) -> k.put(v.getTypecode(), v.getTypename()), HashMap::putAll);
        for (AdTicketUrlTest adTicketUrlTest : list) {
            String saleRealName = (String)userMap.get(saleMap.get(adTicketUrlTest.getAdvertiser().intValue()));
            String aeRealName = (String)userMap.get(adTicketUrlTest.getAe());
            adTicketUrlTest.setSale(saleRealName);
            adTicketUrlTest.setAe(aeRealName);
        }
        pagination.setList(list);
        pagination.setPageSize(condition.getPageSize());
        pagination.setPageNo(condition.getPageNum());
        pagination.setTotalCount(totalcount.intValue());
        return pagination;
    }

    public String getDifferentId(List<Long> oldList, List<Long> newList) {
        String addAssetsIds = "";
        if (!CollectionUtils.isEmpty(oldList)) {
            for (Long along : newList) {
                if (oldList.contains(along)) continue;
                addAssetsIds = addAssetsIds + along + ",";
            }
        }
        return addAssetsIds;
    }

    private boolean updateTicketStatus(AdTicket adTicket) throws Exception {
        if (null == adTicket) {
            throw new IllegalTicketException("Ticket does not exists!");
        }
        this.prodPusherIntegration.syncUpdateTicketStatus(BigInteger.valueOf(adTicket.getId()), adTicket.getStatus().byteValue(), null == adTicket.getPauseReason() ? 0 : adTicket.getPauseReason(), false);
        this.prodService.pushAdTicketToProdPre(adTicket.getId());
        return true;
    }

    public static TicketCache convert2TicketCache(Ticket orig) {
        Preconditions.checkNotNull((Object)orig);
        TicketCache dest = new TicketCache();
        dest.setId(orig.getId());
        dest.setIsSupportWechat(orig.getIsSupportWechat());
        dest.setUserGradePassScore(orig.getUserGradePassScore());
        dest.setDomainCode(orig.getDomainCode());
        dest.setType(orig.getType());
        dest.setOss(orig.getOss());
        dest.setTags(orig.getTags());
        dest.setOnoffs(orig.getOnoffs());
        dest.setStatus(orig.getStatus());
        dest.setPauseReason(orig.getPauseReason());
        dest.setCpaPrice(orig.getCpaPrice());
        dest.setFloorPrice(orig.getFloorPrice());
        dest.setOcpc(TypeHelper.castToInt((Object)orig.getOcpc()));
        dest.setCloseThreshold(orig.getCloseThreshold());
        dest.setGroupId(orig.getGroupId());
        return dest;
    }

    @Override
    public Integer addTicketUrlTest(AdTicketUrlTest adTicketUrlTest) {
        return this.adTicketUrlTestMapper.insert(adTicketUrlTest);
    }

    @Override
    public AdTicketUrlTest findTicketUrlTest(Long ticketId) {
        return this.adTicketUrlTestMapper.findTicketUrlTestByTicketId(ticketId);
    }

    @Override
    public Integer updateTicketUrlTest(AdTicketUrlTest adTicketUrlTest) {
        return this.adTicketUrlTestMapper.updateByPrimaryKeySelective(adTicketUrlTest);
    }

    @Override
    public Integer advertiserReUpdateStatus(AdTicket adTicket) {
        AdTicket ad = this.adTicketMapper.selectByPrimaryKey(adTicket.getId());
        if (ad == null || 99 == ad.getStatus()) {
            throw new ValidateException("\u67e5\u627e\u4e0d\u5230\u5e7f\u544a\u5238\u6216\u8005\u8be5\u5e7f\u544a\u5238\u5df2\u7ecf\u5220\u9664");
        }
        if (ad.getStatus() != -3) {
            throw new ValidateException("\u975e\u5ba1\u6838\u62d2\u7edd\u7684\u5238\u4e0d\u5141\u8bb8\u91cd\u65b0\u63d0\u4ea4");
        }
        int result = this.adTicketMapper.updateByPrimaryKeySelective(adTicket);
        String ids = this.redisNewClient.getRedis("AD:TICKET:REUPDATETICKET");
        List<String> list = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)ids)) {
            list = JSON.parseArray((String)ids, String.class);
        }
        if (!list.contains(adTicket.getId() + "")) {
            list.add(adTicket.getId() + "");
        }
        String json = JSON.toJSONString(list);
        this.redisNewClient.set("AD:TICKET:REUPDATETICKET", json);
        return result;
    }

    private void addCostWarn(AdTicketDto adTicketDto, Long ticketId) {
        String cosWarnTemp = this.redisNewClient.hGet("AD:TICKET:COSWARN", ticketId + "", 0);
        String deleteIds = this.redisNewClient.getRedis("AD:TICKET:DELETECOSWARNS");
        if (StringUtils.isEmpty((CharSequence)cosWarnTemp) && StringUtils.isNotEmpty((CharSequence)adTicketDto.getTags())) {
            String[] tagsArray = adTicketDto.getTags().split(",");
            String string = this.redisNewClient.hGet("AD:TICKET:COSWARNSTAG", tagsArray[tagsArray.length - 1], 0);
            if (StringUtils.isNotEmpty((CharSequence)string)) {
                String coswarns;
                TicketCostWarnTag ticketCostWarnTag = (TicketCostWarnTag)JSON.parseObject((String)string, TicketCostWarnTag.class);
                Double cosWarn = Double.valueOf(ticketCostWarnTag.getCosWarn()) * 1000.0;
                this.redisNewClient.hset("AD:TICKET:COSWARN", ticketId + "", cosWarn + "", 0, null);
                if (CollectionUtils.isNotEmpty((Collection)ticketCostWarnTag.getList())) {
                    String warnName = JSON.toJSONString((Object)ticketCostWarnTag.getList());
                    this.redisNewClient.hset("AD:TICKET:COSWARNNAME", ticketId + "", warnName, 0, null);
                }
                if (StringUtils.isNotEmpty((CharSequence)(coswarns = this.redisNewClient.getRedis("AD:TICKET:COSWARNS"))) && !coswarns.equals("[]")) {
                    List list = JSON.parseArray((String)coswarns, String.class);
                    list.add(ticketId + "");
                    HashSet set = new HashSet(list);
                    list.clear();
                    list.addAll(set);
                    String ids = JSON.toJSONString((Object)list);
                    this.redisNewClient.set("AD:TICKET:COSWARNS", ids);
                } else {
                    ArrayList list = Lists.newArrayList();
                    list.add(ticketId + "");
                    String ids = JSON.toJSONString((Object)list);
                    this.redisNewClient.set("AD:TICKET:COSWARNS", ids);
                }
            } else {
                this.redisNewClient.hdel("AD:TICKET:COSWARN", ticketId + "", 0);
                this.redisNewClient.hdel("AD:TICKET:COSWARNNAME", ticketId + "", 0);
                String coswarns = this.redisNewClient.getRedis("AD:TICKET:COSWARNS");
                if (StringUtils.isNotEmpty((CharSequence)coswarns) && !coswarns.equals("[]")) {
                    List list = JSON.parseArray((String)coswarns, String.class);
                    list.remove(ticketId + "");
                    String ids = JSON.toJSONString((Object)list);
                    this.redisNewClient.set("AD:TICKET:COSWARNS", ids);
                }
            }
        }
    }

    private void updateCostWarn(AdTicketDto adTicketDto, String tagCode) {
        String string;
        String deleteIds = this.redisNewClient.getRedis("AD:TICKET:DELETECOSWARNS");
        List deleteIdList = Lists.newArrayList();
        deleteIdList = JSON.parseArray((String)deleteIds, String.class);
        if (StringUtils.isEmpty((CharSequence)adTicketDto.getTags())) {
            adTicketDto.setTags("-99,-99");
        }
        String[] tagsArray = adTicketDto.getTags().split(",");
        if (CollectionUtils.isEmpty((Collection)deleteIdList) || !deleteIdList.contains(adTicketDto.getId() + "") || deleteIds.equals("[]")) {
            String code = this.redisNewClient.hGet("AD:TICKET:COSWARNSTAG", tagsArray[tagsArray.length - 1], 0);
            if (!tagsArray[tagsArray.length - 1].equals(tagCode)) {
                if (StringUtils.isNotEmpty((CharSequence)code)) {
                    TicketCostWarnTag ticketCostWarnTag = (TicketCostWarnTag)JSON.parseObject((String)code, TicketCostWarnTag.class);
                    Double cosWarn = Double.valueOf(ticketCostWarnTag.getCosWarn()) * 1000.0;
                    this.redisNewClient.hset("AD:TICKET:COSWARN", adTicketDto.getId() + "", cosWarn + "", 0, null);
                    String warnName = JSON.toJSONString((Object)ticketCostWarnTag.getList());
                    this.redisNewClient.hset("AD:TICKET:COSWARNNAME", adTicketDto.getId() + "", warnName, 0, null);
                    String coswarns = this.redisNewClient.getRedis("AD:TICKET:COSWARNS");
                    List list = JSON.parseArray((String)coswarns, String.class);
                    list.add(adTicketDto.getId() + "");
                    HashSet set = new HashSet(list);
                    list.clear();
                    list.addAll(set);
                    String ids = JSON.toJSONString((Object)list);
                    this.redisNewClient.set("AD:TICKET:COSWARNS", ids);
                } else {
                    this.redisNewClient.hdel("AD:TICKET:COSWARN", adTicketDto.getId() + "", 0);
                    this.redisNewClient.hdel("AD:TICKET:COSWARNNAME", adTicketDto.getId() + "", 0);
                    String coswarns = this.redisNewClient.getRedis("AD:TICKET:COSWARNS");
                    if (StringUtils.isNotEmpty((CharSequence)coswarns) && !coswarns.equals("[]")) {
                        List list = JSON.parseArray((String)coswarns, String.class);
                        list.remove(adTicketDto.getId() + "");
                        String ids = JSON.toJSONString((Object)list);
                        this.redisNewClient.set("AD:TICKET:COSWARNS", ids);
                    }
                }
            }
        } else if (CollectionUtils.isNotEmpty(deleteIdList) && deleteIdList.contains(adTicketDto.getId() + "") && !tagsArray[tagsArray.length - 1].equals(tagCode) && StringUtils.isNotEmpty((CharSequence)(string = this.redisNewClient.hGet("AD:TICKET:COSWARNSTAG", tagsArray[tagsArray.length - 1], 0)))) {
            List<String> list;
            String coswarns;
            TicketCostWarnTag ticketCostWarnTag = (TicketCostWarnTag)JSON.parseObject((String)string, TicketCostWarnTag.class);
            Double cosWarn = Double.valueOf(ticketCostWarnTag.getCosWarn()) * 1000.0;
            this.redisNewClient.hset("AD:TICKET:COSWARN", adTicketDto.getId() + "", cosWarn + "", 0, null);
            if (CollectionUtils.isNotEmpty((Collection)ticketCostWarnTag.getList())) {
                String warnName = JSON.toJSONString((Object)ticketCostWarnTag.getList());
                this.redisNewClient.hset("AD:TICKET:COSWARNNAME", adTicketDto.getId() + "", warnName, 0, null);
            }
            if (StringUtils.isNotEmpty((CharSequence)(coswarns = this.redisNewClient.getRedis("AD:TICKET:COSWARNS"))) && !coswarns.equals("[]")) {
                list = JSON.parseArray((String)coswarns, String.class);
                list.add(adTicketDto.getId() + "");
                HashSet set = new HashSet(list);
                list.clear();
                list.addAll(set);
                String ids = JSON.toJSONString(list);
                this.redisNewClient.set("AD:TICKET:COSWARNS", ids);
            } else {
                list = Lists.newArrayList();
                list.add(adTicketDto.getId() + "");
                String ids = JSON.toJSONString((Object)list);
                this.redisNewClient.set("AD:TICKET:COSWARNS", ids);
            }
            deleteIdList.remove(adTicketDto.getId() + "");
            if (CollectionUtils.isNotEmpty(deleteIdList)) {
                String ids = JSON.toJSONString(deleteIdList);
                this.redisNewClient.set("AD:TICKET:DELETECOSWARNS", ids);
            } else {
                this.redisNewClient.delKey("AD:TICKET:DELETECOSWARNS", 0);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean addBatchFlowPackage(List<AdTicketFlowPackageAddBatchDto> flowPackageAddBatchDtos, String username) throws Exception {
        ArrayList<AdTicketFlowPackageOfferRelation> addFlowPackageOfferRelationList;
        Long flowPackageId = flowPackageAddBatchDtos.get(0).getFlowPackageId();
        AdFlowPackage adFlowPackage = this.adFlowPackageMapper.findById(String.valueOf(flowPackageId));
        if (adFlowPackage == null) {
            throw new ValidateException("\u6d41\u91cf\u5305\u4e0d\u5b58\u5728");
        }
        if (adFlowPackage.getCount() >= 100) {
            throw new ValidateException("\u6d41\u91cf\u5305\u4f7f\u7528\u4e0a\u9650\u5df2\u7ecf\u8d85\u8fc7100");
        }
        ArrayList<Long> ticketIds = new ArrayList<Long>(flowPackageAddBatchDtos.size());
        for (AdTicketFlowPackageAddBatchDto adTicketFlowPackageAddBatchDto : flowPackageAddBatchDtos) {
            ticketIds.add(adTicketFlowPackageAddBatchDto.getTicketId());
        }
        this.adTicketFlowPackageMapper.deleteByFlowPackageIdAndTicketIds(flowPackageId, ticketIds);
        ArrayList<AdTicketFlowPackageConf> adTicketFlowPackageConf = new ArrayList<AdTicketFlowPackageConf>(flowPackageAddBatchDtos.size());
        for (AdTicketFlowPackageAddBatchDto flowPackageAddBatchDto : flowPackageAddBatchDtos) {
            AdTicketFlowPackageConf ticketFlowPackageConf = new AdTicketFlowPackageConf();
            ticketFlowPackageConf.setTicketId(flowPackageAddBatchDto.getTicketId());
            ticketFlowPackageConf.setFlowPackageId(flowPackageAddBatchDto.getFlowPackageId());
            String price = flowPackageAddBatchDto.getPrice();
            if (StringUtil.isNotEmpty((CharSequence)price)) {
                Money money = Money.ofYuan((double)Double.valueOf(price));
                ticketFlowPackageConf.setPrice(Long.valueOf(money.getLi()));
            } else {
                ticketFlowPackageConf.setPrice(Long.valueOf(0L));
            }
            String quota = flowPackageAddBatchDto.getQuota();
            if (StringUtil.isNotEmpty((CharSequence)quota)) {
                if ("infinity".equalsIgnoreCase(quota)) {
                    ticketFlowPackageConf.setQuota("infinity");
                } else {
                    Money money = Money.ofYuan((double)Double.valueOf(quota));
                    ticketFlowPackageConf.setQuota(String.valueOf(money.getLi()));
                }
            } else {
                ticketFlowPackageConf.setQuota(STR_ZERO);
            }
            String cpaPrice = flowPackageAddBatchDto.getCpaPrice();
            if (StringUtil.isNotEmpty((CharSequence)cpaPrice)) {
                Money money = Money.ofYuan((double)Double.valueOf(cpaPrice));
                ticketFlowPackageConf.setCpaPrice(Long.valueOf(money.getLi()));
            } else {
                ticketFlowPackageConf.setCpaPrice(Long.valueOf(0L));
            }
            String deepCpaPrice = flowPackageAddBatchDto.getDeepCpaPrice();
            if (StringUtil.isNotEmpty((CharSequence)deepCpaPrice)) {
                Money money = Money.ofYuan((double)Double.valueOf(deepCpaPrice));
                ticketFlowPackageConf.setDeepCpaPrice(Long.valueOf(money.getLi()));
            } else {
                ticketFlowPackageConf.setDeepCpaPrice(Long.valueOf(0L));
            }
            ticketFlowPackageConf.setType(Integer.valueOf(2));
            ticketFlowPackageConf.setCreateUser(username);
            ticketFlowPackageConf.setModifyUser(username);
            adTicketFlowPackageConf.add(ticketFlowPackageConf);
        }
        this.adTicketFlowPackageMapper.insert(adTicketFlowPackageConf);
        List list = this.adTicketFlowPackageOfferRelationMapper.findByFlowPackageIdAndTicketIds(flowPackageId, ticketIds);
        ArrayList<Long> notOperationTicketIds = new ArrayList<Long>(list.size());
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            ArrayList<Long> deleteFlowPackageOfferRelationIds = new ArrayList<Long>(list.size());
            addFlowPackageOfferRelationList = new ArrayList<AdTicketFlowPackageOfferRelation>(list.size());
            for (AdTicketFlowPackageOfferRelation oldFlowPackageOfferRelation : list) {
                notOperationTicketIds.add(oldFlowPackageOfferRelation.getTicketId());
                deleteFlowPackageOfferRelationIds.add(oldFlowPackageOfferRelation.getId());
                this.addNewFlowPackageOffRelation(flowPackageAddBatchDtos, username, addFlowPackageOfferRelationList, oldFlowPackageOfferRelation);
            }
            this.adTicketFlowPackageOfferRelationMapper.deleteBatch(deleteFlowPackageOfferRelationIds);
            this.adTicketFlowPackageOfferRelationMapper.insertBatch(addFlowPackageOfferRelationList);
        }
        ticketIds.removeAll(notOperationTicketIds);
        if (CollectionUtils.isNotEmpty(ticketIds)) {
            List adTickets = this.adTicketMapper.findAllByIds(ticketIds);
            addFlowPackageOfferRelationList = new ArrayList(adTickets.size());
            AdTicketFlowPackageOfferRelation oldFlowPackageOfferRelation = new AdTicketFlowPackageOfferRelation();
            oldFlowPackageOfferRelation.setFlowPackageId(flowPackageId);
            for (AdTicket adTicket : adTickets) {
                if (adTicket.getFlowPackageOfferConfId() == null) continue;
                oldFlowPackageOfferRelation.setTicketId(adTicket.getId());
                oldFlowPackageOfferRelation.setFlowPackageOfferConfId(adTicket.getFlowPackageOfferConfId());
                this.addNewFlowPackageOffRelation(flowPackageAddBatchDtos, username, addFlowPackageOfferRelationList, oldFlowPackageOfferRelation);
            }
            if (CollectionUtils.isNotEmpty(addFlowPackageOfferRelationList)) {
                this.adTicketFlowPackageOfferRelationMapper.insertBatch(addFlowPackageOfferRelationList);
            }
        }
        for (Long ticketId : ticketIds) {
            this.prodService.pushAdTicketToProdPre((long)ticketId);
        }
        return true;
    }

    private void addNewFlowPackageOffRelation(List<AdTicketFlowPackageAddBatchDto> flowPackageAddBatchDtos, String username, List<AdTicketFlowPackageOfferRelation> addFlowPackageOfferRelationList, AdTicketFlowPackageOfferRelation oldFlowPackageOfferRelation) {
        AdTicketFlowPackageOfferRelation newFlowPackageOfferRelation = new AdTicketFlowPackageOfferRelation();
        newFlowPackageOfferRelation.setId(null);
        newFlowPackageOfferRelation.setTicketId(oldFlowPackageOfferRelation.getTicketId());
        newFlowPackageOfferRelation.setFlowPackageOfferConfId(oldFlowPackageOfferRelation.getFlowPackageOfferConfId());
        newFlowPackageOfferRelation.setFlowPackageId(oldFlowPackageOfferRelation.getFlowPackageId());
        for (AdTicketFlowPackageAddBatchDto flowPackageAddBatchDto : flowPackageAddBatchDtos) {
            Money money;
            if (!oldFlowPackageOfferRelation.getTicketId().equals(flowPackageAddBatchDto.getTicketId())) continue;
            String price = flowPackageAddBatchDto.getPrice();
            if (StringUtils.isNotEmpty((CharSequence)price)) {
                Double priceTemp = Double.valueOf(price);
                if (99999.0 < priceTemp) {
                    throw new RuntimeException("\u6700\u9ad8\u652f\u6301\u51fa\u4ef710.00\u5143");
                }
                if (0.001 > priceTemp) {
                    throw new RuntimeException("\u51fa\u4ef7\u5fc5\u987b\u5927\u4e8e0.00\u5143");
                }
                money = Money.ofYuan((double)Double.valueOf(price));
                newFlowPackageOfferRelation.setPrice(Long.valueOf(money.getLi()));
            } else {
                newFlowPackageOfferRelation.setPrice(Long.valueOf(0L));
            }
            String quota = flowPackageAddBatchDto.getQuota();
            if (StringUtil.isNotEmpty((CharSequence)quota)) {
                if ("infinity".equalsIgnoreCase(quota)) {
                    newFlowPackageOfferRelation.setQuota("infinity");
                } else {
                    money = Money.ofYuan((double)Double.valueOf(quota));
                    newFlowPackageOfferRelation.setQuota(String.valueOf(money.getLi()));
                }
            } else {
                newFlowPackageOfferRelation.setQuota(STR_ZERO);
            }
            String cpaPrice = flowPackageAddBatchDto.getCpaPrice();
            if (StringUtils.isNotEmpty((CharSequence)cpaPrice)) {
                Double priceTemp = Double.valueOf(cpaPrice);
                Money money2 = Money.ofYuan((double)Double.valueOf(cpaPrice));
                newFlowPackageOfferRelation.setCpaPrice(Long.valueOf(money2.getLi()));
            } else {
                newFlowPackageOfferRelation.setCpaPrice(Long.valueOf(0L));
            }
            String deepCpaPrice = flowPackageAddBatchDto.getDeepCpaPrice();
            if (StringUtils.isNotEmpty((CharSequence)deepCpaPrice)) {
                Double priceTemp = Double.valueOf(deepCpaPrice);
                Money money3 = Money.ofYuan((double)Double.valueOf(deepCpaPrice));
                newFlowPackageOfferRelation.setDeepCpaPrice(Long.valueOf(money3.getLi()));
                break;
            }
            newFlowPackageOfferRelation.setDeepCpaPrice(Long.valueOf(0L));
            break;
        }
        Date createTime = new Date();
        newFlowPackageOfferRelation.setCreateUser(username);
        newFlowPackageOfferRelation.setCreateTime(createTime);
        newFlowPackageOfferRelation.setModifyUser(username);
        newFlowPackageOfferRelation.setModifyTime(createTime);
        addFlowPackageOfferRelationList.add(newFlowPackageOfferRelation);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean addBatchPosition(List<AdTicketPositionAddBatchDto> positionAddBatchDtos, String username) throws Exception {
        String positionId = positionAddBatchDtos.get(0).getPositionId();
        ArrayList<Long> allTicketIds = new ArrayList<Long>(positionAddBatchDtos.size());
        ArrayList<Long> operationTicketIds = new ArrayList<Long>(positionAddBatchDtos.size());
        for (AdTicketPositionAddBatchDto positionAddBatchDto : positionAddBatchDtos) {
            allTicketIds.add(positionAddBatchDto.getTicketId());
            operationTicketIds.add(positionAddBatchDto.getTicketId());
        }
        List<AdRules> oldExistAdRulesList = this.adRulesService.findByTargetAndRuleTypeAndTargetIds(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.GUANGGAOWEI.getValue(), operationTicketIds);
        ArrayList<Long> oldExistTicketIds = new ArrayList<Long>(positionAddBatchDtos.size());
        if (CollectionUtils.isNotEmpty(oldExistAdRulesList)) {
            for (AdRules adRules : oldExistAdRulesList) {
                if (!adRules.getRuleValue().startsWith("2")) continue;
                throw new ValidateException("\u5e7f\u544a\u5238ID:" + adRules.getTargetId() + " \u5b58\u5728\u5e7f\u544a\u4f4d\u9ed1\u540d\u5355\u914d\u7f6e\uff0c\u65e0\u6cd5\u6279\u91cf\u6dfb\u52a0\u3002");
            }
            ArrayList<AdRules> updateAdRulesList = new ArrayList<AdRules>(positionAddBatchDtos.size());
            for (AdRules oldAdRule : oldExistAdRulesList) {
                oldExistTicketIds.add(oldAdRule.getTargetId());
                if (oldAdRule.getRuleValue().contains(positionId)) continue;
                oldAdRule.setRuleValue(oldAdRule.getRuleValue() + "," + positionId);
                updateAdRulesList.add(oldAdRule);
            }
            if (CollectionUtils.isNotEmpty(updateAdRulesList)) {
                this.adRulesService.updateBatch(updateAdRulesList);
            }
        }
        operationTicketIds.removeAll(oldExistTicketIds);
        if (CollectionUtils.isNotEmpty(operationTicketIds)) {
            ArrayList<AdRules> addAdRulesList = new ArrayList<AdRules>(positionAddBatchDtos.size());
            for (Long operationTicketId : operationTicketIds) {
                AdRules adRules = new AdRules();
                adRules.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
                adRules.setTargetId(operationTicketId);
                adRules.setRuleType(Integer.valueOf(RuleTypeEnum.GUANGGAOWEI.getValue()));
                adRules.setRuleValue("1-" + positionId);
                addAdRulesList.add(adRules);
            }
            this.adRulesService.insertBatch(addAdRulesList);
        }
        for (Long l : allTicketIds) {
            this.prodService.pushAdTicketToProdPre((long)l);
        }
        return true;
    }

    @Override
    public Boolean checkTagModifyOrNeedAudit(Integer ticketId, String tags) {
        if (StringUtils.isBlank((CharSequence)tags)) {
            int num = this.industryAuditMapper.countTicketTagAuditNum(Long.valueOf(ticketId.longValue()));
            if (num == 0) {
                return true;
            }
            return false;
        }
        List oldTags = this.adTicketTagConfMapper.findTicketAttributeTag(Long.valueOf(ticketId.longValue()));
        HashSet oldTagsSet = Sets.newHashSet((Iterable)oldTags);
        Set newTags = Arrays.asList(tags.split(",")).stream().map(t -> Integer.valueOf(t)).collect(Collectors.toSet());
        List tblAdTagList = this.tblAdPostionTagMapperExt.findTblAdTagList(Integer.valueOf(0), Integer.valueOf(1), null);
        List allTag = tblAdTagList.stream().map(t -> t.getCode()).collect(Collectors.toList());
        HashSet newSet = Sets.newHashSet();
        newSet.addAll(Sets.newHashSet(allTag));
        newSet.retainAll(newTags);
        if (!oldTagsSet.equals(newSet)) {
            return true;
        }
        int num = this.industryAuditMapper.countTicketTagAuditNum(Long.valueOf(ticketId.longValue()));
        if (num == 0) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean checkTagModify(Integer ticketId, String tags) {
        List oldTags = this.adTicketTagConfMapper.findTicketAttributeTag(Long.valueOf(ticketId.longValue()));
        HashSet oldTagsSet = Sets.newHashSet((Iterable)oldTags);
        Set newTags = Arrays.asList(tags.split(",")).stream().map(t -> Integer.valueOf(t)).collect(Collectors.toSet());
        List tblAdTagList = this.tblAdPostionTagMapperExt.findTblAdTagList(Integer.valueOf(-1), Integer.valueOf(2), null);
        List allTag = tblAdTagList.stream().map(t -> t.getCode()).collect(Collectors.toList());
        HashSet newSet = Sets.newHashSet();
        newSet.addAll(Sets.newHashSet(allTag));
        newSet.retainAll(newTags);
        if (!oldTagsSet.equals(newSet)) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean checkTagNeedAudit(Integer ticketId) {
        AdTicket t = this.adTicketMapper.selectByPrimaryKey(Long.valueOf(ticketId.longValue()));
        Boolean isRejectionStatus = t.getStatus().equals((short)-3);
        if (isRejectionStatus.booleanValue()) {
            return true;
        }
        int num = this.industryAuditMapper.countTicketTagAuditNum(Long.valueOf(ticketId.longValue()));
        if (num == 0) {
            return true;
        }
        return false;
    }

    @Override
    @Transactional
    public String addBatchFlowPackagesByTickets(String ticketIds, String flowPackages, String type, String username) throws Exception {
        StringBuffer stringBuffer = new StringBuffer("\u5e7f\u544a\u5238id\uff1a");
        Boolean flag = true;
        String[] ticketIds1 = ticketIds.split(",");
        List<String> newFlowPackages = Arrays.asList(flowPackages.split(","));
        if (ticketIds1.length > 20) {
            throw new Exception("\u6700\u591a\u53ea\u80fd\u6dfb\u52a020\u4e2a\u5e7f\u544a\u5238");
        }
        Set<String> newPositionSet = this.adFlowPackageService.findPositionIdsByPackageIds(flowPackages);
        if (CollectionUtils.isEmpty(newPositionSet)) {
            throw new Exception("\u8be5\u6d41\u91cf\u5305\u6ca1\u6709\u5e7f\u544a\u4f4d");
        }
        ArrayList<AdTicketFlowPackageConf> finalAddFlowList = new ArrayList<AdTicketFlowPackageConf>();
        ArrayList<Long> deletePackageId = new ArrayList<Long>();
        ArrayList<Long> deleteRuleId = new ArrayList<Long>();
        ArrayList<AdRules> finalRulesList = new ArrayList<AdRules>();
        ArrayList<Long> pushTicket = new ArrayList<Long>();
        for (String ticketId : ticketIds1) {
            if (!this.handleRule(Long.valueOf(ticketId), type, deleteRuleId, finalRulesList, newPositionSet).booleanValue()) {
                flag = false;
                stringBuffer.append(ticketId + ",");
                continue;
            }
            this.handlePackage(newFlowPackages, username, Long.valueOf(ticketId), finalAddFlowList, deletePackageId);
            pushTicket.add(Long.valueOf(ticketId));
        }
        if (CollectionUtils.isNotEmpty(deletePackageId)) {
            this.adTicketFlowPackageMapper.deleteByIds(deletePackageId);
        }
        if (CollectionUtils.isNotEmpty(finalAddFlowList)) {
            this.adTicketFlowPackageMapper.insert(finalAddFlowList);
        }
        if (CollectionUtils.isNotEmpty(deleteRuleId)) {
            this.adRulesMapper.deleteByIds(deleteRuleId);
        }
        if (CollectionUtils.isNotEmpty(finalRulesList)) {
            this.adRulesMapper.insertBatch(finalRulesList);
        }
        for (Long ticketId : pushTicket) {
            this.prodService.pushAdTicketToProdPre(ticketId);
        }
        if (flag.booleanValue()) {
            return "\u6dfb\u52a0\u6210\u529f";
        }
        stringBuffer.append("\u56e0\u4e3a\u9ed1\u767d\u540d\u5355\u4e0d\u4e00\u81f4\uff0c\u672a\u6210\u529f\u6dfb\u52a0");
        return stringBuffer.toString();
    }

    @Override
    public PageInfo<AdTicketAppEntranceVo> queryTicketsByParams(AdTicketSearchDto adTicketSearchDto) throws Exception {
        List list;
        PageHelper.startPage((int)adTicketSearchDto.getPageNum(), (int)adTicketSearchDto.getPageSize());
        List<Object> ids = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)adTicketSearchDto.getTicketStrIds())) {
            ids = Arrays.asList(adTicketSearchDto.getTicketStrIds().split(","));
        }
        List<Object> types = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)adTicketSearchDto.getTypes())) {
            types = Arrays.asList(adTicketSearchDto.getTypes().split(","));
        }
        if (CollectionUtils.isEmpty((Collection)(list = this.adTicketMapper.getAdTicketAppEntrance(adTicketSearchDto.getTicketIdOrName(), types, adTicketSearchDto.getStatus(), ids, null)))) {
            return new PageInfo();
        }
        ArrayList<Long> ticketIds = new ArrayList<Long>();
        for (AdTicketAppEntranceVo adTicketAppEntranceVo : list) {
            ticketIds.add(Long.valueOf(adTicketAppEntranceVo.getId()));
        }
        Map<String, String> dictionariesMap = this.getDictionaries("adstatus");
        Map<Long, String> tagNameMap = this.adTicketTagConfService.findClassifyTagName(ticketIds);
        for (AdTicketAppEntranceVo adTicketAppEntranceVo : list) {
            if (adTicketAppEntranceVo.getStatus() == 2 && adTicketAppEntranceVo.getPauseReason() != null) {
                adTicketAppEntranceVo.setPauseReason(dictionariesMap.get(STR_TWO + adTicketAppEntranceVo.getPauseReason()));
            } else {
                adTicketAppEntranceVo.setPauseReason(dictionariesMap.get(adTicketAppEntranceVo.getStatus() + ""));
            }
            adTicketAppEntranceVo.setTagName(tagNameMap.get(Long.valueOf(adTicketAppEntranceVo.getId())));
        }
        return new PageInfo(list);
    }

    public Boolean handleRule(Long ticketId, String type, List<Long> deleteRuleId, List<AdRules> finalRulesList, Set<String> newPositionSet) {
        AdRules adRules = this.adRulesMapper.findAdRulesByTicketId(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()), Integer.valueOf(RuleTypeEnum.GUANGGAOWEI.getValue()), ticketId);
        HashSet<String> oldPositionSet = new HashSet<String>();
        if (adRules != null) {
            String[] positionIds;
            String blackWhite = adRules.getRuleValue().substring(0, 1);
            if (!StringUtils.equalsIgnoreCase((CharSequence)blackWhite, (CharSequence)type)) {
                return false;
            }
            String allPositionId = adRules.getRuleValue().substring(2, adRules.getRuleValue().length());
            for (String positionId : positionIds = allPositionId.split(",")) {
                oldPositionSet.add(positionId);
            }
            deleteRuleId.add(adRules.getId());
        }
        oldPositionSet.addAll(newPositionSet);
        StringBuffer sb = new StringBuffer(type + "-");
        for (String postionId : oldPositionSet) {
            sb.append(postionId + ",");
        }
        AdRules finalRule = new AdRules();
        finalRule.setRuleValue(sb.toString());
        finalRule.setRuleType(Integer.valueOf(RuleTypeEnum.GUANGGAOWEI.getValue()));
        finalRule.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
        finalRule.setTargetId(ticketId);
        finalRulesList.add(finalRule);
        return true;
    }

    public void handlePackage(List<String> newFlowPackages, String username, Long ticketId, List<AdTicketFlowPackageConf> finalAddList, List<Long> deletePackageId) {
        AdTicketFlowPackageConf adTicketFlowPackageConf;
        List adTicketFlowPackageConfList = this.adTicketFlowPackageMapper.findByAdFlowConfByTicketId(Long.valueOf(ticketId), Integer.valueOf(1));
        for (String flowPackageId : newFlowPackages) {
            adTicketFlowPackageConf = new AdTicketFlowPackageConf();
            adTicketFlowPackageConf.setQuota(STR_ZERO);
            adTicketFlowPackageConf.setPrice(Long.valueOf(0L));
            adTicketFlowPackageConf.setCreateUser(username);
            adTicketFlowPackageConf.setTicketId(ticketId);
            adTicketFlowPackageConf.setFlowPackageId(Long.valueOf(flowPackageId));
            adTicketFlowPackageConf.setType(Integer.valueOf(1));
            finalAddList.add(adTicketFlowPackageConf);
        }
        for (AdTicketFlowPackageConf oldadTicketFlowPackageConf : adTicketFlowPackageConfList) {
            deletePackageId.add(oldadTicketFlowPackageConf.getId());
            if (newFlowPackages.contains(oldadTicketFlowPackageConf.getFlowPackageId().toString())) continue;
            adTicketFlowPackageConf = new AdTicketFlowPackageConf();
            adTicketFlowPackageConf.setQuota(STR_ZERO);
            adTicketFlowPackageConf.setPrice(Long.valueOf(0L));
            adTicketFlowPackageConf.setCreateUser(username);
            adTicketFlowPackageConf.setTicketId(Long.valueOf(ticketId));
            adTicketFlowPackageConf.setFlowPackageId(oldadTicketFlowPackageConf.getFlowPackageId());
            adTicketFlowPackageConf.setType(Integer.valueOf(1));
            finalAddList.add(adTicketFlowPackageConf);
        }
    }

    public Boolean isAdxMeituanReview(Integer isMeituanReview, String banners) {
        String position = this.meituanReviewConfig.getPosition();
        if (StringUtils.isBlank((CharSequence)position)) {
            return false;
        }
        if (isMeituanReview != null && isMeituanReview == 1 && StringUtils.isNotBlank((CharSequence)banners)) {
            return banners.contains(position);
        }
        return false;
    }

    private int getAdxRequestCount(String ticketId, Set<String> dailys) {
        int count = 0;
        for (String daily : dailys) {
            count += this.prodPuller.fetchAdxRequestCount(ticketId, daily).intValue();
        }
        return count;
    }

    private int getAdxOfferPriceCount(String ticketId, Set<String> dailys) {
        int count = 0;
        for (String daily : dailys) {
            count += this.prodPuller.fetchAdxOfferPriceCount(ticketId, daily).intValue();
        }
        return count;
    }

    @Override
    public void addLogs(String userName, String content, String adticketId) {
        try {
            String userAccount = "-";
            LogModel logModel = new LogModel.Builder().userName(userAccount).userAccount(userName).parentAccount(userAccount).content(content).adticketId(adticketId).ip("-").build();
            SAVE_LOG_POOL.execute(() -> this.logsIntegration.add(logModel));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void dealSettleTypeSearch(AdTicketSearchDto condition, Map<String, String> stageTickets) {
        if (condition.getSettleType() == null && condition.getOcpcTicket() == null) {
            return;
        }
        List<Long> allOcpcTicket = this.adTicketOcpcService.findAllOcpcTicket();
        if (null != condition.getOcpcTicket() && condition.getOcpcTicket().booleanValue()) {
            if (condition.getOcpcStage() != null && CollectionUtils.isNotEmpty(allOcpcTicket)) {
                Iterator<Long> iter = allOcpcTicket.iterator();
                while (iter.hasNext()) {
                    Long o = iter.next();
                    boolean isOcpcStage = stageTickets.containsKey(o.toString()) && condition.getOcpcStage().toString().equals(stageTickets.get(o.toString()));
                    if (isOcpcStage) continue;
                    iter.remove();
                }
            }
            if (CollectionUtils.isEmpty(allOcpcTicket)) {
                allOcpcTicket.add(-1L);
            }
            if (CollectionUtils.isEmpty((Collection)condition.getTicketIds())) {
                condition.setTicketIds(allOcpcTicket);
            } else if (CollectionUtils.isNotEmpty(allOcpcTicket)) {
                List ticketIds = condition.getTicketIds();
                ticketIds.retainAll(allOcpcTicket);
                condition.setTicketIds(ticketIds);
            }
        }
        if (null != condition.getSettleType() && condition.getSettleType().equals((short)1)) {
            condition.setExcludeTicketIds(allOcpcTicket);
        }
    }

    private void saveDirectChasePrice(Long ticketId, AdTicketDto adTicketDto, String userName) {
        String currentDate = DateHelper.format((String)"yyyyMMdd");
        String chasePriceConfigStr = adTicketDto.getChasePriceConfig();
        if (StringUtils.isBlank((CharSequence)chasePriceConfigStr)) {
            return;
        }
        List chasePriceConfigs = JSONObject.parseArray((String)chasePriceConfigStr, ChasePriceConfig.class);
        for (ChasePriceConfig chasePriceConfig : chasePriceConfigs) {
            String chaseId = chasePriceConfig.getId();
            if (StringUtils.isBlank((CharSequence)chasePriceConfig.getId())) {
                chaseId = RandomStringUtils.randomAlphanumeric((int)6);
                chasePriceConfig.setId(chaseId);
            }
            this.updater.update(TicketKeyGenerator.getChasePriceBalance((String)chaseId, (String)currentDate), (Object)Money.ofYuan((double)chasePriceConfig.getBalance()).getLi(), (int)DateHelper.getRemainSecondsOfToday());
        }
        this.updater.update(TicketKeyGenerator.getChasePriceConfig((String)ticketId.toString(), (String)currentDate), (Object)JSONObject.toJSONString((Object)chasePriceConfigs), (int)DateHelper.getRemainSecondsOfToday());
    }

    private void fillDirectChasePrice(AdTicketVo adTicketVo) {
        String date = DateHelper.format((String)"yyyyMMdd");
        String chasePriceConfigStr = (String)this.fetcher.fetch(TicketKeyGenerator.getChasePriceConfig((String)adTicketVo.getId().toString(), (String)date), String.class);
        if (StringUtils.isBlank((CharSequence)chasePriceConfigStr)) {
            return;
        }
        List chasePriceConfigs = JSONObject.parseArray((String)chasePriceConfigStr, ChasePriceConfig.class);
        for (ChasePriceConfig chasePriceConfig : chasePriceConfigs) {
            Long chasePriceBalance = (Long)this.fetcher.fetch(TicketKeyGenerator.getChasePriceBalance((String)chasePriceConfig.getId(), (String)date), Long.class);
            chasePriceConfig.setBalance(Double.valueOf(Money.ofLi((long)chasePriceBalance).getYuan()));
        }
        adTicketVo.setChasePriceConfig(JSONObject.toJSONString((Object)chasePriceConfigs));
    }

    private void processSettleTypeModify(AdTicketDto adTicketDto, Long ticketId, String userName, AdTicket oldTicketInfo) {
        boolean isSettleTypeModified;
        AdTicketDto.OcpcConfDto ocpcConf = adTicketDto.getOcpcConf();
        Short oldSettleType = oldTicketInfo.getSettleType();
        Short newSettleType = adTicketDto.getSettleType();
        if (oldSettleType == null || newSettleType == null) {
            LOGGER.error("oldSettleType \u6216 newSettleType \u4e0d\u5b58\u5728 ticketId: {}", (Object)ticketId);
            return;
        }
        AdTicketOcpcConf adTicketOcpcConf = this.adTicketOcpcService.selectByTicketId(ticketId);
        boolean oldSupportOcpc = adTicketOcpcConf != null && adTicketOcpcConf.getIsSupportOcpc() == 1;
        boolean newSupportOcpc = adTicketOcpcConf != null && ocpcConf.getIsSupportOcpc() == 1;
        String oldSettleTypeName = oldSupportOcpc ? "OCPC" : CommonConstant.SettleTypeEnum.getNameBySettleType((Short)oldSettleType);
        String newSettleTypeName = newSupportOcpc ? "OCPC" : CommonConstant.SettleTypeEnum.getNameBySettleType((Short)newSettleType);
        boolean bl = isSettleTypeModified = !Objects.equals(oldSettleType, newSettleType) || !Objects.equals(oldSupportOcpc, newSupportOcpc);
        if (isSettleTypeModified) {
            this.addLogs(userName, String.format("\u7ed3\u7b97\u65b9\u5f0f\u4ece%s\u6539\u4e3a%s", oldSettleTypeName, newSettleTypeName), ticketId.toString());
        }
        if (oldSupportOcpc && !newSupportOcpc && !CommonConstant.SettleTypeEnum.isOcpr((Short)newSettleType)) {
            this.updater.hremove(RedisKeys.getOcpcSecendStageTicket(), new String[]{ticketId.toString()});
        }
    }

    private void fillConsume(AdTicketAllVo vo, boolean isActivityType, Map<String, String> map, AdTicketSearchDto condition, Map<Long, Double> abnormalConsumeMap) {
        if (isActivityType) {
            vo.setConsume(Double.valueOf(NumberUtils.toDouble((String)String.valueOf(map.get("activityConsume"))) / 1000.0));
        } else {
            vo.setConsume(Double.valueOf(1 == vo.getSettleType() || 4 == vo.getSettleType() || 5 == vo.getSettleType() ? NumberUtils.toDouble((String)String.valueOf(map.get("consume"))) / 1000.0 : 0.0));
        }
        if (MapUtils.isNotEmpty(abnormalConsumeMap)) {
            vo.setConsume(Double.valueOf(vo.getConsume() + abnormalConsumeMap.getOrDefault(vo.getId(), 0.0)));
        }
    }

    private Map<Long, Double> getAbnormalConsumeMap(AdTicketSearchDto condition, List<AdTicket> list) {
        List ticketId = list.stream().map(AdTicket::getId).collect(Collectors.toList());
        AdAbnormalTicketConsumeSearchDTO dto = new AdAbnormalTicketConsumeSearchDTO().setStartTime(condition.getPvStartTime()).setEndTime(condition.getPvEndTime()).setTicketIds(ticketId);
        List abnormalTicketConsume = this.adTicketMapper.getAbnormalTicketConsume(dto);
        if (CollectionUtils.isEmpty((Collection)abnormalTicketConsume)) {
            return Collections.EMPTY_MAP;
        }
        return abnormalTicketConsume.stream().collect(Collectors.toMap(AdAbnormalTicketConsumeVo::getTicketId, AdAbnormalTicketConsumeVo::getAbnormalConsume));
    }

    private Map<Long, Boolean> getAdvertiserQualifyWarningMap(List<AdTicket> list) {
        List advertiserIds = list.stream().map(t -> t.getAdvertiser()).collect(Collectors.toList());
        List qualifyTypes = this.tblAdQualifyMapperExt.getQualifyTypeByAdvertiserIds(advertiserIds);
        if (CollectionUtils.isEmpty((Collection)qualifyTypes)) {
            return Collections.EMPTY_MAP;
        }
        return qualifyTypes.stream().collect(Collectors.toMap(q -> q.getAdvertiserId(), q -> StringUtils.contains((CharSequence)q.getQualifyStatusStr(), (CharSequence)"1")));
    }

    @Override
    public void closeOneClickRecovery() {
        List ticketIdByOneClickRecovery;
        HashSet ticketIds = Sets.newHashSet();
        AdTicketAppExtendExample adTicketAppExtendExample = new AdTicketAppExtendExample();
        adTicketAppExtendExample.createCriteria().andOneClickRecoveryEqualTo(Short.valueOf(CommonConstant.OpenFlag.OPEN_YES.shortValue()));
        List adTicketAppExtends = this.adTicketAppExtendMapperExt.selectByExample(adTicketAppExtendExample);
        if (CollectionUtils.isNotEmpty((Collection)adTicketAppExtends)) {
            List openTicketIds = adTicketAppExtends.stream().map(AdTicketAppExtend::getTicketId).collect(Collectors.toList());
            ticketIds.addAll(openTicketIds);
            this.adTicketAppExtendMapperExt.updateOneClickRecoveryByTicketIds(Short.valueOf(CommonConstant.OpenFlag.OPEN_NO.shortValue()), openTicketIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)(ticketIdByOneClickRecovery = this.adTicketPositionTimesLimitMapperExt.findTicketIdByOneClickRecovery(Short.valueOf(CommonConstant.OpenFlag.OPEN_YES.shortValue()))))) {
            ticketIds.addAll(ticketIdByOneClickRecovery);
            this.adTicketPositionTimesLimitMapperExt.updateOneClickRecoveryByTicketIds(Short.valueOf(CommonConstant.OpenFlag.OPEN_NO.shortValue()), ticketIdByOneClickRecovery);
        }
        if (ticketIds.size() > 0) {
            this.adTicketAppExtendMapperExt.updateOneClickRecoveryInBakByTicketIds(new ArrayList(ticketIds));
            for (Long ticketId : ticketIds) {
                try {
                    this.prodService.pushAdTicketToProdPre(ticketId);
                }
                catch (Exception e) {
                    LOGGER.error("adsprod exception!", (Throwable)e);
                }
            }
        }
    }
}

