/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adkeeper.impl;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketTagConfMapper;
import com.bxm.adsmanager.model.constant.CommonConstant;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketTagConf;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketTagConfDO;
import com.bxm.adsmanager.service.adkeeper.AdTicketTagConfService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdTicketTagConfServiceImpl
implements AdTicketTagConfService {
    @Autowired
    private AdTicketTagConfMapper adTicketTagConfMapper;

    @Override
    public Integer add(AdTicketTagConf conf) {
        return this.adTicketTagConfMapper.insert(conf);
    }

    @Override
    public Integer addBatch(String tags, Long ticketId) {
        if (tags == null) {
            return null;
        }
        String[] tagsArray = tags.split(",");
        List<String> list = Arrays.asList(tagsArray);
        Integer result = this.adTicketTagConfMapper.addBatch(list, ticketId);
        return result;
    }

    @Override
    public Integer delete(Long ticketId) {
        return this.adTicketTagConfMapper.deleteByTicketId(ticketId);
    }

    @Override
    public String findByTicketId(Long ticketId) {
        String ads = "";
        List adTagConfList = this.adTicketTagConfMapper.findByTicketId(ticketId);
        if (adTagConfList.isEmpty()) {
            return null;
        }
        for (int i = 0; i < adTagConfList.size(); ++i) {
            ads = i == adTagConfList.size() - 1 ? ads + ((AdTicketTagConf)adTagConfList.get(i)).getTagCode() : ads + ((AdTicketTagConf)adTagConfList.get(i)).getTagCode() + ",";
        }
        return ads;
    }

    @Override
    public List<Long> findTicketIds(Integer tagCode) {
        if (null == tagCode) {
            return Collections.emptyList();
        }
        return this.adTicketTagConfMapper.findTicketIds(tagCode);
    }

    @Override
    public Map<Long, String> findClassifyTagName(List<Long> ticketIds) {
        if (CollectionUtils.isEmpty(ticketIds)) {
            return Collections.emptyMap();
        }
        List adTicketTagConfDOS = this.adTicketTagConfMapper.findTicketBelongCodeName(ticketIds, CommonConstant.TicketTag.TAG_TYPE_CLASSIFY);
        HashMap<Long, String> tagNameMap = new HashMap<Long, String>(adTicketTagConfDOS.size());
        for (AdTicketTagConfDO adTicketTagConfDO : adTicketTagConfDOS) {
            String fullNameStr = adTicketTagConfDO.getFullNameStr();
            if (StringUtils.isBlank((CharSequence)fullNameStr)) continue;
            Integer indexOf = fullNameStr.indexOf(".");
            String tagName = indexOf < 0 ? fullNameStr : fullNameStr.substring(0, indexOf);
            String name = (String)tagNameMap.get(adTicketTagConfDO.getTicketId());
            if (StringUtils.isBlank((CharSequence)name)) {
                tagNameMap.put(adTicketTagConfDO.getTicketId(), tagName);
                continue;
            }
            tagNameMap.put(adTicketTagConfDO.getTicketId(), StringUtils.join((Object[])new String[]{name, ",", tagName}));
        }
        return tagNameMap;
    }

    @Override
    public List<Long> findTicketIdsByCode(String tagCode) {
        if (null == tagCode) {
            return Collections.emptyList();
        }
        return this.adTicketTagConfMapper.findTicketIdsByCode(tagCode);
    }

    @Override
    public String findCode(long ticketId, int typeTag) {
        ArrayList list = Lists.newArrayList();
        list.add(ticketId);
        List adTicketTagConfDOS = this.adTicketTagConfMapper.findTicketBelongCodeName((List)list, Integer.valueOf(typeTag));
        if (CollectionUtils.isNotEmpty((Collection)adTicketTagConfDOS)) {
            return ((AdTicketTagConfDO)adTicketTagConfDOS.get(0)).getTagCode();
        }
        return null;
    }
}

