/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adkeeper.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdTicketThirdPartyCrowdPackageMapperExt;
import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketThirdPartyCrowdPackage;
import com.bxm.adsmanager.model.dto.AdTicketThirdPartyCrowdPackageDto;
import com.bxm.adsmanager.model.enums.ProdServiceNameEnum;
import com.bxm.adsmanager.model.enums.RuleTargetEnum;
import com.bxm.adsmanager.model.enums.RuleTypeEnum;
import com.bxm.adsmanager.model.vo.AdTicketThirdPartyCrowdPackageVo;
import com.bxm.adsmanager.service.adkeeper.AdRulesService;
import com.bxm.adsmanager.service.adkeeper.AdTicketThirdPartyCrowdPackageService;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ValidateException;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdTicketThirdPartyCrowdPackageServiceImpl
implements AdTicketThirdPartyCrowdPackageService {
    @Autowired
    private AdTicketThirdPartyCrowdPackageMapperExt adTicketThirdPartyCrowdPackageMapperExt;
    @Autowired
    private AdRulesService adRulesService;
    @Autowired
    private ProdPusherIntegration prodPusher;

    @Override
    @Transactional
    public Long add(AdTicketThirdPartyCrowdPackageDto adTicketThirdPartyCrowdPackageDto) throws Exception {
        AdTicketThirdPartyCrowdPackage adTicketThirdPartyCrowdPackage = new AdTicketThirdPartyCrowdPackage();
        BeanUtils.copyProperties((Object)adTicketThirdPartyCrowdPackageDto, (Object)adTicketThirdPartyCrowdPackage);
        adTicketThirdPartyCrowdPackage.setId(null);
        int result = this.adTicketThirdPartyCrowdPackageMapperExt.insert(adTicketThirdPartyCrowdPackage);
        if (result > 0) {
            this.prodPusher.pushToProd(ProdServiceNameEnum.THIRD_PARTY_CROWD_PACKAGE.getServiceName(), null, JSONArray.toJSONBytes((Object)adTicketThirdPartyCrowdPackage, (SerializerFeature[])new SerializerFeature[0]));
            return adTicketThirdPartyCrowdPackage.getId();
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer update(AdTicketThirdPartyCrowdPackageDto adTicketThirdPartyCrowdPackageDto) throws Exception {
        AdTicketThirdPartyCrowdPackage adTicketThirdPartyCrowdPackage = new AdTicketThirdPartyCrowdPackage();
        BeanUtils.copyProperties((Object)adTicketThirdPartyCrowdPackageDto, (Object)adTicketThirdPartyCrowdPackage);
        adTicketThirdPartyCrowdPackage.setId(Long.valueOf(adTicketThirdPartyCrowdPackageDto.getId().longValue()));
        int result = this.adTicketThirdPartyCrowdPackageMapperExt.updateByPrimaryKeySelective(adTicketThirdPartyCrowdPackage);
        this.prodPusher.pushToProd(ProdServiceNameEnum.THIRD_PARTY_CROWD_PACKAGE.getServiceName(), null, JSONArray.toJSONBytes((Object)adTicketThirdPartyCrowdPackage, (SerializerFeature[])new SerializerFeature[0]));
        return result;
    }

    @Override
    public List<AdTicketThirdPartyCrowdPackageVo> findById(String ids) {
        if (StringUtil.isBlank((CharSequence)ids)) {
            return null;
        }
        String[] idsStr = ids.split(",");
        ArrayList<Long> assetsAdxIds = new ArrayList<Long>(idsStr.length);
        for (String id : idsStr) {
            assetsAdxIds.add(Long.valueOf(id));
        }
        return this.adTicketThirdPartyCrowdPackageMapperExt.findByIds(assetsAdxIds);
    }

    @Override
    public PageInfo<AdTicketThirdPartyCrowdPackageVo> findAll(AdTicketThirdPartyCrowdPackageDto searchDto) throws Exception {
        PageHelper.startPage((int)searchDto.getPageNum(), (int)searchDto.getPageSize());
        List listVo = this.adTicketThirdPartyCrowdPackageMapperExt.findAll(searchDto);
        PageInfo pageInfo = new PageInfo(listVo);
        return pageInfo;
    }

    @Override
    public List<AdTicketThirdPartyCrowdPackageVo> getList(AdTicketThirdPartyCrowdPackageDto searchDto) throws Exception {
        return this.adTicketThirdPartyCrowdPackageMapperExt.findAll(searchDto);
    }

    @Override
    public void delete(Long id) throws Exception {
        List<String> ruleList = this.adRulesService.findByTargetAndRuleType(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.THIRD_PARTY_CROWD_PACKAGE.getValue());
        for (String ruleValue : ruleList) {
            String[] values = StringUtils.split((String)ruleValue, (String)",");
            if (values == null) continue;
            for (String value : values) {
                if (!value.equals(id.toString())) continue;
                throw new ValidateException("\u8be5\u6570\u636e\u5df2\u88ab\u5f15\u7528\uff01");
            }
        }
        this.adTicketThirdPartyCrowdPackageMapperExt.deleteByPrimaryKey(id);
    }
}

