/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adkeeper.impl;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdAssetsMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.common.DictionariesMapper;
import com.bxm.adsmanager.integration.adsprod.service.ProdPullerIntegration;
import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssets;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.common.Dictionaries;
import com.bxm.adsmanager.model.dto.AdAssetsDto;
import com.bxm.adsmanager.model.dto.DirectTicketSearch;
import com.bxm.adsmanager.model.enums.ProdServiceNameEnum;
import com.bxm.adsmanager.model.vo.AdAssetsVo;
import com.bxm.adsmanager.model.vo.DirectTicketVo;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.service.adkeeper.DirectTicketMaterialService;
import com.bxm.adsmanager.service.common.DictionariesService;
import com.bxm.adsmanager.utils.ListOrderUtils;
import com.bxm.adsmanager.utils.ListUtil;
import com.bxm.adsprod.facade.ticket.DirectMaterial;
import com.bxm.adsprod.facade.ticket.DirectTicketMaterial;
import com.bxm.util.DateUtil;
import com.bxm.util.StringUtil;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DirectTicketMaterialServiceImpl
implements DirectTicketMaterialService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectTicketMaterialServiceImpl.class);
    private static final int TWO = 2;
    private static final String STR_TWO = "2-";
    @Autowired
    private DictionariesService dictionariesService;
    @Autowired
    private AdAssetsMapper adAssetsMapper;
    @Autowired
    private ProdPullerIntegration prodPullerIntegration;
    @Autowired
    private AdTicketMapper adTicketMapper;
    @Autowired
    private DictionariesMapper dictionariesMapper;
    @Autowired
    private ProdPusherIntegration prodPusherIntegration;

    @Override
    public Pagination findDirectTickets(DirectTicketSearch directTicketSearch) {
        List adTickets;
        String code = directTicketSearch.getStatusCode();
        if (StringUtil.isNotBlank((CharSequence)code)) {
            if (code.contains(STR_TWO)) {
                directTicketSearch.setPauseReason(Integer.valueOf(Integer.parseInt(code.substring(2))));
            } else {
                directTicketSearch.setStatus(Short.valueOf(code));
            }
        }
        if (CollectionUtils.isEmpty((Collection)(adTickets = this.adTicketMapper.findDirectTicketsByParams(directTicketSearch)))) {
            return new Pagination();
        }
        ArrayList<DirectTicketVo> directTicketVos = new ArrayList<DirectTicketVo>(adTickets.size());
        Map<String, String> dictionariesMap = this.getDictionaries("adstatus");
        for (AdTicket ad : adTickets) {
            List<AdAssetsVo> adAssetsVos;
            List listCount;
            DirectTicketVo directTicketVo = new DirectTicketVo();
            directTicketVo.setClickPv(Integer.valueOf(0));
            directTicketVo.setOpenPv(Integer.valueOf(0));
            directTicketVo.setValidClickPv(Integer.valueOf(0));
            directTicketVo.setAssetCount(Integer.valueOf(0));
            BeanUtils.copyProperties((Object)ad, (Object)directTicketVo);
            directTicketVo.setTicketName(ad.getName());
            directTicketVo.setPositionSize(ad.getAssetSize());
            if (ad.getPauseReason() != null && ad.getStatus() == 2) {
                directTicketVo.setStatus(dictionariesMap.get(STR_TWO + ad.getPauseReason()));
            } else {
                directTicketVo.setStatus(dictionariesMap.get(ad.getStatus() + ""));
            }
            HashMap<String, Object> map = new HashMap<String, Object>(5);
            map.put("ticketId", ad.getTicketId());
            map.put("assetSize", ad.getAssetSize());
            List list = this.adAssetsMapper.findDirectAssetsListByParams(map);
            if (!CollectionUtils.isEmpty((Collection)list) && !CollectionUtils.isEmpty((Collection)(listCount = (List)CollectionUtils.select((Collection)list, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    AdAssets adAssets = (AdAssets)object;
                    return 1 == adAssets.getStatus();
                }
            })))) {
                directTicketVo.setAssetCount(Integer.valueOf(listCount.size()));
            }
            if (!CollectionUtils.isEmpty(adAssetsVos = this.getAdAssetsVos(directTicketSearch.getPvStartTime(), directTicketSearch.getPvEndTime(), list))) {
                int validClickPvSum = adAssetsVos.stream().mapToInt(AdAssetsVo::getValidClick).sum();
                int clickPvSum = adAssetsVos.stream().mapToInt(AdAssetsVo::getClickPv).sum();
                int openPvSum = adAssetsVos.stream().mapToInt(AdAssetsVo::getOpenPv).sum();
                directTicketVo.setValidClickPv(Integer.valueOf(validClickPvSum));
                directTicketVo.setClickPv(Integer.valueOf(clickPvSum));
                directTicketVo.setOpenPv(Integer.valueOf(openPvSum));
                if (openPvSum == 0) {
                    directTicketVo.setClickRate(0.0);
                } else {
                    directTicketVo.setClickRate((double)Math.round(Double.parseDouble(clickPvSum + "") * 100.0 / Double.parseDouble(openPvSum + "")));
                }
                if (clickPvSum == 0) {
                    directTicketVo.setValidClickRate(0.0);
                } else {
                    directTicketVo.setValidClickRate((double)Math.round(Double.parseDouble(validClickPvSum + "") * 100.0 / Double.parseDouble(clickPvSum + "")));
                }
            }
            directTicketVos.add(directTicketVo);
        }
        if (StringUtil.isNotBlank((CharSequence)directTicketSearch.getOrderParam()) && StringUtil.isNotBlank((CharSequence)directTicketSearch.getOrderType())) {
            ListOrderUtils.sortList(directTicketVos, directTicketSearch.getOrderParam(), directTicketSearch.getOrderType());
        }
        List pageList = ListUtil.getTotalPage(directTicketVos, directTicketVos.size(), directTicketSearch.getPageNum(), directTicketSearch.getPageSize());
        Pagination pagination = new Pagination();
        pagination.setPageNo(directTicketSearch.getPageNum());
        pagination.setPageSize(directTicketSearch.getPageSize());
        pagination.setTotalCount(directTicketVos.size());
        pagination.setList(pageList);
        return pagination;
    }

    @Override
    public void add(AdAssetsDto adAssetsDto, String userName) {
        Long lastDirectTicket = this.adTicketMapper.findLastDirectTicket(adAssetsDto.getTicketId(), adAssetsDto.getAssetSize());
        if (null == lastDirectTicket) {
            this.adTicketMapper.insertDirectTicket(adAssetsDto.getTicketId(), adAssetsDto.getAssetSize(), Long.valueOf(0L));
        }
        String assetName = adAssetsDto.getName();
        if (StringUtil.isBlank((CharSequence)userName)) {
            userName = "null";
        }
        if (adAssetsDto.getUrls().length > 1) {
            for (int i = 0; i < adAssetsDto.getUrls().length; ++i) {
                AdAssets adAssets = new AdAssets();
                adAssets.setName(assetName + (i + 1));
                adAssets.setImage(adAssetsDto.getUrls()[i]);
                adAssets.setButtonTxt("\u76f4\u6295");
                adAssets.setIntro("\u76f4\u6295");
                adAssets.setDirect(Integer.valueOf(1));
                adAssets.setAssetSize(adAssetsDto.getAssetSize());
                adAssets.setAssetType(adAssetsDto.getAssetType());
                adAssets.setTitle(adAssetsDto.getTitle());
                adAssets.setSubtitle(adAssetsDto.getSubtitle());
                adAssets.setCreateUser(userName);
                this.adAssetsMapper.insertDirectAsset(adAssets);
                this.adTicketMapper.insertDirectTicket(adAssetsDto.getTicketId(), adAssetsDto.getAssetSize(), adAssets.getId());
            }
        } else {
            AdAssets adAssets = new AdAssets();
            adAssets.setImage(adAssetsDto.getUrls()[0]);
            adAssets.setButtonTxt("\u76f4\u6295");
            adAssets.setIntro("\u76f4\u6295");
            adAssets.setName(assetName);
            adAssets.setDirect(Integer.valueOf(1));
            adAssets.setAssetSize(adAssetsDto.getAssetSize());
            adAssets.setAssetType(adAssetsDto.getAssetType());
            adAssets.setTitle(adAssetsDto.getTitle());
            adAssets.setSubtitle(adAssetsDto.getSubtitle());
            adAssets.setCreateUser(userName);
            this.adAssetsMapper.insertDirectAsset(adAssets);
            this.adTicketMapper.insertDirectTicket(adAssetsDto.getTicketId(), adAssetsDto.getAssetSize(), adAssets.getId());
        }
        this.pushDirectTicketMaterial(adAssetsDto);
    }

    private void pushDirectTicketMaterial(AdAssetsDto adAssetsDto) {
        DirectTicketMaterial directTicketMaterial = new DirectTicketMaterial();
        directTicketMaterial.setTicketId(adAssetsDto.getTicketId().longValue());
        directTicketMaterial.setSize(adAssetsDto.getAssetSize());
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("status", "1");
        map.put("ticketId", adAssetsDto.getTicketId());
        map.put("assetSize", adAssetsDto.getAssetSize());
        List list = this.adAssetsMapper.findDirectAssetsListByParams(map);
        ArrayList directMaterials = Lists.newArrayList();
        for (AdAssets adAssets : list) {
            DirectMaterial directMaterial = new DirectMaterial();
            BeanUtils.copyProperties((Object)adAssets, (Object)directMaterial);
            directMaterial.setUrl(adAssets.getImage());
            directMaterials.add(directMaterial);
        }
        directTicketMaterial.setMaterials((List)directMaterials);
        try {
            this.prodPusherIntegration.pushToProd(ProdServiceNameEnum.DIRECT_TICKET_MATERIAL.getServiceName(), (Map)Maps.newHashMap(), JsonHelper.convert2bytes((Object)directTicketMaterial));
        }
        catch (Exception e) {
            LOGGER.error("\u63a8\u9001\u76f4\u6295\u5238\u7d20\u6750\u914d\u7f6e\u51fa\u9519" + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void update(AdAssetsDto adAssetsDto, String userName) {
        AdAssets adAssets = new AdAssets();
        adAssets.setName(adAssetsDto.getName());
        adAssets.setAssetType(adAssetsDto.getAssetType());
        adAssets.setTitle(adAssetsDto.getTitle());
        adAssets.setSubtitle(adAssetsDto.getSubtitle());
        adAssets.setImage(adAssetsDto.getImage());
        adAssets.setId(Long.valueOf(adAssetsDto.getId().longValue()));
        adAssets.setStatus(adAssetsDto.getStatus());
        adAssets.setModifyUser(userName);
        this.adAssetsMapper.updateDirectAssetByPrimaryKey(adAssets);
        this.pushDirectTicketMaterial(adAssetsDto);
    }

    @Override
    public AdAssetsVo get(Long id) {
        AdAssets directAsset = this.adAssetsMapper.findDirectAssetById(id);
        AdAssetsVo adAssetsVo = new AdAssetsVo();
        BeanUtils.copyProperties((Object)directAsset, (Object)adAssetsVo);
        return adAssetsVo;
    }

    @Override
    public void delete(Long id) {
        this.adAssetsMapper.deleteDirectAssetById(id);
    }

    @Override
    public Pagination findDirectAssetsListByParams(AdAssetsDto adAssetsDto) {
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("keywords", adAssetsDto.getKeywords());
        map.put("status", "0,1");
        map.put("ticketId", adAssetsDto.getTicketId());
        map.put("assetSize", adAssetsDto.getAssetSize());
        List list = this.adAssetsMapper.findDirectAssetsListByParams(map);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new Pagination();
        }
        List<AdAssetsVo> listVo = this.getAdAssetsVos(adAssetsDto.getPvStartTime(), adAssetsDto.getPvEndTime(), list);
        if (StringUtil.isNotBlank((CharSequence)adAssetsDto.getOrderParam()) && StringUtil.isNotBlank((CharSequence)adAssetsDto.getOrderType())) {
            ListOrderUtils.sortList(listVo, adAssetsDto.getOrderParam(), adAssetsDto.getOrderType());
        }
        List<AdAssetsVo> listPage = ListUtil.getTotalPage(listVo, listVo.size(), adAssetsDto.getPageNum(), adAssetsDto.getPageSize());
        Pagination pagination = new Pagination();
        pagination.setPageNo(adAssetsDto.getPageNum());
        pagination.setPageSize(adAssetsDto.getPageSize());
        pagination.setTotalCount(listVo.size());
        pagination.setList(listPage);
        return pagination;
    }

    private List<AdAssetsVo> getAdAssetsVos(String startTime, String endTime, List<AdAssets> list) {
        ArrayList<AdAssetsVo> listVo = new ArrayList<AdAssetsVo>();
        Integer allClick = 0;
        Integer allView = 0;
        Integer validClick = 0;
        DecimalFormat df = new DecimalFormat("######0");
        Map<String, String> materialTypes = this.dictionariesService.getCodeDetailMapByCode("materialType");
        Set<String> dailys = DirectTicketMaterialServiceImpl.getDailyBetweenDate(DateUtil.convertStr2Date((String)startTime), DateUtil.convertStr2Date((String)endTime));
        for (AdAssets ad : list) {
            allClick = this.getClickCount(dailys, ad.getId());
            allView = this.getViewCount(dailys, ad.getId());
            validClick = this.getValidClickCount(dailys, ad.getId());
            AdAssetsVo aav = new AdAssetsVo();
            BeanUtils.copyProperties((Object)ad, (Object)aav);
            aav.setAssetType((String)materialTypes.getOrDefault(ad.getAssetType(), null));
            aav.setClickPv(allClick);
            if (allView == 0) {
                aav.setClickRate2(0.0);
            } else {
                aav.setClickRate2((double)Math.round(Double.parseDouble(allClick + "") * 100.0 / Double.parseDouble(allView + "")));
            }
            if (allClick == 0) {
                aav.setValidClickRate(0.0);
            } else {
                aav.setValidClickRate((double)Math.round(Double.parseDouble(validClick + "") * 100.0 / Double.parseDouble(allClick + "")));
            }
            aav.setValidClick(validClick);
            aav.setOpenPv(allView);
            listVo.add(aav);
        }
        return listVo;
    }

    public Map<String, String> getDictionaries(String typegroupid) {
        List list = this.dictionariesMapper.findAll(typegroupid);
        HashMap<String, String> map = new HashMap<String, String>(list.size());
        for (Dictionaries dictionaries : list) {
            map.put(dictionaries.getTypecode(), dictionaries.getTypename());
        }
        return map;
    }

    private int getClickCount(Set<String> dailys, Long assetsId) {
        int count = 0;
        for (String daily : dailys) {
            count += this.prodPullerIntegration.fetchAssetAllClikePvCount(assetsId.toString(), daily).intValue();
        }
        return count;
    }

    private int getViewCount(Set<String> dailys, Long assetsId) {
        int count = 0;
        for (String daily : dailys) {
            count += this.prodPullerIntegration.fetchAssetAllViewPvCount(assetsId.toString(), daily).intValue();
        }
        return count;
    }

    private int getValidClickCount(Set<String> dailys, Long assetsId) {
        int count = 0;
        for (String daily : dailys) {
            count += this.prodPullerIntegration.fetchAssetValiedClikePvCount(assetsId.toString(), daily).intValue();
        }
        return count;
    }

    public static Set<String> getDailyBetweenDate(Date beginDate, Date endDate) {
        HashSet<String> lDate = new HashSet<String>();
        lDate.add(DateUtil.dateTo8String1((Date)beginDate));
        Calendar cal = Calendar.getInstance();
        cal.setTime(beginDate);
        boolean bContinue = true;
        while (bContinue) {
            cal.add(5, 1);
            if (!endDate.after(cal.getTime())) break;
            lDate.add(DateUtil.dateTo8String1((Date)cal.getTime()));
        }
        lDate.add(DateUtil.dateTo8String1((Date)endDate));
        return lDate;
    }
}

