/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adkeeper.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bxm.adsmanager.dal.mapper.adkeeper.DownloadLandingPageMapper;
import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.DownloadLandingPage;
import com.bxm.adsmanager.model.dao.adkeeper.DownloadLandingPageExample;
import com.bxm.adsmanager.model.dto.DownloadLandingPageDTO;
import com.bxm.adsmanager.model.dto.DownloadLandingPageSearchDTO;
import com.bxm.adsmanager.model.enums.ProdServiceNameEnum;
import com.bxm.adsmanager.service.adkeeper.DownloadLandingPageService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DownloadLandingPageServiceImpl
implements DownloadLandingPageService {
    @Autowired
    private DownloadLandingPageMapper downloadLandingPageMapper;
    @Autowired
    private ProdPusherIntegration prodPusher;

    @Override
    @Transactional
    public Long add(DownloadLandingPageDTO dto) throws Exception {
        DownloadLandingPage downloadLandingPage = new DownloadLandingPage();
        BeanUtils.copyProperties((Object)dto, (Object)downloadLandingPage);
        downloadLandingPage.setId(null);
        int result = this.downloadLandingPageMapper.insert(downloadLandingPage);
        if (result > 0) {
            this.prodPusher.pushToProd(ProdServiceNameEnum.DOWNLOAD_LANDING_PAGE.getServiceName(), null, JSONArray.toJSONBytes((Object)downloadLandingPage, (SerializerFeature[])new SerializerFeature[0]));
            return downloadLandingPage.getId();
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer update(DownloadLandingPageDTO dto) throws Exception {
        DownloadLandingPage downloadLandingPage = this.downloadLandingPageMapper.selectByPrimaryKey(Long.valueOf(dto.getId()));
        BeanUtils.copyProperties((Object)dto, (Object)downloadLandingPage);
        int result = this.downloadLandingPageMapper.updateByPrimaryKeySelective(downloadLandingPage);
        this.prodPusher.pushToProd(ProdServiceNameEnum.DOWNLOAD_LANDING_PAGE.getServiceName(), null, JSONArray.toJSONBytes((Object)downloadLandingPage, (SerializerFeature[])new SerializerFeature[0]));
        return result;
    }

    @Override
    public PageInfo<DownloadLandingPage> findAll(DownloadLandingPageSearchDTO searchDto) throws Exception {
        PageHelper.startPage((int)searchDto.getPageNum(), (int)searchDto.getPageSize());
        PageInfo pageInfo = new PageInfo(this.getList(searchDto));
        return pageInfo;
    }

    @Override
    public List<DownloadLandingPage> getList(DownloadLandingPageSearchDTO searchDto) throws Exception {
        DownloadLandingPageExample example = new DownloadLandingPageExample();
        if (StringUtils.isNotBlank((CharSequence)searchDto.getKeywords())) {
            DownloadLandingPageExample.Criteria criteria = example.createCriteria();
            criteria.andAppNameLike("%" + searchDto.getKeywords() + "%");
            if (NumberUtils.isParsable((String)searchDto.getKeywords())) {
                example.or().andIdEqualTo(Long.valueOf(searchDto.getKeywords()));
            }
        }
        example.setOrderByClause("id desc");
        return this.downloadLandingPageMapper.selectByExample(example);
    }
}

