/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adkeeper.impl;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdLandingPageConfigMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdLandingPagePlanMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketOcpcMapper;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dao.adkeeper.AdLandingPageConfig;
import com.bxm.adsmanager.model.dao.adkeeper.AdLandingPagePlan;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dto.LandingPagePlanDto;
import com.bxm.adsmanager.model.dto.LandingPagePlanSearchDto;
import com.bxm.adsmanager.model.vo.LandingPageConfigVo;
import com.bxm.adsmanager.model.vo.LandingPagePlanVo;
import com.bxm.adsmanager.service.adkeeper.LandingPageService;
import com.bxm.adsmanager.service.prod.ProdService;
import com.bxm.adsmanager.utils.RequestUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LandingPageServiceImpl
implements LandingPageService {
    @Autowired
    private AdLandingPagePlanMapper landingPagePlanMapper;
    @Autowired
    private AdLandingPageConfigMapper landingPageConfigMapper;
    @Autowired
    private AdTicketMapper adTicketMapper;
    @Autowired
    private AdTicketOcpcMapper adTicketOcpcMapper;
    @Autowired
    private ProdService prodService;

    @Override
    public PageInfo<LandingPagePlanVo> list(LandingPagePlanSearchDto dto) {
        Page page = PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        List list = this.landingPagePlanMapper.list(dto);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List landingPageConfigVos = this.landingPageConfigMapper.selectAll();
            Map<Long, List<LandingPageConfigVo>> planConfigMap = landingPageConfigVos.stream().collect(Collectors.groupingBy(LandingPageConfigVo::getPlanId));
            list.forEach(l -> {
                Long planId = l.getId();
                l.setLandingPageConfigs((List)planConfigMap.get(planId));
            });
        }
        PageInfo pageInfo = page.toPageInfo();
        pageInfo.setList(list);
        return pageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=60)
    public void add(LandingPagePlanDto dto, String userName) throws Exception {
        AdTicket adTicket = this.adTicketMapper.selectByPrimaryKey(dto.getTicketId());
        this.validateTicket(adTicket);
        List landingPageConfigs = dto.getLandingPageConfigVoList();
        AdLandingPagePlan adLandingPagePlan = new AdLandingPagePlan();
        BeanUtils.copyProperties((Object)dto, (Object)adLandingPagePlan);
        adLandingPagePlan.setStatus(AdLandingPagePlan.STATUS_CLOSE);
        adLandingPagePlan.setAuditStatus(AdLandingPagePlan.AUDIT_STATUS_WAIT);
        adLandingPagePlan.setCreateUser(userName);
        adLandingPagePlan.setTicketName(adTicket.getName());
        this.landingPagePlanMapper.insertSelective(adLandingPagePlan);
        landingPageConfigs.forEach(l -> {
            AdLandingPageConfig adLandingPageConfig = new AdLandingPageConfig();
            BeanUtils.copyProperties((Object)l, (Object)adLandingPageConfig);
            adLandingPageConfig.setPlanId(adLandingPagePlan.getId());
            this.landingPageConfigMapper.insertSelective(adLandingPageConfig);
        });
        this.prodService.pushAdTicketToProdPre(dto.getTicketId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=60)
    public void update(LandingPagePlanDto dto, String userName) throws Exception {
        AdTicket adTicket = this.adTicketMapper.selectByPrimaryKey(dto.getTicketId());
        this.validateTicket(adTicket);
        Long planId = dto.getId();
        AdLandingPagePlan oldPlan = this.landingPagePlanMapper.selectByPrimaryKey(planId);
        boolean isRefuse = AdLandingPagePlan.AUDIT_STATUS_REFUSE.equals(oldPlan.getAuditStatus());
        if (!isRefuse) {
            AdLandingPagePlan adLandingPagePlan = new AdLandingPagePlan();
            adLandingPagePlan.setId(dto.getId());
            adLandingPagePlan.setStartDate(dto.getStartDate());
            adLandingPagePlan.setEndDate(dto.getEndDate());
            adLandingPagePlan.setStartTime(dto.getStartTime());
            adLandingPagePlan.setEndTime(dto.getEndTime());
            this.landingPagePlanMapper.updateByPrimaryKeySelective(adLandingPagePlan);
        } else {
            List landingPageConfigs = dto.getLandingPageConfigVoList();
            this.landingPageConfigMapper.deleteByPlanId(dto.getId());
            AdLandingPagePlan adLandingPagePlan = new AdLandingPagePlan();
            BeanUtils.copyProperties((Object)dto, (Object)adLandingPagePlan);
            adLandingPagePlan.setStatus(AdLandingPagePlan.STATUS_CLOSE);
            adLandingPagePlan.setAuditStatus(AdLandingPagePlan.AUDIT_STATUS_WAIT);
            adLandingPagePlan.setModifyUser(userName);
            adLandingPagePlan.setTicketName(adTicket.getName());
            this.landingPagePlanMapper.updateByPrimaryKeySelective(adLandingPagePlan);
            landingPageConfigs.forEach(l -> {
                AdLandingPageConfig adLandingPageConfig = new AdLandingPageConfig();
                BeanUtils.copyProperties((Object)l, (Object)adLandingPageConfig);
                adLandingPageConfig.setPlanId(planId);
                adLandingPageConfig.setId(null);
                this.landingPageConfigMapper.insertSelective(adLandingPageConfig);
            });
        }
        this.prodService.pushAdTicketToProdPre(dto.getTicketId());
    }

    @Override
    public void updateStatus(Long id, Short status) throws Exception {
        AdLandingPagePlan oldPlan = this.landingPagePlanMapper.selectByPrimaryKey(id);
        if (oldPlan == null) {
            throw new BusinessException("\u4e0d\u5b58\u5728\u7684\u8ba1\u5212");
        }
        if (status.equals(AdLandingPagePlan.STATUS_OPEN)) {
            if (!AdLandingPagePlan.AUDIT_STATUS_PASS.equals(oldPlan.getAuditStatus())) {
                throw new BusinessException("\u4ec5\u843d\u5730\u9875AB\u8ba1\u5212\u5ba1\u6838\u901a\u8fc7\u53ef\u4ee5\u5f00\u542f");
            }
            Long ticketId = oldPlan.getTicketId();
            List ticketAllPlan = this.landingPagePlanMapper.findByTicketId(ticketId, AdLandingPagePlan.STATUS_OPEN);
            if (CollectionUtils.isNotEmpty((Collection)ticketAllPlan) && ticketAllPlan.size() >= 1) {
                throw new BusinessException("\u5238\u4e0b\u53ea\u80fd\u6709\u4e00\u4e2a\u5f00\u542f\u7684\u843d\u5730\u9875AB\u8ba1\u5212");
            }
        }
        AdLandingPagePlan adLandingPagePlan = new AdLandingPagePlan();
        adLandingPagePlan.setId(id);
        adLandingPagePlan.setStatus(status);
        adLandingPagePlan.setModifyUser(RequestUtils.getCurrentUserName());
        this.landingPagePlanMapper.updateByPrimaryKeySelective(adLandingPagePlan);
        this.prodService.pushAdTicketToProdPre(oldPlan.getTicketId());
    }

    @Override
    public void updateFlowRate(Long ticketId, Long landingPageConfigId, Double flowRate) throws Exception {
        AdLandingPageConfig landingPageConfig = this.landingPageConfigMapper.selectByPrimaryKey(landingPageConfigId);
        if (null == landingPageConfig) {
            throw new BusinessException("\u8be5\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        AdLandingPageConfig forUpdate = new AdLandingPageConfig();
        forUpdate.setId(landingPageConfigId);
        forUpdate.setFlowRate(flowRate);
        this.landingPageConfigMapper.updateByPrimaryKeySelective(forUpdate);
        this.prodService.pushAdTicketToProdPre(ticketId);
    }

    @Override
    public void enableKylin(Long id, Long landPageId, Short enableKylin) throws Exception {
        AdLandingPagePlan oldPlan = this.landingPagePlanMapper.selectByPrimaryKey(id);
        if (oldPlan == null) {
            throw new BusinessException("\u4e0d\u5b58\u5728\u7684\u8ba1\u5212");
        }
        AdLandingPageConfig landingPageConfig = this.landingPageConfigMapper.selectByPrimaryKey(landPageId);
        if (Objects.isNull(landingPageConfig)) {
            throw new BusinessException("\u8be5\u843d\u5730\u9875\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        landingPageConfig.setEnableKylin(enableKylin);
        this.landingPageConfigMapper.updateByPrimaryKeySelective(landingPageConfig);
        this.prodService.pushAdTicketToProdPre(oldPlan.getTicketId());
    }

    private void validateTicket(AdTicket adTicket) {
        if (adTicket == null) {
            throw new BusinessException("\u5e7f\u544a\u8ba1\u5212id\u4e0d\u5b58\u5728");
        }
    }
}

