/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adprofit.impl;

import com.bxm.adsmanager.model.dto.adprofit.AdProfitMediaDto;
import com.bxm.adsmanager.model.dto.adprofit.AdProfitPositionDto;
import com.bxm.util.DateUtil;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class AdProfitMediaPositionCheckServiceImpl {
    public ResultModel<String> checkAuth(String datetime) {
        ResultModel rs = new ResultModel();
        String limitTime = "15:00";
        SimpleDateFormat df = new SimpleDateFormat("HH:mm");
        SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd");
        Date nowDate1 = null;
        Date nowDate2 = null;
        Date limitDate = null;
        Date paramDate = null;
        try {
            nowDate1 = df.parse(df.format(new Date()));
            limitDate = df.parse(limitTime);
            paramDate = df2.parse(datetime);
            nowDate2 = df2.parse(df2.format(new Date()));
        }
        catch (Exception e) {
            rs.setSuccessed(false);
            rs.setErrorDesc(e.getMessage());
            return rs;
        }
        if (DateUtil.isAfter((Date)limitDate, (Date)nowDate1) && DateUtil.isAfter((Date)paramDate, (Date)nowDate2)) {
            rs.setSuccessed(false);
            rs.setErrorDesc("\u7528\u6237\u65e0\u6743\u9650\u4fee\u6539");
            return rs;
        }
        return rs;
    }

    public ResultModel<String> checkMediaProfit(List<AdProfitMediaDto> lists) {
        ResultModel rs = new ResultModel();
        if (null == lists || lists.isEmpty()) {
            rs.setSuccessed(false);
            rs.setErrorDesc("\u63d0\u4ea4\u7684\u6570\u636e\u5b58\u5728\u95ee\u9898");
            return rs;
        }
        for (AdProfitMediaDto record : lists) {
            if (null == record.getId() || record.getId() == 0L) {
                rs.setSuccessed(false);
                rs.setErrorDesc("ID\u4e0d\u80fd\u4e3a\u7a7a");
                return rs;
            }
            if (StringUtil.isBlank((CharSequence)record.getDatetime())) {
                rs.setSuccessed(false);
                rs.setErrorDesc("\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
                return rs;
            }
            if (StringUtil.isBlank((CharSequence)record.getAppId())) {
                rs.setSuccessed(false);
                rs.setErrorDesc("\u5a92\u4f53ID\u4e0d\u80fd\u4e3a\u7a7a");
                return rs;
            }
            if (null == record.getProfitPredict()) {
                rs.setSuccessed(false);
                rs.setErrorDesc("\u9884\u4f30\u6536\u76ca\u4e0d\u80fd\u4e3a\u7a7a");
                return rs;
            }
            if (null == record.getYesterPredictArpu()) {
                rs.setSuccessed(false);
                rs.setErrorDesc("\u6628\u65e5arpu\u4e0d\u80fd\u4e3a\u7a7a");
                return rs;
            }
            if (!StringUtils.isNotEmpty((String)record.getRemark()) || record.getRemark().length() <= 30) continue;
            rs.setSuccessed(false);
            rs.setErrorDesc("\u5907\u6ce8\u6700\u591a\u8f93\u516530\u4e2a\u5b57\u7b26");
            return rs;
        }
        return rs;
    }

    public ResultModel<String> checkPositionProfit(List<AdProfitPositionDto> lists) {
        ResultModel rs = new ResultModel();
        if (null == lists || lists.isEmpty()) {
            rs.setSuccessed(false);
            rs.setErrorDesc("\u63d0\u4ea4\u7684\u6570\u636e\u5b58\u5728\u95ee\u9898");
            return rs;
        }
        for (AdProfitPositionDto record : lists) {
            if (null == record.getId() || record.getId() == 0L) {
                rs.setSuccessed(false);
                rs.setErrorDesc("ID\u4e0d\u80fd\u4e3a\u7a7a");
                return rs;
            }
            if (StringUtil.isBlank((CharSequence)record.getDatetime())) {
                rs.setSuccessed(false);
                rs.setErrorDesc("\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
                return rs;
            }
            if (StringUtil.isBlank((CharSequence)record.getPositionId())) {
                rs.setSuccessed(false);
                rs.setErrorDesc("\u5e7f\u544a\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a");
                return rs;
            }
            if (StringUtil.isBlank((CharSequence)record.getAppId())) {
                rs.setSuccessed(false);
                rs.setErrorDesc("\u5a92\u4f53ID\u4e0d\u80fd\u4e3a\u7a7a");
                return rs;
            }
            if (null == record.getProfitPredict()) {
                rs.setSuccessed(false);
                rs.setErrorDesc("\u9884\u4f30\u6536\u76ca\u4e0d\u80fd\u4e3a\u7a7a");
                return rs;
            }
            if (null == record.getProfitDeduct()) {
                rs.setSuccessed(false);
                rs.setErrorDesc("\u6263\u91cf\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
                return rs;
            }
            if (null == record.getYesterPredictArpu()) {
                rs.setSuccessed(false);
                rs.setErrorDesc("\u6628\u65e5arpu\u4e0d\u80fd\u4e3a\u7a7a");
                return rs;
            }
            if (!StringUtils.isNotEmpty((String)record.getRemark()) || record.getRemark().length() <= 30) continue;
            rs.setSuccessed(false);
            rs.setErrorDesc("\u5907\u6ce8\u6700\u591a\u8f93\u516530\u4e2a\u5b57\u7b26");
            return rs;
        }
        return rs;
    }
}

