/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adprofit.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.dal.mapper.adprofit.AdProfitAllMapper;
import com.bxm.adsmanager.dal.mapper.adprofit.AdProfitMediaMapper;
import com.bxm.adsmanager.dal.mapper.adprofit.AdProfitPositionMapper;
import com.bxm.adsmanager.dal.mapper.adprofit.ext.AdProfitAllMapperExt;
import com.bxm.adsmanager.dal.mapper.adprofit.ext.AdProfitMediaMapperExt;
import com.bxm.adsmanager.dal.mapper.adprofit.ext.AdProfitPositionMapperExt;
import com.bxm.adsmanager.dal.mapper.adprofit.ext.AdTicketIncomeMapperExt;
import com.bxm.adsmanager.dal.mapper.adprofit.ext.AdTicketIncomePositionMapperExt;
import com.bxm.adsmanager.dal.mapper.position.PositionDefaultPercentMapper;
import com.bxm.adsmanager.ecxeption.ProfitException;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.integration.adsmedia.provider.ProviderFacadeIntegration;
import com.bxm.adsmanager.integration.config.WarnHelperConfig;
import com.bxm.adsmanager.integration.datapark.model.AppCount;
import com.bxm.adsmanager.integration.datapark.service.DataparkListToMapService;
import com.bxm.adsmanager.model.dao.adprofit.AdProfitAll;
import com.bxm.adsmanager.model.dao.adprofit.AdProfitMedia;
import com.bxm.adsmanager.model.dao.adprofit.AdProfitPosition;
import com.bxm.adsmanager.model.dao.position.PositionDefaultPercent;
import com.bxm.adsmanager.model.dao.position.PositionDefaultPercentVo;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdMediaPositionProfitSearchDto;
import com.bxm.adsmanager.model.dto.adprofit.AdProfitMediaDto;
import com.bxm.adsmanager.model.dto.adprofit.AdProfitPositionDto;
import com.bxm.adsmanager.model.dto.position.PositionQualityFactorDto;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.model.vo.AdTicketIncomePositionVo;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.model.vo.adprofit.AdProfitAllVo;
import com.bxm.adsmanager.model.vo.adprofit.AdProfitMediaVo;
import com.bxm.adsmanager.model.vo.adprofit.AdProfitPositionVo;
import com.bxm.adsmanager.service.adkeeper.impl.AdPositionServiceImpl;
import com.bxm.adsmanager.service.adprofit.AdIncomeTicketService;
import com.bxm.adsmanager.service.adprofit.AdProfitMediaPositionService;
import com.bxm.adsmanager.service.datapark.DataparkIncomeService;
import com.bxm.adsmanager.service.position.PositionQualityFactorService;
import com.bxm.adsmanager.utils.DateFormatUtil;
import com.bxm.adsmanager.utils.DoubleUtil;
import com.bxm.adsmanager.utils.ListOrderUtils;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceParamDTO;
import com.bxm.adsmedia.facade.model.provider.ProviderAppAdDTO;
import com.bxm.adsmedia.facade.model.provider.ProviderAppAdRO;
import com.bxm.commons.currency.Money;
import com.bxm.profit.model.dto.AddAdIncomeLogDto;
import com.bxm.util.DateUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.VoUtil;
import com.bxm.warcar.utils.WarnHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdProfitMediaPositionServiceImpl
implements AdProfitMediaPositionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdPositionServiceImpl.class);
    private static final int DEFULT_ZERO = 0;
    @Autowired
    private AdProfitAllMapperExt adProfitAllExt;
    @Autowired
    private AdProfitMediaMapperExt adProfitMediaExt;
    @Autowired
    private AdProfitPositionMapperExt adProfitPositionExt;
    @Autowired
    private AdIncomeTicketService adIncomeTicketService;
    @Autowired
    private DataparkListToMapService dataparkListToMapService;
    @Autowired
    private AdProfitAllMapper adProfitAllMapper;
    @Autowired
    private AdProfitMediaMapper adProfitMediaMapper;
    @Autowired
    private AdProfitPositionMapper adProfitPositionMapper;
    @Autowired
    private AdTicketIncomePositionMapperExt incomePositionMapperExt;
    @Autowired
    private DataparkIncomeService dataparkIncomeService;
    @Autowired
    private AdTicketIncomeMapperExt adTicketIncomeMapperExt;
    @Autowired
    private AdTicketIncomePositionMapperExt adTicketIncomePositionMapperExt;
    @Autowired
    private WarnHelperConfig warnHelperConfig;
    @Autowired
    private PositionQualityFactorService positionQualityFactorService;
    @Autowired
    private PositionDefaultPercentMapper positionDefaultPercentMapper;
    @Autowired
    private ProviderFacadeIntegration providerFacadeIntegration;
    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;

    @Override
    public List<AdProfitAllVo> findAll(AdMediaPositionProfitSearchDto search) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("start", search.getStart());
        param.put("end", search.getEnd());
        List results = this.adProfitAllExt.getAdProfitAll(param);
        for (AdProfitAllVo vo : results) {
            Map totalCost;
            Long totalIncome = this.adTicketIncomeMapperExt.fingToTalIncome(vo.getDatetime());
            vo.setTotalProfit(totalIncome);
            Long totalConsume = this.incomePositionMapperExt.fingToTalConsume(vo.getDatetime());
            vo.setConsume(Integer.valueOf(null == totalConsume ? 0 : totalConsume.intValue()));
            if (vo.getConsumeShow() != null && vo.getTotalProfitShow() != 0.0) {
                Double actualConsumeRate = DoubleUtil.div(vo.getConsumeShow(), vo.getTotalProfitShow(), 4);
                vo.setActualConsumeRate(VoUtil.percentage((String)String.valueOf(actualConsumeRate * 100.0)));
            } else {
                vo.setActualConsumeRate(VoUtil.percentage((String)"0.0"));
            }
            if (vo.getTotalProfitShow() != 0.0 && vo.getBxmProfitShow() != null) {
                Double grossProfitRate = DoubleUtil.div(vo.getBxmProfitShow(), vo.getTotalProfitShow(), 4);
                vo.setGrossProfitRate(VoUtil.percentage((String)String.valueOf(grossProfitRate * 100.0)));
            } else {
                vo.setGrossProfitRate(VoUtil.percentage((String)"0.0"));
            }
            if ((totalCost = this.adTicketIncomeMapperExt.fingTotalCost(vo.getDatetime())) == null || totalCost.isEmpty()) continue;
            vo.setAgentRebate(Double.valueOf(DoubleUtil.savePoint(((BigDecimal)totalCost.get("agentRebate")).doubleValue(), 3)));
            vo.setBdRebate(Double.valueOf(DoubleUtil.savePoint(((BigDecimal)totalCost.get("bdRebate")).doubleValue(), 3)));
            vo.setFixCost(Double.valueOf(DoubleUtil.savePoint(((BigDecimal)totalCost.get("fixCost")).doubleValue(), 3)));
        }
        return results;
    }

    @Override
    public Pagination findMediaProfit(AdMediaPositionProfitSearchDto search) {
        Pagination results = new Pagination();
        List lists = this.adProfitMediaExt.getMediaProfitPage(search);
        Map<String, Integer> mediaIncomeMap = this.adIncomeTicketService.getTicketIncomeGroupMedia(search.getDatetime());
        Map mediaCountMap = this.dataparkListToMapService.getAppCountMap(search.getDatetime());
        Map medisMap = this.providerFacadeIntegration.findMediaAllToMap();
        for (AdProfitMediaVo vo : lists) {
            AppCount count;
            ProviderAppAdRO mediaMsg = (ProviderAppAdRO)medisMap.get(vo.getAppId());
            if (mediaMsg != null) {
                String appName = StringUtils.defaultString((String)mediaMsg.getAlias(), (String)mediaMsg.getAppName());
                vo.setAppName(appName);
            }
            vo.setConsume(mediaIncomeMap.get(vo.getAppId()));
            if (vo.getIsUpload().equals((short)1)) {
                // empty if block
            }
            if ((count = (AppCount)mediaCountMap.get(vo.getAppId())) == null) continue;
            vo.setIndexUv(count.getIndexUv());
            vo.setClickPv(count.getClickPv());
        }
        Integer totalCount = this.adProfitMediaExt.countMediaMsg(search);
        results.setPageSize(search.getPageSize());
        results.setPageNo(search.getPageNum());
        results.setList(lists);
        results.setTotalCount(totalCount.intValue());
        return results;
    }

    @Override
    public Pagination findPositionProfit(AdMediaPositionProfitSearchDto search) {
        Pagination results = new Pagination();
        List lists = this.adProfitPositionExt.getPositionProfitPage(search);
        Map mediaCountMap = this.dataparkListToMapService.getPositionCountMap(search.getDatetime());
        List appEntranceAdROS = this.newAppEntranceFacadeIntegration.getAllList(new QueryAppEntranceParamDTO());
        Map appEntranceAdROMap = appEntranceAdROS.stream().collect(HashMap::new, (k, v) -> k.put(v.getPositionId(), v), HashMap::putAll);
        Map medisMap = this.providerFacadeIntegration.findMediaAllToMap();
        for (AdProfitPositionVo vo : lists) {
            AppCount count;
            ProviderAppAdRO mediaMsg;
            AppEntranceAdRO appEntranceAdRO = (AppEntranceAdRO)appEntranceAdROMap.get(vo.getPositionId());
            if (appEntranceAdRO != null) {
                vo.setPositionName(appEntranceAdRO.getAppEntranceName());
            }
            if ((mediaMsg = (ProviderAppAdRO)medisMap.get(vo.getAppId())) != null) {
                String appName = StringUtils.defaultString((String)mediaMsg.getAlias(), (String)mediaMsg.getAppName());
                vo.setAppName(appName);
            }
            if (vo.getIsUpload().equals((short)1)) {
                // empty if block
            }
            if ((count = (AppCount)mediaCountMap.get(vo.getPositionId())) == null) continue;
            vo.setIndexUv(count.getIndexUv());
            vo.setClickPv(count.getClickPv());
        }
        Integer totalCount = this.adProfitPositionExt.countPositionMsg(search);
        results.setPageSize(search.getPageSize());
        results.setPageNo(search.getPageNum());
        results.setList(lists);
        results.setTotalCount(totalCount.intValue());
        return results;
    }

    @Override
    public void importAdProfitMediaExcel(User user, List<AdProfitMediaDto> results) throws ProfitException {
        if (CollectionUtils.isEmpty(results)) {
            throw new ProfitException("\u6570\u636e\u4e3a\u7a7a");
        }
        long start = System.currentTimeMillis();
        String datetime = results.get(0).getDatetime();
        AdProfitAll adProfitAll = this.adProfitAllExt.findAdProfitAllBydatetime(datetime);
        if (null == adProfitAll || 1 == adProfitAll.getPositionStatus()) {
            throw new ProfitException("\u6570\u636e\u5f55\u5165\u4e2d\uff0c\u8bf7\u7a0d\u5019\u518d\u63d0\u4ea4\u6570\u636e");
        }
        try {
            adProfitAll.setMediaStatus(Short.valueOf((short)1));
            adProfitAll.setModifyUser(user.getUsername());
            this.adProfitAllMapper.updateByPrimaryKeySelective(adProfitAll);
            for (AdProfitMediaDto adProfitMedia : results) {
                Long profitPredict = adProfitMedia.getProfitPredictLi();
                if (null == profitPredict || profitPredict < 1L) continue;
                AdProfitMedia media = new AdProfitMedia();
                media.setAppId(adProfitMedia.getAppId());
                media.setId(adProfitMedia.getId());
                media.setRemark(adProfitMedia.getRemark());
                media.setProfitPredict(Integer.valueOf(profitPredict.intValue()));
                media.setModifyUser(user.getUsername());
                LOGGER.info(user.getUsername() + "\u5bfc\u5165id:" + adProfitMedia.getId() + ",\u5a92\u4f53\u9884\u4f30\u6536\u76ca:" + adProfitMedia.getProfitPredict() + "\u5143\uff0c\u65f6\u95f4" + datetime);
                this.adProfitMediaExt.updateByPrimaryKeySelective(media);
                this.countPositionCashRate(datetime, adProfitMedia.getAppId(), user.getUsername());
                this.adProfitPositionExt.updateCashByDatetime(datetime, adProfitMedia.getAppId(), user.getUsername());
            }
            LOGGER.info("\u5a92\u4f53\u6536\u76ca\u6536\u5165\u5b8c\u6210\uff0c\u7528\u65f6\uff1a{}ms,\u5a92\u4f53\u6570\u91cf\uff1a{}", (Object)(System.currentTimeMillis() - start), (Object)results.size());
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u5165\u5a92\u4f53\u6536\u76caExcel\u8868\u683c\u51fa\u9519", (Throwable)e);
            throw new ProfitException("\u5bfc\u5165\u5a92\u4f53\u6536\u76caExcel\u8868\u683c\u51fa\u9519");
        }
        finally {
            adProfitAll.setMediaStatus(Short.valueOf((short)2));
            adProfitAll.setModifyUser(user.getUsername());
            this.adProfitAllMapper.updateByPrimaryKeySelective(adProfitAll);
            this.adProfitAllExt.updateByDatetime(user.getUsername(), datetime, (short)2);
        }
    }

    @Override
    public void importProfitMediaExcel(User user, List<AdProfitMediaDto> results) throws ProfitException {
        if (CollectionUtils.isEmpty(results)) {
            throw new ProfitException("\u6570\u636e\u4e3a\u7a7a");
        }
        long start = System.currentTimeMillis();
        String datetime = results.get(0).getDatetime();
        AdProfitAll adProfitAll = this.adProfitAllExt.findAdProfitAllBydatetime(datetime);
        if (null == adProfitAll || 1 == adProfitAll.getPositionStatus()) {
            throw new ProfitException("\u6570\u636e\u5f55\u5165\u4e2d\uff0c\u8bf7\u7a0d\u5019\u518d\u63d0\u4ea4\u6570\u636e");
        }
        try {
            List profitPositions;
            adProfitAll.setMediaStatus(Short.valueOf((short)1));
            adProfitAll.setModifyUser(user.getUsername());
            this.adProfitAllMapper.updateByPrimaryKeySelective(adProfitAll);
            HashMap mediarofitPredictMap = Maps.newHashMap();
            for (AdProfitMediaDto adProfitMedia : results) {
                Long profitPredict = adProfitMedia.getProfitPredictLi();
                if (null == profitPredict || profitPredict < 1L) continue;
                mediarofitPredictMap.put(adProfitMedia.getAppId(), profitPredict.intValue());
                AdProfitMedia media = new AdProfitMedia();
                media.setAppId(adProfitMedia.getAppId());
                media.setId(adProfitMedia.getId());
                media.setRemark(adProfitMedia.getRemark());
                media.setProfitPredict(Integer.valueOf(profitPredict.intValue()));
                media.setModifyUser(user.getUsername());
                LOGGER.info(user.getUsername() + "\u5bfc\u5165id:" + adProfitMedia.getId() + ",\u5a92\u4f53\u9884\u4f30\u6536\u76ca:" + adProfitMedia.getProfitPredict() + "\u5143\uff0c\u65f6\u95f4" + datetime);
                this.adProfitMediaExt.updateByPrimaryKeySelective(media);
            }
            HashMap mediaConsumeMap = Maps.newHashMap();
            HashMap positionConsumeMap = Maps.newHashMap();
            List positionVoList = this.adTicketIncomePositionMapperExt.findAllByType(datetime, null);
            if (CollectionUtils.isNotEmpty((Collection)positionVoList)) {
                for (Object vo : positionVoList) {
                    Integer positionConsume;
                    Integer mediaConsume;
                    Integer n = mediaConsume = null == mediaConsumeMap.get(vo.getAppId()) ? Integer.valueOf(0) : (Integer)mediaConsumeMap.get(vo.getAppId());
                    if (null != vo.getConsume() && null != mediaConsume) {
                        mediaConsume = mediaConsume + vo.getConsume();
                    }
                    mediaConsumeMap.put(vo.getAppId(), mediaConsume);
                    Integer n2 = positionConsume = null == positionConsumeMap.get(vo.getPositionId()) ? Integer.valueOf(0) : (Integer)positionConsumeMap.get(vo.getPositionId());
                    if (null != vo.getConsume() && null != positionConsume) {
                        positionConsume = positionConsume + vo.getConsume();
                    }
                    positionConsumeMap.put(vo.getPositionId(), positionConsume);
                }
            }
            if (CollectionUtils.isEmpty((Collection)(profitPositions = this.adProfitPositionExt.findPositionByDatetime(datetime)))) {
                return;
            }
            for (AdProfitPosition position : profitPositions) {
                Integer mediaConsume = AdProfitMediaPositionServiceImpl.intFormat((Integer)mediaConsumeMap.get(position.getAppId()));
                Integer positionConsume = AdProfitMediaPositionServiceImpl.intFormat((Integer)positionConsumeMap.get(position.getPositionId()));
                Integer mediaPredict = AdProfitMediaPositionServiceImpl.intFormat((Integer)mediarofitPredictMap.get(position.getAppId()));
                Double cashRate = AdProfitMediaPositionServiceImpl.doubleFormat(positionConsume, mediaConsume);
                position.setProfitPredict(Integer.valueOf(new BigDecimal(cashRate.toString()).multiply(new BigDecimal(mediaPredict.toString())).intValue()));
            }
            HashMap updateMap = Maps.newHashMap();
            updateMap.put("username", user.getUsername());
            updateMap.put("list", profitPositions);
            this.adProfitPositionExt.updateProfit((Map)updateMap);
            LOGGER.info("\u5a92\u4f53\u6536\u76ca\u6536\u5165\u5b8c\u6210\uff0c\u7528\u65f6\uff1a{}ms,\u5a92\u4f53\u6570\u91cf\uff1a{}", (Object)(System.currentTimeMillis() - start), (Object)results.size());
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u5165\u5a92\u4f53\u6536\u76caExcel\u8868\u683c\u51fa\u9519", (Throwable)e);
            throw new ProfitException("\u5bfc\u5165\u5a92\u4f53\u6536\u76caExcel\u8868\u683c\u51fa\u9519");
        }
        finally {
            adProfitAll.setMediaStatus(Short.valueOf((short)2));
            adProfitAll.setModifyUser(user.getUsername());
            this.adProfitAllMapper.updateByPrimaryKeySelective(adProfitAll);
            this.adProfitAllExt.updateByDatetime(user.getUsername(), datetime, (short)2);
        }
    }

    private static int intFormat(Integer integer) {
        if (null == integer) {
            return 0;
        }
        return integer;
    }

    private static double doubleFormat(Integer val1, Integer val2) {
        double dou = 0.0;
        try {
            if (null == val1 || null == val2) {
                return dou;
            }
            BigDecimal b1 = new BigDecimal(val1);
            BigDecimal b2 = new BigDecimal(val2);
            if (b2.compareTo(new BigDecimal(BigInteger.ZERO)) != 0) {
                dou = b1.divide(b2, 4, 1).doubleValue();
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return dou;
        }
        return dou;
    }

    @Override
    public void updateAdProfitMedia(User user, List<AdProfitMediaDto> results) throws ProfitException {
        if (CollectionUtils.isEmpty(results)) {
            throw new ProfitException("\u63d0\u4ea4\u7684\u6570\u636e\u4e3a\u7a7a");
        }
        String datetime = results.get(0).getDatetime();
        AdProfitAll adProfitAll = this.adProfitAllExt.findAdProfitAllBydatetime(datetime);
        if (null == adProfitAll || 1 == adProfitAll.getPositionStatus()) {
            throw new ProfitException("\u6570\u636e\u5f55\u5165\u4e2d\uff0c\u8bf7\u7a0d\u5019\u518d\u63d0\u4ea4\u6570\u636e");
        }
        Map appCountMapmap = this.dataparkListToMapService.getPositionCountMap(datetime);
        try {
            adProfitAll.setMediaStatus(Short.valueOf((short)1));
            adProfitAll.setModifyUser(user.getUsername());
            this.adProfitAllMapper.updateByPrimaryKeySelective(adProfitAll);
            ArrayList positionIds = Lists.newArrayList();
            for (AdProfitMediaDto adProfitMedia : results) {
                Long profitPredict = adProfitMedia.getProfitPredictLi();
                if (null == profitPredict || profitPredict < 1L) continue;
                AdProfitMedia media = new AdProfitMedia();
                media.setAppId(adProfitMedia.getAppId());
                media.setId(adProfitMedia.getId());
                media.setRemark(adProfitMedia.getRemark());
                media.setProfitPredict(Integer.valueOf(profitPredict.intValue()));
                media.setModifyUser(user.getUsername());
                LOGGER.info(user.getUsername() + "\u5bfc\u5165id:" + adProfitMedia.getId() + ",\u5a92\u4f53\u9884\u4f30\u6536\u76ca:" + adProfitMedia.getProfitPredict() + "\u5143\uff0c\u65f6\u95f4" + datetime);
                this.adProfitMediaExt.updateByPrimaryKeySelective(media);
                this.countPositionCashRate(datetime, adProfitMedia.getAppId(), user.getUsername());
                this.adProfitPositionExt.updateCashByDatetime(datetime, adProfitMedia.getAppId(), user.getUsername());
                HashMap param = Maps.newHashMap();
                param.put("datetime", datetime);
                param.put("app_id", adProfitMedia.getAppId());
                List adProfitPositions = this.adProfitPositionExt.findProfitPositionByParam((Map)param);
                for (AdProfitPosition adProfitPosition : adProfitPositions) {
                    Integer uv;
                    AppCount count = (AppCount)appCountMapmap.get(adProfitPosition.getPositionId());
                    if (count == null || (uv = count.getIndexUv()) == null || uv >= 100) continue;
                    positionIds.add(adProfitPosition.getPositionId());
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)positionIds)) {
                this.adProfitPositionExt.updatProfitDeduct((List)positionIds);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u63d0\u4ea4\u5a92\u4f53\u6536\u76ca\u6570\u636e\u51fa\u9519", (Throwable)e);
            throw new ProfitException("\u63d0\u4ea4\u5a92\u4f53\u6536\u76ca\u6570\u636e\u51fa\u9519");
        }
        finally {
            adProfitAll.setMediaStatus(Short.valueOf((short)2));
            adProfitAll.setModifyUser(user.getUsername());
            this.adProfitAllMapper.updateByPrimaryKeySelective(adProfitAll);
            this.adProfitAllExt.updateByDatetime(user.getUsername(), datetime, (short)2);
        }
    }

    public void countPositionCashRate(String datetime, String appId, String userName) {
        try {
            this.adProfitPositionExt.updateCashRateByDatetime(datetime, appId, userName);
        }
        catch (Exception e) {
            LOGGER.error("\u8ba1\u7b97\u5e7f\u544a\u4f4d\u7684\u9884\u4f30\u6536\u76ca\u6bd4\u7387\u51fa\u9519,\u65e5\u671f:" + datetime + ",appId:" + appId + ",userName:" + userName, (Throwable)e);
        }
    }

    @Override
    public void importAdProfitPositionExcel(User user, List<AdProfitPositionDto> results) throws ProfitException {
        if (CollectionUtils.isEmpty(results)) {
            throw new ProfitException("\u6570\u636e\u4e3a\u7a7a");
        }
        String datetime = results.get(0).getDatetime();
        AdProfitAll adProfitAll = this.adProfitAllExt.findAdProfitAllBydatetime(datetime);
        if (null == adProfitAll || 1 == adProfitAll.getMediaStatus()) {
            throw new ProfitException("\u6570\u636e\u5f55\u5165\u4e2d\uff0c\u8bf7\u7a0d\u5019\u518d\u63d0\u4ea4\u6570\u636e");
        }
        try {
            adProfitAll.setPositionStatus(Short.valueOf((short)1));
            adProfitAll.setModifyUser(user.getUsername());
            this.adProfitAllMapper.updateByPrimaryKeySelective(adProfitAll);
            for (AdProfitPositionDto profitPosition : results) {
                if (null == profitPosition.getProfitPredict() || profitPosition.getProfitPredict().compareTo(0.0) <= 0) continue;
                AdProfitPosition position = new AdProfitPosition();
                position.setId(profitPosition.getId());
                position.setRemark(profitPosition.getRemark());
                position.setProfitDeduct(Integer.valueOf(profitPosition.getProfitDeductLi().intValue()));
                position.setProfitPredict(Integer.valueOf(profitPosition.getProfitPredictLi().intValue()));
                Double predict = profitPosition.getProfitPredictLi().doubleValue();
                Double deduct = profitPosition.getProfitDeductLi().doubleValue();
                Double tempActual = (predict - deduct) / 400.0;
                Integer actual = tempActual.intValue() * 400;
                position.setProfitActual(actual);
                position.setModifyUser(user.getUsername());
                position.setModifyTime(new Date());
                this.adProfitPositionMapper.updateByPrimaryKeySelective(position);
                LOGGER.info(user.getUsername() + "\u5bfc\u5165id:" + position.getId() + ",\u5e7f\u544a\u4f4d\u6263\u91cf\u91d1\u989d:" + profitPosition.getProfitDeduct() + "\u5143\uff0c\u65f6\u95f4" + datetime);
            }
            this.adProfitMediaExt.updateProfitDeductByDatetime(datetime);
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u5165\u5e7f\u544a\u4f4d\u6536\u76caExcel\u8868\u683c\u51fa\u9519", (Throwable)e);
            throw new ProfitException("\u5bfc\u5165\u5e7f\u544a\u4f4d\u6536\u76caExcel\u8868\u683c\u51fa\u9519");
        }
        finally {
            adProfitAll.setPositionStatus(Short.valueOf((short)2));
            adProfitAll.setModifyUser(user.getUsername());
            this.adProfitAllMapper.updateByPrimaryKeySelective(adProfitAll);
            this.adProfitAllExt.updateByDatetime(user.getUsername(), datetime, (short)2);
        }
    }

    @Override
    public void updateAdProfitPosition(User user, List<AdProfitPositionDto> results) throws ProfitException {
        if (CollectionUtils.isEmpty(results)) {
            throw new ProfitException("\u63d0\u4ea4\u7684\u6570\u636e\u4e3a\u7a7a");
        }
        String datetime = results.get(0).getDatetime();
        AdProfitAll adProfitAll = this.adProfitAllExt.findAdProfitAllBydatetime(datetime);
        if (null == adProfitAll || 1 == adProfitAll.getMediaStatus()) {
            throw new ProfitException("\u6570\u636e\u5f55\u5165\u4e2d\uff0c\u8bf7\u7a0d\u5019\u518d\u63d0\u4ea4\u6570\u636e");
        }
        try {
            adProfitAll.setPositionStatus(Short.valueOf((short)1));
            adProfitAll.setModifyUser(user.getUsername());
            this.adProfitAllMapper.updateByPrimaryKeySelective(adProfitAll);
            for (AdProfitPositionDto profitPosition : results) {
                if (null == profitPosition.getProfitPredict() || profitPosition.getProfitPredict().compareTo(0.0) <= 0) continue;
                AdProfitPosition position = new AdProfitPosition();
                position.setId(profitPosition.getId());
                position.setRemark(profitPosition.getRemark());
                position.setProfitDeduct(Integer.valueOf(profitPosition.getProfitDeductLi().intValue()));
                position.setProfitPredict(Integer.valueOf(profitPosition.getProfitPredictLi().intValue()));
                Double tempActual = profitPosition.getProfitActualLi().doubleValue() / 400.0;
                Integer actual = tempActual.intValue() * 400;
                position.setProfitActual(actual);
                position.setModifyUser(user.getUsername());
                position.setModifyTime(new Date());
                this.adProfitPositionMapper.updateByPrimaryKeySelective(position);
                LOGGER.info(user.getUsername() + "\u5bfc\u5165id:" + position.getId() + ",\u5e7f\u544a\u4f4d\u6263\u91cf\u91d1\u989d:" + profitPosition.getProfitDeduct() + "\u5143\uff0c\u65f6\u95f4" + datetime);
            }
            this.adProfitMediaExt.updateProfitDeductByDatetime(datetime);
        }
        catch (Exception e) {
            LOGGER.error("\u63d0\u4ea4\u5e7f\u544a\u4f4d\u6536\u76ca\u6570\u636e\u51fa\u9519", (Throwable)e);
            throw new ProfitException("\u63d0\u4ea4\u5e7f\u544a\u4f4d\u6536\u76ca\u6570\u636e\u51fa\u9519");
        }
        finally {
            adProfitAll.setPositionStatus(Short.valueOf((short)2));
            adProfitAll.setModifyUser(user.getUsername());
            this.adProfitAllMapper.updateByPrimaryKeySelective(adProfitAll);
            this.adProfitAllExt.updateByDatetime(user.getUsername(), datetime, (short)2);
        }
    }

    @Override
    public void entering(User user, String datetime) throws ProfitException {
        this.adProfitMediaExt.updateProfitDeductByDatetime(datetime);
        List mediaList = this.adProfitMediaExt.findProfitMediaByDatetime(datetime);
        List positions = this.adProfitPositionExt.findProfitPositionByDatetime(datetime, null);
        if (CollectionUtils.isEmpty((Collection)positions)) {
            throw new ProfitException(datetime + "\u6570\u636e\u4e3a\u7a7a");
        }
        HashMap integerMap = Maps.newHashMap();
        for (AdProfitPosition position : positions) {
            if (null == position.getProfitActual() || position.getProfitActual() == 0) continue;
            this.addByPosition(user.getUsername(), position, datetime);
            Integer mediaActual = (Integer)integerMap.get(position.getAppId());
            if (null == mediaActual) {
                mediaActual = 0;
            }
            mediaActual = mediaActual + position.getProfitActual();
            integerMap.put(position.getAppId(), mediaActual);
        }
        for (AdProfitMedia media : mediaList) {
            media.setProfitActual((Integer)integerMap.get(media.getAppId()));
            LOGGER.info(user.getUsername() + "\u65f6\u95f4:" + datetime + ",\u5f55\u5165 \u7ed3\u7b97\u5a92\u4f53:" + media.getAppId() + ",\u91d1\u989d:" + media.getProfitActual() + "\u5398");
            media.setIsUpload(AdProfitMedia.YES);
            media.setModifyUser(user.getUsername());
            this.adProfitMediaMapper.updateByPrimaryKeySelective(media);
        }
        this.adProfitAllExt.updateByDatetime(user.getUsername(), datetime, (short)1);
        try {
            this.dataparkIncomeService.dealAppCash(datetime);
        }
        catch (IOException e) {
            LOGGER.error("dealAppCash ERROR", (Throwable)e);
        }
    }

    public void addByPosition(String userName, AdProfitPosition position, String datetime) {
        AddAdIncomeLogDto addAdIncomeLogDto = new AddAdIncomeLogDto();
        ResultModel rs = new ResultModel();
        try {
            addAdIncomeLogDto.setAdPositionId(position.getPositionId());
            addAdIncomeLogDto.setAppKey(position.getAppId());
            addAdIncomeLogDto.setAppId(Long.valueOf(1L));
            addAdIncomeLogDto.setEntranceId(Long.valueOf(1L));
            Money money = Money.ofLi((long)position.getProfitActual().intValue());
            addAdIncomeLogDto.setPrepareIncome(new BigDecimal(money.getYuan()));
            addAdIncomeLogDto.setOrderTime(DateUtil.StringToDate((String)datetime));
            addAdIncomeLogDto.setOrderNumber(UUID.randomUUID().toString().replaceAll("-", ""));
            if (!rs.isSuccessed()) {
                WarnHelper.sendDDWarn((String)this.warnHelperConfig.getToken(), (String)("\u51fa\u9519\u4e86\uff0c\u65f6\u95f4:" + datetime + ",\u589e\u52a0\u5e7f\u544a\u4f4d\u6536\u76ca\uff0cpositionId:" + position.getPositionId() + "\u6536\u76ca" + addAdIncomeLogDto.getPrepareIncome() + "\u540c\u6b65\u8fd4\u56de\u9519\u8bef" + rs.getErrorDesc()), (Boolean)false, null);
                return;
            }
            this.adProfitPositionExt.updateStatusByDatetime(datetime, userName, position.getPositionId());
        }
        catch (Exception e) {
            WarnHelper.sendDDWarn((String)this.warnHelperConfig.getToken(), (String)("\u51fa\u9519\u4e86\uff0c\u65f6\u95f4:" + datetime + ",\u589e\u52a0\u5e7f\u544a\u4f4d\u6536\u76ca\uff0cpositionId:" + position.getPositionId() + "\u6536\u76ca" + addAdIncomeLogDto.getPrepareIncome() + "\u540c\u6b65\u8fd4\u56de\u9519\u8bef" + rs.getErrorDesc()), (Boolean)false, null);
            LOGGER.error("\u51fa\u9519\u4e86\uff0c\u65f6\u95f4:" + datetime + ",\u589e\u52a0\u5e7f\u544a\u4f4d\u6536\u76ca\uff0cpositionId:" + position.getPositionId() + "\u6536\u76ca" + addAdIncomeLogDto.getPrepareIncome() + "\u540c\u6b65\u8fd4\u56de\u9519\u8bef" + rs.getErrorDesc(), (Throwable)e);
        }
        LOGGER.info(userName + "\u65f6\u95f4:" + datetime + "\u5f55\u5165 \u589e\u52a0\u5e7f\u544a\u4f4d\u6536\u76ca\uff0cpositionId:" + position.getPositionId() + "\u6536\u76ca" + addAdIncomeLogDto.getPrepareIncome() + "\u6210\u529f");
    }

    @Override
    public List<AdProfitMediaVo> downLoadMedia(String datetime) throws Exception {
        List list = this.adProfitMediaExt.findProfitMediaByDatetime(datetime);
        Map appCountMapmap = this.dataparkListToMapService.getAppCountMap(datetime);
        Map mediaMap = this.providerFacadeIntegration.findMediaAllToMap();
        ArrayList voList = Lists.newArrayList();
        Map<String, Integer> mediaIncomeMap = this.adIncomeTicketService.getTicketIncomeGroupMedia(datetime);
        for (AdProfitMedia media : list) {
            AdProfitMediaVo vo = new AdProfitMediaVo();
            ProviderAppAdRO mediaMsgDto = (ProviderAppAdRO)mediaMap.get(media.getAppId());
            AppCount count = (AppCount)appCountMapmap.get(media.getAppId());
            if (mediaMsgDto != null) {
                String appName = StringUtils.defaultString((String)mediaMsgDto.getAlias(), (String)mediaMsgDto.getAppName());
                vo.setAppName(appName);
                media.setRemark(mediaMsgDto.getRemark());
            }
            if (count != null) {
                vo.setClickPv(count.getClickPv());
                vo.setIndexUv(count.getIndexUv());
            }
            vo.setConsume(mediaIncomeMap.get(media.getAppId()));
            BeanUtils.copyProperties((Object)media, (Object)vo);
            voList.add(vo);
        }
        return voList;
    }

    @Override
    public List<AdProfitPositionVo> downLoadPosition(String datetime, String appId) throws Exception {
        List list = this.adProfitPositionExt.findProfitPositionByDatetime(datetime, appId);
        Map appCountMapmap = this.dataparkListToMapService.getPositionCountMap(datetime);
        Map mediaMap = this.providerFacadeIntegration.findMediaAllToMap();
        Map<Object, Object> factorMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            PositionQualityFactorDto positionQualityFactorDto = new PositionQualityFactorDto();
            positionQualityFactorDto.setImportTime(datetime);
            factorMap = this.positionQualityFactorService.queryPositionQualityFactorMap(positionQualityFactorDto);
        }
        Map<String, Integer> incomeMap = this.getPositionIncome(datetime);
        ArrayList voList = Lists.newArrayList();
        for (AdProfitPosition position : list) {
            AdProfitPositionVo vo = new AdProfitPositionVo();
            ProviderAppAdRO mediaMsgDto = (ProviderAppAdRO)mediaMap.get(position.getAppId());
            AppCount count = (AppCount)appCountMapmap.get(position.getPositionId());
            if (mediaMsgDto != null) {
                String appName = StringUtils.defaultString((String)mediaMsgDto.getAlias(), (String)mediaMsgDto.getAppName());
                vo.setAppName(appName);
                position.setRemark(mediaMsgDto.getRemark());
            }
            if (count != null) {
                vo.setClickPv(count.getClickPv());
                vo.setIndexUv(count.getIndexUv());
                vo.setJoinRate(count.getJoinRate());
                vo.setClickRate(count.getClickRate());
            }
            vo.setPositionIncome(incomeMap.get(position.getPositionId()));
            BeanUtils.copyProperties((Object)position, (Object)vo);
            if (null == vo.getIndexUv()) continue;
            vo.setFactor((String)factorMap.get(vo.getPositionId()));
            voList.add(vo);
        }
        ListOrderUtils.sortList(voList, "indexUv", "DESC");
        return voList;
    }

    public Map<String, Integer> getPositionIncome(String datetime) {
        HashMap map = Maps.newHashMap();
        try {
            List list = this.incomePositionMapperExt.fingMsgGroupPosition(datetime);
            for (AdTicketIncomePositionVo vo : list) {
                map.put(vo.getPositionId(), vo.getConsume());
            }
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            return map;
        }
        return map;
    }

    @Override
    public List<AdProfitMediaVo> selectMediaProfitByTime(AdMediaPositionProfitSearchDto search) throws Exception {
        HashMap map = Maps.newHashMap();
        map.put("roleCode", search.getUserName());
        ProviderAppAdDTO dto = new ProviderAppAdDTO();
        dto.setMedium(search.getUserName());
        dto.setBd(search.getBd());
        List allAppkeys = this.providerFacadeIntegration.getProviderAppKeyList(dto);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("datetime", search.getDatetime());
        if (allAppkeys != null && !allAppkeys.isEmpty()) {
            param.put("appIds", allAppkeys);
        }
        List list = this.adProfitMediaExt.findProfitMediaByParam(param);
        Map appCountMapmap = this.dataparkListToMapService.getAppCountMap(search.getDatetime());
        Map mediaMap = this.providerFacadeIntegration.findMediaAllToMap();
        ArrayList voList = Lists.newArrayList();
        Map<String, Integer> mediaIncomeMap = this.adIncomeTicketService.getTicketIncomeGroupMedia(search.getDatetime());
        AdProfitMediaVo vo = null;
        for (AdProfitMedia media : list) {
            vo = new AdProfitMediaVo();
            ProviderAppAdRO mediaMsgDto = (ProviderAppAdRO)mediaMap.get(media.getAppId());
            AppCount count = (AppCount)appCountMapmap.get(media.getAppId());
            if (mediaMsgDto != null) {
                String appName = StringUtils.defaultString((String)mediaMsgDto.getAlias(), (String)mediaMsgDto.getAppName());
                vo.setAppName(appName);
            }
            if (count != null) {
                vo.setClickPv(count.getClickPv());
                vo.setIndexUv(count.getIndexUv());
            }
            vo.setConsume(mediaIncomeMap.get(media.getAppId()));
            if (null == vo.getIndexUv() || 0 == vo.getIndexUv() || null == vo.getClickPv() || 0 == vo.getClickPv()) continue;
            BeanUtils.copyProperties((Object)media, (Object)vo);
            voList.add(vo);
        }
        if (StringUtil.isNotBlank((String)search.getOrderParam()) && StringUtil.isNotBlank((String)search.getOrderType())) {
            ListOrderUtils.sortList(voList, search.getOrderParam(), search.getOrderType());
        } else {
            ListOrderUtils.sortList(voList, "indexUv", "DESC");
        }
        return voList;
    }

    @Override
    public List<AdProfitPositionVo> selectPositionProfitByTime(AdMediaPositionProfitSearchDto search) throws Exception {
        HashMap map = Maps.newHashMap();
        map.put("roleCode", search.getUserName());
        ProviderAppAdDTO dto = new ProviderAppAdDTO();
        dto.setMedium(search.getUserName());
        dto.setBd(search.getBd());
        List allAppkeys = this.providerFacadeIntegration.getProviderAppKeyList(dto);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("datetime", search.getDatetime());
        if (allAppkeys != null && !allAppkeys.isEmpty()) {
            param.put("appIds", allAppkeys);
        }
        if (search.getKeyWords() != null) {
            param.put("appId", search.getKeyWords());
        }
        List list = this.adProfitPositionExt.findProfitPositionByParam(param);
        List appKeyList = this.adProfitPositionExt.findProfitAppIdListByDate(search.getDatetime());
        String endTime = DateFormatUtil.getPastDate(search.getDatetime(), 1);
        String beginTime = DateFormatUtil.getPastDate(search.getDatetime(), 7);
        Map positionTotalVUMap = this.dataparkListToMapService.analysisAppBusinessProfitRangeTime(beginTime, endTime, appKeyList);
        List near7dayTotalActualProfitMap = this.adProfitPositionExt.findPositionTotalActualProfitByTime(beginTime, endTime);
        Map<String, Double> totalActualProfitMap = AdProfitMediaPositionServiceImpl.getNear7dayTotalActualProfitMap(near7dayTotalActualProfitMap);
        Map cvrContrast = this.dataparkListToMapService.analysisTicketByRangeTime(search.getDatetime(), appKeyList);
        Map appCountMapmap = this.dataparkListToMapService.getPositionCountMap(search.getDatetime());
        Map mediaMap = this.providerFacadeIntegration.findMediaAllToMap();
        Map<Object, Object> factorMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            PositionQualityFactorDto positionQualityFactorDto = new PositionQualityFactorDto();
            positionQualityFactorDto.setImportTime(search.getDatetime());
            factorMap = this.positionQualityFactorService.queryPositionQualityFactorMap(positionQualityFactorDto);
        }
        Map<String, Integer> incomeMap = this.getPositionIncome(search.getDatetime());
        ArrayList voList = Lists.newArrayList();
        AdProfitPositionVo vo = null;
        for (AdProfitPosition position : list) {
            vo = new AdProfitPositionVo();
            ProviderAppAdRO mediaMsgDto = (ProviderAppAdRO)mediaMap.get(position.getAppId());
            AppCount count = (AppCount)appCountMapmap.get(position.getPositionId());
            if (mediaMsgDto != null) {
                String appName = StringUtils.defaultString((String)mediaMsgDto.getAlias(), (String)mediaMsgDto.getAppName());
                vo.setAppName(appName);
            }
            if (count != null) {
                vo.setClickPv(count.getClickPv());
                vo.setIndexUv(count.getIndexUv());
                vo.setJoinRate(count.getJoinRate());
                vo.setClickRate(count.getClickRate());
            }
            vo.setPositionIncome(incomeMap.get(position.getPositionId()));
            BeanUtils.copyProperties((Object)position, (Object)vo);
            if (null == vo.getIndexUv() || 0 == vo.getIndexUv() || null == vo.getClickPv() || 0 == vo.getClickPv()) continue;
            if (vo.getPositionIncome() != null) {
                BigDecimal uvarpu = new BigDecimal((double)vo.getPositionIncome().intValue() / 1000.0 / (double)vo.getIndexUv().intValue()).setScale(2, RoundingMode.HALF_UP);
                vo.setUvArpu(Double.valueOf(uvarpu.doubleValue()));
            } else {
                vo.setUvArpu(Double.valueOf(0.0));
            }
            Double near7dayTotalActualProfit = totalActualProfitMap.get(position.getPositionId());
            Integer near7dayTotalVU = (Integer)positionTotalVUMap.get(position.getPositionId());
            if (near7dayTotalActualProfit != null && near7dayTotalActualProfit != 0.0 && near7dayTotalVU != null && near7dayTotalVU != 0) {
                vo.setNear7dayArpu(DoubleUtil.div(near7dayTotalActualProfit, near7dayTotalVU.doubleValue(), 2));
            } else {
                vo.setNear7dayArpu(Double.valueOf(0.0));
            }
            vo.setFactor((String)factorMap.get(position.getPositionId()));
            vo.setValidClickRateContrast((String)cvrContrast.get(position.getPositionId()));
            voList.add(vo);
        }
        if (StringUtil.isNotBlank((String)search.getOrderParam()) && StringUtil.isNotBlank((String)search.getOrderType())) {
            ListOrderUtils.sortList(voList, search.getOrderParam(), search.getOrderType());
        } else {
            ListOrderUtils.sortList(voList, "indexUv", "DESC");
        }
        return voList;
    }

    @Override
    public List<String> findOnlyAppkeys(String mediumName) {
        HashMap map = Maps.newHashMap();
        map.put("roleCode", mediumName);
        ProviderAppAdDTO providerAppAdDto = new ProviderAppAdDTO();
        providerAppAdDto.setMedium(mediumName);
        List allAppkeys = this.providerFacadeIntegration.getProviderAppKeyList(providerAppAdDto);
        return allAppkeys;
    }

    @Override
    public PageInfo<PositionDefaultPercentVo> findDefaultPercent(User user, String appkeyName, String positionName, Integer pageNum, Integer pageSize) throws Exception {
        String name = null;
        if (user.getRoleCodes() != null && !user.getRoleCodes().contains(RoleEnum.MJLEADER.getCode()) && user.getRoleCodes().contains(RoleEnum.MJ.getCode())) {
            name = user.getUsername();
        }
        QueryAppEntranceParamDTO dto = new QueryAppEntranceParamDTO();
        dto.setFuzzyProviderName(appkeyName);
        dto.setKeywords(positionName);
        dto.setMjCode(name);
        dto.setPageNum(pageNum);
        dto.setPageSize(pageSize);
        PageInfo page = this.newAppEntranceFacadeIntegration.getPage(dto);
        List resultList = page.getList();
        ArrayList<PositionDefaultPercentVo> list = new ArrayList<PositionDefaultPercentVo>();
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return new PageInfo();
        }
        for (AppEntranceAdRO appEntranceAdRo : resultList) {
            PositionDefaultPercentVo positionDefaultPercentVo = new PositionDefaultPercentVo();
            positionDefaultPercentVo.setPositionId(appEntranceAdRo.getPositionId());
            positionDefaultPercentVo.setAppkey(appEntranceAdRo.getAppKey());
            positionDefaultPercentVo.setAppName(appEntranceAdRo.getProviderAlias());
            positionDefaultPercentVo.setPositionName(appEntranceAdRo.getAppEntranceName());
            PositionDefaultPercent positionDefaultPercent = this.positionDefaultPercentMapper.findByPositionId(appEntranceAdRo.getPositionId());
            if (null == positionDefaultPercent) {
                String time = "2018-12-03";
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                Date dateTime = format.parse(time);
                Date createTime = appEntranceAdRo.getCreatedTime();
                if (dateTime.getTime() > createTime.getTime()) {
                    positionDefaultPercentVo.setDefaultPercent("0%");
                } else {
                    positionDefaultPercentVo.setDefaultPercent("60%");
                }
            } else {
                positionDefaultPercentVo.setDefaultPercent(positionDefaultPercent.getDefaultPercent());
            }
            list.add(positionDefaultPercentVo);
        }
        PageInfo pageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)page, (Object)pageInfo);
        pageInfo.setList(list);
        return pageInfo;
    }

    @Override
    public List<PositionDefaultPercentVo> findPercentByPositionId(String positionIds) throws Exception {
        ArrayList resultList = Lists.newArrayList();
        if (StringUtils.isEmpty((CharSequence)positionIds) || "[]".equals(positionIds)) {
            return resultList;
        }
        String time = "2018-12-03";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date dateTime = format.parse(time);
        List list = JSON.parseArray((String)positionIds, String.class);
        List result = this.positionDefaultPercentMapper.findByPositionIds(list);
        List appEntranceAdROS = this.newAppEntranceFacadeIntegration.findListByPositionIds(list);
        Map appEntranceAdROMap = appEntranceAdROS.stream().collect(HashMap::new, (k, v) -> k.put(v.getPositionId(), v), HashMap::putAll);
        if (CollectionUtils.isEmpty((Collection)result)) {
            for (String positionId : list) {
                AppEntranceAdRO appEntranceAdRO = (AppEntranceAdRO)appEntranceAdROMap.get(positionId);
                if (null == appEntranceAdRO) {
                    PositionDefaultPercentVo positionDefaultPercentVo = new PositionDefaultPercentVo();
                    positionDefaultPercentVo.setPositionId(positionId);
                    positionDefaultPercentVo.setDefaultPercent("0%");
                    resultList.add(positionDefaultPercentVo);
                    continue;
                }
                Date createTime = appEntranceAdRO.getCreatedTime();
                PositionDefaultPercentVo positionDefaultPercentVo = new PositionDefaultPercentVo();
                if (dateTime.getTime() > createTime.getTime()) {
                    positionDefaultPercentVo.setPositionId(positionId);
                    positionDefaultPercentVo.setDefaultPercent("0%");
                    resultList.add(positionDefaultPercentVo);
                    continue;
                }
                positionDefaultPercentVo.setPositionId(positionId);
                positionDefaultPercentVo.setDefaultPercent("60%");
                resultList.add(positionDefaultPercentVo);
            }
        } else {
            for (PositionDefaultPercent positionDefaultPercent : result) {
                PositionDefaultPercentVo positionDefaultPercentVo = new PositionDefaultPercentVo();
                positionDefaultPercentVo.setPositionId(positionDefaultPercent.getPositionId());
                positionDefaultPercentVo.setDefaultPercent(positionDefaultPercent.getDefaultPercent());
                resultList.add(positionDefaultPercentVo);
            }
            Map<String, String> mapTemp = resultList.stream().collect(Collectors.toMap(PositionDefaultPercentVo::getPositionId, PositionDefaultPercent::getDefaultPercent));
            for (String positionId : list) {
                if (null != mapTemp.get(positionId)) continue;
                PositionDefaultPercentVo positionDefaultPercentVo = new PositionDefaultPercentVo();
                positionDefaultPercentVo.setPositionId(positionId);
                AppEntranceAdRO appEntranceAdRO = (AppEntranceAdRO)appEntranceAdROMap.get(positionId);
                if (null == appEntranceAdRO) {
                    PositionDefaultPercentVo positionDefaultPercentVo2 = new PositionDefaultPercentVo();
                    positionDefaultPercentVo2.setPositionId(positionId);
                    positionDefaultPercentVo2.setDefaultPercent("0%");
                    resultList.add(positionDefaultPercentVo2);
                    continue;
                }
                Date createTime = appEntranceAdRO.getCreatedTime();
                if (dateTime.getTime() > createTime.getTime()) {
                    positionDefaultPercentVo.setDefaultPercent("0%");
                    resultList.add(positionDefaultPercentVo);
                    continue;
                }
                positionDefaultPercentVo.setDefaultPercent("60%");
                resultList.add(positionDefaultPercentVo);
            }
        }
        return resultList;
    }

    @Override
    public Boolean updatePercentByPositionId(PositionDefaultPercent positionDefaultPercent) {
        if (null == positionDefaultPercent || StringUtils.isEmpty((CharSequence)positionDefaultPercent.getPositionId()) || StringUtils.isEmpty((CharSequence)positionDefaultPercent.getDefaultPercent())) {
            return false;
        }
        PositionDefaultPercent positionDefaultPercentTemp = this.positionDefaultPercentMapper.findByPositionId(positionDefaultPercent.getPositionId());
        if (null == positionDefaultPercentTemp) {
            positionDefaultPercent.setCreateTime(new Date());
            int num = this.positionDefaultPercentMapper.insert(positionDefaultPercent);
            return num == 1;
        }
        positionDefaultPercent.setUpdateTime(new Date());
        int num = this.positionDefaultPercentMapper.updateByPositionId(positionDefaultPercent);
        return num == 1;
    }

    private static Map<String, Double> getNear7dayTotalActualProfitMap(List<Map<String, Object>> param) throws Exception {
        HashMap<String, Double> result = new HashMap<String, Double>();
        if (!CollectionUtils.isEmpty(param)) {
            for (Map<String, Object> record : param) {
                result.put(String.valueOf(record.get("positionId")), Double.valueOf(String.valueOf(record.get("profitActual"))));
            }
        }
        return result;
    }
}

