/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adprofit.impl;

import com.bxm.adsmanager.dal.mapper.adprofit.DeveloperProfitMapper;
import com.bxm.adsmanager.ecxeption.ProfitException;
import com.bxm.adsmanager.integration.adsmedia.provider.ProviderFacadeIntegration;
import com.bxm.adsmanager.model.dto.adprofit.DeveloperProfitDto;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.model.vo.adprofit.DeveloperProfitVo;
import com.bxm.adsmanager.service.adprofit.DeveloperProfitService;
import com.bxm.adsmanager.service.adprofit.impl.DeveloperProfitServiceTemp;
import com.bxm.adsmanager.utils.ListOrderUtils;
import com.bxm.adsmanager.utils.ListUtil;
import com.bxm.adsmedia.facade.model.provider.ProviderAppAdRO;
import com.bxm.commons.currency.Money;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeveloperProfitServiceImpl
implements DeveloperProfitService {
    private static final Logger log = LoggerFactory.getLogger(DeveloperProfitServiceImpl.class);
    @Autowired
    private DeveloperProfitMapper developerProfitMapper;
    @Autowired
    private ProviderFacadeIntegration providerFacadeIntegration;
    @Autowired
    private DeveloperProfitServiceTemp developerProfitServiceTemp;

    @Override
    public DeveloperProfitVo getTotalProfit(DeveloperProfitDto search) {
        Map unUsettledProfit;
        String msg = this.checkParams(search);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            throw new ProfitException(msg);
        }
        DeveloperProfitVo settledProfit = this.developerProfitMapper.getTotalProfitFromMediaSettle(search);
        if (null == settledProfit) {
            settledProfit = new DeveloperProfitVo();
        }
        if (null != (unUsettledProfit = this.developerProfitMapper.getUnSettledProfit(search)) && !unUsettledProfit.isEmpty()) {
            Long unUsettled = Long.valueOf(null == unUsettledProfit.get("unSettledProfit") ? "0" : unUsettledProfit.get("unSettledProfit") + "");
            settledProfit.setUnSettledProfit(Double.valueOf(Money.ofLi((long)unUsettled).getYuan()));
            settledProfit.setTotalProfit(Double.valueOf(Money.ofLi((long)(unUsettled + settledProfit.getSettled_Profit() + settledProfit.getDeduct_Profit())).getYuan()));
        } else {
            settledProfit.setUnSettledProfit(Double.valueOf(0.0));
            settledProfit.setTotalProfit(Double.valueOf(Money.ofLi((long)(settledProfit.getSettled_Profit() + settledProfit.getDeduct_Profit())).getYuan()));
        }
        if (StringUtils.isNotBlank((CharSequence)search.getDateTime())) {
            settledProfit.setDateTime(search.getDateTime());
        }
        return settledProfit;
    }

    @Override
    public Pagination findProfitList(DeveloperProfitDto search) {
        String msg = this.checkParams(search);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            throw new ProfitException(msg);
        }
        Map<String, ProviderAppAdRO> providers = this.keywordConvertList(search);
        List profitVos = this.developerProfitMapper.findProfitListByPage(search);
        if (profitVos == null || profitVos.isEmpty()) {
            profitVos = Lists.newArrayList();
        }
        int totalCount = this.developerProfitMapper.getTotalCountOfDatetime(search);
        Pagination result = new Pagination();
        result.setList(profitVos);
        result.setPageSize(search.getPageSize());
        result.setPageNo(search.getPageNum());
        result.setTotalCount(totalCount);
        return result;
    }

    @Override
    public Pagination findProfitByDate(DeveloperProfitDto search) {
        if (StringUtils.isBlank((CharSequence)search.getDateTime())) {
            throw new ProfitException("\u67e5\u8be2\u65e5\u671f\u4e3a\u7a7a");
        }
        Map<String, ProviderAppAdRO> providers = this.keywordConvertList(search);
        Set<String> appIds = providers.keySet();
        List profitVos = this.developerProfitMapper.findProfitByDateByPage(search);
        if (null == profitVos) {
            profitVos = Lists.newArrayList();
        }
        List unSettledProfits = this.developerProfitMapper.findUnsettledProfits(search);
        Double unSettled = search.getUnSettledProfit();
        List<Object> result = Lists.newArrayList();
        if (null == unSettled && (null == unSettledProfits || unSettledProfits.size() == 0)) {
            for (DeveloperProfitVo profitVo : profitVos) {
                boolean flag = this.combineDeveloperInfo(profitVo, appIds, providers);
                if (!flag) continue;
                profitVo.setUnSettledProfit(Double.valueOf(0.0));
                result.add(profitVo);
            }
        }
        boolean flag = false;
        for (Map unSettledProfit : unSettledProfits) {
            boolean isExist = true;
            for (DeveloperProfitVo profitVo : profitVos) {
                if (profitVo.getAppId().equals(unSettledProfit.get("app_id").toString())) {
                    if (StringUtils.isBlank((CharSequence)profitVo.getAppName())) {
                        flag = this.combineDeveloperInfo(profitVo, appIds, providers);
                    }
                    profitVo.setUnSettledProfit(Double.valueOf(Money.ofLi((long)Long.parseLong(unSettledProfit.get("unSettledProfit") + "")).getYuan()));
                    isExist = false;
                    if (!result.contains(profitVo) && flag) {
                        result.add(profitVo);
                    }
                }
                if (null != unSettled) continue;
                if (StringUtils.isBlank((CharSequence)profitVo.getAppName())) {
                    flag = this.combineDeveloperInfo(profitVo, appIds, providers);
                }
                isExist = false;
                if (result.contains(profitVo) || !flag) continue;
                result.add(profitVo);
            }
            if (!isExist || null == unSettled) continue;
            DeveloperProfitVo profitVo = new DeveloperProfitVo();
            profitVo.setAppId(unSettledProfit.get("app_id").toString());
            profitVo.setUnSettledProfit(Double.valueOf(Money.ofLi((long)Long.parseLong(unSettledProfit.get("unSettledProfit") + "")).getYuan()));
            profitVo.setSettledProfit(Double.valueOf(0.0));
            profitVo.setDeductProfit(Double.valueOf(0.0));
            flag = this.combineDeveloperInfo(profitVo, appIds, providers);
            if (!flag) continue;
            result.add(profitVo);
        }
        int total = result.size();
        log.warn("findProfitByDate-->\u7ed3\u679c\u96c6\u5408\u603b\u6570total\uff1a" + total);
        if (null == unSettled) {
            ListOrderUtils.sortList(result, "settled_Profit", "DESC");
        } else {
            ListOrderUtils.sortList(result, "unSettledProfit", "DESC");
        }
        result = ListUtil.getTotalPage(result, total, search.getPageNum(), search.getPageSize());
        Pagination resultPage = new Pagination(search.getPageNum().intValue(), search.getPageSize().intValue(), total, result);
        return resultPage;
    }

    private boolean combineDeveloperInfo(DeveloperProfitVo profit, Set<String> appIds, Map<String, ProviderAppAdRO> providers) {
        boolean flag = false;
        for (String appId : appIds) {
            if (!profit.getAppId().equals(appId)) continue;
            profit.setAppName(providers.get(appId).getAlias() == null ? providers.get(appId).getAppName() : providers.get(appId).getAlias());
            profit.setAdvanceType((int)providers.get(appId).getAdvanceType().shortValue());
            if (1 == providers.get(appId).getAdvanceType()) {
                profit.setAdvanceTypeStr(DeveloperProfitVo.DeveloperAdvanceType.getName((int)1));
            } else if (0 == providers.get(appId).getAdvanceType()) {
                profit.setAdvanceTypeStr(DeveloperProfitVo.DeveloperAdvanceType.getName((int)0));
            }
            flag = true;
        }
        return flag;
    }

    @Override
    public Pagination findInfoForSettle(DeveloperProfitDto search) {
        if (StringUtils.isBlank((CharSequence)search.getDateTime())) {
            throw new ProfitException("\u67e5\u8be2\u65e5\u671f\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)search.getKeywords())) {
            throw new ProfitException("\u5f00\u53d1\u8005appkey\u4e3a\u7a7a");
        }
        search.setAdvanceType(null);
        Map<String, ProviderAppAdRO> providers = this.keywordConvertList(search);
        Set<String> appIds = providers.keySet();
        if (null == search.getKeywordList() || search.getKeywordList().size() == 0) {
            throw new ProfitException("\u5f00\u53d1\u8005appkey\u83b7\u53d6\u4e3a\u7a7a");
        }
        Integer pageSize = search.getPageSize();
        search.setPageSize(Integer.valueOf(0));
        List<DeveloperProfitVo> profitVos = this.developerProfitMapper.findInfoForSettle(search);
        int andvanceNum = 0;
        long totalProfit = 0L;
        for (DeveloperProfitVo profit : profitVos) {
            this.combineDeveloperInfo(profit, appIds, providers);
            profit.setUnSettledProfit(Double.valueOf(Money.ofLi((long)profit.getSettled_Profit()).getYuan()));
            totalProfit += profit.getSettled_Profit();
            if (profit.getAdvanceType() != 1) continue;
            ++andvanceNum;
        }
        int total = profitVos.size();
        log.warn("findInfoForSettle-->\u7ed3\u679c\u96c6\u5408\u603b\u6570total\uff1a" + total);
        search.setPageSize(pageSize);
        ListOrderUtils.sortList(profitVos, "unSettledProfit", "DESC");
        profitVos = ListUtil.getTotalPage(profitVos, total, search.getPageNum(), search.getPageSize());
        Pagination resultPage = new Pagination(search.getPageNum().intValue(), search.getPageSize().intValue(), total, profitVos);
        resultPage.setCondition((Object)Money.ofLi((long)totalProfit).getYuan());
        resultPage.setSort(Integer.valueOf(andvanceNum));
        return resultPage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int settleAccount(DeveloperProfitDto search, String username) {
        int result = 0;
        if (StringUtils.isBlank((CharSequence)search.getDateTime())) {
            throw new ProfitException("\u67e5\u8be2\u65e5\u671f\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)search.getKeywords())) {
            throw new ProfitException("\u5f00\u53d1\u8005appkey\u4e3a\u7a7a");
        }
        search.setPageSize(Integer.valueOf(0));
        List profitVos = this.developerProfitMapper.findInfoForSettle(search);
        if (null == profitVos || profitVos.size() == 0) {
            throw new ProfitException("\u5f00\u53d1\u8005\u53ef\u7ed3\u7b97\u91d1\u989d\u4fe1\u606f\u4e3a\u7a7a");
        }
        Double settledProfit = search.getSettledProfit();
        if (null != settledProfit) {
            long needSettle = Money.ofYuan((double)settledProfit).getLi();
            long hasSettle = ((DeveloperProfitVo)profitVos.get(0)).getSettled_Profit();
            if (needSettle < 0L || needSettle > hasSettle) throw new ProfitException("\u5355\u4e2a\u7ed3\u7b97-->\u7ed3\u7b97\u91d1\u989d\u6709\u8bef\u6216\u8d85\u51fa\u4e86\u53ef\u7ed3\u7b97\u91d1\u989d");
            try {
                int i = this.developerProfitServiceTemp.addSettleAndUpdateProfit(username, ((DeveloperProfitVo)profitVos.get(0)).getAppId(), needSettle, hasSettle, search.getDateTime(), search.getRemark());
                if (0 == i) {
                    log.error("\u5355\u4e2a\u7ed3\u7b97\u5931\u8d25\uff0c\u6570\u636e\u63a8\u9001\u6ca1\u6709\u6210\u529f");
                    throw new ProfitException("\u5355\u4e2a\u7ed3\u7b97\u5931\u8d25\uff0c\u6570\u636e\u63a8\u9001\u6ca1\u6709\u6210\u529f");
                }
                ++result;
                return result;
            }
            catch (Exception e) {
                log.error("\u5355\u4e2a\u7ed3\u7b97-->" + e.getMessage(), (Throwable)e);
                throw new ProfitException("\u5355\u4e2a\u7ed3\u7b97-->" + e.getMessage());
            }
        } else {
            for (DeveloperProfitVo profitVo : profitVos) {
                try {
                    int i = this.developerProfitServiceTemp.addSettleAndUpdateProfit(username, profitVo.getAppId(), profitVo.getSettled_Profit(), profitVo.getSettled_Profit(), search.getDateTime(), null);
                    if (0 == i) continue;
                    ++result;
                }
                catch (Exception e) {
                    log.error(profitVo.getAppId() + "\u6279\u91cf\u7ed3\u7b97\u51fa\u9519-->" + e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    private Map<String, ProviderAppAdRO> keywordConvertList(DeveloperProfitDto search) {
        Map result = null;
        if (StringUtils.isNotBlank((CharSequence)search.getKeywords())) {
            String[] keys = search.getKeywords().split(",");
            search.setKeywordList(Arrays.asList(keys));
        }
        try {
            result = this.providerFacadeIntegration.getListByAdvanceType(search.getAdvanceType(), search.getKeywords());
            if (null != search.getAdvanceType() && null != result) {
                List keywordList = search.getKeywordList();
                if (CollectionUtils.isEmpty((Collection)keywordList)) {
                    keywordList = Lists.newArrayList();
                }
                keywordList.addAll(result.keySet());
                search.setKeywordList(keywordList);
            }
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u5e10\u6237\u9884\u4ed8\u7c7b\u578b\u548cappkey\u83b7\u53d6\u5a92\u4f53\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        return result == null ? Maps.newHashMap() : result;
    }

    private String checkParams(DeveloperProfitDto search) {
        StringBuffer sb = new StringBuffer();
        if (StringUtils.isBlank((CharSequence)search.getDateTime())) {
            if (StringUtils.isBlank((CharSequence)search.getStartDate())) {
                sb.append("\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7a").append(",");
            }
            if (StringUtils.isBlank((CharSequence)search.getEndDate())) {
                sb.append("\u7ed3\u7b97\u65f6\u95f4\u4e3a\u7a7a").append(",");
            }
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }
}

