/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adprofit.impl;

import com.bxm.adsmanager.dal.mapper.adprofit.DeveloperProfitMapper;
import com.bxm.adsmanager.ecxeption.ProfitException;
import com.bxm.adsmanager.integration.config.WarnHelperConfig;
import com.bxm.adsmanager.model.dao.profit.ProfitMediaSettle;
import com.bxm.adsmanager.model.vo.adprofit.DeveloperSetletProfitVo;
import com.bxm.commons.currency.Money;
import com.bxm.profit.model.dto.IncomeLogDto;
import com.bxm.util.DateUtil;
import com.bxm.util.StringUtil;
import com.bxm.warcar.utils.WarnHelper;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeveloperProfitServiceTemp {
    private static final Logger LOG = LoggerFactory.getLogger(DeveloperProfitServiceTemp.class);
    @Autowired
    private DeveloperProfitMapper developerProfitMapper;
    @Autowired
    private WarnHelperConfig warnHelperConfig;

    @Transactional(rollbackFor={Exception.class, ProfitException.class}, timeout=30)
    public int addSettleAndUpdateProfit(String username, String appId, long needSettle, long hasSettle, String dateTime, String remark) {
        int result = 0;
        if (null == appId || null == username || null == dateTime) {
            throw new ProfitException("\u4fdd\u5b58\u7ed3\u7b97\u8bb0\u5f55\u53c2\u6570\u51fa\u9519");
        }
        HashMap params = Maps.newHashMap();
        params.put("username", username);
        params.put("appId", appId);
        params.put("needSettle", needSettle);
        params.put("deductSettle", hasSettle - needSettle);
        params.put("dateTime", dateTime);
        params.put("remark", null == remark ? "" : remark);
        params.put("nowDate", DateUtil.dateTo8String((Date)new Date()));
        LOG.info("\u6b63\u5728\u7ed3\u7b97\u7684\u53c2\u6570\uff1a" + ((Object)params).toString() + "-----------");
        List listDeveloperProfitVo = this.developerProfitMapper.findDeveloperProfitVoByParam((Map)params);
        if (CollectionUtils.isEmpty((Collection)listDeveloperProfitVo)) {
            WarnHelper.sendDDWarn((String)this.warnHelperConfig.getToken(), (String)("\u3010\u7ed3\u7b97\u5f02\u5e38\u3011\u6839\u636eappKey\u548c\u65f6\u95f4\u6ca1\u6709\u67e5\u5230\u672a\u8ba1\u7b97\u6536\u76caapp_key:" + appId + ":datetime:" + dateTime), (Boolean)false, null);
            throw new ProfitException("\u6839\u636eappKey\u548c\u65f6\u95f4\u6ca1\u6709\u67e5\u5230\u672a\u8ba1\u7b97\u6536\u76ca");
        }
        Double b = DeveloperProfitServiceTemp.formatDouble(needSettle + "", hasSettle + "");
        ArrayList<ProfitMediaSettle> rofitMediaSettleList = new ArrayList<ProfitMediaSettle>();
        ArrayList<IncomeLogDto> incomeLogDtoList = new ArrayList<IncomeLogDto>();
        for (DeveloperSetletProfitVo developerProfitVo : listDeveloperProfitVo) {
            Long cashMoney = new Double((double)developerProfitVo.getUnSettledProfit().longValue() * b).longValue();
            ProfitMediaSettle ps = new ProfitMediaSettle();
            ps.setCreateUser(username);
            ps.setDatetime(developerProfitVo.getDateTime());
            ps.setAppId(appId);
            ps.setProfitSettle(Integer.valueOf(cashMoney.intValue()));
            ps.setProfitDeduct(Integer.valueOf((int)(developerProfitVo.getUnSettledProfit() - cashMoney)));
            ps.setRemark(remark);
            IncomeLogDto incomeLogDto = new IncomeLogDto();
            incomeLogDto.setAppKey(appId);
            incomeLogDto.setAccount("0");
            incomeLogDto.setProductId(Integer.valueOf(4));
            incomeLogDto.setOrderNumber(System.currentTimeMillis() + "");
            incomeLogDto.setOrderTime(DateUtil.StringToDate((String)developerProfitVo.getDateTime()));
            incomeLogDto.setBxmIncome(BigDecimal.valueOf(0L));
            incomeLogDto.setIncome(BigDecimal.valueOf(Money.ofLi((long)cashMoney).getYuan()));
            incomeLogDto.setPrepareIncome(BigDecimal.valueOf(0L));
            incomeLogDto.setOrderAmount(BigDecimal.valueOf(Money.ofLi((long)developerProfitVo.getUnSettledProfit()).getYuan()));
            IncomeLogDto incomeLogDto1 = new IncomeLogDto();
            BeanUtils.copyProperties((Object)incomeLogDto, (Object)incomeLogDto1);
            incomeLogDto1.setIncome(BigDecimal.valueOf(0L));
            incomeLogDto1.setPrepareIncome(BigDecimal.valueOf(Money.ofLi((long)developerProfitVo.getUnSettledProfit()).getYuan() * -1.0));
            incomeLogDto1.setOrderAmount(BigDecimal.valueOf(Money.ofLi((long)developerProfitVo.getUnSettledProfit()).getYuan()));
            incomeLogDtoList.add(incomeLogDto);
            incomeLogDtoList.add(incomeLogDto1);
            rofitMediaSettleList.add(ps);
        }
        result = this.developerProfitMapper.batchinsertSettledInfo(rofitMediaSettleList);
        if (result != listDeveloperProfitVo.size()) {
            WarnHelper.sendDDWarn((String)this.warnHelperConfig.getToken(), (String)("\u3010\u7ed3\u7b97\u5f02\u5e38\u3011\u65b0\u589e\u5f00\u53d1\u8005\u7ed3\u7b97\u8bb0\u5f55\u5931\u8d25app_key:" + appId), (Boolean)false, null);
            throw new ProfitException("\u65b0\u589e\u5f00\u53d1\u8005\u7ed3\u7b97\u8bb0\u5f55\u5931\u8d25");
        }
        LOG.info("\u65b0\u589e\u5f00\u53d1\u8005\u7ed3\u7b97\u8bb0\u5f55app_id:" + appId + ",\u7ed3\u7b97\u91d1\u989dneedSettle\uff1a" + needSettle + "-----------");
        result = this.developerProfitMapper.updateProfitInfo((Map)params);
        if (result == 0) {
            WarnHelper.sendDDWarn((String)this.warnHelperConfig.getToken(), (String)("\u3010\u7ed3\u7b97\u5f02\u5e38\u3011\u4fee\u6539\u5f00\u53d1\u8005\u6536\u76ca\u8bb0\u5f55\u8868\u5931\u8d25app_key:" + appId), (Boolean)false, null);
            throw new ProfitException("\u4fee\u6539\u5f00\u53d1\u8005\u6536\u76ca\u8bb0\u5f55\u8868\u5931\u8d25");
        }
        LOG.info("\u4fee\u6539\u5f00\u53d1\u8005\u6536\u76ca\u8bb0\u5f55\u8868app_id:" + appId + ",\u53ef\u7ed3\u7b97\u91d1\u989dhasSettle\uff1a" + hasSettle + "-----------");
        try {
            Boolean flag = null;
            if (null == flag || !flag.booleanValue()) {
                WarnHelper.sendDDWarn((String)this.warnHelperConfig.getToken(), (String)("\u3010\u7ed3\u7b97\u5f02\u5e38\u3011\u6570\u636e\u63a8\u9001-->\u65b0\u589e\u5b9e\u9645\u6536\u76ca\u8bb0\u5f55\u5931\u8d25app_key:" + appId), (Boolean)false, null);
                throw new ProfitException("\u6570\u636e\u63a8\u9001-->\u65b0\u589e\u5b9e\u9645\u6536\u76ca\u8bb0\u5f55\u5931\u8d25");
            }
            LOG.info("\u5916\u90e8\u63a5\u53e3\u8c03\u7528\u6279\u91cf\u65b0\u589e\u5b9e\u9645\u6536\u76ca\u8bb0\u5f55app_id:" + appId + ",\u7ed3\u7b97\u622a\u6b62\u65e5dateTime\uff1a" + dateTime + "-----------");
        }
        catch (Exception e) {
            WarnHelper.sendDDWarn((String)this.warnHelperConfig.getToken(), (String)("\u3010\u7ed3\u7b97\u5f02\u5e38\u3011\u6279\u91cf\u65b0\u589e\u5b9e\u9645\u6536\u76ca\u8bb0\u5f55\u5f02\u5e38app_key:" + appId), (Boolean)false, null);
            throw new ProfitException("\u65b0\u589e\u6536\u76ca\u8bb0\u5f55\u5f02\u5e38");
        }
        return result;
    }

    public static Double formatDouble(String num1, String num2) {
        if (StringUtils.isBlank((String)num1) || StringUtils.isBlank((String)num2)) {
            return null;
        }
        if (!StringUtil.isPositiveNumber((String)num1) || !StringUtil.isPositiveNumber((String)num2)) {
            return null;
        }
        BigDecimal b1 = new BigDecimal(Double.valueOf(num1));
        BigDecimal b2 = new BigDecimal(Double.valueOf(num2));
        double num = 0.0;
        num = b1.divide(b2, 2, 1).doubleValue();
        return num;
    }
}

