/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adprofit.impl;

import com.bxm.adsmanager.dal.mapper.adprofit.DeveloperProfitMapper;
import com.bxm.adsmanager.ecxeption.ProfitException;
import com.bxm.adsmanager.integration.config.WarnHelperConfig;
import com.bxm.commons.currency.Money;
import com.bxm.profit.model.dto.IncomeLogDto;
import com.bxm.util.DateUtil;
import com.bxm.warcar.utils.WarnHelper;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeveloperProfitServiceTempbak {
    private static final Logger LOG = LoggerFactory.getLogger(DeveloperProfitServiceTempbak.class);
    @Autowired
    private DeveloperProfitMapper developerProfitMapper;
    @Autowired
    private WarnHelperConfig warnHelperConfig;

    @Transactional(rollbackFor={Exception.class, ProfitException.class}, timeout=30)
    public int addSettleAndUpdateProfit(String username, String appId, long needSettle, long hasSettle, String dateTime, String remark) {
        Boolean flag;
        int result = 0;
        if (null == appId || null == username || null == dateTime) {
            throw new ProfitException("\u4fdd\u5b58\u7ed3\u7b97\u8bb0\u5f55\u53c2\u6570\u51fa\u9519");
        }
        HashMap params = Maps.newHashMap();
        params.put("username", username);
        params.put("appId", appId);
        params.put("needSettle", needSettle);
        params.put("deductSettle", hasSettle - needSettle);
        params.put("dateTime", dateTime);
        params.put("remark", null == remark ? "" : remark);
        params.put("nowDate", DateUtil.dateTo8String((Date)new Date()));
        LOG.info("\u6b63\u5728\u7ed3\u7b97\u7684\u53c2\u6570\uff1a" + ((Object)params).toString() + "-----------");
        result = this.developerProfitMapper.insertSettledInfo((Map)params);
        if (result == 0) {
            WarnHelper.sendDDWarn((String)this.warnHelperConfig.getToken(), (String)("\u3010\u7ed3\u7b97\u5f02\u5e38\u3011\u65b0\u589e\u5f00\u53d1\u8005\u7ed3\u7b97\u8bb0\u5f55\u5931\u8d25app_key:" + appId), (Boolean)false, null);
            throw new ProfitException("\u65b0\u589e\u5f00\u53d1\u8005\u7ed3\u7b97\u8bb0\u5f55\u5931\u8d25");
        }
        LOG.info("\u65b0\u589e\u5f00\u53d1\u8005\u7ed3\u7b97\u8bb0\u5f55app_id:" + appId + ",\u7ed3\u7b97\u91d1\u989dneedSettle\uff1a" + needSettle + "-----------");
        result = this.developerProfitMapper.updateProfitInfo((Map)params);
        if (result == 0) {
            WarnHelper.sendDDWarn((String)this.warnHelperConfig.getToken(), (String)("\u3010\u7ed3\u7b97\u5f02\u5e38\u3011\u4fee\u6539\u5f00\u53d1\u8005\u6536\u76ca\u8bb0\u5f55\u8868\u5931\u8d25app_key:" + appId), (Boolean)false, null);
            throw new ProfitException("\u4fee\u6539\u5f00\u53d1\u8005\u6536\u76ca\u8bb0\u5f55\u8868\u5931\u8d25");
        }
        LOG.info("\u4fee\u6539\u5f00\u53d1\u8005\u6536\u76ca\u8bb0\u5f55\u8868app_id:" + appId + ",\u53ef\u7ed3\u7b97\u91d1\u989dhasSettle\uff1a" + hasSettle + "-----------");
        IncomeLogDto incomeLogDto = new IncomeLogDto();
        incomeLogDto.setAppKey(appId);
        incomeLogDto.setAccount("0");
        incomeLogDto.setProductId(Integer.valueOf(4));
        incomeLogDto.setOrderNumber(System.currentTimeMillis() + "");
        incomeLogDto.setOrderTime(DateUtil.StringToDate((String)dateTime));
        incomeLogDto.setBxmIncome(BigDecimal.valueOf(0L));
        incomeLogDto.setIncome(BigDecimal.valueOf(Money.ofLi((long)needSettle).getYuan()));
        incomeLogDto.setPrepareIncome(BigDecimal.valueOf(0L));
        incomeLogDto.setOrderAmount(BigDecimal.valueOf(Money.ofLi((long)hasSettle).getYuan()));
        try {
            flag = null;
            if (null == flag || !flag.booleanValue()) {
                WarnHelper.sendDDWarn((String)this.warnHelperConfig.getToken(), (String)("\u3010\u7ed3\u7b97\u5f02\u5e38\u3011\u6570\u636e\u63a8\u9001-->\u65b0\u589e\u5b9e\u9645\u6536\u76ca\u8bb0\u5f55\u5931\u8d25app_key:" + appId), (Boolean)false, null);
                throw new ProfitException("\u6570\u636e\u63a8\u9001-->\u65b0\u589e\u5b9e\u9645\u6536\u76ca\u8bb0\u5f55\u5931\u8d25");
            }
            LOG.info("\u5916\u90e8\u63a5\u53e3\u8c03\u7528\u65b0\u589e\u5b9e\u9645\u6536\u76ca\u8bb0\u5f55app_id:" + appId + ",\u7ed3\u7b97\u622a\u6b62\u65e5dateTime\uff1a" + dateTime + "-----------");
        }
        catch (Exception e) {
            WarnHelper.sendDDWarn((String)this.warnHelperConfig.getToken(), (String)("\u3010\u7ed3\u7b97\u5f02\u5e38\u3011\u65b0\u589e\u5b9e\u9645\u6536\u76ca\u8bb0\u5f55\u5f02\u5e38app_key:" + appId), (Boolean)false, null);
            throw new ProfitException("\u65b0\u589e\u5b9e\u9645\u6536\u76ca\u8bb0\u5f55\u5f02\u5e38");
        }
        incomeLogDto.setIncome(BigDecimal.valueOf(0L));
        incomeLogDto.setPrepareIncome(BigDecimal.valueOf(Money.ofLi((long)hasSettle).getYuan() * -1.0));
        incomeLogDto.setOrderAmount(BigDecimal.valueOf(Money.ofLi((long)hasSettle).getYuan()));
        try {
            flag = null;
            if (null == flag || !flag.booleanValue()) {
                result = 0;
                LOG.error("\u6570\u636e\u63a8\u9001-->\u65b0\u589e\u9884\u4f30\u6536\u76ca\u8bb0\u5f55\u5931\u8d25app_key:" + appId);
                WarnHelper.sendDDWarn((String)this.warnHelperConfig.getToken(), (String)("\u3010\u7ed3\u7b97\u5f02\u5e38\u3011\u6570\u636e\u63a8\u9001-->\u65b0\u589e\u9884\u4f30\u6536\u76ca\u8bb0\u5f55\u5931\u8d25app_key:" + appId), (Boolean)false, null);
                params.put("errorMsg", "\u6570\u636e\u63a8\u9001-->\u65b0\u589e\u9884\u4f30\u6536\u76ca\u8bb0\u5f55\u5931\u8d25");
                this.developerProfitMapper.updateErrorMsg((Map)params);
                LOG.error("\u6570\u636e\u63a8\u9001\u5931\u8d25-->\u4fee\u6539\u8868tbl_ad_profit_media_settle\u5931\u8d25\u8bb0\u5f55upload_msg__settle\uff0capp_key=" + appId);
            }
            LOG.info("\u5916\u90e8\u63a5\u53e3\u8c03\u7528\u65b0\u589e\u9884\u4f30\u6536\u76ca\u8bb0\u5f55app_id:" + appId + ",OrderAmount\uff1a" + incomeLogDto.getOrderAmount() + "-----------");
        }
        catch (Exception e) {
            result = 0;
            LOG.error("\u6570\u636e\u63a8\u9001-->\u65b0\u589e\u9884\u4f30\u6536\u76ca\u8bb0\u5f55\u5f02\u5e38app_key:" + appId, (Throwable)e);
            WarnHelper.sendDDWarn((String)this.warnHelperConfig.getToken(), (String)("\u3010\u7ed3\u7b97\u5f02\u5e38\u3011\u6570\u636e\u63a8\u9001-->\u65b0\u589e\u9884\u4f30\u6536\u76ca\u8bb0\u5f55\u5f02\u5e38app_key:" + appId), (Boolean)false, null);
            params.put("errorMsg", "\u8fdc\u7a0b\u8c03\u7528-->\u65b0\u589e\u9884\u4f30\u6536\u76ca\u8bb0\u5f55\u5931\u8d25");
            this.developerProfitMapper.updateErrorMsg((Map)params);
            LOG.error("\u6570\u636e\u63a8\u9001\u5f02\u5e38-->\u4fee\u6539\u8868tbl_ad_profit_media_settle\u5931\u8d25\u8bb0\u5f55upload_msg__settle\uff0capp_key=" + appId);
        }
        return result;
    }
}

