/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adsmedia.impl;

import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.integration.adsmedia.provider.ProviderFinanceFacadeIntegration;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.service.adsmedia.ProviderFinanceService;
import com.bxm.adsmanager.service.common.DictionariesService;
import com.bxm.adsmedia.facade.model.provider.FirstProviderAuditDto;
import com.bxm.adsmedia.facade.model.provider.ProviderFinanceListRO;
import com.bxm.adsmedia.facade.model.provider.ProviderStatusListRO;
import com.github.pagehelper.PageInfo;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProviderFinanceServiceImpl
implements ProviderFinanceService {
    private static final Logger log = LoggerFactory.getLogger(ProviderFinanceServiceImpl.class);
    @Autowired
    private ProviderFinanceFacadeIntegration providerFinanceFacadeIntegration;
    @Autowired
    private DictionariesService dictionariesService;

    @Override
    public PageInfo<ProviderFinanceListRO> getAuditPage(boolean isFk, String keywords, String mjCode, String bdCode, long providerId, Byte status, Integer areaType, Integer pageNum, Integer pageSize) {
        PageInfo auditPage = this.providerFinanceFacadeIntegration.getAuditPage(keywords, mjCode, bdCode, providerId, status, areaType, pageNum, pageSize);
        if (!isFk && auditPage != null && auditPage.getList() != null) {
            auditPage.getList().stream().forEach(e -> {
                e.setPhoneNum("");
                e.setContacts("");
            });
        }
        return auditPage;
    }

    @Override
    public PageInfo<ProviderStatusListRO> getAuditStatusPage(User user, String providerName, String email, Byte financeStatus, Byte mediaStatus, Byte appEntranceStatus, String mjCode, String bdCode, Boolean isOrderByDateDesc, String code, Integer areaType, Integer pageNum, Integer pageSize) {
        PageInfo auditStatusPage = this.providerFinanceFacadeIntegration.getAuditStatusPage(providerName, email, financeStatus, mediaStatus, appEntranceStatus, mjCode, bdCode, isOrderByDateDesc, code, areaType, pageNum, pageSize);
        if (auditStatusPage.getList() != null) {
            boolean isEditTag = user.getRoleCodes().contains(RoleEnum.PING_TAI_YUN_YING_LEADER.getCode()) || user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode());
            boolean isEdit = user.getRoleCodes().contains(RoleEnum.MJLEADER.getCode()) || user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode());
            boolean isAudit = user.getRoleCodes().contains(RoleEnum.MJ.getCode()) || user.getRoleCodes().contains(RoleEnum.MJLEADER.getCode()) || user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode());
            Map<String, String> kfzbqMap = this.dictionariesService.getIdDetailMapByCode("KFZBQ");
            auditStatusPage.getList().stream().forEach(e -> {
                String tags = e.getTags();
                if (StringUtils.isNotBlank((CharSequence)tags)) {
                    String[] tagArray = tags.split(",");
                    StringBuilder tagNams = new StringBuilder();
                    for (String tagId : tagArray) {
                        String tagName = (String)kfzbqMap.get(tagId);
                        if (tagName == null) continue;
                        tagNams.append(tagName).append(",");
                    }
                    if (tagNams.length() > 0) {
                        tagNams.deleteCharAt(tagNams.length() - 1);
                    }
                    e.setTagNames(tagNams.toString());
                }
                e.setOperatorAudit(isAudit);
                e.setOperatorEdit(isEdit);
                e.setOperatorTag(isEditTag);
            });
        }
        return auditStatusPage;
    }

    @Override
    public Boolean audit(boolean isRiskController, Long providerId, Boolean auditPass, String refuseReason, String reviewRefuseIds, String modifier) {
        boolean result = this.providerFinanceFacadeIntegration.audit(isRiskController, providerId, auditPass, refuseReason, reviewRefuseIds, modifier);
        if (!result) {
            throw new BusinessException("\u5ba1\u6838\u5931\u8d25\uff01");
        }
        return true;
    }

    @Override
    public FirstProviderAuditDto firstAudit(Long providerId, Boolean auditPass, String modifier, boolean isRiskController) {
        FirstProviderAuditDto firstProviderAuditDto = this.providerFinanceFacadeIntegration.firstAudit(providerId, auditPass, modifier, isRiskController);
        if (firstProviderAuditDto == null) {
            throw new BusinessException("\u5ba1\u6838\u5931\u8d25\uff01");
        }
        return firstProviderAuditDto;
    }
}

