/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adticketgroup.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bxm.adsmanager.dal.mapper.adticketgroup.AppkeyGroupConfigMapper;
import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.model.dao.adticketgroup.AppkeyGroupConfig;
import com.bxm.adsmanager.model.enums.ProdServiceNameEnum;
import com.bxm.adsmanager.service.adticketgroup.AppkeyGroupService;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppkeyGroupServiceImpl
implements AppkeyGroupService {
    @Autowired
    AppkeyGroupConfigMapper appkeyGroupConfigMapper;
    @Autowired
    private ProdPusherIntegration prodPusher;

    @Override
    public AppkeyGroupConfig findByAppkey(String appKey) {
        return this.appkeyGroupConfigMapper.findByAppKey(appKey);
    }

    @Override
    public void saveOrUpdate(Long id, String groupIds, String appkey, String username) throws Exception {
        AppkeyGroupConfig appkeyGroupConfig;
        if (Objects.nonNull(id)) {
            appkeyGroupConfig = this.appkeyGroupConfigMapper.selectByPrimaryKey(id);
            appkeyGroupConfig.setModifyTime(new Date());
            appkeyGroupConfig.setModifyUser(username);
            appkeyGroupConfig.setGroupIds(groupIds);
            this.appkeyGroupConfigMapper.updateByPrimaryKeySelective(appkeyGroupConfig);
        } else {
            appkeyGroupConfig = new AppkeyGroupConfig();
            appkeyGroupConfig.setCreateTime(new Date());
            appkeyGroupConfig.setCreateUser(username);
            appkeyGroupConfig.setAppKey(appkey);
            appkeyGroupConfig.setGroupIds(groupIds);
            this.appkeyGroupConfigMapper.insertSelective(appkeyGroupConfig);
        }
        HashMap propMap = Maps.newHashMap();
        propMap.put("appkey", appkey);
        this.prodPusher.pushToProd(ProdServiceNameEnum.GROUP_APPKEY_TICKET.getServiceName(), (Map)propMap, JSONArray.toJSONBytes((Object)groupIds, (SerializerFeature[])new SerializerFeature[0]));
    }
}

