/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adticketgroup.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bxm.adsmanager.dal.mapper.adticketgroup.TicketGroupMapper;
import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.model.dao.adticketgroup.TicketGroup;
import com.bxm.adsmanager.model.dao.common.Dictionaries;
import com.bxm.adsmanager.model.enums.ProdServiceNameEnum;
import com.bxm.adsmanager.model.enums.TicketGroupStatusEnum;
import com.bxm.adsmanager.model.vo.adticketgroup.TicketGroupVo;
import com.bxm.adsmanager.model.vo.adticketgroup.TicketVo;
import com.bxm.adsmanager.service.adticketgroup.TicketGroupService;
import com.bxm.adsmanager.service.common.DictionariesService;
import com.bxm.adsprod.facade.ticket.TicketGroupPushVo;
import com.bxm.util.StringUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TicketGroupServiceImpl
implements TicketGroupService {
    @Autowired
    private TicketGroupMapper ticketGroupMapper;
    @Autowired
    private DictionariesService dictionariesService;
    @Autowired
    private ProdPusherIntegration prodPusher;

    @Override
    public PageInfo<TicketGroupVo> findTicketGroup(String keyword, Integer status, Integer pageNum, Integer pageSize, String sortName, String sortType) {
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("keyword", keyword);
        map.put("status", status);
        map.put("pageNum", pageNum);
        map.put("pageSize", pageSize);
        map.put("sortName", sortName);
        map.put("sortType", sortType);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List ticketGroups = this.ticketGroupMapper.findTicketGroup(map);
        PageInfo pageInfo = new PageInfo(ticketGroups);
        if (ticketGroups.isEmpty()) {
            return pageInfo;
        }
        ArrayList groupIds = new ArrayList();
        ticketGroups.forEach(ticketGroupVo -> {
            ticketGroupVo.setStatusShow(TicketGroupStatusEnum.getName((Integer)ticketGroupVo.getStatus()));
            ticketGroupVo.setOpenFrequencyStatus(ticketGroupVo.getOpenFrequency() != null);
            ticketGroupVo.setClickFrequencyStatus(ticketGroupVo.getClickFrequency() != null);
            ticketGroupVo.setIpOpenFrequencyStatus(ticketGroupVo.getIpOpenFrequency() != null);
            ticketGroupVo.setIpClickFrequencyStatus(ticketGroupVo.getIpClickFrequency() != null);
            groupIds.add(ticketGroupVo.getId());
        });
        List ticketCounts = this.ticketGroupMapper.findTicketCount(groupIds);
        if (!ticketCounts.isEmpty()) {
            HashMap mapTicketCount = new HashMap(ticketCounts.size());
            ticketCounts.forEach(ticketCount -> mapTicketCount.put(ticketCount.getId(), ticketCount.getTicketCount()));
            ticketGroups.forEach(ticketGroupVo -> ticketGroupVo.setTicketCount(mapTicketCount.getOrDefault(ticketGroupVo.getId(), 0)));
        }
        return pageInfo;
    }

    @Override
    public PageInfo<TicketGroupVo> findByIds(String groupIds, Integer pageNum, Integer pageSize, String keywords) {
        List<String> groupIdsList = Arrays.asList(groupIds.split(","));
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("groupIdsList", groupIdsList);
        map.put("keyword", keywords);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List ticketGroups = this.ticketGroupMapper.findTicketGroup(map);
        PageInfo pageInfo = new PageInfo(ticketGroups);
        if (ticketGroups.isEmpty()) {
            return pageInfo;
        }
        ArrayList resultgroupIdsList = new ArrayList();
        ticketGroups.forEach(ticketGroupVo -> {
            ticketGroupVo.setStatusShow(TicketGroupStatusEnum.getName((Integer)ticketGroupVo.getStatus()));
            ticketGroupVo.setOpenFrequencyStatus(ticketGroupVo.getOpenFrequency() != null);
            ticketGroupVo.setClickFrequencyStatus(ticketGroupVo.getClickFrequency() != null);
            ticketGroupVo.setIpOpenFrequencyStatus(ticketGroupVo.getIpOpenFrequency() != null);
            ticketGroupVo.setIpClickFrequencyStatus(ticketGroupVo.getIpClickFrequency() != null);
            resultgroupIdsList.add(ticketGroupVo.getId());
        });
        List ticketCounts = this.ticketGroupMapper.findTicketCount(resultgroupIdsList);
        if (!ticketCounts.isEmpty()) {
            HashMap mapTicketCount = new HashMap(ticketCounts.size());
            ticketCounts.forEach(ticketCount -> mapTicketCount.put(ticketCount.getId(), ticketCount.getTicketCount()));
            ticketGroups.forEach(ticketGroupVo -> ticketGroupVo.setTicketCount(mapTicketCount.getOrDefault(ticketGroupVo.getId(), 0)));
        }
        return pageInfo;
    }

    @Override
    public TicketGroupVo findTicketGroupById(Long id) {
        TicketGroupVo ticketGroupVo = new TicketGroupVo();
        HashMap<String, Long> map = new HashMap<String, Long>(1);
        map.put("id", id);
        List ticketGroups = this.ticketGroupMapper.findTicketGroup(map);
        if (ticketGroups.isEmpty()) {
            return ticketGroupVo;
        }
        ticketGroupVo = (TicketGroupVo)ticketGroups.get(0);
        ticketGroupVo.setStatusShow(TicketGroupStatusEnum.getName((Integer)ticketGroupVo.getStatus()));
        ticketGroupVo.setOpenFrequencyStatus(ticketGroupVo.getOpenFrequency() != null);
        ticketGroupVo.setClickFrequencyStatus(ticketGroupVo.getClickFrequency() != null);
        ticketGroupVo.setIpOpenFrequencyStatus(ticketGroupVo.getIpOpenFrequency() != null);
        ticketGroupVo.setIpClickFrequencyStatus(ticketGroupVo.getIpClickFrequency() != null);
        HashMap<String, Object> mapTicket = new HashMap<String, Object>();
        mapTicket.put("groupId", ticketGroupVo.getId());
        mapTicket.put("type", "inlink");
        List tickets = this.ticketGroupMapper.findTicket(mapTicket);
        ArrayList ticketIds = new ArrayList();
        if (!tickets.isEmpty()) {
            tickets.forEach(ticket -> ticketIds.add(ticket.getId()));
        }
        ticketGroupVo.setTicketCount(Integer.valueOf(tickets.size()));
        ticketGroupVo.setTicketIdArray(JSON.toJSONString(ticketIds));
        return ticketGroupVo;
    }

    @Override
    public PageInfo<TicketVo> findTicket(Long groupId, String keyword, List<Long> ticketIds, String type, Integer pageNum, Integer pageSize) {
        HashMap<String, Object> mapTicket = new HashMap<String, Object>();
        mapTicket.put("groupId", groupId);
        mapTicket.put("keyword", keyword);
        mapTicket.put("ticketIds", ticketIds);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        mapTicket.put("type", type);
        List tickets = this.ticketGroupMapper.findTicket(mapTicket);
        this.dealDomain(tickets);
        return new PageInfo(tickets);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public synchronized void saveOrUpdateTicketGroup(TicketGroupVo ticketGroupvo, List<Long> ticketIds, String userName) throws Exception {
        if (!ticketGroupvo.isOpenFrequencyStatus()) {
            ticketGroupvo.setOpenFrequency(null);
            ticketGroupvo.setOpenFrequencyNum(null);
        }
        if (!ticketGroupvo.isClickFrequencyStatus()) {
            ticketGroupvo.setClickFrequency(null);
            ticketGroupvo.setClickFrequencyNum(null);
        }
        if (!ticketGroupvo.isIpOpenFrequencyStatus()) {
            ticketGroupvo.setIpOpenFrequency(null);
            ticketGroupvo.setIpOpenFrequencyNum(null);
        }
        if (!ticketGroupvo.isIpClickFrequencyStatus()) {
            ticketGroupvo.setIpClickFrequency(null);
            ticketGroupvo.setIpClickFrequencyNum(null);
        }
        ticketGroupvo.setModifyUser(userName);
        if (ticketGroupvo.getId() != null) {
            this.ticketGroupMapper.updateTicketGroup((TicketGroup)ticketGroupvo);
        } else {
            ticketGroupvo.setCreateUser(userName);
            this.ticketGroupMapper.insertTicketGroup((TicketGroup)ticketGroupvo);
        }
        if (CollectionUtils.isNotEmpty(ticketIds)) {
            this.ticketGroupMapper.dealTicketGroup(ticketGroupvo.getId(), ticketIds);
        }
        this.pushTicketGroup(ticketGroupvo.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public synchronized boolean deleteTicketGroup(Long id, String userName) throws Exception {
        TicketGroupVo ticketGroup = this.findTicketGroupById(id);
        if (TicketGroupStatusEnum.ON.getCode().equals(ticketGroup.getStatus())) {
            return false;
        }
        ticketGroup = new TicketGroupVo();
        ticketGroup.setModifyUser(userName);
        ticketGroup.setId(id);
        ticketGroup.setIsDelete(new Timestamp(System.currentTimeMillis()));
        this.ticketGroupMapper.updateTicketGroupSelective((TicketGroup)ticketGroup);
        this.ticketGroupMapper.dealTicketGroup(id, new ArrayList());
        this.pushTicketGroup(id);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public synchronized void changeTicketStatus(Long id, Integer status, String userName) throws Exception {
        TicketGroupVo ticketGroup = new TicketGroupVo();
        ticketGroup.setModifyUser(userName);
        ticketGroup.setId(id);
        ticketGroup.setStatus(status);
        this.ticketGroupMapper.updateTicketGroupSelective((TicketGroup)ticketGroup);
        this.pushTicketGroup(id);
    }

    private void dealDomain(List<TicketVo> tickets) {
        List<Dictionaries> domainNames;
        if (!tickets.isEmpty() && CollectionUtils.isNotEmpty(domainNames = this.dictionariesService.findAll("shopstype"))) {
            HashMap mapDomainName = new HashMap(domainNames.size());
            domainNames.forEach(domainName -> mapDomainName.put(domainName.getTypecode(), domainName.getTypename()));
            tickets.forEach(ticket -> ticket.setDomainName((String)mapDomainName.getOrDefault(ticket.getDomainCode(), null)));
        }
    }

    @Override
    public void pushTicketGroup(Long groupId) throws Exception {
        if (groupId == null) {
            return;
        }
        TicketGroupVo ticketGroup = this.findTicketGroupById(groupId);
        TicketGroupPushVo ticketGroupPushVo = new TicketGroupPushVo();
        if (ticketGroup != null) {
            ticketGroupPushVo.setClickFrequency(ticketGroup.getClickFrequency());
            ticketGroupPushVo.setClickFrequencyNum(ticketGroup.getClickFrequencyNum());
            ticketGroupPushVo.setOpenFrequency(ticketGroup.getOpenFrequency());
            ticketGroupPushVo.setOpenFrequencyNum(ticketGroup.getOpenFrequencyNum());
            ticketGroupPushVo.setIpClickFrequency(ticketGroup.getIpClickFrequency());
            ticketGroupPushVo.setIpClickFrequencyNum(ticketGroup.getIpClickFrequencyNum());
            ticketGroupPushVo.setIpOpenFrequency(ticketGroup.getIpOpenFrequency());
            ticketGroupPushVo.setIpOpenFrequencyNum(ticketGroup.getIpOpenFrequencyNum());
            ticketGroupPushVo.setStatus(ticketGroup.getStatus());
            String ticketIdArray = ticketGroup.getTicketIdArray();
            if (StringUtil.isNotEmpty((CharSequence)ticketIdArray)) {
                ticketGroupPushVo.setTicketIds(JSON.parseArray((String)ticketIdArray, Long.class));
            }
        }
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("groupid", groupId);
        this.prodPusher.pushToProd(ProdServiceNameEnum.TICKET_GROUP.getServiceName(), map, JSONArray.toJSONBytes((Object)ticketGroupPushVo, (SerializerFeature[])new SerializerFeature[0]));
    }
}

