/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adticketgroup.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bxm.adsmanager.dal.mapper.adticketgroup.TicketGroupWhiteMapper;
import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.model.dao.adticketgroup.TicketGroupWhite;
import com.bxm.adsmanager.model.enums.ProdServiceNameEnum;
import com.bxm.adsmanager.model.vo.adticketgroup.TicketGroupWhiteVo;
import com.bxm.adsmanager.service.adticketgroup.TicketGroupWhiteService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TicketGroupWhiteServiceImpl
implements TicketGroupWhiteService {
    @Resource
    TicketGroupWhiteMapper ticketGroupWhiteMapper;
    @Autowired
    private ProdPusherIntegration prodPusher;

    @Override
    public PageInfo<TicketGroupWhiteVo> findWhiteGroup(String keywords, Integer isShare, Integer pageNum, Integer pageSize) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("keywords", keywords);
        map.put("isShare", isShare);
        map.put("pageNum", pageNum);
        map.put("pageSize", pageSize);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List list = this.ticketGroupWhiteMapper.findTicketGroup(map);
        PageInfo pageInfo = new PageInfo(list);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return pageInfo;
        }
        return pageInfo;
    }

    @Override
    public PageInfo<TicketGroupWhiteVo> findByIds(String groupIds, Integer pageNum, Integer pageSize, String keywords) {
        List<String> groupIdsList = Arrays.asList(groupIds.split(","));
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("groupIdsList", groupIdsList);
        map.put("keywords", keywords);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List list = this.ticketGroupWhiteMapper.findTicketGroup(map);
        PageInfo pageInfo = new PageInfo(list);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return pageInfo;
        }
        return pageInfo;
    }

    @Override
    public void saveOrUpdate(TicketGroupWhiteVo ticketGroupWhiteVo, String username) throws Exception {
        TicketGroupWhite ticketGroupWhite = new TicketGroupWhite();
        List<String> ticketIdsList = Arrays.asList(ticketGroupWhiteVo.getTicketIds().split(","));
        BeanUtils.copyProperties((Object)ticketGroupWhiteVo, (Object)ticketGroupWhite);
        ticketGroupWhite.setTicketCount(Integer.valueOf(ticketIdsList.size()));
        if (ticketGroupWhiteVo.getId() != null) {
            ticketGroupWhite.setModifyUser(username);
            ticketGroupWhite.setModifyTime(new Date());
            this.ticketGroupWhiteMapper.updateByPrimaryKeySelective(ticketGroupWhite);
        } else {
            ticketGroupWhite.setCreateUser(username);
            ticketGroupWhite.setCreateTime(new Date());
            this.ticketGroupWhiteMapper.insertSelective(ticketGroupWhite);
        }
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("groupid", ticketGroupWhite.getId());
        this.prodPusher.pushToProd(ProdServiceNameEnum.TICKET_GROUP_WHITE.getServiceName(), map, JSONArray.toJSONBytes((Object)ticketGroupWhite.getTicketIds(), (SerializerFeature[])new SerializerFeature[0]));
    }

    @Override
    public void delete(String ids, String username) throws Exception {
        List<String> idList = Arrays.asList(ids.split(","));
        for (String id : idList) {
            TicketGroupWhite ticketGroupWhite = new TicketGroupWhite();
            ticketGroupWhite.setId(Long.valueOf(id));
            ticketGroupWhite.setIsDelete(Short.valueOf((short)1));
            this.ticketGroupWhiteMapper.updateByPrimaryKeySelective(ticketGroupWhite);
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("groupid", ticketGroupWhite.getId());
            this.prodPusher.pushToProd(ProdServiceNameEnum.TICKET_GROUP_WHITE.getServiceName(), map, null);
        }
    }
}

