/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.advertiser.impl;

import com.bxm.adsmanager.dal.mapper.advertiser.TblAdQualifyMapper;
import com.bxm.adsmanager.dal.mapper.advertiser.ext.TblAdQualifyMapperExt;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dao.advertiser.TblAdQualify;
import com.bxm.adsmanager.model.dto.TblAdQualifyDto;
import com.bxm.adsmanager.service.advertiser.AdvertiserQualifyService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdvertiserQualifyServiceImpl
implements AdvertiserQualifyService {
    private static final Logger log = LoggerFactory.getLogger(AdvertiserQualifyServiceImpl.class);
    @Autowired
    private TblAdQualifyMapper tblAdQualifyMapper;
    @Autowired
    private TblAdQualifyMapperExt tblAdQualifyMapperExt;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addAdvertiserQualifyBatch(List<TblAdQualify> list) throws Exception {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        TblAdQualify tblAdQualify = list.get(0);
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("content", tblAdQualify.getContent());
        map.put("advertiserId", tblAdQualify.getAdvertiserId());
        int count = this.tblAdQualifyMapper.countByParam(map);
        if (count > 0) {
            throw new BusinessException("\u8be5\u4ea7\u54c1\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u5982\u9700\u8865\u5145/\u4fee\u6539\u8d44\u8d28\u8bf7\u5728\u539f\u4ea7\u54c1\u540d\u79f0\u4e0b\u64cd\u4f5c");
        }
        this.tblAdQualifyMapperExt.insertAdQualifyBatch(list);
    }

    @Override
    public TblAdQualify getAdQualifyById(Integer id) throws Exception {
        return this.tblAdQualifyMapper.selectByPrimaryKey(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int updateAdQualifyById(TblAdQualify record) throws Exception {
        if (Objects.nonNull(record.getId())) {
            TblAdQualify tblAdQualify = this.tblAdQualifyMapperExt.selectByPrimaryKey(record.getId());
            if (Objects.isNull(tblAdQualify)) {
                return 0;
            }
            Long advertiserId = tblAdQualify.getAdvertiserId();
            if (Objects.nonNull(record.getContent())) {
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                map.put("neId", record.getId());
                map.put("content", record.getContent());
                map.put("advertiserId", advertiserId);
                int count = this.tblAdQualifyMapper.countByParam(map);
                if (count > 0) {
                    throw new BusinessException("\u8be5\u4ea7\u54c1\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u5982\u9700\u8865\u5145/\u4fee\u6539\u8d44\u8d28\u8bf7\u5728\u539f\u4ea7\u54c1\u540d\u79f0\u4e0b\u64cd\u4f5c");
                }
            }
        }
        return this.tblAdQualifyMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public PageInfo<TblAdQualify> getAdQualifyList(TblAdQualifyDto param) throws Exception {
        PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize());
        List qualifyList = this.tblAdQualifyMapperExt.queryAdQualifyList(param);
        PageInfo pageInfo = new PageInfo(qualifyList);
        return pageInfo;
    }

    @Override
    public long getAdQualifyCount(TblAdQualifyDto param) throws Exception {
        return this.tblAdQualifyMapperExt.queryAdQualifyCount(param);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateAuditStatusByIds(List<Integer> list) throws Exception {
        this.tblAdQualifyMapperExt.updateAuditStatusByIds(list);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateAuditStatusBatch(List<TblAdQualify> list) throws Exception {
        this.tblAdQualifyMapperExt.updateAuditStatusBatch(list);
    }
}

