/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.advertiser.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.dal.mapper.adflowpackage.AdFlowPackageMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdTicketMapperExt;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdTicketWeightManualConfMapperExt;
import com.bxm.adsmanager.dal.mapper.advertiser.ext.TblStationUserWeightMapperExt;
import com.bxm.adsmanager.dal.mapper.mediamanager.ext.AdTicketPositionWeightMapperExt;
import com.bxm.adsmanager.dal.mapper.tbltag.ext.TblAdPostionTagMapperExt;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.model.dao.adflowpackage.AdFlowPackage;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketWeightManualConf;
import com.bxm.adsmanager.model.dao.advertiser.TblStationUserWeight;
import com.bxm.adsmanager.model.dao.mediamanager.AdTicketPositionWeight;
import com.bxm.adsmanager.model.dto.advertiser.UpdateStationUserWeightDTO;
import com.bxm.adsmanager.model.enums.ProdServiceNameEnum;
import com.bxm.adsmanager.model.vo.advertiser.TblStationUserWeightDetailVO;
import com.bxm.adsmanager.model.vo.advertiser.TblStationUserWeightVO;
import com.bxm.adsmanager.model.vo.tbltag.TblAdTagVo;
import com.bxm.adsmanager.redis.RedisNewClient;
import com.bxm.adsmanager.service.advertiser.TblStationUserWeightService;
import com.bxm.adsmanager.service.advertiser.context.StationUserWeightContext;
import com.bxm.adsmanager.service.advertiser.context.StationUserWeightOperationParams;
import com.bxm.adsmanager.utils.DingtalkMsgUtil;
import com.bxm.adsmanager.utils.PageInfoFactory;
import com.bxm.adsprod.facade.advertiser.AdvertiserConstant;
import com.bxm.adsprod.facade.advertiser.StationUserWeightPushParam;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.StringHelper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class TblStationUserWeightServiceImpl
implements TblStationUserWeightService {
    private static final Logger log = LoggerFactory.getLogger(TblStationUserWeightServiceImpl.class);
    private static final String POSITION_WEIGHT_KEY = "AD:WEIGHT:POSITION_MIF:";
    private static final String DING_TALK_URL = "https://oapi.dingtalk.com/robot/send?access_token=ef60c4cae6387ad2106d070803d6ca3ecb44de5ffec02b167f730c55ea6bbff3";
    private static final Integer POSITION_WEIGHT_NOTICE_SIZE = 500;
    @Autowired
    private TblStationUserWeightMapperExt tblStationUserWeightMapperExt;
    @Autowired
    private RedisNewClient redisNewClient;
    @Autowired
    private AdShopIntegration adShopIntegration;
    @Autowired
    private AdTicketMapperExt adTicketMapperExt;
    @Autowired
    private AdTicketMapper adTicketMapper;
    @Autowired
    private AdFlowPackageMapper adFlowPackageMapper;
    @Autowired
    private AdTicketPositionWeightMapperExt adTicketPositionWeightMapperExt;
    @Autowired
    private AdTicketWeightManualConfMapperExt adTicketWeightManualConfMapperExt;
    @Autowired
    private ProdPusherIntegration prodPusherIntegration;
    @Autowired
    private TblAdPostionTagMapperExt tblAdPostionTagMapperExt;
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;

    @Override
    public PageInfo<TblStationUserWeightVO> getPage(String advertiserNameOrId, String saleCode, Integer pageNum, Integer pageSize) {
        Map advertiserNameMap;
        HashMap onLevelCodeNameMap;
        PageInfo stationUserWeightVOPageInfo;
        List stationUserWeightVOS;
        ArrayList advertiserIdsParam = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)advertiserNameOrId)) {
            if (StringUtils.isNumeric((CharSequence)advertiserNameOrId)) {
                advertiserIdsParam.add(Integer.valueOf(advertiserNameOrId));
            }
            try {
                List advertiserDtos = this.adShopIntegration.findAdShopMsgsByKeywords(advertiserNameOrId, null);
                if (CollectionUtils.isEmpty((Collection)advertiserDtos) && CollectionUtils.isEmpty((Collection)advertiserIdsParam)) {
                    return PageInfoFactory.noData();
                }
                advertiserIdsParam.addAll(advertiserDtos.stream().map(AdvertiserDto::getId).collect(Collectors.toList()));
            }
            catch (IOException e) {
                log.error("\u7ad9\u5185\u6237\u6743\u91cd\u8ba1\u5212\u67e5\u8be2\u5f02\u5e38\uff1a", (Throwable)e);
                return PageInfoFactory.noData();
            }
        }
        if (CollectionUtils.isEmpty((Collection)(stationUserWeightVOS = (stationUserWeightVOPageInfo = PageHelper.startPage((int)pageNum, (int)pageSize).doSelectPageInfo(() -> this.tblStationUserWeightMapperExt.getList(advertiserIdsParam, saleCode))).getList()))) {
            return PageInfoFactory.noData();
        }
        List tblAdTagVos = this.tblAdPostionTagMapperExt.findAllByCodes(stationUserWeightVOS.stream().map(TblStationUserWeightVO::getTicketTagCode).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty((Collection)tblAdTagVos)) {
            onLevelCodeNameMap = Collections.emptyMap();
        } else {
            onLevelCodeNameMap = Maps.newHashMapWithExpectedSize((int)tblAdTagVos.size());
            for (TblAdTagVo tblAdTagVo : tblAdTagVos) {
                int index = tblAdTagVo.getFullNameStr().indexOf(".");
                if (index > 0) {
                    onLevelCodeNameMap.put(tblAdTagVo.getCode(), tblAdTagVo.getFullNameStr().substring(0, index));
                    continue;
                }
                onLevelCodeNameMap.put(tblAdTagVo.getCode(), tblAdTagVo.getFullNameStr());
            }
        }
        List advertiserIds = stationUserWeightVOS.stream().map(TblStationUserWeightVO::getAdvertiserId).collect(Collectors.toList());
        try {
            List advertiserDtos = this.adShopIntegration.findAdShopMsgs(Joiner.on((String)",").skipNulls().join(advertiserIds));
            advertiserNameMap = CollectionUtils.isEmpty((Collection)advertiserDtos) ? Collections.emptyMap() : (Map)advertiserDtos.stream().collect(HashMap::new, (k, v) -> k.put(v.getId().longValue(), v.getCompany()), HashMap::putAll);
        }
        catch (IOException e) {
            log.error("\u7ad9\u5185\u6237\u6743\u91cd\u8ba1\u5212\u67e5\u8be2\u5f02\u5e38\uff1a", (Throwable)e);
            return PageInfoFactory.noData();
        }
        Map<Long, BigDecimal> consumeMap = this.getRealTimeConsume(stationUserWeightVOS.stream().mapToLong(TblStationUserWeightVO::getId).toArray());
        for (TblStationUserWeightVO vo : stationUserWeightVOS) {
            vo.setRealTimeConsume(consumeMap.getOrDefault(vo.getId(), BigDecimal.ZERO));
            vo.setTicketTagName(onLevelCodeNameMap.getOrDefault(vo.getTicketTagCode(), "?"));
            vo.setAdvertiserName((String)advertiserNameMap.get(vo.getAdvertiserId()));
        }
        return stationUserWeightVOPageInfo;
    }

    @Override
    public TblStationUserWeightDetailVO detail(Long stationUserWeightId) {
        TblStationUserWeight stationUserWeight = this.tblStationUserWeightMapperExt.selectByPrimaryKey(stationUserWeightId);
        if (null == stationUserWeight) {
            throw new BusinessException("\u6728\u6709\u67e5\u8be2\u5230\u7ad9\u5185\u6237\u6743\u91cd\u7684\u6570\u636e\uff01");
        }
        TblStationUserWeightDetailVO stationUserWeightDetailVO = new TblStationUserWeightDetailVO();
        AdvertiserDto advertiserDto = this.adShopIntegration.findAdShopMsg(stationUserWeight.getAdvertiserId().longValue());
        stationUserWeightDetailVO.setId(stationUserWeight.getId());
        stationUserWeightDetailVO.setAdvertiserId(stationUserWeight.getAdvertiserId());
        if (null != advertiserDto) {
            stationUserWeightDetailVO.setAdvertiserName(advertiserDto.getCompany());
        }
        stationUserWeightDetailVO.setTicketTagCode(stationUserWeight.getTicketTagCode());
        stationUserWeightDetailVO.setLimitFlowPackageFlag(stationUserWeight.getLimitFlowPackageFlag());
        stationUserWeightDetailVO.setWeightCoefficient(stationUserWeight.getWeightCoefficient());
        stationUserWeightDetailVO.setWeightPlanConsume(stationUserWeight.getWeightPlanConsume());
        TblAdTagVo tblAdTagVo = this.tblAdPostionTagMapperExt.findByCode(stationUserWeight.getTicketTagCode());
        if (null != tblAdTagVo) {
            stationUserWeightDetailVO.setTicketTagCodeFullPath(tblAdTagVo.getFullCodePath().split("\\."));
        }
        List<AdFlowPackage> adFlowPackages = this.getFlowPackageByFlowPackageIdsStr(stationUserWeight.getFlowPackageIdsStr());
        ArrayList toJsonStrList = Lists.newArrayListWithCapacity((int)adFlowPackages.size());
        for (AdFlowPackage adFlowPackage : adFlowPackages) {
            AdFlowPackage entity = new AdFlowPackage();
            entity.setId(adFlowPackage.getId());
            entity.setPackageName(adFlowPackage.getPackageName());
            entity.setCount(adFlowPackage.getCount());
            toJsonStrList.add(entity);
        }
        stationUserWeightDetailVO.setFlowPackageInfoJsonStr(JSON.toJSONString((Object)toJsonStrList));
        return stationUserWeightDetailVO;
    }

    @Override
    public Boolean add(UpdateStationUserWeightDTO dto) {
        AdvertiserDto advertiserDto = this.adShopIntegration.findAdShopMsg(dto.getAdvertiserId().longValue());
        if (null == advertiserDto) {
            throw new BusinessException("\u6dfb\u52a0\u7ad9\u5185\u6237\u6743\u91cd\u8ba1\u5212\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u5e7f\u544a\u4e3b\uff01");
        }
        if (this.tblStationUserWeightMapperExt.findUnCompleteByAdvertiserAndTagCode(Long.valueOf(advertiserDto.getId().longValue()), dto.getTicketTagCode()).size() > 0) {
            throw new BusinessException("\u6dfb\u52a0\u7ad9\u5185\u6237\u6743\u91cd\u8ba1\u5212\u5931\u8d25\uff1a\u540c\u4e00\u4e2a\u5e7f\u544a\u4e3b\u4e0b\uff0c \u4e0d\u80fd\u5b58\u5728\u591a\u6761\u540c\u4e00\u79cd\u5e7f\u544a\u5238\u7c7b\u578b\u4e14\u6709\u6548\uff08\u672a\u5b8c\u6210\uff09\u7684\u6743\u91cd\u8ba1\u5212\uff01");
        }
        List tickets = this.adTicketMapperExt.findCpcTicketByAdvertiserAndType(advertiserDto.getId(), dto.getTicketTagCode());
        List<Object> adFlowPackages = dto.getLimitFlowPackageFlag() != false ? this.getFlowPackageByFlowPackageIdsStr(dto.getFlowPackageIdsStr()) : Collections.emptyList();
        TblStationUserWeight insertEntity = new TblStationUserWeight();
        insertEntity.setAdvertiserId(dto.getAdvertiserId());
        insertEntity.setSale(advertiserDto.getSale());
        insertEntity.setTicketTagCode(dto.getTicketTagCode());
        insertEntity.setTicketCount(Integer.valueOf(tickets.size()));
        insertEntity.setLimitFlowPackageFlag(dto.getLimitFlowPackageFlag());
        if (insertEntity.getLimitFlowPackageFlag().booleanValue()) {
            insertEntity.setFlowPackageIdsStr(Joiner.on((String)",").skipNulls().join((Iterable)adFlowPackages.stream().map(AdFlowPackage::getId).collect(Collectors.toList())));
        }
        insertEntity.setFlowPackageCount(Integer.valueOf(adFlowPackages.size()));
        insertEntity.setWeightCoefficient(dto.getWeightCoefficient());
        insertEntity.setWeightPlanConsume(dto.getWeightPlanConsume());
        insertEntity.setCreateTime(new Date());
        insertEntity.setCreator(dto.getOperationUserName());
        insertEntity.setStatus(AdvertiserConstant.StationUserWeight.STATION_USER_WEIGHT_STATUS_NORMAL);
        if (this.tblStationUserWeightMapperExt.insert(insertEntity) < 1) {
            throw new BusinessException("\u65b0\u589e\u7ad9\u5185\u6237\u6743\u91cd\u63d2\u5165\u6570\u636e\u5e93\u5931\u8d25\uff01");
        }
        StationUserWeightOperationParams params = StationUserWeightOperationParams.builder().adFlowPackages(adFlowPackages).adTickets(tickets).modifyTime(new Date()).operationUserName(dto.getOperationUserName()).stationUserWeightId(insertEntity.getId()).tblStationUserWeight(this.tblStationUserWeightMapperExt.selectByPrimaryKey(insertEntity.getId())).rollbackPositionWeightFlag(false).rollbackTicketWeightFlag(false).build();
        StationUserWeightContext.set(params);
        this.afterUpdateDbAction();
        return true;
    }

    @Override
    public Boolean update(UpdateStationUserWeightDTO dto) {
        Date operationTime = new Date();
        Long stationUserWeightId = dto.getId();
        TblStationUserWeight tblStationUserWeight = this.tblStationUserWeightMapperExt.selectByPrimaryKey(stationUserWeightId);
        if (null == tblStationUserWeight) {
            throw new BusinessException("\u6728\u6709\u67e5\u8be2\u5230\u7ad9\u5185\u6237\u6743\u91cd\uff01");
        }
        if (AdvertiserConstant.StationUserWeight.STATION_USER_WEIGHT_STATUS_COMPLETE.equals(tblStationUserWeight.getStatus())) {
            throw new BusinessException("\u6743\u91cd\u8ba1\u5212\u5df2\u5230\u8fbe\u767e\u5206\u4e4b\u767e\uff0c\u4e0d\u53ef\u518d\u7f16\u8f91\uff01");
        }
        List tickets = this.adTicketMapperExt.findCpcTicketByAdvertiserAndType(Integer.valueOf(tblStationUserWeight.getAdvertiserId().intValue()), tblStationUserWeight.getTicketTagCode());
        List<Object> adFlowPackages = tblStationUserWeight.getLimitFlowPackageFlag() != false ? this.getFlowPackageByFlowPackageIdsStr(tblStationUserWeight.getFlowPackageIdsStr()) : Lists.newArrayList();
        StationUserWeightOperationParams params = StationUserWeightOperationParams.builder().adFlowPackages((List<AdFlowPackage>)adFlowPackages).adTickets(tickets).modifyTime(new Date()).operationUserName(dto.getOperationUserName()).stationUserWeightId(stationUserWeightId).tblStationUserWeight(tblStationUserWeight).rollbackTicketWeightFlag(tblStationUserWeight.getLimitFlowPackageFlag() == false).rollbackPositionWeightFlag(tblStationUserWeight.getLimitFlowPackageFlag()).build();
        StationUserWeightContext.set(params);
        try {
            this.rollbackWeight();
        }
        catch (Exception e) {
            throw new BusinessException("\u4fee\u6539\u7ad9\u5185\u6237\u6743\u91cd\u4e4b\u524d\uff0c\u56de\u6eda\u65e7\u6743\u91cd\u5931\u8d25\uff01", e);
        }
        for (TblStationUserWeight stationUserWeight : this.tblStationUserWeightMapperExt.findUnCompleteByAdvertiserAndTagCode(tblStationUserWeight.getAdvertiserId(), tblStationUserWeight.getTicketTagCode())) {
            if (stationUserWeight.getId().equals(tblStationUserWeight.getId())) continue;
            throw new BusinessException("\u6dfb\u52a0\u7ad9\u5185\u6237\u6743\u91cd\u8ba1\u5212\u5931\u8d25\uff1a\u540c\u4e00\u4e2a\u5e7f\u544a\u4e3b\u4e0b\uff0c \u4e0d\u80fd\u5b58\u5728\u591a\u6761\u540c\u4e00\u79cd\u5e7f\u544a\u5238\u7c7b\u578b\u4e14\u6709\u6548\uff08\u672a\u5b8c\u6210\uff09\u7684\u6743\u91cd\u8ba1\u5212\uff01");
        }
        adFlowPackages = dto.getLimitFlowPackageFlag() != false ? this.getFlowPackageByFlowPackageIdsStr(dto.getFlowPackageIdsStr()) : Lists.newArrayList();
        params.setAdFlowPackages((List<AdFlowPackage>)adFlowPackages);
        TblStationUserWeight updateEntity = new TblStationUserWeight();
        updateEntity.setId(stationUserWeightId);
        updateEntity.setTicketCount(Integer.valueOf(tickets.size()));
        updateEntity.setLimitFlowPackageFlag(dto.getLimitFlowPackageFlag());
        if (updateEntity.getLimitFlowPackageFlag().booleanValue()) {
            updateEntity.setFlowPackageIdsStr(Joiner.on((String)",").skipNulls().join((Iterable)adFlowPackages.stream().map(AdFlowPackage::getId).collect(Collectors.toList())));
        } else {
            updateEntity.setFlowPackageIdsStr("");
        }
        updateEntity.setFlowPackageCount(Integer.valueOf(adFlowPackages.size()));
        updateEntity.setWeightCoefficient(dto.getWeightCoefficient());
        updateEntity.setWeightPlanConsume(dto.getWeightPlanConsume());
        updateEntity.setModifyTime(operationTime);
        updateEntity.setModifier(dto.getOperationUserName());
        BigDecimal realTimeConsume = this.getRealTimeConsume(stationUserWeightId).get(stationUserWeightId);
        log.error("\u4fee\u6539\u6743\u91cd\u8ba1\u5212\uff1a  \u5b9e\u65f6\u6d88\u8017\u503c\uff1a" + realTimeConsume);
        if (realTimeConsume.compareTo(dto.getWeightPlanConsume()) >= 0) {
            updateEntity.setCompleteTime(operationTime);
            updateEntity.setStatus(AdvertiserConstant.StationUserWeight.STATION_USER_WEIGHT_STATUS_COMPLETE);
        }
        if (this.tblStationUserWeightMapperExt.updateByPrimaryKeySelective(updateEntity) < 1) {
            throw new BusinessException("\u4fee\u6539\u7ad9\u5185\u6237\u6743\u91cd\u6570\u636e\u5931\u8d25\uff01");
        }
        params.setTblStationUserWeight(this.tblStationUserWeightMapperExt.selectByPrimaryKey(stationUserWeightId));
        params.setRollbackTicketWeightFlag(false);
        params.setRollbackPositionWeightFlag(false);
        this.afterUpdateDbAction();
        return true;
    }

    @Override
    public void complete(Long stationUserWeightId) {
        this.tblStationUserWeightMapperExt.batchUpdateStatusByIds(Collections.singletonList(stationUserWeightId), AdvertiserConstant.StationUserWeight.STATION_USER_WEIGHT_STATUS_COMPLETE);
        TblStationUserWeight stationUserWeight = this.tblStationUserWeightMapperExt.selectByPrimaryKey(stationUserWeightId);
        if (null == stationUserWeight) {
            return;
        }
        List adTickets = this.adTicketMapperExt.findCpcTicketByAdvertiserAndType(Integer.valueOf(stationUserWeight.getAdvertiserId().intValue()), stationUserWeight.getTicketTagCode());
        List<AdFlowPackage> adFlowPackages = stationUserWeight.getLimitFlowPackageFlag() != false ? this.getFlowPackageByFlowPackageIdsStr(stationUserWeight.getFlowPackageIdsStr()) : Collections.emptyList();
        StationUserWeightOperationParams params = StationUserWeightOperationParams.builder().adFlowPackages(adFlowPackages).adTickets(adTickets).modifyTime(new Date()).operationUserName("complete auth").stationUserWeightId(stationUserWeightId).tblStationUserWeight(stationUserWeight).rollbackTicketWeightFlag(stationUserWeight.getLimitFlowPackageFlag() == false).rollbackPositionWeightFlag(stationUserWeight.getLimitFlowPackageFlag()).build();
        StationUserWeightContext.set(params);
        this.rollbackWeight();
        this.syncRedis();
    }

    @Override
    public void refreshWeightCacheWhenFlowPackageUpdate(Long adFlowPackageId, Set<String> removePositionIds, Set<String> addPositionIds, String operationUserName) {
        if (null == adFlowPackageId) {
            return;
        }
        List stationUserWeights = this.tblStationUserWeightMapperExt.findEffectiveByFuzzyFlowPackageId(adFlowPackageId.toString());
        if (CollectionUtils.isEmpty((Collection)stationUserWeights)) {
            return;
        }
        stationUserWeights.removeIf(tblStationUserWeight -> !Splitter.on((String)",").splitToList((CharSequence)tblStationUserWeight.getFlowPackageIdsStr()).contains(adFlowPackageId.toString()));
        HashMap redisPositionWeightMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(removePositionIds)) {
            List rollBackAdTicketPositionWeights = this.adTicketPositionWeightMapperExt.findAllByPositionIds(removePositionIds);
            if (CollectionUtils.isEmpty((Collection)rollBackAdTicketPositionWeights)) {
                return;
            }
            for (TblStationUserWeight weight : stationUserWeights) {
                List tickets = this.adTicketMapperExt.findCpcTicketByAdvertiserAndType(Integer.valueOf(weight.getAdvertiserId().intValue()), weight.getTicketTagCode());
                if (CollectionUtils.isEmpty((Collection)tickets)) continue;
                List ticketIds = tickets.stream().map(AdTicket::getId).collect(Collectors.toList());
                List<String> positionIds = this.getAllPositionIdsInFlowPackages(this.getFlowPackageByFlowPackageIdsStr(weight.getFlowPackageIdsStr()));
                ArrayList batchUpdateIds = Lists.newArrayList();
                for (AdTicketPositionWeight adTicketPositionWeight : rollBackAdTicketPositionWeights) {
                    if (positionIds.contains(adTicketPositionWeight.getPositionId()) || !ticketIds.contains(adTicketPositionWeight.getTicketId()) || weight.getWeightCoefficient().compareTo(adTicketPositionWeight.getInterventionFactor()) != 0) continue;
                    batchUpdateIds.add(adTicketPositionWeight.getId());
                    redisPositionWeightMap.computeIfAbsent(POSITION_WEIGHT_KEY + adTicketPositionWeight.getPositionId(), k -> Maps.newHashMap()).put(adTicketPositionWeight.getTicketId().toString(), "1");
                }
                if (batchUpdateIds.size() <= 0) continue;
                this.adTicketPositionWeightMapperExt.batchUpdateInterventionFactorByIds((List)batchUpdateIds, Double.valueOf(100.0));
            }
        }
        if (CollectionUtils.isNotEmpty(addPositionIds)) {
            List addAadTicketPositionWeights = this.adTicketPositionWeightMapperExt.findAllByPositionIds(addPositionIds);
            Map<String, List<AdTicketPositionWeight>> map = this.positionWeightDataGroupByPositionId(addAadTicketPositionWeights);
            for (String positionId : addPositionIds) {
                List dbPositionWeights = map.getOrDefault(positionId, Collections.emptyList());
                for (TblStationUserWeight weight : stationUserWeights) {
                    List tickets = this.adTicketMapperExt.findCpcTicketByAdvertiserAndType(Integer.valueOf(weight.getAdvertiserId().intValue()), weight.getTicketTagCode());
                    if (CollectionUtils.isEmpty((Collection)tickets)) continue;
                    ArrayList batchInsertPositionWeightEntities = Lists.newArrayList();
                    ArrayList batchUpdatePositionWeightIds = Lists.newArrayList();
                    String weightCoefficientCacheValue = new BigDecimal(weight.getWeightCoefficient()).divide(new BigDecimal(100), 2, 4).toPlainString();
                    for (AdTicket ticket : tickets) {
                        redisPositionWeightMap.computeIfAbsent(POSITION_WEIGHT_KEY + positionId, k -> Maps.newHashMap()).put(ticket.getId().toString(), weightCoefficientCacheValue);
                        Long dbAdTicketPositionWeightId = null;
                        for (AdTicketPositionWeight dbPositionWeight : dbPositionWeights) {
                            if (!ticket.getId().equals(dbPositionWeight.getTicketId())) continue;
                            dbAdTicketPositionWeightId = dbPositionWeight.getId();
                            break;
                        }
                        if (null != dbAdTicketPositionWeightId) {
                            batchUpdatePositionWeightIds.add(dbAdTicketPositionWeightId);
                            continue;
                        }
                        AdTicketPositionWeight adTicketPositionWeight = new AdTicketPositionWeight();
                        adTicketPositionWeight.setPositionId(positionId);
                        adTicketPositionWeight.setInterventionFactor(weight.getWeightCoefficient());
                        adTicketPositionWeight.setTicketId(ticket.getId());
                        batchInsertPositionWeightEntities.add(adTicketPositionWeight);
                    }
                    if (batchInsertPositionWeightEntities.size() > 0) {
                        this.adTicketPositionWeightMapperExt.batchInsert((List)batchInsertPositionWeightEntities);
                    }
                    if (batchUpdatePositionWeightIds.size() <= 0) continue;
                    this.adTicketPositionWeightMapperExt.batchUpdateInterventionFactorByIds((List)batchUpdatePositionWeightIds, weight.getWeightCoefficient());
                }
            }
        }
        if (redisPositionWeightMap.size() > 0) {
            for (Map.Entry entry : redisPositionWeightMap.entrySet()) {
                if (this.redisNewClient.hmset((String)entry.getKey(), (Map)entry.getValue())) continue;
                DingtalkMsgUtil.sendMsg(DING_TALK_URL, "\u7ad9\u5185\u6237\u6743\u91cd\u64cd\u4f5c\uff1a\u4fee\u6539\u5e7f\u544a\u4f4d:{" + (String)entry.getKey() + "}\u6743\u91cd\u5931\u8d25\uff01", false, Collections.emptyList());
            }
        }
        HashMap stationUserWeightPushParamsMap = Maps.newHashMap();
        for (Long advertiserId : stationUserWeights.stream().map(TblStationUserWeight::getAdvertiserId).collect(Collectors.toSet())) {
            stationUserWeightPushParamsMap.put(advertiserId, this.buildStationUserWeightCacheByAdvertiserId(advertiserId));
        }
        this.pushStationUserWeightToRedis(stationUserWeightPushParamsMap);
    }

    @Override
    public void refreshWeightCacheWhenFlowPackageDelete(Long adFlowPackageId, Set<String> removePositionIds, String operationUserName) {
        this.refreshWeightCacheWhenFlowPackageUpdate(adFlowPackageId, removePositionIds, null, operationUserName);
        List stationUserWeights = this.tblStationUserWeightMapperExt.findEffectiveByFuzzyFlowPackageId(adFlowPackageId.toString());
        if (CollectionUtils.isEmpty((Collection)stationUserWeights)) {
            return;
        }
        ArrayList updateEntities = Lists.newArrayListWithCapacity((int)stationUserWeights.size());
        String adFlowPackageIdStr = String.valueOf(adFlowPackageId);
        for (TblStationUserWeight stationUserWeight : stationUserWeights) {
            ArrayList flowPackageIds = Lists.newArrayList((Iterable)Splitter.on((String)",").splitToList((CharSequence)stationUserWeight.getFlowPackageIdsStr()));
            if (!flowPackageIds.contains(adFlowPackageIdStr)) continue;
            flowPackageIds.remove(adFlowPackageIdStr);
            TblStationUserWeight updateEntity = new TblStationUserWeight();
            updateEntity.setId(stationUserWeight.getId());
            updateEntity.setFlowPackageIdsStr(Joiner.on((String)",").skipNulls().join((Iterable)flowPackageIds));
            updateEntity.setFlowPackageCount(Integer.valueOf(flowPackageIds.size()));
            updateEntity.setModifier(operationUserName);
            updateEntities.add(updateEntity);
        }
        if (updateEntities.size() > 0) {
            this.tblStationUserWeightMapperExt.batchUpdateAdFlowPackage((List)updateEntities);
        }
    }

    @Override
    public void refreshWeightCacheWhenTicketUpdate(Long ticketId, Integer oldTagCode, Integer newTagCode, Boolean addTicketFlag) {
        AdTicket adTicket = this.adTicketMapper.selectByPrimaryKey(ticketId);
        List stationUserWeightPushParams = this.fetcher.hfetchList(TicketKeyGenerator.Advertiser.getStationUserWeight(), adTicket.getAdvertiser().toString(), StationUserWeightPushParam.class);
        if (CollectionUtils.isEmpty((Collection)stationUserWeightPushParams)) {
            return;
        }
        String ticketIdContainsRegex = "," + ticketId + ",";
        boolean changeTagCodeFlag = oldTagCode.equals(newTagCode);
        HashMap redisPositionWeightMap = Maps.newHashMap();
        List adTicketPositionWeights = null;
        AdTicketWeightManualConf updateAdTicketWeightManualConf = (AdTicketWeightManualConf)this.adTicketWeightManualConfMapperExt.selectByTicketIds(Collections.singletonList(ticketId)).get(0);
        if (null == updateAdTicketWeightManualConf) {
            DingtalkMsgUtil.sendMsg(DING_TALK_URL, "\u6570\u636e\u5f02\u5e38\uff1a\u5238\u4fee\u6539/\u65b0\u589e\u64cd\u4f5c\uff0c\u5237\u65b0\u7ad9\u5185\u6237\u6743\u91cd\u65f6\uff0c\u672a\u53d1\u73b0\u5238\u6743\u91cd\u6570\u636e\uff01\uff01\uff01", false, Collections.emptyList());
            return;
        }
        boolean needUpdateTicketWeightFlag = false;
        String ticketIdStr = adTicket.getId().toString();
        for (StationUserWeightPushParam weightPushParam : stationUserWeightPushParams) {
            TblStationUserWeight updateEntity;
            ArrayList ticketIdStrList;
            if (!changeTagCodeFlag && weightPushParam.getTicketTagCode().equals(oldTagCode)) {
                log.info("==============================================");
                log.info("\u5f00\u59cb\u5237\u65b0ticketIds\u5b57\u6bb5\uff0c \u5e76\u56de\u6eda\u5e7f\u544a\u4f4d\u6743\u91cd\uff01\uff01\uff01");
                log.info("ticketIdContainsRegex:{}, ticketIdsStr:{}", (Object)ticketIdContainsRegex, (Object)weightPushParam.getTicketIdsStr());
                log.info("==============================================");
                ticketIdStrList = Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)weightPushParam.getTicketIdsStr()));
                if (ticketIdStrList.contains(ticketIdStr)) {
                    ticketIdStrList.remove(ticketIdStr);
                    weightPushParam.setTicketIdsStr("," + Joiner.on((String)",").skipNulls().join((Iterable)ticketIdStrList) + ",");
                    updateEntity = new TblStationUserWeight();
                    updateEntity.setId(weightPushParam.getStationUserWeightId());
                    updateEntity.setTicketCount(Integer.valueOf(ticketIdStrList.size()));
                    updateEntity.setModifier("ticket:" + ticketIdStr + " modifier");
                    updateEntity.setModifyTime(new Date());
                    this.tblStationUserWeightMapperExt.updateByPrimaryKeySelective(updateEntity);
                    if (weightPushParam.getLimitPositionFlag().booleanValue()) {
                        log.info("-------------------------------------\u56de\u6eda\u5e7f\u544a\u4f4d\u6743\u91cd\uff01");
                        adTicketPositionWeights = this.adTicketPositionWeightMapperExt.findAllByTicketId(ticketId);
                        ArrayList rollbackWeightIds = Lists.newArrayListWithCapacity((int)adTicketPositionWeights.size());
                        for (AdTicketPositionWeight positionWeight : adTicketPositionWeights) {
                            String positionIdContainsRegex = "," + positionWeight.getPositionId() + ",";
                            if (!weightPushParam.getPositionIdsStr().contains(positionIdContainsRegex)) continue;
                            redisPositionWeightMap.computeIfAbsent(POSITION_WEIGHT_KEY + positionWeight.getPositionId(), k -> Maps.newHashMap()).put(ticketIdStr, "1");
                            rollbackWeightIds.add(positionWeight.getId());
                        }
                        log.info("-------------------------------------\u56de\u6eda\u5e7f\u544a\u4f4d\u6743\u91cd\u6570\u91cf\uff1a{}\uff01", (Object)rollbackWeightIds.size());
                        if (rollbackWeightIds.size() > 0) {
                            this.adTicketPositionWeightMapperExt.batchUpdateInterventionFactorByIds((List)rollbackWeightIds, Double.valueOf(100.0));
                        }
                    } else if (updateAdTicketWeightManualConf.getInterventionFactor().compareTo(weightPushParam.getWeightCoefficient()) == 0) {
                        log.info("-------------------------------------\u4e0e\u65e7\u6743\u91cd\u4e00\u81f4\uff1a\u56de\u6eda\u5e7f\u544a\u4f4d\u6743\u91cd\uff01");
                        updateAdTicketWeightManualConf.setInterventionFactor(Double.valueOf(100.0));
                        needUpdateTicketWeightFlag = true;
                    }
                }
            }
            if (!weightPushParam.getTicketTagCode().equals(newTagCode)) continue;
            log.info("==============================================");
            log.info("\u5f00\u59cb\u5237\u65b0ticketIds\u5b57\u6bb5\uff0c \u5e76\u56de\u6eda\u5e7f\u544a\u4f4d\u6743\u91cd\uff01\uff01\uff01");
            log.info("==============================================");
            ticketIdStrList = Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)weightPushParam.getTicketIdsStr()));
            if (!ticketIdStrList.contains(ticketIdStr)) {
                ticketIdStrList.add(ticketIdStr);
                weightPushParam.setTicketIdsStr("," + Joiner.on((String)",").skipNulls().join((Iterable)ticketIdStrList) + ",");
                updateEntity = new TblStationUserWeight();
                updateEntity.setId(weightPushParam.getStationUserWeightId());
                updateEntity.setTicketCount(Integer.valueOf(ticketIdStrList.size()));
                updateEntity.setModifier("ticket:" + ticketIdStr + " modifier");
                updateEntity.setModifyTime(new Date());
                this.tblStationUserWeightMapperExt.updateByPrimaryKeySelective(updateEntity);
            }
            if (!weightPushParam.getTicketIdsStr().contains(ticketIdContainsRegex)) {
                weightPushParam.setTicketIdsStr(weightPushParam.getTicketIdsStr() + ticketId + ",");
            }
            if (weightPushParam.getLimitPositionFlag().booleanValue()) {
                log.info("-------------------------------------\u5237\u65b0\u5e7f\u544a\u4f4d\u6743\u91cd\uff01");
                if (null == adTicketPositionWeights) {
                    adTicketPositionWeights = this.adTicketPositionWeightMapperExt.findAllByTicketId(ticketId);
                }
                String weightCoefficientCacheValue = new BigDecimal(weightPushParam.getWeightCoefficient()).divide(new BigDecimal(100), 2, 4).toPlainString();
                ArrayList increasedWeightIds = Lists.newArrayListWithCapacity((int)adTicketPositionWeights.size());
                ArrayList batchInsertEntities = Lists.newArrayList();
                List stationUserWeightPositionIds = Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)weightPushParam.getPositionIdsStr());
                for (String positionId : stationUserWeightPositionIds) {
                    redisPositionWeightMap.computeIfAbsent(POSITION_WEIGHT_KEY + positionId, k -> Maps.newHashMap()).put(ticketIdStr, weightCoefficientCacheValue);
                    Long dbPositionWeightId = null;
                    for (AdTicketPositionWeight positionWeight : adTicketPositionWeights) {
                        if (!positionWeight.getPositionId().equals(positionId)) continue;
                        dbPositionWeightId = positionWeight.getId();
                    }
                    if (null == dbPositionWeightId) {
                        AdTicketPositionWeight adTicketPositionWeight = new AdTicketPositionWeight();
                        adTicketPositionWeight.setPositionId(positionId);
                        adTicketPositionWeight.setInterventionFactor(weightPushParam.getWeightCoefficient());
                        adTicketPositionWeight.setTicketId(ticketId);
                        batchInsertEntities.add(adTicketPositionWeight);
                        continue;
                    }
                    increasedWeightIds.add(dbPositionWeightId);
                }
                if (batchInsertEntities.size() > 0) {
                    this.adTicketPositionWeightMapperExt.batchInsert((List)batchInsertEntities);
                }
                if (increasedWeightIds.size() <= 0) continue;
                this.adTicketPositionWeightMapperExt.batchUpdateInterventionFactorByIds((List)increasedWeightIds, weightPushParam.getWeightCoefficient());
                continue;
            }
            log.info("-------------------------------------\u5237\u65b0\u5e7f\u544a\u5238\u6743\u91cd\uff01");
            updateAdTicketWeightManualConf.setInterventionFactor(weightPushParam.getWeightCoefficient());
            needUpdateTicketWeightFlag = true;
        }
        if (needUpdateTicketWeightFlag) {
            log.info("\u7ad9\u5185\u6237\u6743\u6743\u91cd\u3010\u5238\u7f16\u8f91\u3011\uff1a\u66f4\u65b0\u5238\u6743\u91cd==============");
            this.adTicketWeightManualConfMapperExt.updateByPrimaryKeySelective(updateAdTicketWeightManualConf);
        }
        HashMap stationUserWeightPushParamsMap = Maps.newHashMap();
        stationUserWeightPushParamsMap.put(adTicket.getAdvertiser(), stationUserWeightPushParams);
        this.pushStationUserWeightToRedis(stationUserWeightPushParamsMap);
        if (redisPositionWeightMap.size() > 0) {
            for (Map.Entry entry : redisPositionWeightMap.entrySet()) {
                if (this.redisNewClient.hmset((String)entry.getKey(), (Map)entry.getValue())) continue;
                DingtalkMsgUtil.sendMsg(DING_TALK_URL, "\u5238\u7f16\u8f91\u64cd\u4f5c\uff1a\u5237\u65b0\u5e7f\u544a\u4f4d:{" + (String)entry.getKey() + "}\u6743\u91cd\u5931\u8d25\uff01", false, Collections.emptyList());
            }
        }
    }

    @Override
    public void check() {
        Map<Long, List<StationUserWeightPushParam>> advertiserStationUserWeightMap = this.getStationUserWeightsInProgress();
        for (Map.Entry<Long, List<StationUserWeightPushParam>> entry : advertiserStationUserWeightMap.entrySet()) {
            for (StationUserWeightPushParam weightPushParam : entry.getValue()) {
                try {
                    TblStationUserWeight tblStationUserWeight = this.tblStationUserWeightMapperExt.selectByPrimaryKey(weightPushParam.getStationUserWeightId());
                    List<Long> cacheTicketIds = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)weightPushParam.getTicketIdsStr()).stream().map(Long::valueOf).collect(Collectors.toList());
                    List adTickets = this.adTicketMapperExt.findCpcTicketByAdvertiserAndType(Integer.valueOf(entry.getKey().intValue()), weightPushParam.getTicketTagCode());
                    List<Long> dbTicketIds = adTickets.stream().map(AdTicket::getId).collect(Collectors.toList());
                    this.checkTicket(cacheTicketIds, dbTicketIds);
                    if (weightPushParam.getLimitPositionFlag().booleanValue()) {
                        HashSet cachePositionIds = Sets.newHashSet((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)weightPushParam.getPositionIdsStr()));
                        HashSet dbPositionIds = Sets.newHashSet(this.getAllPositionIdsInFlowPackages(this.getFlowPackageByFlowPackageIdsStr(tblStationUserWeight.getFlowPackageIdsStr())));
                        this.checkPosition(cachePositionIds, dbPositionIds);
                        if (cachePositionIds.size() <= 0) continue;
                        this.checkPositionWeight(cachePositionIds, weightPushParam.getWeightCoefficient());
                        continue;
                    }
                    this.checkTicketWeight(cacheTicketIds, weightPushParam.getWeightCoefficient());
                }
                catch (BusinessException e) {
                    DingtalkMsgUtil.sendMsg(DING_TALK_URL, "\u3010\u6743\u91cdID:" + weightPushParam.getStationUserWeightId() + "\u68c0\u67e5\u62a5\u8b66\u3011:" + e.getMessage(), false, Collections.emptyList());
                }
                catch (Exception e) {
                    log.error("\u68c0\u67e5\u6743\u91cd\u8ba1\u5212\u4e2d\u7684\u5e7f\u544a\u5238\u6743\u91cd/\u5e7f\u544a\u4f4d\u6743\u91cd \u662f\u5426\u4e0e\u6743\u91cd\u8ba1\u5212\u6743\u91cd\u7cfb\u6570\u662f\u5426\u4e00\u81f4 \u5f02\u5e38\uff01", (Throwable)e);
                    DingtalkMsgUtil.sendMsg(DING_TALK_URL, "\u6743\u91cd\u8ba1\u5212\u68c0\u67e5\u5f02\u5e38\uff01\uff01\uff01", false, Collections.emptyList());
                }
            }
        }
    }

    private void rollbackWeight() {
        List adTicketWeightManualConfs;
        TblStationUserWeight stationUserWeight = StationUserWeightContext.get().getTblStationUserWeight();
        List<AdFlowPackage> adFlowPackages = StationUserWeightContext.get().getAdFlowPackages();
        HashSet positionIds = Sets.newHashSet(this.getAllPositionIdsInFlowPackages(adFlowPackages));
        List<AdTicket> tickets = StationUserWeightContext.get().getAdTickets();
        List ticketIds = tickets.stream().map(AdTicket::getId).collect(Collectors.toList());
        Map<String, Map<String, String>> redisPositionWeightMap = StationUserWeightContext.get().getRedisPositionWeightMapIfCreate();
        Map<Long, String> redisTicketWeightMap = StationUserWeightContext.get().getRedisTicketWeightMapIfCreate();
        boolean rollbackPositionWeightFlag = StationUserWeightContext.get().getRollbackPositionWeightFlag();
        boolean rollbackTicketWeightFlag = StationUserWeightContext.get().getRollbackTicketWeightFlag();
        if (CollectionUtils.isNotEmpty((Collection)positionIds) && rollbackPositionWeightFlag) {
            HashMap adTicketPositionWeightMap = Maps.newHashMap();
            List adTicketPositionWeights = this.adTicketPositionWeightMapperExt.findAllByPositionIds((Set)positionIds);
            ArrayList batchUpdateIds = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)adTicketPositionWeights)) {
                for (AdTicketPositionWeight adTicketPositionWeight : adTicketPositionWeights) {
                    if (!ticketIds.contains(adTicketPositionWeight.getTicketId()) || stationUserWeight.getWeightCoefficient().compareTo(adTicketPositionWeight.getInterventionFactor()) != 0) continue;
                    batchUpdateIds.add(adTicketPositionWeight.getId());
                    adTicketPositionWeightMap.computeIfAbsent(adTicketPositionWeight.getPositionId(), k -> Lists.newArrayList()).add(adTicketPositionWeight);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)batchUpdateIds)) {
                this.adTicketPositionWeightMapperExt.batchUpdateInterventionFactorByIds((List)batchUpdateIds, Double.valueOf(100.0));
            }
            for (Map.Entry entry : adTicketPositionWeightMap.entrySet()) {
                Map positionWeightCacheMap = redisPositionWeightMap.computeIfAbsent(POSITION_WEIGHT_KEY + (String)entry.getKey(), k -> Maps.newHashMapWithExpectedSize((int)((List)entry.getValue()).size()));
                for (AdTicketPositionWeight adTicketPositionWeight : (List)entry.getValue()) {
                    positionWeightCacheMap.put(adTicketPositionWeight.getTicketId().toString(), "1");
                }
            }
        }
        if (CollectionUtils.isNotEmpty(ticketIds) && rollbackTicketWeightFlag && CollectionUtils.isNotEmpty((Collection)(adTicketWeightManualConfs = this.adTicketWeightManualConfMapperExt.selectByTicketIds(ticketIds)))) {
            ArrayList batchUpdateTicketIds = Lists.newArrayList();
            ArrayList ticketWeightManualConfIds = Lists.newArrayList();
            for (AdTicketWeightManualConf adTicketWeightManualConf : adTicketWeightManualConfs) {
                if (stationUserWeight.getWeightCoefficient().compareTo(adTicketWeightManualConf.getInterventionFactor()) != 0) continue;
                ticketWeightManualConfIds.add(adTicketWeightManualConf.getId());
                batchUpdateTicketIds.add(adTicketWeightManualConf.getTicketId());
            }
            if (CollectionUtils.isNotEmpty((Collection)ticketWeightManualConfIds)) {
                this.adTicketWeightManualConfMapperExt.batchCompareAndUpdateInterventionFactorByIds((List)ticketWeightManualConfIds, stationUserWeight.getWeightCoefficient(), Double.valueOf(100.0));
                for (Long l : batchUpdateTicketIds) {
                    redisTicketWeightMap.put(l, "100");
                }
            }
        }
    }

    private Map<Long, BigDecimal> getRealTimeConsume(long ... stationUserWeightIds) {
        List<String> consumes = this.redisNewClient.hmget(TicketKeyGenerator.Advertiser.getConsumeForStationUserWeight().generateKey(), (String[])Arrays.stream(stationUserWeightIds).mapToObj(String::valueOf).toArray(String[]::new));
        if (CollectionUtils.isEmpty(consumes)) {
            return Collections.emptyMap();
        }
        BigDecimal convert = new BigDecimal(1000);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)stationUserWeightIds.length);
        for (int i = 0; i < stationUserWeightIds.length; ++i) {
            String consumeStr = consumes.get(i);
            if (StringUtils.isNotBlank((CharSequence)consumeStr) && StringUtils.isNumeric((CharSequence)consumeStr)) {
                resultMap.put(stationUserWeightIds[i], new BigDecimal(consumes.get(i)).divide(convert, 2, 4));
                continue;
            }
            resultMap.put(stationUserWeightIds[i], BigDecimal.ZERO);
        }
        return resultMap;
    }

    private void afterUpdateDbAction() {
        TblStationUserWeight stationUserWeight = StationUserWeightContext.get().getTblStationUserWeight();
        StationUserWeightContext.get().setStationUserWeightPushParamList(this.buildStationUserWeightCacheByAdvertiserId(stationUserWeight.getAdvertiserId()));
        if (AdvertiserConstant.StationUserWeight.STATION_USER_WEIGHT_STATUS_NORMAL.equals(stationUserWeight.getStatus())) {
            if (stationUserWeight.getLimitFlowPackageFlag().booleanValue()) {
                this.batchUpdatePositionWeight();
            } else {
                this.batchUpdateTicketWeight();
            }
        }
        this.syncRedis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncRedis() {
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(3, 3, 0L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(3), new ThreadFactoryBuilder().setNameFormat("station-user-weight-sync-redis-pool-%d").build(), new ThreadPoolExecutor.AbortPolicy());
        try {
            Map<String, Map<String, String>> redisPositionWeightMap;
            Map<Long, String> redisTicketWeightMap = StationUserWeightContext.get().getRedisTicketWeightMap();
            if (MapUtils.isNotEmpty(redisTicketWeightMap)) {
                log.info("\u7ad9\u5185\u6237\u6743\u91cd-\u540c\u6b65redis\uff1a\u5faa\u73af\u63a8\u9001\u5e7f\u544a\u5238\u6743\u91cd--");
                executorService.execute(() -> {
                    for (Map.Entry entry : redisTicketWeightMap.entrySet()) {
                        try {
                            HashMap propMap = Maps.newHashMap();
                            propMap.put(ProdServiceNameEnum.TICKET_WEIGHT.getParameters(), entry.getKey());
                            this.prodPusherIntegration.pushToProd(ProdServiceNameEnum.TICKET_WEIGHT.getServiceName(), (Map)propMap, StringHelper.convert((String)((String)entry.getValue())));
                        }
                        catch (Exception e) {
                            log.error("\u63a8\u9001\u5e7f\u544a\u5238\u6743\u91cd\u5230\u524d\u53f0\u5931\u8d25\uff01", (Throwable)e);
                            DingtalkMsgUtil.sendMsg(DING_TALK_URL, "\u7ad9\u5185\u6237\u6743\u91cd\u64cd\u4f5c\uff1a\u63a8\u9001\u5e7f\u544a\u5238:{" + entry.getKey() + "}\u6743\u91cd\u5230\u524d\u53f0\u5931\u8d25\uff01", false, Collections.emptyList());
                        }
                    }
                });
            }
            if (MapUtils.isNotEmpty(redisPositionWeightMap = StationUserWeightContext.get().getRedisPositionWeightMap())) {
                if (redisPositionWeightMap.keySet().size() > POSITION_WEIGHT_NOTICE_SIZE) {
                    int postDataSize = redisPositionWeightMap.keySet().size() * StationUserWeightContext.get().getAdTickets().size();
                    DingtalkMsgUtil.sendMsg(DING_TALK_URL, "\u7528\u6237\uff1a" + StationUserWeightContext.get().getOperationUserName() + "\u64cd\u4f5c\u4e86\u7ad9\u5185\u6237\u6743\u91cd\uff0c\u6b63\u5728\u5411\u524d\u7aef\u63a8\u9001" + postDataSize + "\u7684\u5e7f\u544a\u4f4d\u6743\u91cd\u6570\u636e\uff01", false, Collections.emptyList());
                }
                log.info("\u7ad9\u5185\u6237\u6743\u91cd-\u540c\u6b65redis\uff1a\u5faa\u73af\u63a8\u9001\u5e7f\u544a\u5238\u4f4d\u6743\u91cd--");
                executorService.execute(() -> {
                    for (Map.Entry entry : redisPositionWeightMap.entrySet()) {
                        if (this.redisNewClient.hmset((String)entry.getKey(), (Map)entry.getValue())) continue;
                        DingtalkMsgUtil.sendMsg(DING_TALK_URL, "\u7ad9\u5185\u6237\u6743\u91cd\u64cd\u4f5c\uff1a\u4fee\u6539\u5e7f\u544a\u4f4d:{" + (String)entry.getKey() + "}\u6743\u91cd\u5931\u8d25\uff01", false, Collections.emptyList());
                    }
                });
            }
            long advertiserId = StationUserWeightContext.get().getTblStationUserWeight().getAdvertiserId();
            List<StationUserWeightPushParam> stationUserWeightPushParams = StationUserWeightContext.get().getStationUserWeightPushParamList();
            if (CollectionUtils.isNotEmpty(stationUserWeightPushParams)) {
                log.info("\u7ad9\u5185\u6237\u6743\u91cd-\u540c\u6b65redis\uff1a\u63a8\u9001\u7ad9\u5185\u6237\u6743\u91cd\u8ba1\u5212--");
                executorService.execute(() -> {
                    try {
                        HashMap map = Maps.newHashMap();
                        map.put("advertiserId", advertiserId);
                        this.prodPusherIntegration.pushToProd(ProdServiceNameEnum.STATION_USER_WEIGHT.getServiceName(), (Map)map, JsonHelper.convert2bytes((Object)stationUserWeightPushParams));
                    }
                    catch (Exception e) {
                        log.error("\u63a8\u9001\u5e7f\u544a\u4e3b\uff1a{}\u7684\u7ad9\u5185\u6237\u6743\u91cd\u8ba1\u5212\u5230\u524d\u53f0\u5931\u8d25\uff01", (Object)advertiserId, (Object)e);
                        DingtalkMsgUtil.sendMsg(DING_TALK_URL, "\u7ad9\u5185\u6237\u6743\u91cd\u64cd\u4f5c\uff1a\u63a8\u9001\u5e7f\u544a\u4e3b\uff1a{" + advertiserId + "}\u7684\u7ad9\u5185\u6237\u6743\u91cd\u6743\u91cd\u5230\u524d\u53f0\u5931\u8d25\uff01", false, Collections.emptyList());
                    }
                });
            }
        }
        finally {
            executorService.shutdown();
        }
    }

    private void batchUpdatePositionWeight() {
        Double weightCoefficient = StationUserWeightContext.get().getTblStationUserWeight().getWeightCoefficient();
        List<AdFlowPackage> adFlowPackages = StationUserWeightContext.get().getAdFlowPackages();
        List<AdTicket> tickets = StationUserWeightContext.get().getAdTickets();
        Map<String, Map<String, String>> redisPositionWeightMap = StationUserWeightContext.get().getRedisPositionWeightMapIfCreate();
        HashSet positionIds = Sets.newHashSet(this.getAllPositionIdsInFlowPackages(adFlowPackages));
        if (CollectionUtils.isEmpty((Collection)positionIds)) {
            return;
        }
        List adTicketPositionWeights = this.adTicketPositionWeightMapperExt.findAllByPositionIds((Set)positionIds);
        Map<String, List<AdTicketPositionWeight>> adTicketPositionWeightMap = this.positionWeightDataGroupByPositionId(adTicketPositionWeights);
        ArrayList batchInsertEntities = Lists.newArrayList();
        ArrayList batchUpdatePositionWeightIds = Lists.newArrayList();
        String weightCoefficientCacheValue = new BigDecimal(weightCoefficient).divide(new BigDecimal(100), 2, 4).toPlainString();
        for (String positionId : positionIds) {
            List dbPositionWeights = adTicketPositionWeightMap.getOrDefault(positionId, Collections.emptyList());
            for (AdTicket ticket : tickets) {
                Map positionWeightCacheMap = redisPositionWeightMap.computeIfAbsent(POSITION_WEIGHT_KEY + positionId, k -> Maps.newHashMap());
                positionWeightCacheMap.put(ticket.getId().toString(), weightCoefficientCacheValue);
                Long dbAdTicketPositionWeightId = null;
                for (AdTicketPositionWeight dbPositionWeight : dbPositionWeights) {
                    if (!ticket.getId().equals(dbPositionWeight.getTicketId())) continue;
                    dbAdTicketPositionWeightId = dbPositionWeight.getId();
                    break;
                }
                if (null != dbAdTicketPositionWeightId) {
                    batchUpdatePositionWeightIds.add(dbAdTicketPositionWeightId);
                    continue;
                }
                AdTicketPositionWeight adTicketPositionWeight = new AdTicketPositionWeight();
                adTicketPositionWeight.setPositionId(positionId);
                adTicketPositionWeight.setInterventionFactor(weightCoefficient);
                adTicketPositionWeight.setTicketId(ticket.getId());
                batchInsertEntities.add(adTicketPositionWeight);
            }
        }
        if (batchInsertEntities.size() > 0) {
            this.adTicketPositionWeightMapperExt.batchInsert((List)batchInsertEntities);
        }
        if (batchUpdatePositionWeightIds.size() > 0) {
            this.adTicketPositionWeightMapperExt.batchUpdateInterventionFactorByIds((List)batchUpdatePositionWeightIds, weightCoefficient);
        }
    }

    private void batchUpdateTicketWeight() {
        List ticketIds = StationUserWeightContext.get().getAdTickets().stream().map(AdTicket::getId).collect(Collectors.toList());
        Double weightCoefficient = StationUserWeightContext.get().getTblStationUserWeight().getWeightCoefficient();
        String operationUserName = StationUserWeightContext.get().getOperationUserName();
        Map<Long, String> redisTicketWeightMap = StationUserWeightContext.get().getRedisTicketWeightMapIfCreate();
        if (CollectionUtils.isEmpty(ticketIds)) {
            return;
        }
        this.adTicketWeightManualConfMapperExt.batchUpdateTicketWeight(ticketIds, weightCoefficient, operationUserName);
        for (Long ticketId : ticketIds) {
            redisTicketWeightMap.put(ticketId, String.valueOf(weightCoefficient));
        }
    }

    private Map<String, List<AdTicketPositionWeight>> positionWeightDataGroupByPositionId(List<AdTicketPositionWeight> adTicketPositionWeights) {
        if (CollectionUtils.isEmpty(adTicketPositionWeights)) {
            return Collections.emptyMap();
        }
        HashMap map = Maps.newHashMap();
        for (AdTicketPositionWeight positionWeight : adTicketPositionWeights) {
            map.computeIfAbsent(positionWeight.getPositionId(), k -> Lists.newArrayList()).add(positionWeight);
        }
        return map;
    }

    private List<String> getAllPositionIdsInFlowPackages(List<AdFlowPackage> adFlowPackages) {
        if (CollectionUtils.isEmpty(adFlowPackages)) {
            return Collections.emptyList();
        }
        StringBuilder positionIdsStrBuilder = new StringBuilder();
        for (AdFlowPackage adFlowPackage : adFlowPackages) {
            positionIdsStrBuilder.append(adFlowPackage.getPositionId()).append(",");
        }
        return Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)positionIdsStrBuilder.toString()));
    }

    private List<AdFlowPackage> getFlowPackageByFlowPackageIdsStr(String flowPackageIdsStr) {
        if (StringUtils.isBlank((CharSequence)flowPackageIdsStr)) {
            return Collections.emptyList();
        }
        List flowPackageIds = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)flowPackageIdsStr).stream().map(Long::valueOf).collect(Collectors.toList());
        return this.adFlowPackageMapper.findByIds(flowPackageIds);
    }

    private List<StationUserWeightPushParam> buildStationUserWeightCacheByAdvertiserId(Long advertiserId) {
        List stationUserWeights = this.tblStationUserWeightMapperExt.findEffectiveByAdvertiserId(advertiserId);
        if (CollectionUtils.isEmpty((Collection)stationUserWeights)) {
            return Collections.emptyList();
        }
        BigDecimal convert = new BigDecimal(1000);
        ArrayList stationUserWeightPushParams = Lists.newArrayListWithCapacity((int)stationUserWeights.size());
        for (TblStationUserWeight weight : stationUserWeights) {
            if (AdvertiserConstant.StationUserWeight.STATION_USER_WEIGHT_STATUS_COMPLETE.equals(weight.getStatus())) continue;
            List adTickets = this.adTicketMapperExt.findCpcTicketByAdvertiserAndType(Integer.valueOf(weight.getAdvertiserId().intValue()), weight.getTicketTagCode());
            StationUserWeightPushParam stationUserWeightPushParam = new StationUserWeightPushParam();
            stationUserWeightPushParam.setTicketTagCode(weight.getTicketTagCode());
            stationUserWeightPushParam.setStationUserWeightId(weight.getId());
            stationUserWeightPushParam.setTicketIdsStr("," + Joiner.on((String)",").skipNulls().join((Iterable)adTickets.stream().map(AdTicket::getId).collect(Collectors.toList())) + ",");
            stationUserWeightPushParam.setLimitPositionFlag(weight.getLimitFlowPackageFlag());
            if (weight.getLimitFlowPackageFlag().booleanValue()) {
                List<AdFlowPackage> adFlowPackages = this.getFlowPackageByFlowPackageIdsStr(weight.getFlowPackageIdsStr());
                HashSet positionIds = Sets.newHashSet(this.getAllPositionIdsInFlowPackages(adFlowPackages));
                stationUserWeightPushParam.setPositionIdsStr("," + Joiner.on((String)",").skipNulls().join((Iterable)positionIds) + ",");
            }
            stationUserWeightPushParam.setWeightCoefficient(weight.getWeightCoefficient());
            stationUserWeightPushParam.setWeightPlanConsume(weight.getWeightPlanConsume().multiply(convert));
            stationUserWeightPushParam.setStatus(weight.getStatus());
            stationUserWeightPushParams.add(stationUserWeightPushParam);
        }
        return stationUserWeightPushParams;
    }

    private void pushStationUserWeightToRedis(Map<Long, List<StationUserWeightPushParam>> stationUserWeightPushParamsMap) {
        if (MapUtils.isNotEmpty(stationUserWeightPushParamsMap)) {
            return;
        }
        for (Map.Entry<Long, List<StationUserWeightPushParam>> entry : stationUserWeightPushParamsMap.entrySet()) {
            try {
                HashMap map = Maps.newHashMap();
                map.put("advertiserId", entry.getKey());
                this.prodPusherIntegration.pushToProd(ProdServiceNameEnum.STATION_USER_WEIGHT.getServiceName(), (Map)map, JsonHelper.convert2bytes(entry.getValue()));
            }
            catch (Exception e) {
                log.error("\u63a8\u9001\u5e7f\u544a\u4e3b\uff1a{}\u7684\u5e7f\u544a\u5238\u6743\u91cd\u5230\u524d\u53f0\u5931\u8d25\uff01", (Object)entry.getKey(), (Object)e);
                DingtalkMsgUtil.sendMsg(DING_TALK_URL, "\u63a8\u9001\u5e7f\u544a\u4e3b\uff1a{" + entry.getKey() + "}\u7684\u7ad9\u5185\u6237\u6743\u91cd\u6743\u91cd\u5230\u524d\u53f0\u5931\u8d25\uff01", false, Collections.emptyList());
            }
        }
    }

    private Map<Long, List<StationUserWeightPushParam>> getStationUserWeightsInProgress() {
        Map allStationUserWeightMap = this.fetcher.hfetchall(TicketKeyGenerator.Advertiser.getStationUserWeight(), String.class);
        if (MapUtils.isEmpty((Map)allStationUserWeightMap)) {
            return Collections.emptyMap();
        }
        HashMap advertiserStationUserWeightMap = Maps.newHashMapWithExpectedSize((int)allStationUserWeightMap.size());
        for (Map.Entry entry : allStationUserWeightMap.entrySet()) {
            advertiserStationUserWeightMap.put(Long.valueOf((String)entry.getKey()), JSON.parseArray((String)((String)entry.getValue()), StationUserWeightPushParam.class));
        }
        return advertiserStationUserWeightMap;
    }

    private void checkTicket(List<Long> cacheTicketIds, List<Long> dbTicketIds) {
        ArrayList cacheTicketIdsCopy = Lists.newArrayList(cacheTicketIds);
        if (cacheTicketIdsCopy.size() != dbTicketIds.size()) {
            throw new BusinessException("\u5238\u6570\u91cf\u4e0d\u4e00\u81f4\uff01");
        }
        for (Long ticketId : cacheTicketIds) {
            if (dbTicketIds.contains(ticketId)) continue;
            throw new BusinessException("\u7f13\u5b58\u5238ID\u5b57\u7b26\u96c6\u5408\uff0c\u4e0eDB\u4e0d\u4e00\u81f4\uff01");
        }
    }

    private void checkTicketWeight(List<Long> cacheTicketIds, Double weightCoefficient) {
        List adTicketWeightManualConfs = this.adTicketWeightManualConfMapperExt.selectByTicketIds(cacheTicketIds);
        ArrayList differenceTicketIds = Lists.newArrayList();
        for (AdTicketWeightManualConf weightManualConf : adTicketWeightManualConfs) {
            if (weightCoefficient.equals(weightManualConf.getInterventionFactor())) continue;
            differenceTicketIds.add(weightManualConf.getTicketId());
        }
        if (differenceTicketIds.size() > 0) {
            throw new BusinessException("\u5e7f\u544a\u5238\u6743\u91cd\u4e0d\u4e00\u81f4\uff01\u5238ID\uff1a" + Joiner.on((String)",").skipNulls().join((Iterable)differenceTicketIds));
        }
    }

    private void checkPosition(Set<String> cachePositionIds, Set<String> dbPositionIds) {
        if (cachePositionIds.size() != dbPositionIds.size()) {
            throw new BusinessException("\u5e7f\u544a\u4f4d\u6570\u91cf\u4e0d\u4e00\u81f4\uff01");
        }
        for (String positionId : cachePositionIds) {
            if (dbPositionIds.contains(positionId)) continue;
            throw new BusinessException("\u7f13\u5b58\u5e7f\u544a\u4f4dID\u5b57\u7b26\u96c6\u5408\uff0c\u4e0eDB\u4e0d\u4e00\u81f4\uff01");
        }
    }

    private void checkPositionWeight(Set<String> cachePositionIds, Double weightCoefficient) {
        HashMap differencePositionWeightMap = Maps.newHashMap();
        for (String positionId : cachePositionIds) {
            Map<String, String> positionWeightMap = this.redisNewClient.hGetAll(POSITION_WEIGHT_KEY + positionId);
            if (MapUtils.isEmpty(positionWeightMap)) continue;
            for (Map.Entry<String, String> entry : positionWeightMap.entrySet()) {
                if (!StringUtils.isNumeric((CharSequence)entry.getValue()) || !StringUtils.isNumeric((CharSequence)entry.getKey())) continue;
                long ticketId = Long.valueOf(entry.getKey());
                double weight = Double.valueOf(entry.getValue());
                if (Double.valueOf(weight).compareTo(weightCoefficient) == 0) continue;
                differencePositionWeightMap.computeIfAbsent(positionId, k -> Maps.newHashMap()).put(ticketId, weight);
            }
        }
        if (differencePositionWeightMap.size() > 0) {
            throw new BusinessException("\u5e7f\u544a\u4f4d\u6743\u91cd\u4e0d\u4e00\u81f4\uff01-->>>" + JSON.toJSONString((Object)differencePositionWeightMap));
        }
    }
}

