/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.alarm.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.dal.mapper.alarm.AlarmPlanMapper;
import com.bxm.adsmanager.dal.mapper.alarm.AlarmPlanPositionMapper;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.integration.datapark.model.Page;
import com.bxm.adsmanager.integration.datapark.service.DataparkAppPullerIntegration;
import com.bxm.adsmanager.model.dao.alarm.AlarmPlanPosition;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.model.ro.AdPositionAlarmRo;
import com.bxm.adsmanager.model.vo.AlarmPlanPositionVo;
import com.bxm.adsmanager.service.alarm.AdPositionAlarmService;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceParamDTO;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AlarmAdPositionServiceImpl
implements AdPositionAlarmService {
    private static final Logger log = LoggerFactory.getLogger(AlarmAdPositionServiceImpl.class);
    @Resource
    private AlarmPlanPositionMapper alarmPlanPositionMapper;
    @Resource
    private AlarmPlanMapper alarmPlanMapper;
    @Resource
    private NewAppEntranceFacadeIntegration appEntranceFacadeIntegration;
    @Resource
    private DataparkAppPullerIntegration dataparkAppPullerIntegration;

    @Override
    public PageInfo<AlarmPlanPositionVo> queryList(AdPositionAlarmRo adPositionAlarmRo, User user) {
        Page appCounts;
        String username = user.getRoleCodes().contains(RoleEnum.MJLEADER.getCode()) ? null : user.getUsername();
        com.github.pagehelper.Page result = new com.github.pagehelper.Page();
        QueryAppEntranceParamDTO queryDto = new QueryAppEntranceParamDTO();
        queryDto.setFuzzyProviderName(adPositionAlarmRo.getMediaName());
        if (StringUtils.isNotBlank((CharSequence)adPositionAlarmRo.getAdPositionId())) {
            queryDto.setPositionIds((List)Lists.newArrayList((Object[])new String[]{adPositionAlarmRo.getAdPositionId()}));
        }
        if (StringUtils.isNotBlank((CharSequence)username)) {
            queryDto.setMjCode(username);
        } else {
            queryDto.setMjCode(adPositionAlarmRo.getMjcode());
        }
        List appEntranceAdRos = this.appEntranceFacadeIntegration.getAllList(queryDto);
        if (appEntranceAdRos == null || appEntranceAdRos.isEmpty()) {
            return new PageInfo((List)result);
        }
        HashMap<String, AppEntranceAdRO> positionNames = new HashMap<String, AppEntranceAdRO>(appEntranceAdRos.size());
        for (AppEntranceAdRO appEntranceAdRo : appEntranceAdRos) {
            positionNames.put(appEntranceAdRo.getPositionId(), appEntranceAdRo);
        }
        adPositionAlarmRo.setAdPositionIds(new ArrayList(positionNames.keySet()));
        List alarmPlanPositions = this.alarmPlanPositionMapper.queryList(adPositionAlarmRo);
        HashMap<String, AlarmPlanPositionVo> alarmPlanPositionMap = new HashMap<String, AlarmPlanPositionVo>(alarmPlanPositions.size());
        for (AlarmPlanPositionVo alarmPlanPosition : alarmPlanPositions) {
            alarmPlanPositionMap.put(alarmPlanPosition.getPositionId(), alarmPlanPosition);
        }
        alarmPlanPositionMap.put(null, this.alarmPlanMapper.queryDefaultPlan());
        ArrayList queryDataParkPositionIds = adPositionAlarmRo.getAdPositionIds();
        if (adPositionAlarmRo.getAlarmPlanId() != null) {
            if (adPositionAlarmRo.getAlarmPlanId() == 1L) {
                queryDataParkPositionIds.removeAll(alarmPlanPositionMap.keySet());
            } else {
                queryDataParkPositionIds = new ArrayList(alarmPlanPositionMap.keySet());
            }
        }
        if ((appCounts = this.dataparkAppPullerIntegration.getAppBusinessCountPage(LocalDate.now().minusDays(1L).toString(), adPositionAlarmRo.getPageSize(), adPositionAlarmRo.getPageNum(), adPositionAlarmRo.getOrderBy(), adPositionAlarmRo.getOrderType(), JSONObject.toJSONString(queryDataParkPositionIds))) == null || appCounts.getList() == null) {
            return new PageInfo((List)result);
        }
        List collect = appCounts.getList().stream().map(appCount -> {
            AlarmPlanPositionVo vo = new AlarmPlanPositionVo();
            String adPositionId = appCount.getAppKey() + "-" + appCount.getBusiness().replace("ad-", "");
            vo.setPositionId(adPositionId);
            AppEntranceAdRO appEntranceAdRo = (AppEntranceAdRO)positionNames.get(adPositionId);
            if (appEntranceAdRo != null) {
                vo.setMediaName(appEntranceAdRo.getProviderAlias());
                vo.setPositionName(appEntranceAdRo.getAppEntranceName());
            }
            vo.setLastIncome(appCount.getIncome());
            vo.setLastUV(appCount.getIndexUv());
            AlarmPlanPositionVo alarmPlanPosition = (AlarmPlanPositionVo)alarmPlanPositionMap.get(adPositionId);
            if (alarmPlanPosition == null) {
                alarmPlanPosition = (AlarmPlanPositionVo)alarmPlanPositionMap.get(null);
            }
            vo.setAlarmPlanId(alarmPlanPosition.getAlarmPlanId());
            vo.setAlarmPlanName(alarmPlanPosition.getAlarmPlanName());
            vo.setCreatorName(alarmPlanPosition.getCreatorName());
            return vo;
        }).collect(Collectors.toList());
        PageInfo pageInfo = new PageInfo(collect);
        pageInfo.setTotal(appCounts.getTotal().longValue());
        pageInfo.setIsFirstPage(appCounts.getFirstPage().booleanValue());
        pageInfo.setIsLastPage(appCounts.getLastPage().booleanValue());
        pageInfo.setPageSize(appCounts.getPageSize().intValue());
        pageInfo.setPageNum(appCounts.getPageNum().intValue());
        return pageInfo;
    }

    @Override
    public boolean submitAlarmPlans(AdPositionAlarmRo adPositionAlarmRo, User user) {
        List adPositionIds = adPositionAlarmRo.getAdPositionIds();
        if (adPositionIds == null || adPositionIds.isEmpty()) {
            return false;
        }
        if (adPositionAlarmRo.getAlarmPlanId() == null) {
            return false;
        }
        boolean commonPlan = adPositionAlarmRo.getAlarmPlanId() == 1L;
        for (String adPositionId : adPositionIds) {
            AlarmPlanPosition alarmPlanPosition = this.alarmPlanPositionMapper.selectByPositionId(adPositionId);
            if (alarmPlanPosition == null) {
                if (commonPlan) continue;
                alarmPlanPosition = new AlarmPlanPosition();
                alarmPlanPosition.setAlarmPlanId(adPositionAlarmRo.getAlarmPlanId());
                alarmPlanPosition.setPositionId(adPositionId);
                this.alarmPlanPositionMapper.insertSelective(alarmPlanPosition);
                continue;
            }
            if (commonPlan) {
                this.alarmPlanPositionMapper.deleteById(alarmPlanPosition.getId());
                continue;
            }
            this.alarmPlanPositionMapper.updateAlarmPlanId(adPositionId, adPositionAlarmRo.getAlarmPlanId());
        }
        return true;
    }
}

