/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.alarm.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.dal.mapper.alarm.ext.AlarmRecordMapperExt;
import com.bxm.adsmanager.integration.acl.AclUserIntegration;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.model.dao.alarm.AlarmRecord;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.model.vo.AlarmStatistic;
import com.bxm.adsmanager.service.alarm.AlarmNotifyService;
import com.bxm.adsmanager.service.alarm.SocketSessionRegistry;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceParamDTO;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class AlarmNotifyServiceImpl
implements AlarmNotifyService {
    private static final Logger log = LoggerFactory.getLogger(AlarmNotifyServiceImpl.class);
    @Resource
    private AclUserIntegration aclUserIntegration;
    @Resource
    private SocketSessionRegistry socketSessionRegistry;
    @Resource
    private AlarmRecordMapperExt alarmRecordMapperExt;
    @Resource
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;
    @Autowired(required=false)
    private SimpMessagingTemplate template;

    @Override
    @Async
    public void notify(AlarmRecord alarmRecord) {
        AlarmStatistic alarmStatistic;
        HashMap<String, AlarmStatistic> notifies = new HashMap<String, AlarmStatistic>();
        Map mjs = this.aclUserIntegration.queryUserByRoleCode(RoleEnum.MJLEADER.getCode(), Boolean.valueOf(true));
        Map productionLeader = this.aclUserIntegration.queryUserByRoleCode(RoleEnum.CHAN_PIN_LEADER.getCode(), Boolean.valueOf(true));
        HashSet leaders = new HashSet(mjs.keySet());
        leaders.addAll(productionLeader.keySet());
        if (!leaders.isEmpty()) {
            alarmStatistic = this.alarmRecordMapperExt.statisticAlarm(null);
            alarmStatistic.setLatestAlarm(this.genAlarmDesc(alarmRecord));
            for (String username : leaders) {
                String sessionId = this.socketSessionRegistry.getSessionId(username);
                if (!StringUtils.isNotBlank((CharSequence)sessionId)) continue;
                notifies.put(sessionId, alarmStatistic);
            }
        }
        alarmStatistic = this.alarmRecordMapperExt.statisticAlarm(alarmRecord.getUsername());
        alarmStatistic.setLatestAlarm(this.genAlarmDesc(alarmRecord));
        String mjSessionId = this.socketSessionRegistry.getSessionId(alarmRecord.getUsername());
        if (StringUtils.isNotBlank((CharSequence)mjSessionId)) {
            notifies.put(mjSessionId, alarmStatistic);
        }
        for (String sessionId : notifies.keySet()) {
            this.template.convertAndSendToUser(sessionId, "/topic/alarm", (Object)JSONObject.toJSONString(notifies.get(sessionId)), (Map)AlarmNotifyServiceImpl.createHeaders(sessionId));
        }
    }

    @Override
    public String genAlarmDesc(AlarmRecord alarmRecord) {
        StringBuilder result = new StringBuilder();
        QueryAppEntranceParamDTO queryAppEntranceParamDTO = new QueryAppEntranceParamDTO();
        queryAppEntranceParamDTO.setPositionIds((List)Lists.newArrayList((Object[])new String[]{alarmRecord.getAlarmId()}));
        List appEntranceAdRos = this.newAppEntranceFacadeIntegration.getAllList(queryAppEntranceParamDTO);
        if (!appEntranceAdRos.isEmpty()) {
            AppEntranceAdRO appEntranceAdRo = (AppEntranceAdRO)appEntranceAdRos.get(0);
            result.append(appEntranceAdRo.getProviderAlias()).append("-");
            String code = String.format("%06d", appEntranceAdRo.getCode()) + "-" + appEntranceAdRo.getAppEntranceId();
            result.append(code).append("\u7684");
        }
        double hour = BigDecimal.valueOf(alarmRecord.getScope() * 15).divide(BigDecimal.valueOf(60L), 2, RoundingMode.HALF_UP).doubleValue();
        result.append(alarmRecord.getIndicationName()).append("\u6700\u8fd1").append(hour).append("\u5c0f\u65f6");
        result.append(alarmRecord.getChange() < 0.0 ? "\u4e0b\u964d" : "\u4e0a\u6da8").append(Math.abs(alarmRecord.getChange())).append("%");
        return result.toString();
    }

    public static MessageHeaders createHeaders(String sessionId) {
        SimpMessageHeaderAccessor headerAccessor = SimpMessageHeaderAccessor.create((SimpMessageType)SimpMessageType.MESSAGE);
        headerAccessor.setSessionId(sessionId);
        headerAccessor.setLeaveMutable(true);
        return headerAccessor.getMessageHeaders();
    }
}

