/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.alarm.impl;

import com.bxm.adsmanager.dal.mapper.alarm.AlarmPlanMapper;
import com.bxm.adsmanager.dal.mapper.alarm.AlarmPlanPositionMapper;
import com.bxm.adsmanager.dal.mapper.monitor.AlarmConfigMapper;
import com.bxm.adsmanager.model.dao.alarm.AlarmPlan;
import com.bxm.adsmanager.model.dao.monitor.AlarmConfig;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.model.ro.AlarmPlanRo;
import com.bxm.adsmanager.service.alarm.AlarmPlanService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.dozer.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AlarmPlanServiceImpl
implements AlarmPlanService {
    private static final Logger log = LoggerFactory.getLogger(AlarmPlanServiceImpl.class);
    @Resource
    private AlarmPlanMapper alarmPlanMapper;
    @Resource
    private AlarmConfigMapper alarmConfigMapper;
    @Resource
    private Mapper mapper;
    @Resource
    private AlarmPlanPositionMapper alarmPlanPositionMapper;

    @Override
    public PageInfo<AlarmPlan> queryList(AlarmPlanRo alarmPlanRo) {
        PageHelper.startPage((int)alarmPlanRo.getPageNum(), (int)alarmPlanRo.getPageSize());
        List alarmPlans = this.alarmPlanMapper.queryList(alarmPlanRo);
        return new PageInfo(alarmPlans);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean add(AlarmPlanRo alarmPlanRo, User user) {
        if (StringUtils.isBlank((CharSequence)alarmPlanRo.getPlanName())) {
            throw new RuntimeException("\u65b9\u6848\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AlarmPlan alarmPlan = (AlarmPlan)this.mapper.map((Object)alarmPlanRo, AlarmPlan.class);
        alarmPlan.setCreator(user.getUsername());
        alarmPlan.setCreatorName(user.getRealname());
        if (this.alarmPlanMapper.existByPlanName(alarmPlanRo.getPlanName()).booleanValue()) {
            throw new RuntimeException("\u65b9\u6848\u540d\u79f0\u91cd\u590d,\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        if (!this.alarmPlanMapper.insertSelective(alarmPlan).booleanValue()) {
            return false;
        }
        List alarmConfigs = alarmPlanRo.getAlarmConfigs();
        for (AlarmConfig alarmConfig : alarmConfigs) {
            alarmConfig.setAlarmPlanId(alarmPlan.getId());
        }
        if (this.alarmConfigMapper.batchInsert(alarmConfigs).intValue() != alarmConfigs.size()) {
            throw new RuntimeException("\u6279\u91cf\u63d2\u5165\u5931\u8d25");
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean modify(AlarmPlanRo alarmPlanRo, User user) {
        String username = user.getRoleCodes().contains(RoleEnum.MJLEADER.getCode()) ? null : user.getUsername();
        AlarmPlan alarmPlan = this.alarmPlanMapper.selectByIdAndCreator(alarmPlanRo.getId(), username);
        if (alarmPlan == null) {
            log.error("\u4e0d\u5b58\u5728id\u4e3a{},username\u4e3a{}\u7684\u8bb0\u5f55", (Object)alarmPlanRo.getId(), (Object)username);
            return false;
        }
        alarmPlan.setPlanName(alarmPlanRo.getPlanName());
        if (!this.alarmPlanMapper.updateByPrimaryKeySelective(alarmPlan).booleanValue()) {
            throw new RuntimeException();
        }
        List alarmConfigs = alarmPlanRo.getAlarmConfigs();
        for (AlarmConfig alarmConfig : alarmConfigs) {
            alarmConfig.setAlarmPlanId(alarmPlanRo.getId());
            this.alarmConfigMapper.updateByPrimaryKey(alarmConfig);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean delete(AlarmPlanRo alarmPlanRo, User user) {
        String username = user.getRoleCodes().contains(RoleEnum.MJLEADER.getCode()) ? null : user.getUsername();
        AlarmPlan alarmPlan = this.alarmPlanMapper.selectByIdAndCreator(alarmPlanRo.getId(), username);
        if (alarmPlan == null) {
            log.error("\u4e0d\u5b58\u5728id\u4e3a{}\u7684\u8bb0\u5f55", (Object)alarmPlanRo.getId());
            return false;
        }
        alarmPlan.setPlanName(alarmPlanRo.getPlanName());
        if (!this.alarmPlanMapper.deleteById(alarmPlan.getId()).booleanValue()) {
            throw new RuntimeException();
        }
        if (this.alarmConfigMapper.deleteByAlarmPlanId(alarmPlan.getId()) < 1) {
            throw new RuntimeException();
        }
        this.alarmPlanPositionMapper.deleteByPlanId(alarmPlanRo.getId());
        return true;
    }
}

