/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.alipay;

import com.bxm.adsmanager.dal.mapper.alipay.AlipayMapper;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.model.vo.alipay.AlipayMobileVo;
import com.bxm.adsmanager.service.alipay.AlipayService;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlipayServiceImpl
implements AlipayService {
    @Autowired
    private AlipayMapper alipayMapper;
    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;

    @Override
    public PageInfo<AlipayMobileVo> findAllByParams(String appKey, String positionId, Integer pageNum, Integer pageSize) throws Exception {
        List list;
        PageHelper.startPage((int)pageNum, (int)pageSize);
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)appKey)) {
            map.put("appKey", appKey);
        }
        if ((list = this.alipayMapper.findAllByParams(map)).size() > 0) {
            ArrayList<String> positionIds = new ArrayList<String>();
            for (AlipayMobileVo alipayMobileVo : list) {
                positionIds.add(alipayMobileVo.getPositionId());
            }
            List listadRo = this.newAppEntranceFacadeIntegration.findListByPositionIds(positionIds);
            Map<String, AppEntranceAdRO> map1 = listadRo.stream().collect(Collectors.toMap(AppEntranceAdRO::getPositionId, a -> a, (k1, k2) -> k1));
            for (AlipayMobileVo alipayMobileVo : list) {
                alipayMobileVo.setAppKey(map1.getOrDefault(alipayMobileVo.getPositionId(), new AppEntranceAdRO()).getAppKey());
                alipayMobileVo.setAppName(map1.getOrDefault(alipayMobileVo.getPositionId(), new AppEntranceAdRO()).getProviderAlias());
                alipayMobileVo.setAlise(map1.getOrDefault(alipayMobileVo.getPositionId(), new AppEntranceAdRO()).getProviderAlias());
            }
        }
        PageInfo page = new PageInfo(list);
        return page;
    }
}

