/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.audit.impl;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdAssetsMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdAssetsInspireVideoMapperExt;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdAssetsTemplateAssetsMapperExt;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdTicketMapperExt;
import com.bxm.adsmanager.dal.mapper.advertiser.ext.TblAdQualifyMapperExt;
import com.bxm.adsmanager.dal.mapper.audit.AdAuditRecordMapper;
import com.bxm.adsmanager.dal.mapper.tbltag.ext.TblAdPostionTagMapperExt;
import com.bxm.adsmanager.ecxeption.SearchResultEmptyException;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssets;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsInspireVideo;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTemplateAssets;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.audit.AdAuditRecord;
import com.bxm.adsmanager.model.dto.AdTicketAuditSearchDTO;
import com.bxm.adsmanager.model.dto.TicketTypeNameDTO;
import com.bxm.adsmanager.model.vo.AdAssetsInspireVideoVo;
import com.bxm.adsmanager.model.vo.AdAssetsTemplateAssetsAuditVO;
import com.bxm.adsmanager.model.vo.AdAssetsVo;
import com.bxm.adsmanager.model.vo.AdTicketAuditVo;
import com.bxm.adsmanager.model.vo.AssetsPopupVo;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsService;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsTemplateAssetsService;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.service.audit.AdAuditService;
import com.bxm.adsmanager.service.prod.ProdService;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.utils.KeyBuilder;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdAuditServiceImpl
implements AdAuditService {
    private static final Logger log = LoggerFactory.getLogger(AdAuditServiceImpl.class);
    @Autowired
    private AdShopIntegration adShopIntegration;
    @Autowired
    private AdTicketMapper adTicketMapper;
    @Autowired
    private TblAdQualifyMapperExt tblAdQualifyMapperExt;
    @Autowired
    private AdTicketMapperExt adTicketMapperExt;
    @Autowired
    private AdAssetsMapper adAssetsMapper;
    @Autowired
    private TblAdPostionTagMapperExt tblAdPostionTagMapperExt;
    @Autowired
    private JedisFetcher jedisFetcher;
    @Autowired
    private JedisUpdater jedisUpdater;
    @Autowired
    private AdTicketAssetsService adTicketAssetsService;
    @Autowired
    private AdTicketService adTicketService;
    @Autowired
    private AdTicketAssetsTemplateAssetsService adTicketAssetsTemplateAssetsService;
    @Autowired
    private ProdService prodService;
    @Autowired
    private AdAssetsInspireVideoMapperExt adAssetsInspireVideoMapperExt;
    @Autowired
    private AdAssetsTemplateAssetsMapperExt adAssetsTemplateAssetsMapperExt;
    @Autowired
    private AdAuditRecordMapper adAuditRecordMapper;

    @Override
    public PageInfo<AdTicketAuditVo> getTicketAuditList(AdTicketAuditSearchDTO adTicketAuditSearchDTO) throws Exception {
        HashMap<Integer, AdvertiserDto> advertiserIdInfoMap = new HashMap<Integer, AdvertiserDto>(128);
        try {
            this.searchSetter(adTicketAuditSearchDTO, advertiserIdInfoMap);
        }
        catch (SearchResultEmptyException e) {
            return new PageInfo();
        }
        Page page = PageHelper.startPage((int)adTicketAuditSearchDTO.getPageNum(), (int)adTicketAuditSearchDTO.getPageSize());
        List adTicketAuditVos = this.adTicketMapperExt.getTicketAuditList(adTicketAuditSearchDTO);
        if (CollectionUtils.isEmpty((Collection)adTicketAuditVos)) {
            return page.toPageInfo();
        }
        List<Long> ticketIds = adTicketAuditVos.stream().map(a -> a.getTicketId().longValue()).collect(Collectors.toList());
        Set resultAdvertiserIds = adTicketAuditVos.stream().map(a -> a.getAdvertiserId().longValue()).collect(Collectors.toSet());
        List tagNames = this.tblAdPostionTagMapperExt.findTagNamesByTicketIds(ticketIds);
        List tagCodes = this.tblAdPostionTagMapperExt.findTagCodeByTicketIds(ticketIds);
        Map<Long, String> tagNamesMap = tagNames.stream().collect(Collectors.toMap(t -> t.getTicketId(), t -> t.getTagNames() == null ? "" : t.getTagNames()));
        Map<Long, String> tagCodesMap = tagCodes.stream().collect(Collectors.toMap(t -> t.getTicketId(), t -> t.getTagCodes() == null ? "" : t.getTagCodes()));
        List typeNames = this.adTicketMapperExt.getTypeNameByTickets(ticketIds);
        Map<Long, String> typeNamesMap = typeNames.stream().collect(Collectors.toMap(TicketTypeNameDTO::getTicketId, t -> t.getTypeName() == null ? "" : t.getTypeName()));
        List qualifyTypes = this.tblAdQualifyMapperExt.getQualifyTypeByAdvertiserIds(new ArrayList(resultAdvertiserIds));
        Map<Long, String> qualifyTypeMap = qualifyTypes.stream().collect(Collectors.toMap(q -> q.getAdvertiserId(), q -> q.getQualifyTypeStr() == null ? "" : q.getQualifyTypeStr()));
        Map<Long, Boolean> qualifyPassStatusMap = qualifyTypes.stream().collect(Collectors.toMap(q -> q.getAdvertiserId(), q -> StringUtils.contains((CharSequence)q.getQualifyStatusStr(), (CharSequence)"1")));
        HashMap<Long, List<AdAssetsVo>> assetsNamesMap = new HashMap<Long, List<AdAssetsVo>>();
        HashMap<Long, List<AdAssetsInspireVideoVo>> adAssetsInspireVideoGroupMap = new HashMap<Long, List<AdAssetsInspireVideoVo>>();
        HashMap<Long, List<AdAssetsTemplateAssetsAuditVO>> adAssetsTemplateAssetsGroupMap = new HashMap<Long, List<AdAssetsTemplateAssetsAuditVO>>();
        this.fillAssetMap(adTicketAuditSearchDTO, ticketIds, assetsNamesMap, adAssetsInspireVideoGroupMap, adAssetsTemplateAssetsGroupMap);
        for (AdTicketAuditVo t2 : adTicketAuditVos) {
            Long ticketId = t2.getTicketId().longValue();
            Integer advertiserId = t2.getAdvertiserId();
            if (adTicketAuditSearchDTO.getTicketType() == 2) {
                t2.setInspireVideoVoList((List)adAssetsInspireVideoGroupMap.get(ticketId));
            } else if (adTicketAuditSearchDTO.getTicketType() == 3) {
                t2.setTemplateAssetsVoList((List)adAssetsTemplateAssetsGroupMap.get(ticketId));
            } else {
                List adAssetsVos = (List)assetsNamesMap.get(ticketId);
                String adAssetAuditInfo = this.getAdAssetsAuditInfo(adAssetsVos);
                t2.setAssetsAuditInfo(adAssetAuditInfo);
                t2.setAdAssetsVoList(adAssetsVos);
            }
            t2.setTag(tagNamesMap.get(ticketId));
            t2.setTicketType(typeNamesMap.get(ticketId));
            AdvertiserDto advertiserDto = advertiserIdInfoMap.getOrDefault(advertiserId, new AdvertiserDto());
            t2.setAdvertiserStatus(advertiserDto.getStatus());
            t2.setAdvertiserName(advertiserDto.getCompany());
            t2.setAssetAuditWhiteStatus(advertiserDto.getAssetAuditWhiteStatus());
            t2.setAreaType(advertiserDto.getAreaType());
            t2.setSpecialApproval(advertiserDto.getSpecialApproval());
            t2.setAdvertiserQuality(qualifyTypeMap.get(advertiserId.longValue()));
            t2.setTagCodes(tagCodesMap.get(ticketId));
            t2.setQualifyWarningFlag(Integer.valueOf(qualifyPassStatusMap.getOrDefault(advertiserId.longValue(), false) != false ? 0 : 1));
            String remark = (String)this.jedisFetcher.hfetch(AdAuditServiceImpl.ticketRemark(), ticketId.toString(), String.class);
            t2.setRemark(remark);
            String screenShot = (String)this.jedisFetcher.hfetch(AdAuditServiceImpl.loadingPageScreenShotUrl(), ticketId.toString(), String.class);
            t2.setHistoryShot(screenShot);
        }
        return page.toPageInfo();
    }

    private String getAdAssetsAuditInfo(List<AdAssetsVo> adAssetsVos) {
        if (CollectionUtils.isEmpty(adAssetsVos)) {
            return null;
        }
        Integer waitAuditCount = 0;
        Integer passAuditCount = 0;
        Integer refuseAuditCount = 0;
        for (AdAssetsVo adAssetsVo : adAssetsVos) {
            Integer auditStatus = adAssetsVo.getAuditStatus();
            switch (auditStatus) {
                case 1: {
                    Integer n = waitAuditCount;
                    Integer n2 = waitAuditCount = Integer.valueOf(waitAuditCount + 1);
                    break;
                }
                case 2: {
                    Integer n = passAuditCount;
                    Integer n2 = passAuditCount = Integer.valueOf(passAuditCount + 1);
                    break;
                }
                case 3: {
                    Integer n = refuseAuditCount;
                    Integer n2 = refuseAuditCount = Integer.valueOf(refuseAuditCount + 1);
                    break;
                }
            }
        }
        StringBuffer adAssetAuditInfoStringBuffer = new StringBuffer();
        if (!waitAuditCount.equals(0)) {
            adAssetAuditInfoStringBuffer.append("\u5f85\u5ba1\u6838\uff1a").append(waitAuditCount).append(" \uff1b");
        }
        if (!passAuditCount.equals(0)) {
            adAssetAuditInfoStringBuffer.append("\u5ba1\u6838\u901a\u8fc7\uff1a").append(passAuditCount).append(" \uff1b");
        }
        if (!refuseAuditCount.equals(0)) {
            adAssetAuditInfoStringBuffer.append("\u5ba1\u6838\u62d2\u7edd\uff1a").append(refuseAuditCount).append(" \uff1b");
        }
        return adAssetAuditInfoStringBuffer.toString();
    }

    private void searchSetter(AdTicketAuditSearchDTO adTicketAuditSearchDTO, Map<Integer, AdvertiserDto> advertiserIdInfoMap) throws SearchResultEmptyException, Exception {
        this.assetsSearchSetter(adTicketAuditSearchDTO);
        HashSet searchAdvertiserIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet notSearchAdvertiserIds = Sets.newHashSetWithExpectedSize((int)16);
        List advertiserList = this.adShopIntegration.getAdShopList(this.buildAdvertiserSearch(adTicketAuditSearchDTO));
        if (adTicketAuditSearchDTO.isQueryAdvertiser() && CollectionUtils.isEmpty((Collection)advertiserList)) {
            throw new SearchResultEmptyException();
        }
        if (CollectionUtils.isNotEmpty((Collection)advertiserList)) {
            if (adTicketAuditSearchDTO.isQueryAdvertiser()) {
                searchAdvertiserIds.addAll(advertiserList.stream().map(a -> a.getId()).collect(Collectors.toSet()));
            }
            advertiserIdInfoMap.putAll(advertiserList.stream().collect(Collectors.toMap(a -> a.getId(), a -> a)));
        }
        this.fillQualifyWarningSearch(adTicketAuditSearchDTO, searchAdvertiserIds, notSearchAdvertiserIds);
        adTicketAuditSearchDTO.setAdvertiserIds(new ArrayList(searchAdvertiserIds));
        adTicketAuditSearchDTO.setExcludeAdvertiserIds(new ArrayList(notSearchAdvertiserIds));
    }

    private void fillQualifyWarningSearch(AdTicketAuditSearchDTO adTicketAuditSearchDTO, Set<Integer> searchAdvertiserIds, Set<Integer> notSearchAdvertiserIds) {
        if (Objects.isNull(adTicketAuditSearchDTO.getQualifyWarningFlag())) {
            return;
        }
        boolean qualifyWarning = Objects.equals(adTicketAuditSearchDTO.getQualifyWarningFlag(), 1);
        List qualifyTypes = this.tblAdQualifyMapperExt.getQualifyTypeByAdvertiserIds(null);
        Set qualifyAdvertiserId = qualifyTypes.stream().filter(q -> StringUtils.contains((CharSequence)q.getQualifyStatusStr(), (CharSequence)"1")).map(q -> q.getAdvertiserId().intValue()).collect(Collectors.toSet());
        if (qualifyWarning) {
            notSearchAdvertiserIds.addAll(qualifyAdvertiserId);
        } else {
            if (CollectionUtils.isEmpty(qualifyAdvertiserId)) {
                throw new SearchResultEmptyException();
            }
            if (adTicketAuditSearchDTO.isQueryAdvertiser()) {
                searchAdvertiserIds.retainAll(qualifyAdvertiserId);
            } else {
                searchAdvertiserIds.addAll(qualifyAdvertiserId);
            }
        }
    }

    @Override
    public void updateTicketRemark(Integer ticketId, String remark) {
        this.jedisUpdater.hupdate(AdAuditServiceImpl.ticketRemark(), ticketId.toString(), (Object)remark);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public void asstesAudit(Integer id, List<Long> ids, Short auditStatus, String refuseReason, Integer ticketType, short checkStatus, String auditUser) throws Exception {
        if (ticketType == 2) {
            this.asstesInspireVideoAudit(id, auditStatus, refuseReason, auditUser);
        } else if (ticketType == 3) {
            HashSet<Integer> ticketIdSet = new HashSet<Integer>();
            for (Long assetId : ids) {
                ticketIdSet.add(this.assetsTemplateAsstesAudit(assetId, auditStatus, refuseReason, checkStatus, auditUser));
            }
            for (Integer ticketId : ticketIdSet) {
                this.prodService.pushAdTicketToProdPre(ticketId.longValue());
            }
        } else {
            for (Long assetId : ids) {
                this.asstesAudit(assetId, auditStatus, refuseReason, auditUser);
            }
        }
    }

    private void asstesAudit(Long id, Short auditStatus, String refuseReason, String auditUser) throws Exception {
        Integer ticketId = this.adTicketAssetsService.findTicketByAssetIds(id.toString());
        if (ticketId == null) {
            throw new Exception("\u8be5\u7d20\u6750\u6ca1\u6709\u7ed1\u5b9a\u7684\u5238");
        }
        AdTicket adTicket = this.adTicketMapper.selectByPrimaryKey(Long.valueOf(ticketId.longValue()));
        if (adTicket.getStatus() < -1) {
            throw new Exception("\u8bf7\u4f18\u5148\u5ba1\u6838\u5e7f\u544a");
        }
        AdAssets adAssets = this.adAssetsMapper.selectByPrimaryKey(Long.valueOf(id));
        if (adAssets.getStatus() == 1) {
            throw new Exception("\u5f00\u542f\u7684\u7d20\u6750\u4e0d\u80fd\u4fee\u6539\u72b6\u6001");
        }
        if (!Objects.equals(adAssets.getAuditStatus(), 1)) {
            return;
        }
        this.adAssetsMapper.updateAuditStatusById(adAssets.getId(), auditStatus, refuseReason);
        this.adTicketMapper.updateDateTimeById(Long.valueOf(ticketId.longValue()));
        short auditPass = 2;
        if (auditPass == auditStatus) {
            AdAssets adAsset = new AdAssets();
            adAsset.setId(adAssets.getId());
            adAsset.setStatus(Short.valueOf((short)1));
            this.adAssetsMapper.updateByPrimaryKeySelective(adAsset);
            this.prodService.pushAdTicketToProdPre(ticketId.longValue());
        }
        AdAuditRecord adAuditRecord = new AdAuditRecord();
        adAuditRecord.setTicketId(Long.valueOf(ticketId.longValue()));
        adAuditRecord.setAuditType(AdAuditRecord.AUDITTYPE_ASSETS);
        Short assetsAuditStatus = auditPass == auditStatus ? AdAuditRecord.AUDITSTAUS_PASS : AdAuditRecord.AUDITSTAUS_REFUSE;
        adAuditRecord.setAssetsAuditStatus(assetsAuditStatus);
        adAuditRecord.setSubmitTime(adAssets.getModifyTime());
        adAuditRecord.setTicketAuditStatus(AdAuditRecord.AUDITSTAUS_PASS);
        adAuditRecord.setTicketType(adTicket.getType());
        adAuditRecord.setTicketName(adTicket.getName());
        adAuditRecord.setAssetsId(Long.valueOf(id));
        adAuditRecord.setAssetsName(adAssets.getName());
        adAuditRecord.setAuditUser(auditUser);
        this.adAuditRecordMapper.insertSelective(adAuditRecord);
    }

    private void asstesInspireVideoAudit(Integer id, Short auditStatus, String refuseReason, String auditUser) throws Exception {
        Integer ticketId = this.adAssetsInspireVideoMapperExt.findTicketIdByInspireAssetsId(Long.valueOf(id.longValue()));
        if (ticketId == null) {
            throw new Exception("\u8be5\u7d20\u6750\u6ca1\u6709\u7ed1\u5b9a\u7684\u5238");
        }
        AdTicket adTicket = this.adTicketMapper.selectByPrimaryKey(Long.valueOf(ticketId.longValue()));
        if (adTicket.getStatus() < -1) {
            throw new Exception("\u8bf7\u4f18\u5148\u5ba1\u6838\u5e7f\u544a");
        }
        AdAssetsInspireVideo adAssetsInspireVideo = this.adAssetsInspireVideoMapperExt.selectByPrimaryKey(Long.valueOf(id.longValue()));
        if (adAssetsInspireVideo.getStatus() == 1) {
            throw new Exception("\u5f00\u542f\u7684\u7d20\u6750\u4e0d\u80fd\u4fee\u6539\u72b6\u6001");
        }
        this.adAssetsInspireVideoMapperExt.updateAuditStatusById(adAssetsInspireVideo.getId(), auditStatus, refuseReason);
        this.adTicketMapper.updateDateTimeById(Long.valueOf(ticketId.longValue()));
        short auditPass = 2;
        if (auditPass == auditStatus) {
            AdAssetsInspireVideo adAsset = new AdAssetsInspireVideo();
            adAsset.setId(adAssetsInspireVideo.getId());
            adAsset.setStatus(Short.valueOf((short)1));
            this.adAssetsInspireVideoMapperExt.updateByPrimaryKeySelective(adAsset);
            this.prodService.pushAdTicketToProdPre(ticketId.longValue());
        }
        AdAuditRecord adAuditRecord = new AdAuditRecord();
        adAuditRecord.setTicketId(Long.valueOf(ticketId.longValue()));
        adAuditRecord.setAuditType(AdAuditRecord.AUDITTYPE_ASSETS);
        Short assetsAuditStatus = auditPass == auditStatus ? AdAuditRecord.AUDITSTAUS_PASS : AdAuditRecord.AUDITSTAUS_REFUSE;
        adAuditRecord.setAssetsAuditStatus(assetsAuditStatus);
        adAuditRecord.setSubmitTime(adAssetsInspireVideo.getModifyTime());
        adAuditRecord.setTicketAuditStatus(AdAuditRecord.AUDITSTAUS_PASS);
        adAuditRecord.setTicketType(adTicket.getType());
        adAuditRecord.setTicketName(adTicket.getName());
        adAuditRecord.setAssetsId(Long.valueOf(id.longValue()));
        adAuditRecord.setAssetsName(adAssetsInspireVideo.getAssetsName());
        adAuditRecord.setAuditUser(auditUser);
        this.adAuditRecordMapper.insertSelective(adAuditRecord);
    }

    private Integer assetsTemplateAsstesAudit(Long id, Short auditStatus, String refuseReason, short checkStatus, String auditUser) throws Exception {
        Integer ticketId = this.adAssetsTemplateAssetsMapperExt.findTicketIdById(id);
        if (ticketId == null) {
            throw new Exception("\u8be5\u7d20\u6750\u6ca1\u6709\u7ed1\u5b9a\u7684\u5238");
        }
        AdTicket adTicket = this.adTicketMapper.selectByPrimaryKey(Long.valueOf(ticketId.longValue()));
        if (adTicket.getStatus() < -1) {
            throw new Exception("\u8bf7\u4f18\u5148\u5ba1\u6838\u5e7f\u544a");
        }
        AdAssetsTemplateAssets adAssetsTemplateAssets = this.adAssetsTemplateAssetsMapperExt.selectByPrimaryKey(Long.valueOf(id));
        adAssetsTemplateAssets.setAuditStatus(auditStatus);
        adAssetsTemplateAssets.setRefuseReason(refuseReason);
        adAssetsTemplateAssets.setCheckStatus(Short.valueOf(checkStatus));
        short auditPass = 2;
        if (auditPass == auditStatus) {
            adAssetsTemplateAssets.setStatus(Short.valueOf((short)1));
        } else {
            adAssetsTemplateAssets.setStatus(Short.valueOf((short)0));
            List<AdAssetsTemplateAssets> adAssetsList = this.adTicketAssetsTemplateAssetsService.findByTicketId(ticketId.longValue());
            Iterator<AdAssetsTemplateAssets> iterator = adAssetsList.iterator();
            while (iterator.hasNext()) {
                AdAssetsTemplateAssets assets = iterator.next();
                if (assets.getStatus() != 0) continue;
                iterator.remove();
            }
            if (adAssetsList.size() == 1 && (long)id.intValue() == adAssetsList.get(0).getId() && 1 == adTicket.getStatus()) {
                AdTicket updateAdTicketStatus = new AdTicket();
                updateAdTicketStatus.setId(Long.valueOf(ticketId.longValue()));
                updateAdTicketStatus.setStatus(Short.valueOf((short)3));
                updateAdTicketStatus.setModifyUser(auditUser);
                Object object = this.adTicketService.updateStatus(updateAdTicketStatus);
            }
        }
        this.adAssetsTemplateAssetsMapperExt.updateByPrimaryKeySelective(adAssetsTemplateAssets);
        this.adTicketMapper.updateDateTimeById(Long.valueOf(ticketId.longValue()));
        AdAuditRecord adAuditRecord = new AdAuditRecord();
        adAuditRecord.setTicketId(Long.valueOf(ticketId.longValue()));
        adAuditRecord.setAuditType(AdAuditRecord.AUDITTYPE_ASSETS);
        Short assetsAuditStatus = auditPass == auditStatus ? AdAuditRecord.AUDITSTAUS_PASS : AdAuditRecord.AUDITSTAUS_REFUSE;
        adAuditRecord.setAssetsAuditStatus(assetsAuditStatus);
        adAuditRecord.setSubmitTime(adAssetsTemplateAssets.getModifyTime());
        adAuditRecord.setTicketAuditStatus(AdAuditRecord.AUDITSTAUS_PASS);
        adAuditRecord.setTicketType(adTicket.getType());
        adAuditRecord.setTicketName(adTicket.getName());
        adAuditRecord.setAssetsId(Long.valueOf(id));
        adAuditRecord.setAssetsName(adAssetsTemplateAssets.getAssetsName());
        adAuditRecord.setAuditUser(auditUser);
        this.adAuditRecordMapper.insertSelective(adAuditRecord);
        return ticketId;
    }

    public static KeyGenerator ticketRemark() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "REMARK"});
    }

    public static KeyGenerator loadingPageScreenShotUrl() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "LOADINGPAGE", "SCREENSHOTURL"});
    }

    private void assetsSearchSetter(AdTicketAuditSearchDTO adTicketAuditSearchDTO) {
        if (StringUtils.isNotBlank((CharSequence)adTicketAuditSearchDTO.getAssetsKeywords()) || StringUtils.isNotBlank((CharSequence)adTicketAuditSearchDTO.getAssetsStatus()) || StringUtils.isNotBlank((CharSequence)adTicketAuditSearchDTO.getCheckStatus())) {
            if (adTicketAuditSearchDTO.getTicketType() == 2) {
                List adAssetsVoList = this.adAssetsInspireVideoMapperExt.getAdAssetsVoByKeywords(adTicketAuditSearchDTO.getAssetsKeywords(), null, adTicketAuditSearchDTO.getAssetsStatus());
                if (CollectionUtils.isEmpty((Collection)adAssetsVoList)) {
                    throw new SearchResultEmptyException();
                }
                ArrayList<Long> assetsTicketId = new ArrayList<Long>();
                for (AdAssetsInspireVideoVo adAssetsVo : adAssetsVoList) {
                    assetsTicketId.add(adAssetsVo.getTicketId());
                }
                if (CollectionUtils.isEmpty((Collection)adTicketAuditSearchDTO.getTicketIdList())) {
                    adTicketAuditSearchDTO.setTicketIdList(assetsTicketId);
                } else {
                    adTicketAuditSearchDTO.getTicketIdList().retainAll(assetsTicketId);
                }
            } else if (adTicketAuditSearchDTO.getTicketType() == 3) {
                List adAssetsTemplateAssetsVOList = this.adAssetsTemplateAssetsMapperExt.getAdAssetsTemplateAssetsVoByKeywords(adTicketAuditSearchDTO.getAssetsKeywords(), null, adTicketAuditSearchDTO.getAssetsStatus(), adTicketAuditSearchDTO.getCheckStatus());
                if (CollectionUtils.isEmpty((Collection)adAssetsTemplateAssetsVOList)) {
                    throw new SearchResultEmptyException();
                }
                ArrayList<Long> assetsTicketId = new ArrayList<Long>();
                for (AdAssetsTemplateAssetsAuditVO adAssetsVo : adAssetsTemplateAssetsVOList) {
                    assetsTicketId.add(adAssetsVo.getTicketId());
                }
                if (CollectionUtils.isEmpty((Collection)adTicketAuditSearchDTO.getTicketIdList())) {
                    adTicketAuditSearchDTO.setTicketIdList(assetsTicketId);
                } else {
                    adTicketAuditSearchDTO.getTicketIdList().retainAll(assetsTicketId);
                }
            } else {
                List<AdAssetsVo> adAssetsVoList = this.adTicketAssetsService.getAdAssetsVoByKeywords(adTicketAuditSearchDTO.getAssetsKeywords(), null, adTicketAuditSearchDTO.getAssetsStatus());
                if (CollectionUtils.isEmpty(adAssetsVoList)) {
                    throw new SearchResultEmptyException();
                }
                ArrayList<Long> assetsTicketId = new ArrayList<Long>();
                for (AdAssetsVo adAssetsVo : adAssetsVoList) {
                    assetsTicketId.add(adAssetsVo.getTicketId());
                }
                if (CollectionUtils.isEmpty((Collection)adTicketAuditSearchDTO.getTicketIdList())) {
                    adTicketAuditSearchDTO.setTicketIdList(assetsTicketId);
                } else {
                    adTicketAuditSearchDTO.getTicketIdList().retainAll(assetsTicketId);
                }
            }
        }
    }

    private void fillAssetMap(AdTicketAuditSearchDTO adTicketAuditSearchDTO, List<Long> ticketIds, Map<Long, List<AdAssetsVo>> assetsNamesMap, Map<Long, List<AdAssetsInspireVideoVo>> adAssetsInspireVideoGroupMap, Map<Long, List<AdAssetsTemplateAssetsAuditVO>> adAssetsTemplateAssetsGroupMap) {
        if (adTicketAuditSearchDTO.getTicketType() == 2) {
            List adAssetsInspireVideoVoList = this.adAssetsInspireVideoMapperExt.findAllByTicketIds(ticketIds);
            adAssetsInspireVideoGroupMap.putAll(adAssetsInspireVideoVoList.stream().collect(Collectors.groupingBy(AdAssetsInspireVideoVo::getTicketId)));
        } else if (adTicketAuditSearchDTO.getTicketType() == 3) {
            List adAssetsTemplateAssetsVOList = this.adAssetsTemplateAssetsMapperExt.findAllByTicketIds(ticketIds);
            adAssetsTemplateAssetsGroupMap.putAll(adAssetsTemplateAssetsVOList.stream().collect(Collectors.groupingBy(AdAssetsTemplateAssetsAuditVO::getTicketId)));
        } else {
            List assetsPopupList = this.adAssetsMapper.getAssetsPopupList(null, null);
            Map<Long, AssetsPopupVo> assetsPopupVoMap = assetsPopupList.stream().collect(Collectors.toMap(a -> a.getId(), a -> a));
            List<AdAssetsVo> adAssetsVoList = this.adTicketAssetsService.getAdAssetsVoByKeywords(null, ticketIds, null);
            for (AdAssetsVo adAssetsVo : adAssetsVoList) {
                List<AdAssetsVo> list;
                if ("5".equals(adAssetsVo.getIsPopup())) {
                    AssetsPopupVo assetsPopupVo = assetsPopupVoMap.get(adAssetsVo.getAssetsPopupId());
                    adAssetsVo.setAssetsPopupStyleId(assetsPopupVo.getPopupStyleId());
                }
                if (CollectionUtils.isNotEmpty(list = assetsNamesMap.get(adAssetsVo.getTicketId()))) {
                    list.add(adAssetsVo);
                } else {
                    list = new ArrayList<AdAssetsVo>();
                    list.add(adAssetsVo);
                }
                assetsNamesMap.put(adAssetsVo.getTicketId(), list);
            }
        }
    }

    private AdvertiserDto buildAdvertiserSearch(AdTicketAuditSearchDTO adTicketAuditSearchDTO) {
        AdvertiserDto search = new AdvertiserDto();
        String advertiser = adTicketAuditSearchDTO.getAdvertiser();
        if (StringUtils.isNotBlank((CharSequence)advertiser)) {
            if (StringUtils.isNumeric((CharSequence)advertiser)) {
                search.setId(Integer.valueOf(advertiser));
            } else {
                search.setCompany(advertiser);
            }
        }
        if (null != adTicketAuditSearchDTO.getAdvertiserStatus()) {
            search.setStatus(adTicketAuditSearchDTO.getAdvertiserStatus());
        }
        if (null != adTicketAuditSearchDTO.getAssetAuditWhiteStatus()) {
            search.setAssetAuditWhiteStatus(adTicketAuditSearchDTO.getAssetAuditWhiteStatus());
        }
        if (Objects.nonNull(adTicketAuditSearchDTO.getAreaType())) {
            search.setAreaType(adTicketAuditSearchDTO.getAreaType());
        }
        return search;
    }

    public static class ImgInfo {
        private String name;
        private String url;
        private String type;
        private Integer advertiserId;

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public String getType() {
            return this.type;
        }

        public Integer getAdvertiserId() {
            return this.advertiserId;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setAdvertiserId(Integer advertiserId) {
            this.advertiserId = advertiserId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImgInfo)) {
                return false;
            }
            ImgInfo other = (ImgInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Integer this$advertiserId = this.getAdvertiserId();
            Integer other$advertiserId = other.getAdvertiserId();
            return !(this$advertiserId == null ? other$advertiserId != null : !((Object)this$advertiserId).equals(other$advertiserId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ImgInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Integer $advertiserId = this.getAdvertiserId();
            result = result * 59 + ($advertiserId == null ? 43 : ((Object)$advertiserId).hashCode());
            return result;
        }

        public String toString() {
            return "AdAuditServiceImpl.ImgInfo(name=" + this.getName() + ", url=" + this.getUrl() + ", type=" + this.getType() + ", advertiserId=" + this.getAdvertiserId() + ")";
        }
    }
}

